/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.Canvas;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_type_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_module_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_type_t;
import uk.co.caprica.vlcj.log.NativeLog;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AudioDevice;
import uk.co.caprica.vlcj.player.AudioOutput;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.Equalizer;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.ModuleDescription;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DefaultDirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.directaudio.AudioCallback;
import uk.co.caprica.vlcj.player.directaudio.DefaultDirectAudioPlayer;
import uk.co.caprica.vlcj.player.directaudio.DirectAudioPlayer;
import uk.co.caprica.vlcj.player.discoverer.MediaDiscoverer;
import uk.co.caprica.vlcj.player.embedded.DefaultEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.ComponentIdVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.linux.LinuxVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.mac.MacVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.windows.WindowsVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.headless.DefaultHeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.list.DefaultMediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.manager.DefaultMediaManager;
import uk.co.caprica.vlcj.player.manager.MediaManager;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.runtime.x.LibXUtil;
import uk.co.caprica.vlcj.version.LibVlcVersion;
import uk.co.caprica.vlcj.version.Version;

public class MediaPlayerFactory {
    private static final Logger logger;
    private static final String PLUGIN_PATH_HELP = "Failed to initialise libvlc.\n\nThis is most often caused either by an invalid vlc option being passed when creating a MediaPlayerFactory or by libvlc being unable to locate the required plugins.\n\nIf libvlc is unable to locate the required plugins the instructions below may help:\n\nIn the text below <libvlc-path> represents the name of the directory containing \"{0}\" and \"{1}\" and <plugins-path> represents the name of the directory containing the vlc plugins...\n\nFor libvlc to function correctly the vlc plugins must be available, there are a number of different ways to achieve this:\n 1. Make sure the plugins are installed in the \"<libvlc-path>/{2}\" directory, this should be the case with a normal vlc installation.\n 2. Set the VLC_PLUGIN_PATH operating system environment variable to point to \"<plugins-path>\".\n\nMore information may be available in the log.\n\n";
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;
    private final boolean equalizerAvailable;
    private final List<Float> equalizerBandFrequencies;
    private final List<String> equalizerPresetNames;
    private boolean released;

    private static String getJavaVersion() {
        String result = System.getProperty("java.version");
        if (!result.contains(".")) {
            result = result + ".0.0";
        }
        return result;
    }

    public MediaPlayerFactory() {
        this(new String[0]);
    }

    public MediaPlayerFactory(String ... libvlcArgs) {
        this(LibVlcFactory.factory().atLeast("2.1.0").create(), libvlcArgs);
    }

    public MediaPlayerFactory(LibVlc libvlc) {
        this(libvlc, new String[0]);
    }

    public MediaPlayerFactory(LibVlc libvlc, String ... libvlcArgs) {
        logger.debug("MediaPlayerFactory(libvlc={},libvlcArgs={})", (Object)libvlc, (Object)Arrays.toString(libvlcArgs));
        logger.debug("jna.library.path={}", (Object)System.getProperty("jna.library.path"));
        if (libvlcArgs == null) {
            libvlcArgs = new String[]{};
        }
        String vlcPluginPath = System.getProperty("VLC_PLUGIN_PATH");
        logger.debug("VLC_PLUGIN_PATH={}", (Object)vlcPluginPath);
        this.libvlc = libvlc;
        this.instance = libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        logger.debug("instance={}", (Object)this.instance);
        if (this.instance == null) {
            logger.error("Failed to initialise libvlc");
            String msg = MessageFormat.format(PLUGIN_PATH_HELP, RuntimeUtil.getLibVlcName(), RuntimeUtil.getLibVlcCoreName(), RuntimeUtil.getPluginsDirectoryName());
            throw new RuntimeException(msg);
        }
        this.equalizerAvailable = LibVlcVersion.getVersion().atLeast(new Version("2.2.0"));
        logger.debug("equalizerAvailable={}", (Object)this.equalizerAvailable);
        if (this.equalizerAvailable) {
            this.equalizerBandFrequencies = this.createEqualizerBandFrequencies();
            this.equalizerPresetNames = this.createEqualizerPresetNames();
        } else {
            this.equalizerBandFrequencies = null;
            this.equalizerPresetNames = null;
        }
    }

    public MediaPlayerFactory(List<String> libvlcArgs) {
        this(libvlcArgs.toArray(new String[libvlcArgs.size()]));
    }

    public MediaPlayerFactory(LibVlc libvlc, List<String> libvlcArgs) {
        this(libvlc, libvlcArgs.toArray(new String[libvlcArgs.size()]));
    }

    public void release() {
        logger.debug("release()");
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
            }
            this.released = true;
        }
    }

    public void setUserAgent(String userAgent) {
        logger.debug("setUserAgent(userAgent={})", (Object)userAgent);
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        logger.debug("setUserAgent(userAgent={},httpUserAgent={})", (Object)userAgent, (Object)httpUserAgent);
        this.libvlc.libvlc_set_user_agent(this.instance, userAgent, userAgent);
    }

    public void setApplicationId(String id, String version, String icon) {
        logger.debug("setApplicationId(id=" + id + ",version=" + version + ",icon=" + icon + ")");
        this.libvlc.libvlc_set_app_id(this.instance, id, version, icon);
    }

    public List<AudioOutput> getAudioOutputs() {
        logger.debug("getAudioOutputs()");
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = this.libvlc.libvlc_audio_output_list_get(this.instance);
        if (audioOutputs != null) {
            audioOutputs.setAutoSynch(false);
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = NativeString.copyNativeString(this.libvlc, audioOutput.psz_name);
                String description = NativeString.copyNativeString(this.libvlc, audioOutput.psz_description);
                result.add(new AudioOutput(name, description, this.getAudioOutputDevices(name)));
                audioOutput = audioOutput.p_next;
            }
            this.libvlc.libvlc_audio_output_list_release(audioOutputs);
        }
        return result;
    }

    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        logger.debug("getAudioOutputDevices(outputName={})", (Object)outputName);
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = this.libvlc.libvlc_audio_output_device_list_get(this.instance, outputName);
        if (audioDevices != null) {
            audioDevices.setAutoSynch(false);
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString(this.libvlc, audioDevice.psz_device);
                String description = NativeString.copyNativeString(this.libvlc, audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            this.libvlc.libvlc_audio_output_device_list_release(audioDevices);
        }
        return result;
    }

    public List<ModuleDescription> getAudioFilters() {
        logger.debug("getAudioFilters()");
        libvlc_module_description_t moduleDescriptions = this.libvlc.libvlc_audio_filter_list_get(this.instance);
        moduleDescriptions.setAutoSynch(false);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        this.libvlc.libvlc_module_description_list_release(moduleDescriptions);
        return result;
    }

    public List<ModuleDescription> getVideoFilters() {
        logger.debug("getVideoFilters()");
        libvlc_module_description_t moduleDescriptions = this.libvlc.libvlc_video_filter_list_get(this.instance);
        moduleDescriptions.setAutoSynch(false);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        this.libvlc.libvlc_module_description_list_release(moduleDescriptions);
        return result;
    }

    private List<ModuleDescription> getModuleDescriptions(libvlc_module_description_t moduleDescriptions) {
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        libvlc_module_description_t moduleDescription = moduleDescriptions;
        while (moduleDescription != null) {
            result.add(new ModuleDescription(moduleDescription.psz_name, moduleDescription.psz_shortname, moduleDescription.psz_longname, moduleDescription.psz_help));
            moduleDescription = moduleDescription.p_next;
        }
        return result;
    }

    public final boolean isEqualizerAvailable() {
        return this.equalizerAvailable;
    }

    private List<Float> createEqualizerBandFrequencies() {
        logger.debug("createEqualizerBandFrequencies()");
        int numBands = this.libvlc.libvlc_audio_equalizer_get_band_count();
        logger.debug("numBands={}", (Object)numBands);
        ArrayList<Float> result = new ArrayList<Float>(numBands);
        for (int i = 0; i < numBands; ++i) {
            result.add(Float.valueOf(this.libvlc.libvlc_audio_equalizer_get_band_frequency(i)));
        }
        logger.debug("result={}", (Object)result);
        return Collections.unmodifiableList(result);
    }

    private List<String> createEqualizerPresetNames() {
        logger.debug("createEqualizerPresetNames()");
        int numPresets = this.libvlc.libvlc_audio_equalizer_get_preset_count();
        logger.debug("numPresets={}", (Object)numPresets);
        ArrayList<String> result = new ArrayList<String>(numPresets);
        for (int i = 0; i < numPresets; ++i) {
            result.add(this.libvlc.libvlc_audio_equalizer_get_preset_name(i));
        }
        logger.debug("result={}", (Object)result);
        return Collections.unmodifiableList(result);
    }

    public final List<Float> getEqualizerBandFrequencies() {
        logger.debug("getEqualizerBandFrequencies()");
        this.checkEqualizer();
        return this.equalizerBandFrequencies;
    }

    public final List<String> getEqualizerPresetNames() {
        logger.debug("getEqualizerPresetNames()");
        this.checkEqualizer();
        return this.equalizerPresetNames;
    }

    public final Equalizer newEqualizer() {
        logger.debug("newEqualizer()");
        this.checkEqualizer();
        return new Equalizer(this.libvlc.libvlc_audio_equalizer_get_band_count());
    }

    public final Equalizer newEqualizer(String presetName) {
        logger.debug("newEqualizer(presetName={})", (Object)presetName);
        this.checkEqualizer();
        int index = this.equalizerPresetNames.indexOf(presetName);
        if (index != -1) {
            libvlc_equalizer_t presetEqualizer = this.libvlc.libvlc_audio_equalizer_new_from_preset(index);
            if (presetEqualizer != null) {
                Equalizer equalizer = new Equalizer(this.libvlc.libvlc_audio_equalizer_get_band_count());
                equalizer.setPreamp(this.libvlc.libvlc_audio_equalizer_get_preamp(presetEqualizer));
                for (int i = 0; i < this.libvlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                    equalizer.setAmp(i, this.libvlc.libvlc_audio_equalizer_get_amp_at_index(presetEqualizer, i));
                }
                this.libvlc.libvlc_audio_equalizer_release(presetEqualizer);
                return equalizer;
            }
            return null;
        }
        throw new IllegalArgumentException("No such preset named '" + presetName + "'");
    }

    public final Map<String, Equalizer> getAllPresetEqualizers() {
        logger.debug("getAllPresetEqualizers()");
        this.checkEqualizer();
        TreeMap<String, Equalizer> result = new TreeMap<String, Equalizer>();
        for (String presetName : this.equalizerPresetNames) {
            result.put(presetName, this.newEqualizer(presetName));
        }
        logger.trace("result={}", (Object)result);
        return result;
    }

    private void checkEqualizer() {
        if (!this.equalizerAvailable) {
            throw new UnsupportedOperationException("Equalizer is not available, you need libvlc 2.2.0 or later");
        }
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer() {
        logger.debug("newEmbeddedMediaPlayer()");
        return this.newEmbeddedMediaPlayer(null);
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        logger.debug("newEmbeddedMediaPlayer(fullScreenStrategy={})", (Object)fullScreenStrategy);
        return new DefaultEmbeddedMediaPlayer(this.libvlc, this.instance, fullScreenStrategy);
    }

    public DirectMediaPlayer newDirectMediaPlayer(BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback) {
        logger.debug("newDirectMediaPlayer(formatCallback={},renderCallback={})", (Object)bufferFormatCallback, (Object)renderCallback);
        return new DefaultDirectMediaPlayer(this.libvlc, this.instance, bufferFormatCallback, renderCallback);
    }

    public DirectAudioPlayer newDirectAudioPlayer(String format, int rate, int channels, AudioCallback audioCallback) {
        logger.debug("newDirectAudioPlayer(format={},rate={},channels={},audioCallback={}", format, rate, channels, audioCallback);
        return new DefaultDirectAudioPlayer(this.libvlc, this.instance, format, rate, channels, audioCallback);
    }

    public HeadlessMediaPlayer newHeadlessMediaPlayer() {
        logger.debug("newHeadlessMediaPlayer()");
        return new DefaultHeadlessMediaPlayer(this.libvlc, this.instance);
    }

    public MediaListPlayer newMediaListPlayer() {
        logger.debug("newMediaListPlayer()");
        return new DefaultMediaListPlayer(this.libvlc, this.instance);
    }

    public CanvasVideoSurface newVideoSurface(Canvas canvas) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        logger.debug("newVideoSurface(canvas={})", (Object)canvas);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        CanvasVideoSurface videoSurface = new CanvasVideoSurface(canvas, videoSurfaceAdapter);
        logger.debug("videoSurface={}", (Object)videoSurface);
        return videoSurface;
    }

    public ComponentIdVideoSurface newVideoSurface(long componentId) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        logger.debug("newVideoSurface(componentId={})", (Object)componentId);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        ComponentIdVideoSurface videoSurface = new ComponentIdVideoSurface(componentId, videoSurfaceAdapter);
        logger.debug("videoSurface={}", (Object)videoSurface);
        return videoSurface;
    }

    public MediaList newMediaList() {
        logger.debug("newMediaList()");
        return new MediaList(this.libvlc, this.instance);
    }

    public MediaMeta getMediaMeta(String mediaPath, boolean parse) {
        logger.debug("getMediaMeta(mediaPath={},parse={})", (Object)mediaPath, (Object)parse);
        libvlc_media_t media = this.libvlc.libvlc_media_new_path(this.instance, mediaPath);
        logger.debug("media={}", (Object)media);
        if (media != null) {
            if (parse) {
                logger.debug("Parsing media...");
                this.libvlc.libvlc_media_parse(media);
                logger.debug("Media parsed.");
            }
            DefaultMediaMeta mediaMeta = new DefaultMediaMeta(this.libvlc, media);
            this.libvlc.libvlc_media_release(media);
            return mediaMeta;
        }
        return null;
    }

    public libvlc_media_type_e getMediaType(libvlc_media_t media) {
        logger.debug("getMediaType(media={})", (Object)media);
        if (media != null) {
            return libvlc_media_type_e.mediaType(this.libvlc.libvlc_media_get_type(media));
        }
        return null;
    }

    public String getCodecDescription(libvlc_track_type_t type, int codec) {
        logger.debug("getCodecDescription(type={},codec={})", (Object)type, (Object)codec);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return this.libvlc.libvlc_media_get_codec_description(type.intValue(), codec);
        }
        logger.warn("Codec description not available on this platform, needs libvlc 3.0.0 or later");
        return "";
    }

    public NativeLog newLog() {
        logger.debug("newLog()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_210)) {
            return new NativeLog(this.libvlc, this.instance);
        }
        logger.warn("Native log not available on this platform, needs libvlc 2.1.0 or later");
        return null;
    }

    public MediaDiscoverer newMediaDiscoverer(String name) {
        logger.debug("newMediaDiscoverer(name={})", (Object)name);
        return new MediaDiscoverer(this.libvlc, this.instance, name);
    }

    public MediaDiscoverer newAudioMediaDiscoverer() {
        logger.debug("newAudioMediaDiscoverer()");
        return this.newMediaDiscoverer("audio");
    }

    public MediaDiscoverer newVideoMediaDiscoverer() {
        logger.debug("newVideoMediaDiscoverer()");
        return this.newMediaDiscoverer("video");
    }

    public long clock() {
        logger.trace("clock()");
        return this.libvlc.libvlc_clock();
    }

    public MediaManager newMediaManager() {
        logger.trace("newMediaManager()");
        return new DefaultMediaManager(this.libvlc, this.instance);
    }

    public String version() {
        logger.debug("version()");
        return this.libvlc.libvlc_get_version();
    }

    public String compiler() {
        logger.debug("compiler()");
        return this.libvlc.libvlc_get_compiler();
    }

    public String changeset() {
        logger.debug("changeset()");
        return this.libvlc.libvlc_get_changeset();
    }

    static {
        Version actualJavaVersion;
        logger = LoggerFactory.getLogger(MediaPlayerFactory.class);
        if (RuntimeUtil.isNix() && !GraphicsEnvironment.isHeadless() && (actualJavaVersion = new Version(MediaPlayerFactory.getJavaVersion())).atLeast(new Version("1.7.0"))) {
            logger.debug("Trying workaround for Java7+ on Linux");
            Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        logger.debug("Attempting to load jawt...");
                        new JPanel();
                        System.loadLibrary("jawt");
                        logger.debug("...loaded jawt");
                    }
                    catch (UnsatisfiedLinkError e) {
                        logger.debug("Failed to load jawt", e);
                    }
                    return null;
                }
            });
            logger.debug("Java7 on Linux workaround complete.");
        }
        String initX = System.getProperty("VLCJ_INITX");
        logger.debug("initX={}", (Object)initX);
        if (!"no".equalsIgnoreCase(initX)) {
            LibXUtil.initialise();
        }
    }
}

