/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.windows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.windows.ExtendedUser32;
import uk.co.caprica.vlcj.player.embedded.windows.WindowState;

final class Win32FullScreenHandler {
    private final Window window;
    private WindowState windowState;

    Win32FullScreenHandler(Window window) {
        this.window = window;
    }

    void setFullScreen(boolean fullScreen) {
        WinDef.HWND hWnd = this.getHWND(Native.getComponentID(this.window));
        if (fullScreen) {
            this.windowState = this.getWindowState(hWnd);
            ExtendedUser32.INSTANCE.SetWindowLong(hWnd, -16, this.windowState.getStyle() & 0xFF3BFFFF);
            ExtendedUser32.INSTANCE.SetWindowLong(hWnd, -20, this.windowState.getExStyle() & 0xFFFDFCFE);
            WinUser.MONITORINFO monitorInfo = this.getMonitorInfo(hWnd);
            WinDef.RECT rect = monitorInfo.rcMonitor;
            ExtendedUser32.INSTANCE.SetWindowPos(hWnd, null, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 52);
        } else {
            ExtendedUser32.INSTANCE.SetWindowLong(hWnd, -16, this.windowState.getStyle());
            ExtendedUser32.INSTANCE.SetWindowLong(hWnd, -20, this.windowState.getExStyle());
            ExtendedUser32.INSTANCE.SetWindowPos(hWnd, null, this.windowState.getLeft(), this.windowState.getTop(), this.windowState.getRight() - this.windowState.getLeft(), this.windowState.getBottom() - this.windowState.getTop(), 52);
            if (this.windowState.getMaximized()) {
                ExtendedUser32.INSTANCE.SendMessage(hWnd, 274, new WinDef.WPARAM(61488L), new WinDef.LPARAM(0L));
            }
        }
    }

    private WinDef.HWND getHWND(long componentId) {
        return new WinDef.HWND(Pointer.createConstant(componentId));
    }

    private WindowState getWindowState(WinDef.HWND hWnd) {
        WindowState windowState = new WindowState();
        windowState.setMaximized(ExtendedUser32.INSTANCE.IsZoomed(hWnd));
        if (windowState.getMaximized()) {
            ExtendedUser32.INSTANCE.SendMessage(hWnd, 274, new WinDef.WPARAM(61728L), new WinDef.LPARAM(0L));
        }
        windowState.setStyle(ExtendedUser32.INSTANCE.GetWindowLong(hWnd, -16));
        windowState.setExStyle(ExtendedUser32.INSTANCE.GetWindowLong(hWnd, -20));
        WinDef.RECT rect = new WinDef.RECT();
        boolean gotWindowRect = ExtendedUser32.INSTANCE.GetWindowRect(hWnd, rect);
        if (gotWindowRect) {
            windowState.setLeft(rect.left);
            windowState.setTop(rect.top);
            windowState.setRight(rect.right);
            windowState.setBottom(rect.bottom);
        }
        return windowState;
    }

    private WinUser.MONITORINFO getMonitorInfo(WinDef.HWND hWnd) {
        Pointer hMonitor = ExtendedUser32.INSTANCE.MonitorFromWindow(hWnd, ExtendedUser32.MONITOR_DEFAULTTONEAREST);
        WinUser.MONITORINFO monitorInfo = new WinUser.MONITORINFO();
        ExtendedUser32.INSTANCE.GetMonitorInfoA(hMonitor, monitorInfo);
        return monitorInfo;
    }
}

