/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[\\-_\\s]?(.*)");
    private final String version;
    private final Integer major;
    private final Integer minor;
    private final Integer revision;
    private final String extra;

    public Version(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.revision = Integer.parseInt(matcher.group(3));
            this.extra = matcher.groupCount() > 3 ? matcher.group(4) : null;
        } else {
            throw new IllegalArgumentException("Can't parse version from '" + version + "'");
        }
    }

    public String version() {
        return this.version;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int revision() {
        return this.revision;
    }

    public String extra() {
        return this.extra;
    }

    public boolean atLeast(Version required) {
        return this.compareTo(required) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.revision == o.revision) {
                    return 0;
                }
                return this.revision - o.revision;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.version);
        return sb.toString();
    }
}

