function c = chebyshev(x1,x2)
%% function c = chebyshev(x1,x2)
%
% Manuel Grana <manuel.grana[AT]ehu.es>
% Miguel Angel Veganzones <miguelangel.veganzones[AT]ehu.es>
% Grupo de Inteligencia Computacional (GIC), Universidad del Pais Vasco /
% Euskal Herriko Unibertsitatea (UPV/EHU)
% http://www.ehu.es/inteligenciacomputacional
% 
% Chebyshev distance between two vectors.
% See reference:
%       Manuel Grana, Darya Chyzhyk, Maite Garcia-Sebastian, Carmen
%       Hernandez. "lattice Independent Component Analysis for functional
%       Magnetic Resonance Imaging" (Draft). Information Science (acepted).
%       2010.
%
% Parameters:
%   - x1,x2: two vectors with the same dimensionality.
%
% The algorithm retrieves the Chebyshev distance between vectors x1 and x2.

%% Check parameters
if (nargin < 2)
    error('Insufficient parameters');
end
[m1 n1] = size(x1);
[m2 n2] = size(x2);
if (m1 ~= m2) || (n1 ~= n2)
    error('Missmatch vectors dimensionality');
end

%% Calculate distance
c = max(abs(x1-x2));