import nibabel as nib

def concatenate_fmridata (files):
    data = []
    for f in files:
        img = nib.load(f).get_data()
        data.append(img)

    merged = np.concatenate(data, axis=3)
    return merged

#--------------------------------------------------------------------
import numpy as np
import pylab as pl

def imshowvol (data):
    if len(data.shape):
        data = np.mean(data, axis=3)

    medials = np.array(data.shape)/2

    pl.figure()

    # First subplot: coronal view
    # subplot: 1 line, 3 columns and use the first subplot
    pl.subplot(1, 3, 1)
    # Turn off the axes, we don't need it
    pl.axis('off')
    # We use pl.imshow to display an image, and use a 'gray' colormap
    # we also use np.rot90 to rotate the image
    pl.imshow(np.rot90(data[:, medials[1], :]), interpolation='nearest', cmap=pl.cm.gray)
    pl.title('Coronal')

    # Second subplot: sagittal view
    pl.subplot(1, 3, 2)
    pl.axis('off')
    pl.imshow(np.rot90(data[medials[0], :, :]), interpolation='nearest', cmap=pl.cm.gray)
    pl.title('Sagittal')

    # Third subplot: axial view
    pl.subplot(1, 3, 3)
    pl.axis('off')
    pl.imshow(np.rot90(mean_img[:, :, medials[2]]), interpolation='nearest',
          cmap=pl.cm.gray)
    pl.title('Axial')
    pl.show()
