%close all
%clear all
%clc

%Dim = 1000;
%M_adj = load('sinthetic/g1000.dat');

%Dim = 200;
%M_adj = load('ep/e200.dat');

tic

% We select all lonely nodes as a base solution.
aux_adj = M_adj;
base_solution = sum(M_adj)==0;

% We find remaming nodes
remaining = ones(size(base_solution)) - base_solution;

elements = find(base_solution==1);

while (length(elements) > 0)
    
    new_elements = [];
    for i=1:length(elements)
        if ~isempty(find(aux_adj(elements(i),:)==1))
            new_elements = [new_elements, find(aux_adj(elements(i),:)==1)];
            aux_adj(elements(i),:) = 0;
        end
    end
    
    new_elements = unique(new_elements);
    elements = new_elements;
end

% Once we have a base solution if the sum of aux_adj is > 0 we continue
% finding other nodes until that.

while (sum(aux_adj(:)) ~= 0)
    
    % Find the most influential nodes
    most_influential_nodes = find(sum(aux_adj) == max(sum(aux_adj)));
    
    % We add the most influential node to the base list.
    base_solution(most_influential_nodes(1)) = 1;
    
    % We find remaming nodes
    remaining = ones(size(base_solution)) - base_solution;

    elements = find(base_solution==1);

    while (length(elements) > 0)

        new_elements = [];
        for i=1:length(elements)
            if ~isempty(find(aux_adj(elements(i),:)==1))
                new_elements = [new_elements, find(aux_adj(elements(i),:)==1)];
                aux_adj(elements(i),:) = 0;
            end
        end

        new_elements = unique(new_elements);
        elements = new_elements;
    end
    
end

sum(base_solution)
base_solution;
disp('¡Hemos encontrado la solución!')

toc
%solucion_borja = 1/MyFun(base_solution, M_adj, Dim)
tic
greedy
toc