/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.HashedListElement;

public class HashedList
implements Collection {
    private HashMap hash = new HashMap();
    private HashedListElement first = null;
    private HashedListElement last = null;
    private int numElements = 0;

    public boolean add(Object object) {
        this.add(null, null, object);
        return true;
    }

    public boolean add(Object object, Object object2) {
        this.add(null, object, object2);
        return true;
    }

    HashedListElement add(HashedListElement hashedListElement, Object object, Object object2) {
        if (object != null) {
            this.remove((HashedListElement)this.hash.get(object));
        }
        HashedListElement hashedListElement2 = new HashedListElement();
        hashedListElement2.key = object;
        hashedListElement2.reference = object2;
        if (hashedListElement == null) {
            hashedListElement2.prev = this.last;
            if (this.last != null) {
                this.last.next = hashedListElement2;
            } else {
                this.first = hashedListElement2;
            }
            this.last = hashedListElement2;
            hashedListElement2.next = null;
        } else if (hashedListElement.prev == null) {
            hashedListElement2.next = hashedListElement;
            hashedListElement2.prev = null;
            hashedListElement.prev = hashedListElement2;
            this.first = hashedListElement2;
        } else {
            hashedListElement2.next = hashedListElement;
            hashedListElement2.prev = hashedListElement.prev;
            hashedListElement.prev = hashedListElement2;
            hashedListElement2.prev.next = hashedListElement2;
        }
        ++this.numElements;
        if (object != null) {
            this.hash.put(object, hashedListElement2);
        }
        return hashedListElement2;
    }

    public boolean removeKey(Object object) {
        HashedListElement hashedListElement = (HashedListElement)this.hash.get(object);
        if (hashedListElement != null) {
            this.remove(hashedListElement);
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void remove(HashedListElement hashedListElement) {
        if (hashedListElement == null) {
            return;
        }
        if (hashedListElement.prev != null) {
            hashedListElement.prev.next = hashedListElement.next;
        } else {
            this.first = hashedListElement.next;
        }
        if (hashedListElement.next != null) {
            hashedListElement.next.prev = hashedListElement.prev;
        } else {
            this.last = hashedListElement.prev;
        }
        if (hashedListElement.key != null) {
            this.hash.remove(hashedListElement.key);
        }
        --this.numElements;
    }

    public Iterator iterator() {
        return new HashedListIterator(this.first);
    }

    public HashedListIterator iterator(Object object) throws NoSuchElementException {
        return new HashedListIterator((HashedListElement)this.hash.get(object));
    }

    public HashedListIterator iterator(int n) throws NoSuchElementException {
        if (n == 0 && this.numElements == 0) {
            return new HashedListIterator(this.first);
        }
        HashedListElement hashedListElement = this.getElement(n);
        HashedListIterator hashedListIterator = (HashedListIterator)this.iterator();
        hashedListIterator.setCurrent(hashedListElement);
        return hashedListIterator;
    }

    public Object get(Object object) {
        if (!this.hash.containsKey(object)) {
            return null;
        }
        return ((HashedListElement)this.hash.get((Object)object)).reference;
    }

    public Object get(int n) throws NoSuchElementException {
        HashedListElement hashedListElement = this.getElement(n);
        return hashedListElement.reference;
    }

    public boolean replaceKey(Object object, Object object2) {
        if (!this.hash.containsKey(object) || this.hash.containsKey(object2)) {
            return false;
        }
        HashedListElement hashedListElement = (HashedListElement)this.hash.get(object);
        hashedListElement.key = object2;
        this.hash.remove(object);
        this.hash.put(object2, hashedListElement);
        return true;
    }

    HashedListElement getElement(int n) throws NoSuchElementException {
        if (n < 0) {
            throw new NoSuchElementException("Invalid index");
        }
        HashedListElement hashedListElement = this.first;
        while (n > 0 && hashedListElement.next != null) {
            --n;
            hashedListElement = hashedListElement.next;
        }
        if (n > 0) {
            throw new NoSuchElementException("Index beyond end of list");
        }
        if (hashedListElement == null) {
            throw new NoSuchElementException("Empty list");
        }
        return hashedListElement;
    }

    public boolean containsKey(Object object) {
        return this.hash.containsKey(object);
    }

    public int size() {
        return this.numElements;
    }

    public boolean addAll(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.add(objectArray[n]);
            ++n;
        }
        return true;
    }

    public void clear() {
        this.numElements = 0;
        this.first = null;
        this.last = null;
        this.hash.clear();
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.numElements == 0;
    }

    public boolean removeAll(Collection collection) {
        Object[] objectArray = collection.toArray();
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            bl |= this.remove(objectArray[n]);
            ++n;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.numElements];
        return this.toArray(objectArray);
    }

    public Object[] toArray(Object[] objectArray) {
        if (Array.getLength(objectArray) < this.numElements) {
            objectArray = (Object[])ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(objectArray), this.numElements);
        }
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        if (objectArray.length > this.numElements) {
            objectArray[this.numElements] = null;
        }
        return objectArray;
    }

    public class HashedListIterator
    implements Cursor {
        private HashedListElement current;
        private HashedListElement last;

        HashedListIterator(HashedListElement hashedListElement) {
            this.current = hashedListElement;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public boolean hasPrev() {
            if (this.current == null) {
                return this.last != null;
            }
            return this.current.prev != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.current != null) {
                this.last = this.current;
                this.current = this.current.next;
                return this.last.reference;
            }
            throw new NoSuchElementException("Beyond end of list");
        }

        public Object prev() throws NoSuchElementException {
            this.last = null;
            if (this.current == null) {
                if (this.last == null) {
                    throw new NoSuchElementException("Empty list");
                }
                this.current = this.last;
                return this.current.reference;
            }
            if (this.current.prev == null) {
                throw new NoSuchElementException("Before beginning of list");
            }
            this.current = this.current.prev;
            return this.current.reference;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("Removed called in invalid iterator state");
            }
            HashedList.this.remove(this.last);
            this.last = null;
        }

        public void add(Object object) {
            HashedListElement hashedListElement = HashedList.this.add(this.current, null, object);
            this.current = hashedListElement.next;
        }

        public void add(Object object, Object object2) {
            HashedListElement hashedListElement = HashedList.this.add(this.current, object, object2);
            this.current = hashedListElement.next;
        }

        public void setKey(Object object) {
            if (HashedList.this.containsKey(object)) {
                this.setCurrent((HashedListElement)HashedList.this.hash.get(object));
            } else {
                this.current = null;
            }
        }

        void setCurrent(HashedListElement hashedListElement) {
            this.current = hashedListElement;
        }
    }
}

