/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

import es.ehu.www.ccwintco.npp.core.MultiplePointsNppEstimator;
import es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGC;
import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.GlobalForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.ClimateDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.DailyDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.LaiDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SeasonDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SiteDataManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JProgressBar;

public class GlobalForestBGC
implements MultiplePointsNppEstimator {
    private String name = null;
    private final ForestBGC forestBGC = ForestBGC.getInstance();
    private ClimateDataManager climateDataManager = null;
    private SiteDataManager siteDataManager = null;
    private DailyDataManager dailyDataManager = null;
    private SeasonDataManager seasonDataManager = null;
    private LaiDataManager laiDataManager = null;
    private JProgressBar progressBar = null;
    private static final GlobalForestBGC instance = new GlobalForestBGC();

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final ClimateDataManager getClimateDataManager() {
        return this.climateDataManager;
    }

    public final void setClimateDataManager(ClimateDataManager climateDataManager) {
        this.climateDataManager = climateDataManager;
    }

    public final SiteDataManager getSiteDataManager() {
        return this.siteDataManager;
    }

    public final void setSiteDataManager(SiteDataManager siteDataManager) {
        this.siteDataManager = siteDataManager;
    }

    public final DailyDataManager getDailyDataManager() {
        return this.dailyDataManager;
    }

    public final void setDailyDataManager(DailyDataManager dailyDataManager) {
        this.dailyDataManager = dailyDataManager;
    }

    public final SeasonDataManager getSeasonDataManager() {
        return this.seasonDataManager;
    }

    public final void setSeasonDataManager(SeasonDataManager seasonDataManager) {
        this.seasonDataManager = seasonDataManager;
    }

    public final LaiDataManager getLaiDataManager() {
        return this.laiDataManager;
    }

    public final void setLaiDataManager(LaiDataManager laiDataManager) {
        this.laiDataManager = laiDataManager;
    }

    public static GlobalForestBGC getInstance() {
        return instance;
    }

    @Override
    public String getVersion() {
        return "Forest-BGC model implementation based on the Joseph C. Coughlan's SIMLAT5 version 3.6.";
    }

    @Override
    public MultiplePointsNppResults estimate() throws Exception {
        if (this.climateDataManager == null) {
            throw new Exception("A climate data manager is needed");
        }
        if (this.siteDataManager == null) {
            throw new Exception("A site data manager is needed");
        }
        if (this.laiDataManager == null) {
            throw new Exception("A LAI data manager is needed");
        }
        ArrayList<ForestBGCResults> results = new ArrayList<ForestBGCResults>();
        HashMap<Double, ForestBGCResults> heuristico = new HashMap<Double, ForestBGCResults>();
        this.forestBGC.setClimateDataManager(this.climateDataManager);
        this.forestBGC.setSiteDataManager(this.siteDataManager);
        this.forestBGC.setDailyDataManager(this.dailyDataManager);
        this.forestBGC.setSeasonDataManager(this.seasonDataManager);
        this.forestBGC.setName(this.name);
        Iterator<LaiDataManager.CoordinatedLai> it = this.laiDataManager.laiIterator();
        int num = this.laiDataManager.getNumData();
        int i = 0;
        while (it.hasNext()) {
            LaiDataManager.CoordinatedLai lai = it.next();
            if (lai == null) {
                results.add(null);
            } else if (heuristico.containsKey(lai.getLai())) {
                results.add((ForestBGCResults)heuristico.get(lai.getLai()));
            } else {
                this.forestBGC.getSiteDataManager().setData(10, lai.getLai());
                ForestBGCResults estimatedResults = (ForestBGCResults)this.forestBGC.estimate();
                results.add(estimatedResults);
                heuristico.put(lai.getLai(), estimatedResults);
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(i * 100 / num);
            }
            ++i;
        }
        return new GlobalForestBGCResults(this.name, new Date(System.currentTimeMillis()), this, results);
    }

    @Override
    public MultiplePointsNppResults estimate(JProgressBar progressBar) throws Exception {
        this.progressBar = progressBar;
        return this.estimate();
    }

    @Override
    public String getCopyright() {
        return "Copyright 2009 M.A. Veganzones. Copyright 1988 J.C. Coughlan.";
    }
}

