/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.ClimateDataManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Simlat5ClimateDataManager
implements ClimateDataManager {
    private List<Double[]> data = new ArrayList<Double[]>();

    public Simlat5ClimateDataManager(File file) throws Exception {
        try {
            if (!file.isFile()) {
                throw new Exception("Provided file is not a file");
            }
            if (!file.canRead()) {
                throw new Exception("Provided file is not readable");
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            int i = 1;
            while (line != null) {
                String[] s = line.split("\t");
                if (!(s.length == 6 && Integer.valueOf(s[0]) == i || (s = line.split(" ")).length == 6 && Integer.valueOf(s[0]) != i)) {
                    throw new Exception("Provided file data are not valid");
                }
                Double[] d = new Double[5];
                int j = 0;
                while (j < 5) {
                    d[j] = Double.valueOf(s[j + 1]);
                    ++j;
                }
                this.data.add(d);
                line = in.readLine();
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("Exception ocurred: " + e.getMessage());
        }
    }

    @Override
    public Double[] getData(int parameter) throws Exception {
        if (parameter < 0 || parameter > 5) {
            throw new Exception("Unexisting parameter");
        }
        Double[] dataOutput = new Double[this.getNumDays()];
        ListIterator<Double[]> it = this.data.listIterator();
        int i = 0;
        while (it.hasNext()) {
            dataOutput[i] = it.next()[parameter];
            ++i;
        }
        return dataOutput;
    }

    @Override
    public Double getData(int parameter, int day) throws Exception {
        if (parameter < 0 || parameter > 5) {
            throw new Exception("Unexisting parameter");
        }
        if (day < 1 || day > this.getNumDays()) {
            throw new Exception("Unexisting day");
        }
        return this.data.get(day - 1)[parameter];
    }

    @Override
    public Double[] getAllData(int day) throws Exception {
        if (day < 1 || day > this.getNumDays()) {
            throw new Exception("Unexisting day");
        }
        return this.data.get(day - 1);
    }

    @Override
    public int getNumDays() {
        return this.data.size();
    }

    @Override
    public void setData(int parameter, Double[] data) throws Exception {
        if (parameter < 0 || parameter > 5) {
            throw new Exception("Unexisting parameter");
        }
        if (data.length != this.getNumDays()) {
            throw new Exception("Provided data is inconsistent with the number of days");
        }
        int i = 0;
        while (i < this.getNumDays()) {
            if (data[i] == null) {
                throw new Exception("Provided data has null values");
            }
            Double[] oldData = this.data.get(i);
            oldData[parameter] = data[i];
            this.data.set(i, oldData);
            ++i;
        }
    }

    @Override
    public void setData(int parameter, int day, Double data) throws Exception {
        if (parameter < 0 || parameter > 5) {
            throw new Exception("Unexisting parameter");
        }
        if (day < 1 || day > this.getNumDays()) {
            throw new Exception("Unexisting day");
        }
        if (data == null) {
            throw new Exception("Provided data has null values");
        }
        Double[] dataOld = this.data.get(day - 1);
        dataOld[parameter] = data;
        this.data.set(day - 1, dataOld);
    }
}

