/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.DailyDataManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SimpleDailyDataManager
implements DailyDataManager {
    private SortedMap<Integer, List<DailyDataManager.DailyData>> data = new TreeMap<Integer, List<DailyDataManager.DailyData>>();
    private List<Integer> constants;

    public SimpleDailyDataManager(File file) throws Exception {
        try {
            if (!file.isFile()) {
                throw new Exception("Provided file is not a file");
            }
            if (!file.canRead()) {
                throw new Exception("Provided file is not readable");
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            if (line == null) {
                throw new Exception("Empty or invalid file");
            }
            line = in.readLine();
            if (line == null) {
                throw new Exception("Empty or invalid file");
            }
            String[] s = line.trim().split("\\s+");
            boolean tabular = false;
            try {
                if (s == null || Integer.parseInt(s[0]) > 50 || Integer.parseInt(s[0]) < 1) {
                    tabular = true;
                }
            }
            catch (NumberFormatException e) {
                tabular = true;
            }
            if (tabular) {
                s = line.split("\t");
                try {
                    if (s == null || Integer.parseInt(s[0]) > 50 || Integer.parseInt(s[0]) < 1) {
                        throw new Exception("Invalid file");
                    }
                }
                catch (NumberFormatException e) {
                    throw new Exception("Invalid file");
                }
            }
            this.constants = new ArrayList<Integer>();
            int i = 0;
            while (i < s.length) {
                this.constants.add(Integer.parseInt(s[i]));
                ++i;
            }
            line = in.readLine();
            while (line != null) {
                Integer day;
                s = tabular ? line.split("\t") : line.split("\\s+");
                if (s.length != this.constants.size() + 1) {
                    throw new Exception("Provided file data are not valid");
                }
                try {
                    day = Integer.parseInt(s[0]);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Invalid file");
                }
                ArrayList<DailyDataManager.DailyData> dailyDataList = new ArrayList<DailyDataManager.DailyData>();
                int i2 = 1;
                while (i2 < s.length) {
                    if (!s[i2].equalsIgnoreCase("*")) {
                        try {
                            DailyDataManager.DailyData dailyData = new DailyDataManager.DailyData(this.constants.get(i2 - 1), Double.parseDouble(s[i2]));
                            dailyDataList.add(dailyData);
                        }
                        catch (NumberFormatException e) {
                            throw new Exception("Invalid file");
                        }
                    }
                    ++i2;
                }
                this.data.put(day, dailyDataList);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            throw new Exception("Exception ocurred: " + e.getMessage());
        }
    }

    @Override
    public List<DailyDataManager.DailyData> getDailyData(int day) {
        return (List)this.data.get(new Integer(day));
    }

    @Override
    public List<Integer> getDays() {
        return new ArrayList<Integer>((Collection)this.data.keySet());
    }

    @Override
    public List<Integer> getReplacingConstants() {
        return this.constants;
    }
}

