/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5CompoundDS
extends CompoundDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private int nAttributes = -1;
    private List flatNameList;
    private List flatTypeList;
    private boolean isExternal = false;

    public H5CompoundDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H5CompoundDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int n = -1;
            try {
                n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName());
                this.nAttributes = H5.H5Aget_num_attrs(n);
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H5Datatype(6, -1, -1, -1);
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5;
            long[] lArray = new long[]{1L};
            for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
            }
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            n4 = H5.H5Dget_type(n);
            n5 = H5.H5Tget_size(n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
        }
        finally {
            try {
                H5.H5Sclose(n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDF5Exception {
        int n;
        Vector<Object> vector = null;
        String[] stringArray = null;
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int[] nArray = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        if (this.isExternal) {
            String string2 = this.getFileFormat().getAbsoluteFile().getParent();
            if (string2 == null) {
                string2 = ".";
            }
            H5.H5Dchdir_ext(string2);
        }
        int n6 = this.open();
        vector = new Vector<Object>(this.flatNameList.size());
        Vector vector2 = new Vector();
        try {
            long[] lArray = new long[]{1L};
            lArray[0] = this.selectHyperslab(n6, nArray);
            n = this.flatNameList.size();
            n2 = H5.H5Dget_type(n6);
            this.extractCompoundInfo(n2, null, null, vector2);
            for (int i = 0; i < n; ++i) {
                if (!this.isMemberSelected[i]) continue;
                string = new String(this.memberNames[i]);
                n3 = (Integer)vector2.get(i);
                try {
                    n4 = H5.H5Tget_class(n3);
                    n5 = H5.H5Tget_size(n3);
                    stringArray = H5Datatype.allocateArray(n3, (int)lArray[0]);
                }
                catch (Exception exception) {
                    stringArray = null;
                }
                if (stringArray == null || H5.H5Tequal(n3, HDF5Constants.H5T_STD_REF_DSETREG)) {
                    String[] stringArray2 = new String[(int)lArray[0]];
                    String string3 = "unsupported: " + H5Datatype.getDatatypeDescription(n3);
                    int n7 = 0;
                    while ((long)n7 < lArray[0]) {
                        stringArray2[n7] = string3;
                        ++n7;
                    }
                    vector.add(stringArray2);
                    continue;
                }
                boolean bl = false;
                int n8 = -1;
                int[] nArray2 = new int[]{n4, n5, 0};
                try {
                    n8 = this.createCompoundFieldType(n3, string, nArray2);
                    try {
                        bl = H5.H5Tis_variable_str(n3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) {
                        H5.H5DreadVL(n6, n8, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    } else {
                        H5.H5Dread(n6, n8, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                    String[] stringArray3 = new String[(int)lArray[0]];
                    int n9 = 0;
                    while ((long)n9 < lArray[0]) {
                        stringArray3[n9] = "";
                        ++n9;
                    }
                    vector.add(stringArray3);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n8);
                    }
                    catch (Exception exception) {}
                }
                if (n4 == HDF5Constants.H5T_ARRAY) {
                    int n10 = H5.H5Tget_super(n3);
                    n4 = H5.H5Tget_class(n10);
                    try {
                        H5.H5Tclose(n10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    if (n4 == HDF5Constants.H5T_STRING && this.convertByteToString) {
                        stringArray = H5CompoundDS.byteToString((byte[])stringArray, n5 / this.memberOrders[i]);
                    } else if (n4 == HDF5Constants.H5T_REFERENCE) {
                        stringArray = (String[])HDFNativeData.byteToLong((byte[])stringArray);
                    } else if (nArray2[2] != 0) {
                        stringArray = Dataset.convertFromUnsignedC(stringArray, null);
                    } else if (n4 == HDF5Constants.H5T_ENUM) {
                        try {
                            String[] stringArray4 = H5Datatype.convertEnumValueToName(n3, stringArray, null);
                            if (stringArray4 != null) {
                                stringArray = stringArray4;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                vector.add(stringArray);
            }
        }
        finally {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            int n11 = vector2.size();
            for (n = 0; n < n11; ++n) {
                n3 = (Integer)vector2.get(n);
                try {
                    H5.H5Tclose(n3);
                    continue;
                }
                catch (Exception exception) {}
            }
            this.close(n6);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object) throws HDF5Exception {
        int n;
        if (object == null || this.numberOfMembers <= 0 || !(object instanceof List)) {
            return;
        }
        List list = (List)object;
        Object object2 = null;
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int[] nArray = new int[]{-1, -1};
        int n6 = this.open();
        Vector vector = new Vector();
        try {
            long[] lArray = new long[]{1L};
            lArray[0] = this.selectHyperslab(n6, nArray);
            n = 0;
            int n7 = this.flatNameList.size();
            n2 = H5.H5Dget_type(n6);
            this.extractCompoundInfo(n2, null, null, vector);
            for (int i = 0; i < n7; ++i) {
                if (!this.isMemberSelected[i]) continue;
                string = new String(this.memberNames[i]);
                n3 = (Integer)vector.get(i);
                if ((object2 = (Object)list.get(n++)) == null) continue;
                try {
                    n4 = H5.H5Tget_class(n3);
                    n5 = H5.H5Tget_size(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                try {
                    bl = H5.H5Tdetect_class(n3, HDF5Constants.H5T_VLEN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object2 == null || bl || n4 == HDF5Constants.H5T_ENUM) continue;
                Object object3 = object2;
                int n8 = -1;
                int[] nArray2 = new int[]{n4, n5, 0};
                try {
                    n8 = this.createCompoundFieldType(n3, string, nArray2);
                    if (nArray2[2] != 0) {
                        object3 = H5CompoundDS.convertToUnsignedC(object2, null);
                    } else if (n4 == HDF5Constants.H5T_STRING && Array.get(object2, 0) instanceof String) {
                        object3 = H5CompoundDS.stringToByte((String[])object2, n5);
                    }
                    if (object3 == null) continue;
                    H5.H5Dwrite(n6, n8, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object3);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n8);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            int n9 = vector.size();
            for (n = 0; n < n9; ++n) {
                n3 = (Integer)vector.get(n);
                try {
                    H5.H5Tclose(n3);
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        this.close(n6);
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n);
            n2 = H5.H5Dget_create_plist(n);
            if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray = new int[]{0, 0};
            int[] nArray2 = new int[]{2};
            int[] nArray3 = new int[]{0, 0};
            String[] stringArray = new String[]{"", ""};
            int n3 = H5.H5Pget_nfilters(n2);
            int n4 = -1;
            this.compression = "";
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    n4 = H5.H5Pget_filter(n2, i, nArray, nArray2, nArray3, 120, stringArray);
                }
                catch (Throwable throwable) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (n4 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + nArray3[0];
                    continue;
                }
                if (n4 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (n4 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + nArray3[0];
                    continue;
                }
                if (n4 != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + nArray3[1];
                int n5 = -1;
                try {
                    n5 = H5.H5Zget_filter_info(n4);
                }
                catch (Exception exception) {
                    n5 = -1;
                }
                if (n5 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (n5 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n5 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray4 = new int[]{0};
                H5.H5Pget_alloc_time(n2, nArray4);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (nArray4[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (nArray4[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (nArray4[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        } else {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = list.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName());
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Dclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        int n;
        block47: {
            if (this.rank > 0) {
                this.resetSelection();
                return;
            }
            n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string = this.getPath() + this.getName();
            this.flatNameList = new Vector();
            this.flatTypeList = new Vector();
            int[] nArray = null;
            n = this.open();
            int n5 = -1;
            try {
                n5 = H5.H5Dget_create_plist(n);
                int n6 = H5.H5Pget_external_count(n5);
                this.isExternal = n6 > 1;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Pclose(n5);
                }
                catch (Exception exception) {}
            }
            try {
                n2 = H5.H5Dget_space(n);
                this.rank = H5.H5Sget_simple_extent_ndims(n2);
                if (this.rank == 0) {
                    this.rank = 1;
                    this.dims = new long[1];
                    this.dims[0] = 1L;
                } else {
                    this.dims = new long[this.rank];
                    this.maxDims = new long[this.rank];
                    H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
                }
                this.startDims = new long[this.rank];
                this.selectedDims = new long[this.rank];
                n3 = H5.H5Dget_type(n);
                n4 = H5.H5Tget_class(n3);
                int n7 = 0;
                if (n4 == HDF5Constants.H5T_ARRAY) {
                    n7 = n3;
                    n3 = H5.H5Tget_super(n7);
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                }
                this.extractCompoundInfo(n3, "", this.flatNameList, this.flatTypeList);
                this.numberOfMembers = this.flatNameList.size();
                this.memberNames = new String[this.numberOfMembers];
                nArray = new int[this.numberOfMembers];
                this.memberTypes = new Datatype[this.numberOfMembers];
                this.memberOrders = new int[this.numberOfMembers];
                this.isMemberSelected = new boolean[this.numberOfMembers];
                this.memberDims = new Object[this.numberOfMembers];
                for (int i = 0; i < this.numberOfMembers; ++i) {
                    this.isMemberSelected[i] = true;
                    nArray[i] = (Integer)this.flatTypeList.get(i);
                    this.memberTypes[i] = new H5Datatype(nArray[i]);
                    this.memberNames[i] = (String)this.flatNameList.get(i);
                    this.memberOrders[i] = 1;
                    this.memberDims[i] = null;
                    try {
                        n4 = H5.H5Tget_class(nArray[i]);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                    if (n4 != HDF5Constants.H5T_ARRAY) continue;
                    int n8 = H5.H5Tget_array_ndims(nArray[i]);
                    int[] nArray2 = new int[n8];
                    H5.H5Tget_array_dims(nArray[i], nArray2, null);
                    this.memberDims[i] = nArray2;
                    n7 = H5.H5Tget_super(nArray[i]);
                    this.memberOrders[i] = H5.H5Tget_size(nArray[i]) / H5.H5Tget_size(n7);
                    try {
                        H5.H5Tclose(n7);
                        continue;
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                }
            }
            catch (HDF5Exception hDF5Exception) {
                this.numberOfMembers = 0;
                this.memberNames = null;
                this.memberTypes = null;
                this.memberOrders = null;
            }
            finally {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                if (nArray == null) break block47;
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        H5.H5Tclose((int)nArray[i]);
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.close(n);
        this.resetSelection();
    }

    @Override
    public void setName(String string) throws Exception {
        String string2 = this.getPath() + this.getName();
        String string3 = this.getPath() + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Gmove(this.getFID(), string2, string3);
        super.setName(string);
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = this.rank - 2;
            this.selectedIndex[1] = this.rank - 1;
            this.selectedIndex[2] = this.rank - 3;
            this.selectedDims[this.rank - 1] = this.dims[this.rank - 1];
            this.selectedDims[this.rank - 2] = this.dims[this.rank - 2];
        }
        this.isDataLoaded = false;
        this.setMemberSelection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractCompoundInfo(int n, String string, List list, List list2) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        try {
            n2 = H5.H5Tget_nmembers(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (n2 <= 0) {
            return;
        }
        int n5 = -1;
        for (int i = 0; i < n2; ++i) {
            try {
                n4 = H5.H5Tget_member_type(n, i);
            }
            catch (Exception exception) {
                continue;
            }
            try {
                n5 = n4;
                n4 = H5.H5Tget_native_type(n5);
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(n5);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            try {
                n3 = H5.H5Tget_class(n4);
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            if (list != null) {
                string2 = string + H5.H5Tget_member_name(n, i);
            }
            if (n3 == HDF5Constants.H5T_COMPOUND) {
                this.extractCompoundInfo(n4, string2 + "\u0095", list, list2);
                continue;
            }
            if (n3 == HDF5Constants.H5T_ARRAY) {
                try {
                    n5 = H5.H5Tget_super(n4);
                    int n6 = H5.H5Tget_class(n5);
                    if (n6 == HDF5Constants.H5T_COMPOUND || n6 == HDF5Constants.H5T_ARRAY) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (Exception exception) {}
                }
            }
            if (list != null) {
                list.add(string2);
            }
            list2.add(new Integer(n4));
        }
    }

    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray2 = new int[n];
        int[][] nArray3 = new int[n][1];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 1;
            nArray3[i][0] = nArray[i];
        }
        return H5CompoundDS.create(string, group, lArray, stringArray, datatypeArray, nArray2, nArray3, object);
    }

    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, int[][] nArray2, Object object) throws Exception {
        return H5CompoundDS.create(string, group, lArray, null, null, -1, stringArray, datatypeArray, nArray, nArray2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, int[][] nArray2, Object object) throws Exception {
        int n2;
        int n3;
        int n4;
        H5CompoundDS h5CompoundDS = null;
        String string2 = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null || nArray2 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n4 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n4 + 1);
            }
        }
        string2 = string3 + string;
        n4 = 0;
        int n9 = stringArray.length;
        int[] nArray3 = new int[n9];
        int n10 = 1;
        int n11 = lArray.length;
        for (n3 = 0; n3 < n9; ++n3) {
            n10 = 1;
            for (n2 = 0; n2 < nArray[n3]; ++n2) {
                n10 *= nArray2[n3][n2];
            }
            if (n10 > 1 && datatypeArray[n3].getDatatypeClass() != 3) {
                n2 = -1;
                try {
                    n2 = datatypeArray[n3].toNative();
                    nArray3[n3] = H5.H5Tarray_create(n2, nArray[n3], nArray2[n3], null);
                }
                finally {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {}
                }
            }
            nArray3[n3] = datatypeArray[n3].toNative();
            n4 += H5.H5Tget_size(nArray3[n3]);
        }
        try {
            n7 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n4);
            n3 = 0;
            for (n2 = 0; n2 < n9; ++n2) {
                H5.H5Tinsert(n7, stringArray[n2], n3, nArray3[n2]);
                n3 += H5.H5Tget_size(nArray3[n2]);
            }
            n6 = H5.H5Screate_simple(n11, lArray, lArray2);
            n2 = 0;
            if (lArray2 != null) {
                for (int i = 0; i < lArray2.length; ++i) {
                    if (lArray2[i] == 0L) {
                        lArray2[i] = lArray[i];
                    } else if (lArray2[i] < 0L) {
                        lArray2[i] = HDF5Constants.H5S_UNLIMITED;
                    }
                    if (lArray2[i] == lArray[i]) continue;
                    n2 = 1;
                }
            }
            if (lArray3 == null && n2 != 0) {
                lArray3 = lArray;
            }
            n8 = HDF5Constants.H5P_DEFAULT;
            if (lArray3 != null) {
                n8 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout(n8, HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk(n8, n11, lArray3);
                if (n > 0) {
                    H5.H5Pset_deflate(n8, n);
                }
            }
            int n12 = h5File.getFID();
            n5 = H5.H5Dcreate(n12, string2, n7, n6, n8);
        }
        finally {
            try {
                H5.H5Pclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Dclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            for (int i = 0; i < n9; ++i) {
                try {
                    H5.H5Tclose(nArray3[i]);
                    continue;
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        h5CompoundDS = new H5CompoundDS(h5File, string, string3);
        if (h5CompoundDS != null) {
            group.addToMemberList(h5CompoundDS);
            if (object != null) {
                h5CompoundDS.init();
                long[] lArray4 = h5CompoundDS.getSelectedDims();
                for (int i = 0; i < n11; ++i) {
                    lArray4[i] = lArray[i];
                }
                h5CompoundDS.write(object);
            }
        }
        return h5CompoundDS;
    }

    @Override
    public boolean isString(int n) {
        boolean bl = false;
        try {
            bl = HDF5Constants.H5T_STRING == H5.H5Tget_class(n);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int createCompoundFieldType(int n, String string, int[] nArray) throws HDF5Exception {
        int n2;
        int n3 = -1;
        int n4 = n2 = n;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        try {
            int n9 = nArray[0];
            int n10 = nArray[1];
            if (n9 == HDF5Constants.H5T_ARRAY) {
                int n11 = H5.H5Tget_array_ndims(n);
                int[] nArray2 = new int[n11];
                H5.H5Tget_array_dims(n, nArray2, null);
                n6 = n4 = H5.H5Tget_super(n);
                n8 = H5.H5Tget_native_type(n4);
                n7 = n2 = H5.H5Tarray_create(n8, n11, nArray2, null);
            }
            try {
                if (H5Datatype.isUnsigned(n4)) {
                    nArray[2] = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n10 = H5.H5Tget_size(n);
            String string2 = string;
            n5 = H5.H5Tcopy(n2);
            int n12 = string.lastIndexOf("\u0095");
            while (n12 > 0) {
                string2 = string.substring(n12 + 1);
                n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
                H5.H5Tinsert(n3, string2, 0L, n5);
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n5 = n3;
                string = string.substring(0, n12);
                n12 = string.lastIndexOf("\u0095");
            }
            n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
            H5.H5Tinsert(n3, string, 0L, n5);
        }
        finally {
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return n3;
    }
}

