/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.Chart;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.PaletteView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultImageView
extends JInternalFrame
implements ImageView,
ActionListener {
    public static final long serialVersionUID = 240L;
    public static final int FLIP_HORIZONTAL = 0;
    public static final int FLIP_VERTICAL = 1;
    public static final int ROTATE_CW_90 = 10;
    public static final int ROTATE_CCW_90 = 11;
    private final ViewManager viewer;
    private ScalarDS dataset;
    private ImageComponent imageComponent;
    private Image image;
    private float zoomFactor;
    private byte[] imageByteData;
    private byte[][] imagePalette;
    private String frameTitle;
    private JTextField valueField;
    private boolean isTrueColor;
    private boolean is3D;
    private boolean isPlaneInterlace;
    private boolean isHorizontalFlipped = false;
    private boolean isVerticalFlipped = false;
    private int rotateCount = 0;
    private char NT;
    private Object data;
    private boolean isUnsigned;
    private boolean isUnsignedConverted = false;
    private final Toolkit toolkit;
    private double[] dataRange;
    private double[] originalRange;
    private PaletteComponent paletteComponent;
    private int animationSpeed = 2;
    private List rotateRelatedItems;
    private JScrollPane imageScroller;
    private JTextField frameField;
    private long curFrame = 0L;
    private long maxFrame = 1L;
    private MemoryImageSource memoryImageSource;
    private AutoContrastSlider autoContrastSlider;
    private GeneralContrastSlider generalContrastSlider;
    private double[] gainBias;
    private double[] minMaxGain;
    private double[] minMaxBias;
    private Object autoGainData;

    public DefaultImageView(ViewManager viewManager) {
        this(viewManager, null);
    }

    public DefaultImageView(ViewManager viewManager, HashMap hashMap) {
        int n;
        this.setDefaultCloseOperation(2);
        this.setFrameIcon(ViewProperties.getImageIcon());
        this.viewer = viewManager;
        this.zoomFactor = 1.0f;
        this.imageByteData = null;
        this.imagePalette = null;
        this.paletteComponent = null;
        this.isTrueColor = false;
        this.is3D = false;
        this.isPlaneInterlace = false;
        this.isUnsigned = false;
        this.data = null;
        this.NT = '\u0000';
        this.toolkit = Toolkit.getDefaultToolkit();
        this.rotateRelatedItems = new Vector(10);
        this.imageScroller = null;
        this.memoryImageSource = null;
        this.autoContrastSlider = null;
        this.gainBias = null;
        this.minMaxGain = null;
        this.minMaxBias = null;
        this.autoGainData = null;
        this.generalContrastSlider = null;
        HObject hObject = null;
        hObject = hashMap != null ? (HObject)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT) : viewManager.getTreeView().getCurrentObject();
        if (hObject == null || !(hObject instanceof ScalarDS)) {
            this.viewer.showStatus("Display data in image failed for - " + hObject);
            return;
        }
        this.dataset = (ScalarDS)hObject;
        this.dataRange = this.dataset.getImageDataRange();
        if (this.dataRange == null) {
            this.dataRange = new double[2];
            this.dataRange[1] = 0.0;
            this.dataRange[0] = 0.0;
            if (this.dataset.getDatatype().getDatatypeSize() == 1) {
                this.dataRange[1] = 255.0;
            }
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.valueField = new JTextField();
        jPanel.add((Component)this.valueField, "South");
        this.valueField.setEditable(false);
        this.valueField.setVisible(false);
        if (this.image == null) {
            this.getImage();
        }
        if (this.image == null) {
            this.viewer.showStatus("Loading image failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        this.originalRange = new double[2];
        this.originalRange[0] = this.dataRange[0];
        this.originalRange[1] = this.dataRange[1];
        this.imageComponent = new ImageComponent(this.image);
        JScrollPane jScrollPane = new JScrollPane(this.imageComponent);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.imageScroller = jScrollPane;
        jPanel.add((Component)jScrollPane, "Center");
        if (this.imagePalette != null) {
            this.paletteComponent = new PaletteComponent(this.imagePalette, this.dataRange);
            jPanel.add((Component)this.paletteComponent, "East");
        }
        StringBuffer stringBuffer = new StringBuffer("ImageView  -  ");
        stringBuffer.append(hObject.getName());
        stringBuffer.append("  -  ");
        stringBuffer.append(hObject.getPath());
        stringBuffer.append("  -  ");
        stringBuffer.append(this.dataset.getFile());
        this.setTitle(stringBuffer.toString());
        this.frameTitle = stringBuffer.toString();
        this.setTitle(this.frameTitle);
        this.setName(this.frameTitle);
        int n2 = this.dataset.getRank();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray = this.dataset.getSelectedDims();
        long[] lArray2 = this.dataset.getStride();
        long[] lArray3 = this.dataset.getDims();
        long[] lArray4 = this.dataset.getStartDims();
        int n3 = Math.min(3, n2);
        if (n2 > 2) {
            this.curFrame = lArray4[nArray[2]];
            this.maxFrame = lArray3[nArray[2]];
        }
        stringBuffer.append(" [ dims");
        stringBuffer.append(nArray[0]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(nArray[n]);
        }
        stringBuffer.append(", start");
        stringBuffer.append(lArray4[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray4[nArray[n]]);
        }
        stringBuffer.append(", count");
        stringBuffer.append(lArray[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray[nArray[n]]);
        }
        stringBuffer.append(", stride");
        stringBuffer.append(lArray2[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray2[nArray[n]]);
        }
        stringBuffer.append(" ] ");
        this.setJMenuBar(this.createMenuBar());
        this.viewer.showStatus(stringBuffer.toString());
    }

    private JMenuBar createMenuBar() {
        char c;
        Object object;
        JMenuBar jMenuBar = new JMenuBar();
        boolean bl = !this.dataset.getFileFormat().isReadOnly();
        JMenu jMenu = new JMenu("Image", false);
        jMenu.setMnemonic('I');
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Save Image As");
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("JPEG");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save image as jpeg");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("PNG");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save image as png");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("GIF");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save image as gif");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("BMP");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save image as bmp");
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Write Selection to Image");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Write selection to image");
        jMenuItem.setEnabled(bl);
        this.rotateRelatedItems.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Change Palette");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Edit palette");
        jMenuItem.setEnabled(!this.isTrueColor);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Import Palette from File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Import palette");
        jMenuItem.setEnabled(!this.isTrueColor);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Set Value Range");
        jMenuItem.setEnabled(!this.isTrueColor);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Set data range");
        jMenu.add(jMenuItem);
        try {
            object = this.data.getClass().getName();
            c = ((String)object).charAt(((String)object).lastIndexOf("[") + 1);
            if (c == 'B') {
                jMenuItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Histogram");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show chart");
        jMenuItem.setEnabled(!this.isTrueColor);
        this.rotateRelatedItems.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Zoom In");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Zoom in");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom Out");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Zoom out");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        object = new JMenu("Flip");
        jMenu.add((JMenuItem)object);
        jMenuItem = new JMenuItem("Horizontal");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Flip horizontal");
        ((JMenu)object).add(jMenuItem);
        jMenuItem = new JMenuItem("Vertical");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Flip vertical");
        ((JMenu)object).add(jMenuItem);
        object = new JMenu("Rotate Image");
        jMenu.add((JMenuItem)object);
        c = '\u00ba';
        jMenuItem = new JMenuItem("90" + c + " CW");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Rotate clockwise");
        ((JMenu)object).add(jMenuItem);
        jMenuItem = new JMenuItem("90" + c + " CCW");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Rotate counter clockwise");
        ((JMenu)object).add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Brightness/Contrast");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Brightness");
        jMenu.add(jMenuItem);
        JMenu jMenu3 = new JMenu("Contour");
        for (int i = 3; i < 10; ++i) {
            jMenuItem = new JMenuItem(String.valueOf(i));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("Contour " + i);
            jMenu3.add(jMenuItem);
        }
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Animation");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show animation");
        jMenuItem.setEnabled(this.is3D);
        jMenu.add(jMenuItem);
        JMenu jMenu4 = new JMenu("Animation (frames/second)");
        for (int i = 2; i < 12; i += 2) {
            jMenuItem = new JMenuItem(String.valueOf(i));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("Animation speed " + i);
            jMenu4.add(jMenuItem);
        }
        jMenu4.setEnabled(this.is3D);
        jMenu.add(jMenu4);
        jMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Value", false);
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand("Show image value");
        this.rotateRelatedItems.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem);
        jMenuItem = new JMenuItem("Show Statistics");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show statistics");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Select all data");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close");
        jMenu.add(jMenuItem);
        jMenuBar.add(new JLabel("       "));
        Insets insets = new Insets(0, 2, 0, 2);
        JButton jButton = new JButton(ViewProperties.getChartIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Histogram");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Show chart");
        jButton.setEnabled(!this.isTrueColor);
        jButton = new JButton(ViewProperties.getPaletteIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Palette");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Edit palette");
        jButton.setEnabled(!this.isTrueColor);
        jButton = new JButton(ViewProperties.getBrightIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Brightness");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Brightness");
        jButton = new JButton(ViewProperties.getAutocontrastIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Calculate AutoGain");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Calculate AutoGain");
        jButton.setEnabled(ViewProperties.isAutoContrast());
        jButton = new JButton(ViewProperties.getZoominIcon());
        jMenuBar.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setActionCommand("Zoom in");
        jButton.setToolTipText("Zoom In");
        jButton = new JButton(ViewProperties.getZoomoutIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Zoom Out");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Zoom out");
        if (this.is3D) {
            jMenuBar.add(new JLabel("     "));
            jButton = new JButton(ViewProperties.getFirstIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("First");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("First page");
            jButton = new JButton(ViewProperties.getPreviousIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Previous");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Previous page");
            this.frameField = new JTextField(String.valueOf(this.curFrame));
            this.frameField.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(this.frameField);
            this.frameField.setMargin(insets);
            this.frameField.addActionListener(this);
            this.frameField.setActionCommand("Go to frame");
            JLabel jLabel = new JLabel(String.valueOf(this.maxFrame), 0);
            jLabel.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(jLabel);
            jButton = new JButton(ViewProperties.getNextIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Next");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Next page");
            jButton = new JButton(ViewProperties.getLastIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Last");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Last page");
            jButton = new JButton(ViewProperties.getAnimationIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Animation");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Show animation");
        }
        return jMenuBar;
    }

    private void previousPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray = this.dataset.getSelectedDims();
        if (lArray[nArray[2]] > 1L) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long[] lArray3 = this.dataset.getDims();
        long l = lArray2[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(lArray2[nArray[2]] - 1L);
    }

    private void nextPage() {
        long[] lArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getSelectedDims();
        if (lArray2[nArray[2]] > 1L) {
            return;
        }
        long[] lArray3 = this.dataset.getStartDims();
        long l = lArray3[nArray[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray3[nArray[2]] + 1L);
    }

    private void firstPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray = this.dataset.getSelectedDims();
        if (lArray[nArray[2]] > 1L) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long[] lArray3 = this.dataset.getDims();
        long l = lArray2[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(0L);
    }

    private void lastPage() {
        long[] lArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getSelectedDims();
        if (lArray2[nArray[2]] > 1L) {
            return;
        }
        long[] lArray3 = this.dataset.getStartDims();
        long l = lArray3[nArray[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray[nArray[2]] - 1L);
    }

    @Override
    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        int n = this.dataset.getRank();
        if (n <= 0) {
            this.dataset.init();
        }
        this.isTrueColor = this.dataset.isTrueColor();
        this.is3D = this.dataset.getRank() > 2 && !this.dataset.isTrueColor();
        Object var2_2 = null;
        try {
            if (this.isTrueColor) {
                this.getTrueColorImage();
            } else {
                this.getIndexedImage();
            }
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable, this.getTitle(), 0);
            return null;
        }
        if (this.data != null) {
            this.isUnsigned = this.dataset.isUnsigned();
            String string = this.data.getClass().getName();
            this.NT = string.charAt(string.lastIndexOf("[") + 1);
        }
        return this.image;
    }

    private void getIndexedImage() throws Exception, OutOfMemoryError {
        this.imagePalette = this.dataset.getPalette();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.dataset.getFileFormat().exists();
        if (this.imagePalette == null) {
            bl = true;
            this.imagePalette = Tools.createGrayPalette();
            this.viewer.showStatus("\nNo attached palette found, default grey palette is used to display image");
        }
        this.data = this.dataset.getData();
        if (this.dataset.getDatatype().getDatatypeClass() == 0) {
            this.data = this.dataset.convertFromUnsignedC();
            this.isUnsignedConverted = true;
            bl2 = ViewProperties.isAutoContrast() && bl && bl3;
        } else {
            bl2 = false;
        }
        boolean bl4 = true;
        if (bl2) {
            bl4 = !this.computeAutoGainImageData();
        }
        int n = this.dataset.getWidth();
        int n2 = this.dataset.getHeight();
        if (bl4) {
            this.imageByteData = this.dataset.isDefaultImageOrder() ? Tools.getBytes(this.data, this.dataRange, this.dataset.getFillValue(), this.imageByteData) : Tools.getBytes(this.data, this.dataRange, n, n2, true, this.dataset.getFillValue(), this.imageByteData);
        }
        this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, n, n2);
    }

    private void getTrueColorImage() throws Exception, OutOfMemoryError {
        this.isPlaneInterlace = this.dataset.getInterlace() == 2;
        long[] lArray = this.dataset.getSelectedDims();
        long[] lArray2 = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray3 = this.dataset.getStride();
        if (lArray2.length > 2) {
            lArray2[nArray[2]] = 0L;
            lArray[nArray[2]] = 3L;
            lArray3[nArray[2]] = 1L;
        }
        this.dataset.clearData();
        this.data = this.dataset.getData();
        this.imageByteData = Tools.getBytes(this.data, this.dataRange, this.dataset.getFillValue(), this.imageByteData);
        int n = this.dataset.getWidth();
        int n2 = this.dataset.getHeight();
        this.image = this.createTrueColorImage(this.imageByteData, this.isPlaneInterlace, n, n2);
    }

    private boolean computeAutoGainImageData() {
        boolean bl = true;
        boolean bl2 = this.dataset.isUnsigned();
        if (this.gainBias == null) {
            this.gainBias = new double[2];
            this.minMaxGain = new double[2];
            this.minMaxBias = new double[2];
            Tools.autoContrastCompute(this.data, this.gainBias, bl2);
            Tools.autoContrastComputeSliderRange(this.gainBias, this.minMaxGain, this.minMaxBias);
        }
        this.autoGainData = Tools.autoContrastApply(this.data, this.autoGainData, this.gainBias, bl2);
        if (this.autoGainData != null) {
            if (this.imageByteData == null || this.imageByteData.length != Array.getLength(this.data)) {
                this.imageByteData = new byte[Array.getLength(this.data)];
            }
            bl = Tools.autoContrastConvertImageBuffer(this.autoGainData, this.imageByteData, true) >= 0;
        } else {
            bl = false;
        }
        return bl;
    }

    private void zoomIn() {
        if (this.zoomFactor >= 1.0f) {
            this.zoomTo(this.zoomFactor + 1.0f);
        } else {
            this.zoomTo(this.zoomFactor + 0.125f);
        }
    }

    private void zoomOut() {
        if (this.zoomFactor > 1.0f) {
            this.zoomTo(this.zoomFactor - 1.0f);
        } else {
            this.zoomTo(this.zoomFactor - 0.125f);
        }
    }

    private void zoomTo(float f) {
        this.zoomFactor = f > 8.0f ? 8.0f : ((double)f < 0.125 ? 0.125f : f);
        Dimension dimension = new Dimension((int)((float)((ImageComponent)this.imageComponent).originalSize.width * this.zoomFactor), (int)((float)((ImageComponent)this.imageComponent).originalSize.height * this.zoomFactor));
        this.invalidate();
        this.imageComponent.invalidate();
        this.imageComponent.setImageSize(dimension);
        this.validate();
        if ((double)this.zoomFactor > 0.99 && (double)this.zoomFactor < 1.01) {
            this.setTitle(this.frameTitle);
        } else {
            this.setTitle(this.frameTitle + " - " + 100.0f * this.zoomFactor + "%");
        }
    }

    private void showColorTable() {
        if (this.imagePalette == null) {
            return;
        }
        String string = (String)HDFView.getListOfPaletteView().get(0);
        try {
            Class<?> clazz = Class.forName(string);
            if ("ncsa.hdf.view.DefaultPaletteView".equals(string)) {
                Object[] objectArray = new Object[]{this.viewer, this};
                PaletteView paletteView = (PaletteView)Tools.newInstance(clazz, objectArray);
            } else {
                Object[] objectArray = new Object[]{this};
                PaletteView paletteView = (PaletteView)Tools.newInstance(clazz, objectArray);
            }
        }
        catch (Exception exception) {
            this.viewer.showStatus(exception.toString());
        }
    }

    private void showHistogram() {
        int n;
        Rectangle rectangle = this.imageComponent.selectedArea;
        if (this.isTrueColor) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: unable to draw histogram for true color image.", this.getTitle(), 0);
            return;
        }
        if (rectangle == null || rectangle.getWidth() <= 0.0 || rectangle.getHeight() <= 0.0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data for histogram.\nUse Shift+Mouse_drag to select an image area.", this.getTitle(), 0);
            return;
        }
        double[][] dArray = new double[1][256];
        for (n = 0; n < 256; ++n) {
            dArray[0][n] = 0.0;
        }
        n = this.dataset.getWidth();
        int n2 = (int)((float)rectangle.x / this.zoomFactor);
        int n3 = (int)((float)rectangle.y / this.zoomFactor);
        int n4 = n2 + (int)((float)rectangle.width / this.zoomFactor);
        int n5 = n3 + (int)((float)rectangle.height / this.zoomFactor);
        int n6 = 0;
        for (int i = n3; i < n5; ++i) {
            for (int j = n2; j < n4; ++j) {
                n6 = this.imageByteData[i * n + j];
                if (n6 < 0) {
                    n6 += 256;
                }
                double[] dArray2 = dArray[0];
                int n7 = n6;
                dArray2[n7] = dArray2[n7] + 1.0;
            }
        }
        double[] dArray3 = this.originalRange;
        if (dArray3 == null || dArray3[0] == dArray3[1]) {
            dArray3 = new double[2];
            Tools.findMinMax(this.data, dArray3, null);
        }
        Chart chart = new Chart((JFrame)((Object)this.viewer), "Histogram - " + this.dataset.getPath() + this.dataset.getName() + " - by pixel index", 0, dArray, dArray3, null);
        chart.setVisible(true);
    }

    private void selectAll() throws Exception {
        this.imageComponent.selectAll();
    }

    private void flip(int n) {
        FlipFilter flipFilter = new FlipFilter(n);
        if (flipFilter == null) {
            return;
        }
        if (this.changeImageFilter(flipFilter)) {
            if (n == 0) {
                this.isHorizontalFlipped = !this.isHorizontalFlipped;
            } else {
                this.isVerticalFlipped = !this.isVerticalFlipped;
            }
        }
    }

    private void rotate(int n) {
        Rotate90Filter rotate90Filter = new Rotate90Filter(n);
        this.changeImageFilter(rotate90Filter);
    }

    private void contour(int n) {
        ContourFilter contourFilter = new ContourFilter(n);
        if (contourFilter == null) {
            return;
        }
        this.changeImageFilter(contourFilter);
    }

    private void brightness(int n, int n2) {
        BrightnessFilter brightnessFilter = new BrightnessFilter(n, n2);
        if (brightnessFilter == null) {
            return;
        }
        this.changeImageFilter(brightnessFilter);
    }

    private void applyAutoGain() {
        if (this.computeAutoGainImageData()) {
            int n = this.dataset.getWidth();
            int n2 = this.dataset.getHeight();
            this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, n, n2);
            this.imageComponent.setImage(this.image);
            this.zoomTo(this.zoomFactor);
        }
    }

    private void setValueVisible(boolean bl) {
        this.valueField.setVisible(bl);
        this.validate();
    }

    private boolean hasAlpha(Image image) {
        if (image == null) {
            return false;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = (BufferedImage)this.createImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void saveImageAs(String string) throws Exception {
        int n;
        if (this.image == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(this.dataset.getFile());
        if (string.equals("JPEG")) {
            jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterJPEG());
        } else if (string.equals("PNG")) {
            jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterPNG());
        } else if (string.equals("GIF")) {
            jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterGIF());
        } else if (string.equals("BMP")) {
            jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterBMP());
        }
        jFileChooser.setDialogTitle("Save Current Image To " + string + " File --- " + this.dataset.getName());
        File file = new File(this.dataset.getName() + "." + string.toLowerCase());
        jFileChooser.setSelectedFile(file);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.toBufferedImage(this.image);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, outOfMemoryError.getMessage(), this.getTitle(), 0);
            return;
        }
        Tools.saveImageAs(bufferedImage, file, string);
        bufferedImage = null;
        this.viewer.showStatus("Current image saved to: " + string2);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            long l = randomAccessFile.length();
            randomAccessFile.close();
            this.viewer.showStatus("File size (bytes): " + l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block71: {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (string.equals("Close")) {
                    this.dispose();
                    ((Vector)this.rotateRelatedItems).setSize(0);
                    break block71;
                }
                if (string.startsWith("Save image as ")) {
                    String string2 = null;
                    if (string.equals("Save image as jpeg")) {
                        string2 = "JPEG";
                    } else if (string.equals("Save image as tiff")) {
                        string2 = "TIFF";
                    } else if (string.equals("Save image as png")) {
                        string2 = "PNG";
                    } else if (string.equals("Save image as gif")) {
                        string2 = "GIF";
                    } else if (string.equals("Save image as bmp")) {
                        string2 = "BMP";
                    }
                    try {
                        this.saveImageAs(string2);
                    }
                    catch (Exception exception) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                    }
                    break block71;
                }
                if (string.equals("Write selection to image")) {
                    if (this.getSelectedArea().width <= 0 || this.getSelectedArea().height <= 0) {
                        JOptionPane.showMessageDialog(this, "No data to write.\nUse Shift+Mouse_drag to select an image area.", "HDFView", 1);
                        return;
                    }
                    TreeView treeView = this.viewer.getTreeView();
                    TreeNode treeNode = treeView.findTreeNode(this.dataset);
                    Group group = (Group)((DefaultMutableTreeNode)treeNode.getParent()).getUserObject();
                    TreeNode treeNode2 = this.dataset.getFileFormat().getRootNode();
                    if (treeNode2 == null) {
                        return;
                    }
                    Vector<Object> vector = new Vector<Object>(this.dataset.getFileFormat().getNumberOfMembers() + 5);
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode2).depthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                        vector.add(defaultMutableTreeNode.getUserObject());
                    }
                    NewDatasetDialog newDatasetDialog = new NewDatasetDialog((JFrame)((Object)this.viewer), group, vector, this);
                    newDatasetDialog.setVisible(true);
                    HObject hObject = (HObject)newDatasetDialog.getObject();
                    if (hObject != null) {
                        Group group2 = newDatasetDialog.getParentGroup();
                        try {
                            treeView.addObject(hObject, group2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    vector.setSize(0);
                    break block71;
                }
                if (string.equals("Zoom in")) {
                    this.zoomIn();
                    break block71;
                }
                if (string.equals("Zoom out")) {
                    this.zoomOut();
                    break block71;
                }
                if (string.equals("Edit palette")) {
                    this.showColorTable();
                    break block71;
                }
                if (string.equals("Import palette")) {
                    JFileChooser jFileChooser = new JFileChooser(ViewProperties.getWorkDir());
                    int n = jFileChooser.showOpenDialog(this);
                    if (n != 0) {
                        return;
                    }
                    File file = jFileChooser.getSelectedFile();
                    if (file == null || file.isDirectory()) {
                        return;
                    }
                    ViewProperties.getPaletteList().addElement(file.getAbsolutePath());
                    break block71;
                }
                if (string.equals("Set data range")) {
                    DataRangeDialog dataRangeDialog = new DataRangeDialog((JFrame)((Object)this.viewer), this.dataRange, (int)this.originalRange[0], (int)this.originalRange[1]);
                    double[] dArray = dataRangeDialog.getRange();
                    if (dArray == null || dArray[0] == dArray[1] || dArray[0] == this.dataRange[0] && dArray[1] == this.dataRange[1]) {
                        return;
                    }
                    this.changeDataRange(dArray);
                    break block71;
                }
                if (string.equals("Flip horizontal")) {
                    this.flip(0);
                    break block71;
                }
                if (string.equals("Flip vertical")) {
                    this.flip(1);
                    break block71;
                }
                if (string.startsWith("Rotate")) {
                    if (string.equals("Rotate clockwise")) {
                        this.rotate(10);
                        ++this.rotateCount;
                        if (this.rotateCount == 4) {
                            this.rotateCount = 0;
                        }
                    } else {
                        this.rotate(11);
                        --this.rotateCount;
                        if (this.rotateCount == -4) {
                            this.rotateCount = 0;
                        }
                    }
                    int n = this.rotateRelatedItems.size();
                    for (int i = 0; i < n; ++i) {
                        boolean bl = this.rotateCount == 0;
                        ((JComponent)this.rotateRelatedItems.get(i)).setEnabled(bl);
                    }
                    break block71;
                }
                if (string.equals("Show image value")) {
                    boolean bl = ((JCheckBoxMenuItem)object).getState();
                    this.setValueVisible(bl);
                    break block71;
                }
                if (string.startsWith("Go to frame")) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(this.frameField.getText().trim());
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                    this.gotoPage(n);
                    break block71;
                }
                if (string.startsWith("Show animation")) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    Animation animation = new Animation((JFrame)((Object)this.viewer), this.dataset);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break block71;
                }
                if (string.startsWith("Animation speed")) {
                    this.animationSpeed = Integer.parseInt(string.substring(string.length() - 2).trim());
                    break block71;
                }
                if (string.startsWith("Contour")) {
                    int n = Integer.parseInt(string.substring(string.length() - 1));
                    this.contour(n);
                    break block71;
                }
                if (string.startsWith("Brightness")) {
                    boolean bl;
                    boolean bl2 = bl = ViewProperties.isAutoContrast() && this.minMaxGain != null && this.minMaxBias != null;
                    if (bl) {
                        if (this.autoContrastSlider == null) {
                            this.autoContrastSlider = new AutoContrastSlider((JFrame)((Object)this.viewer), this.dataRange);
                        }
                        this.autoContrastSlider.setVisible(true);
                        if (this.autoContrastSlider.isValueChanged) {
                            this.applyAutoGain();
                        }
                    } else {
                        if (this.generalContrastSlider == null) {
                            this.generalContrastSlider = new GeneralContrastSlider((JFrame)((Object)this.viewer), this.image.getSource());
                        }
                        this.generalContrastSlider.setVisible(true);
                    }
                    break block71;
                }
                if (string.equals("Calculate AutoGain")) {
                    boolean bl;
                    boolean bl3 = bl = ViewProperties.isAutoContrast() && this.minMaxGain != null && this.minMaxBias != null;
                    if (bl) {
                        this.gainBias = null;
                        this.applyAutoGain();
                    }
                    break block71;
                }
                if (string.equals("Show chart")) {
                    this.showHistogram();
                    break block71;
                }
                if (string.equals("First page")) {
                    this.firstPage();
                    break block71;
                }
                if (string.equals("Previous page")) {
                    this.previousPage();
                    break block71;
                }
                if (string.equals("Next page")) {
                    this.nextPage();
                    break block71;
                }
                if (string.equals("Last page")) {
                    this.lastPage();
                    break block71;
                }
                if (string.equals("Show statistics")) {
                    try {
                        double[] dArray = new double[2];
                        double[] dArray2 = new double[2];
                        Tools.findMinMax(this.data, dArray, this.dataset.getFillValue());
                        if (Tools.computeStatistics(this.data, dArray2, this.dataset.getFillValue()) > 0) {
                            String string3 = "Min                      = " + dArray[0] + "\nMax                      = " + dArray[1] + "\nMean                     = " + dArray2[0] + "\nStandard deviation = " + dArray2[1];
                            JOptionPane.showMessageDialog(this, string3, "Statistics", 1);
                        }
                        break block71;
                    }
                    catch (Exception exception) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    }
                    break block71;
                }
                if (string.equals("Select all data")) {
                    try {
                        this.selectAll();
                    }
                    catch (Exception exception) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    }
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.dataset.isImage()) {
            this.dataset.clearData();
        }
        this.data = null;
        this.image = null;
        this.imageByteData = null;
        this.imageComponent = null;
        this.autoGainData = null;
        ((Vector)this.rotateRelatedItems).setSize(0);
        System.runFinalization();
        System.gc();
        this.viewer.removeDataView(this);
        super.dispose();
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public byte[] getImageByteData() {
        return this.imageByteData;
    }

    @Override
    public Object getSelectedData() {
        Object[] objectArray = null;
        int n = ((ImageComponent)this.imageComponent).originalSelectedArea.width;
        int n2 = ((ImageComponent)this.imageComponent).originalSelectedArea.height;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        int n3 = n * n2;
        if (this.isTrueColor) {
            n3 *= 3;
        }
        if (this.NT == 'B') {
            objectArray = new byte[n3];
        } else if (this.NT == 'S') {
            objectArray = new short[n3];
        } else if (this.NT == 'I') {
            objectArray = new int[n3];
        } else if (this.NT == 'J') {
            objectArray = new long[n3];
        } else if (this.NT == 'F') {
            objectArray = new float[n3];
        } else if (this.NT == 'D') {
            objectArray = new double[n3];
        } else {
            return null;
        }
        int n4 = ((ImageComponent)this.imageComponent).originalSelectedArea.y;
        int n5 = ((ImageComponent)this.imageComponent).originalSelectedArea.x;
        int n6 = ((ImageComponent)this.imageComponent).originalSize.width;
        int n7 = ((ImageComponent)this.imageComponent).originalSize.height;
        if (this.isHorizontalFlipped) {
            n5 = n6 - 1 - n5 - n;
        }
        if (this.isVerticalFlipped) {
            n4 = n7 - 1 - n4 - n2;
        }
        int n8 = 0;
        int n9 = 0;
        if (this.isTrueColor) {
            int n10 = n6 * n7;
            if (this.isPlaneInterlace) {
                for (int i = 0; i < 3; ++i) {
                    int n11 = n10 * i;
                    for (int j = 0; j < n2; ++j) {
                        n8 = n11 + (n4 + j) * n6 + n5;
                        System.arraycopy(this.data, n8, objectArray, n9, n);
                        n9 += n;
                    }
                }
            } else {
                int n12 = n * 3;
                for (int i = 0; i < n2; ++i) {
                    n8 = (n4 + i) * n6 + n5;
                    System.arraycopy(this.data, n8 * 3, objectArray, n9, n12);
                    n9 += n12;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                n8 = (n4 + i) * n6 + n5;
                System.arraycopy(this.data, n8, objectArray, n9, n);
                n9 += n;
            }
        }
        return objectArray;
    }

    @Override
    public Rectangle getSelectedArea() {
        return this.imageComponent.originalSelectedArea;
    }

    @Override
    public boolean isTrueColor() {
        return this.isTrueColor;
    }

    @Override
    public boolean isPlaneInterlace() {
        return this.isPlaneInterlace;
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
        this.imageComponent.setImage(image);
    }

    @Override
    public byte[][] getPalette() {
        return this.imagePalette;
    }

    @Override
    public void setPalette(byte[][] byArray) {
        this.imagePalette = byArray;
        this.paletteComponent.updatePalette(byArray);
    }

    private void gotoPage(long l) {
        if (this.dataset.getRank() < 3) {
            return;
        }
        long[] lArray = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getDims();
        if (l < 0L || l >= lArray2[nArray[2]]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Frame number must be between 0 and " + (lArray2[nArray[2]] - 1L), this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        lArray[nArray[2]] = l;
        this.curFrame = l;
        this.dataset.clearData();
        this.image = null;
        this.imageComponent.setImage(this.getImage());
        this.frameField.setText(String.valueOf(this.curFrame));
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updateUI();
    }

    public Image createIndexedImage(byte[] byArray, byte[][] byArray2, int n, int n2) {
        Image image = null;
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray2[0], byArray2[1], byArray2[2]);
        if (this.memoryImageSource == null) {
            this.memoryImageSource = new MemoryImageSource(n, n2, (ColorModel)indexColorModel, byArray, 0, n);
        } else {
            this.memoryImageSource.newPixels(byArray, (ColorModel)indexColorModel, 0, n);
        }
        image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
        return image;
    }

    public Image createTrueColorImage(byte[] byArray, boolean bl, int n, int n2) {
        Image image = null;
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n4 = 0;
                if (bl) {
                    n6 = byArray[n5];
                    n7 = byArray[n3 + n5];
                    n8 = byArray[n3 * 2 + n5];
                } else {
                    n6 = byArray[n5 * 3];
                    n7 = byArray[n5 * 3 + 1];
                    n8 = byArray[n5 * 3 + 2];
                }
                n6 = n6 << 16 & 0xFF0000;
                n7 = n7 << 8 & 0xFF00;
                n4 = 0xFF000000 | n6 | n7 | (n8 &= 0xFF);
                nArray[n5++] = n4;
            }
        }
        DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
        if (this.memoryImageSource == null) {
            this.memoryImageSource = new MemoryImageSource(n, n2, (ColorModel)directColorModel, nArray, 0, n);
        } else {
            this.memoryImageSource.newPixels(nArray, (ColorModel)directColorModel, 0, n);
        }
        image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
        nArray = null;
        return image;
    }

    private boolean changeImageFilter(ImageFilter imageFilter) {
        boolean bl = true;
        ImageProducer imageProducer = this.image.getSource();
        try {
            this.image = this.createImage(new FilteredImageSource(imageProducer, imageFilter));
            this.imageComponent.setImage(this.image);
            this.zoomTo(this.zoomFactor);
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable.getMessage(), this.getTitle(), 0);
            bl = false;
        }
        return bl;
    }

    private void changeDataRange(double[] dArray) {
        try {
            this.imageByteData = Tools.getBytes(this.data, dArray, this.dataset.getFillValue(), this.imageByteData);
            int n = this.dataset.getWidth();
            int n2 = this.dataset.getHeight();
            this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, n, n2);
            this.imageComponent.setImage(this.image);
            this.zoomTo(this.zoomFactor);
            this.paletteComponent.updateRange(dArray);
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable.getMessage(), this.getTitle(), 0);
        }
        this.dataRange[0] = dArray[0];
        this.dataRange[1] = dArray[1];
    }

    static /* synthetic */ double[] access$4302(DefaultImageView defaultImageView, double[] dArray) {
        defaultImageView.gainBias = dArray;
        return dArray;
    }

    private class AutoContrastSlider
    extends JDialog
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        public static final long serialVersionUID = 240L;
        private boolean isValueChanged;
        JSlider brightSlider;
        JSlider contrastSlider;
        JFormattedTextField brightField;
        JFormattedTextField contrastField;
        int[] gain;
        int[] bias;

        public AutoContrastSlider(JFrame jFrame, double[] dArray) {
            super(jFrame, "Brightness/Contrast", true);
            this.isValueChanged = false;
            this.gain = new int[]{(int)DefaultImageView.this.minMaxGain[0], (int)DefaultImageView.this.minMaxGain[1]};
            this.bias = new int[]{(int)DefaultImageView.this.minMaxBias[0], (int)DefaultImageView.this.minMaxBias[1]};
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setMinimum(new Integer(this.bias[0]));
            numberFormatter.setMaximum(new Integer(this.bias[1]));
            this.brightField = new JFormattedTextField(numberFormatter);
            this.brightField.addPropertyChangeListener(this);
            this.brightField.setValue(new Integer((int)DefaultImageView.this.gainBias[1]));
            this.brightSlider = new JSlider(0, this.bias[0], this.bias[1], (int)DefaultImageView.this.gainBias[1]);
            int n = (this.bias[1] - this.bias[0]) / 10;
            if (n < 1) {
                n = 1;
            }
            this.brightSlider.setMajorTickSpacing(n);
            this.brightSlider.setPaintTicks(true);
            this.brightSlider.setPaintLabels(true);
            this.brightSlider.addChangeListener(this);
            this.brightSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setMinimum(new Integer(this.gain[0]));
            numberFormatter.setMaximum(new Integer(this.gain[1]));
            this.contrastField = new JFormattedTextField(numberFormatter);
            this.contrastField.addPropertyChangeListener(this);
            this.contrastField.setValue(new Integer((int)DefaultImageView.this.gainBias[0]));
            this.contrastSlider = new JSlider(0, this.gain[0], this.gain[1], (int)DefaultImageView.this.gainBias[0]);
            n = (this.gain[1] - this.gain[0]) / 10;
            if (n < 1) {
                n = 1;
            }
            this.contrastSlider.setMajorTickSpacing(n);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setPaintLabels(true);
            this.contrastSlider.addChangeListener(this);
            this.contrastSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setLayout(new BorderLayout(10, 10));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setPreferredSize(new Dimension(500, 350));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("Brightness"));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.brightField, "North");
            jPanel2.add((Component)this.brightSlider, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new TitledBorder("Contrast"));
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)this.contrastField, "North");
            jPanel3.add((Component)this.contrastSlider, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel.add((Component)jPanel4, "Center");
            JPanel jPanel5 = new JPanel();
            JButton jButton = new JButton("   Ok   ");
            jButton.setMnemonic(79);
            jButton.setActionCommand("Ok_gain_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Cancel");
            jButton.setMnemonic(67);
            jButton.setActionCommand("Cancel_gain_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Apply");
            jButton.setMnemonic(65);
            jButton.setActionCommand("Apply_gain_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jPanel.add((Component)jPanel5, "South");
            jButton = new JButton("Calculate AutoGain");
            jButton.setActionCommand("Calculate AutoGain");
            jButton.addActionListener(this);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout());
            jPanel6.add((Component)jButton, "East");
            jPanel.add((Component)jPanel6, "North");
            Point point = this.getParent().getLocation();
            Dimension dimension = this.getParent().getPreferredSize();
            point.x += 300;
            point.y += 200;
            this.setLocation(point);
            this.pack();
        }

        @Override
        public void setVisible(boolean bl) {
            this.brightField.setValue(new Integer((int)DefaultImageView.this.gainBias[1]));
            this.contrastField.setValue(new Integer((int)DefaultImageView.this.gainBias[0]));
            super.setVisible(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Ok_gain_change") || string.equals("Apply_gain_change")) {
                int n = ((Number)this.brightField.getValue()).intValue();
                int n2 = ((Number)this.contrastField.getValue()).intValue();
                if (n != (int)DefaultImageView.this.gainBias[1] || n2 != (int)DefaultImageView.this.gainBias[0]) {
                    ((DefaultImageView)DefaultImageView.this).gainBias[1] = n;
                    ((DefaultImageView)DefaultImageView.this).gainBias[0] = n2;
                    this.isValueChanged = true;
                } else {
                    this.isValueChanged = false;
                }
                if (string.startsWith("Ok")) {
                    this.setVisible(false);
                } else if (this.isValueChanged) {
                    DefaultImageView.this.applyAutoGain();
                    this.isValueChanged = false;
                }
            } else if (string.equals("Cancel_gain_change")) {
                this.isValueChanged = false;
                this.setVisible(false);
            } else if (string.equals("Calculate AutoGain")) {
                DefaultImageView.access$4302(DefaultImageView.this, null);
                DefaultImageView.this.applyAutoGain();
                this.isValueChanged = false;
                this.brightField.setValue(new Integer((int)DefaultImageView.this.gainBias[1]));
                this.contrastField.setValue(new Integer((int)DefaultImageView.this.gainBias[0]));
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof JSlider)) {
                return;
            }
            JSlider jSlider = (JSlider)object;
            int n = jSlider.getValue();
            if (jSlider.equals(this.brightSlider)) {
                this.brightField.setValue(new Integer(n));
            } else if (jSlider.equals(this.contrastSlider)) {
                this.contrastField.setValue(new Integer(n));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                Number number = (Number)propertyChangeEvent.getNewValue();
                if (number == null) {
                    return;
                }
                double d = number.doubleValue();
                if (object.equals(this.brightField) && this.brightSlider != null) {
                    if (d > (double)this.bias[1]) {
                        d = this.bias[1];
                    } else if (d < (double)this.bias[0]) {
                        d = this.bias[0];
                    }
                    this.brightSlider.setValue((int)d);
                } else if (object.equals(this.contrastField) && this.contrastSlider != null) {
                    if (d > (double)this.gain[1]) {
                        d = this.gain[1];
                    } else if (d < (double)this.gain[0]) {
                        d = this.gain[0];
                    }
                    this.contrastSlider.setValue((int)d);
                }
            }
        }

        public boolean isValueChanged() {
            return this.isValueChanged;
        }
    }

    private class GeneralContrastSlider
    extends JDialog
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        public static final long serialVersionUID = 240L;
        private boolean isValueChanged;
        JSlider brightSlider;
        JSlider contrastSlider;
        JFormattedTextField brightField;
        JFormattedTextField contrastField;
        int brightLevel;
        int contrastLevel;
        ImageProducer imageProducer;

        public GeneralContrastSlider(JFrame jFrame, ImageProducer imageProducer) {
            super(jFrame, "Brightness/Contrast", true);
            this.isValueChanged = false;
            this.brightLevel = 0;
            this.contrastLevel = 0;
            this.imageProducer = imageProducer;
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setMinimum(new Integer(-100));
            numberFormatter.setMaximum(new Integer(100));
            this.brightField = new JFormattedTextField(numberFormatter);
            this.brightField.addPropertyChangeListener(this);
            this.brightField.setValue(new Integer(0));
            this.brightSlider = new JSlider(0, -100, 100, 0);
            this.brightSlider.setMajorTickSpacing(20);
            this.brightSlider.setPaintTicks(true);
            this.brightSlider.setPaintLabels(true);
            this.brightSlider.addChangeListener(this);
            this.brightSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setMinimum(new Integer(-100));
            numberFormatter.setMaximum(new Integer(100));
            this.contrastField = new JFormattedTextField(numberFormatter);
            this.contrastField.addPropertyChangeListener(this);
            this.contrastField.setValue(new Integer(0));
            this.contrastSlider = new JSlider(0, -100, 100, 0);
            this.contrastSlider.setMajorTickSpacing(20);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setPaintLabels(true);
            this.contrastSlider.addChangeListener(this);
            this.contrastSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setLayout(new BorderLayout(5, 5));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setPreferredSize(new Dimension(500, 300));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("Brightness"));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.brightField, "North");
            jPanel2.add((Component)this.brightSlider, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new TitledBorder("Contrast"));
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)this.contrastField, "North");
            jPanel3.add((Component)this.contrastSlider, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel.add((Component)jPanel4, "Center");
            JPanel jPanel5 = new JPanel();
            JButton jButton = new JButton("   Ok   ");
            jButton.setMnemonic(79);
            jButton.setActionCommand("Ok_brightness_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Cancel");
            jButton.setMnemonic(67);
            jButton.setActionCommand("Cancel_brightness_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Apply");
            jButton.setMnemonic(65);
            jButton.setActionCommand("Apply_brightness_change");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jPanel.add((Component)jPanel5, "South");
            jPanel.add((Component)new JLabel(" "), "North");
            Point point = this.getParent().getLocation();
            Dimension dimension = this.getParent().getPreferredSize();
            point.x += 300;
            point.y += 200;
            this.setLocation(point);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Ok_brightness_change") || string.equals("Apply_brightness_change")) {
                int n = ((Number)this.brightField.getValue()).intValue();
                int n2 = ((Number)this.contrastField.getValue()).intValue();
                this.isValueChanged = n != this.brightLevel | n2 != this.contrastLevel;
                this.applyBrightContrast(n, n2);
                this.brightLevel = n;
                this.contrastLevel = n2;
                if (string.startsWith("Ok")) {
                    this.setVisible(false);
                }
            } else if (string.equals("Cancel_brightness_change")) {
                this.isValueChanged = false;
                this.setVisible(false);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof JSlider)) {
                return;
            }
            JSlider jSlider = (JSlider)object;
            int n = jSlider.getValue();
            if (jSlider.equals(this.brightSlider)) {
                this.brightField.setValue(new Integer(n));
            } else if (jSlider.equals(this.contrastSlider)) {
                this.contrastField.setValue(new Integer(n));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                Number number = (Number)propertyChangeEvent.getNewValue();
                if (number == null) {
                    return;
                }
                double d = number.doubleValue();
                if (d > 100.0) {
                    d = 100.0;
                } else if (d < -100.0) {
                    d = -100.0;
                }
                if (object.equals(this.brightField) && this.brightSlider != null) {
                    this.brightSlider.setValue((int)d);
                } else if (object.equals(this.contrastField) && this.contrastSlider != null) {
                    this.contrastSlider.setValue((int)d);
                }
            }
        }

        private void applyBrightContrast(int n, int n2) {
            BrightnessFilter brightnessFilter = new BrightnessFilter(n, n2);
            if (brightnessFilter == null) {
                return;
            }
            try {
                DefaultImageView.this.image = this.createImage(new FilteredImageSource(this.imageProducer, brightnessFilter));
                DefaultImageView.this.imageComponent.setImage(DefaultImageView.this.image);
                DefaultImageView.this.zoomTo(DefaultImageView.this.zoomFactor);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class DataRangeDialog
    extends JDialog
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        public static final long serialVersionUID = 240L;
        double[] minmax;
        JSlider minSlider;
        JSlider maxSlider;
        JFormattedTextField minField;
        JFormattedTextField maxField;

        public DataRangeDialog(JFrame jFrame, double[] dArray, int n, int n2) {
            super(jFrame, "Image Vaule Range", true);
            this.minmax = null;
            this.minmax = new double[2];
            if (dArray == null || dArray.length <= 1) {
                this.minmax[0] = 0.0;
                this.minmax[1] = 255.0;
            } else {
                if (dArray[0] == dArray[1]) {
                    Tools.findMinMax(DefaultImageView.this.data, dArray, DefaultImageView.this.dataset.getFillValue());
                }
                this.minmax[0] = dArray[0];
                this.minmax[1] = dArray[1];
            }
            int n3 = (n2 - n) / 10;
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setMinimum(new Double(this.minmax[0]));
            numberFormatter.setMaximum(new Double(this.minmax[1]));
            this.minField = new JFormattedTextField(numberFormatter);
            this.minField.addPropertyChangeListener(this);
            this.minField.setValue(new Double(this.minmax[0]));
            this.maxField = new JFormattedTextField(numberFormatter);
            this.maxField.addPropertyChangeListener(this);
            this.maxField.setValue(new Double(this.minmax[1]));
            this.minSlider = new JSlider(0, n, n2, (int)this.minmax[0]);
            this.minSlider.setMajorTickSpacing(n3);
            this.minSlider.setPaintTicks(true);
            this.minSlider.setPaintLabels(true);
            this.minSlider.addChangeListener(this);
            this.minSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.maxSlider = new JSlider(0, n, n2, (int)this.minmax[1]);
            this.maxSlider.setMajorTickSpacing(n3);
            this.maxSlider.setPaintTicks(true);
            this.maxSlider.setPaintLabels(true);
            this.maxSlider.addChangeListener(this);
            this.maxSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setLayout(new BorderLayout(5, 5));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setPreferredSize(new Dimension(500, 300));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("Lower Bound"));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.minField, "Center");
            jPanel2.add((Component)this.minSlider, "South");
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new TitledBorder("Upper Bound"));
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)this.maxField, "Center");
            jPanel3.add((Component)this.maxSlider, "South");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel.add((Component)jPanel4, "Center");
            JPanel jPanel5 = new JPanel();
            JButton jButton = new JButton("   Ok   ");
            jButton.setMnemonic(79);
            jButton.setActionCommand("Ok");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Cancel");
            jButton.setMnemonic(67);
            jButton.setActionCommand("Cancel");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jButton = new JButton("Apply");
            jButton.setMnemonic(65);
            jButton.setActionCommand("Apply");
            jButton.addActionListener(this);
            jPanel5.add(jButton);
            jPanel.add((Component)jPanel5, "South");
            jPanel.add((Component)new JLabel(" "), "North");
            Point point = this.getParent().getLocation();
            Dimension dimension = this.getParent().getPreferredSize();
            point.x += 300;
            point.y += 200;
            this.setLocation(point);
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Ok")) {
                this.minmax[0] = ((Number)this.minField.getValue()).doubleValue();
                this.minmax[1] = ((Number)this.maxField.getValue()).doubleValue();
                this.dispose();
            }
            if (string.equals("Apply")) {
                this.minmax[0] = ((Number)this.minField.getValue()).doubleValue();
                this.minmax[1] = ((Number)this.maxField.getValue()).doubleValue();
                DefaultImageView.this.changeDataRange(this.minmax);
                this.minmax[1] = 0.0;
                this.minmax[0] = 0.0;
            } else if (string.equals("Cancel")) {
                this.minmax = null;
                this.dispose();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof JSlider)) {
                return;
            }
            JSlider jSlider = (JSlider)object;
            int n = jSlider.getValue();
            if (jSlider.equals(this.minSlider)) {
                int n2 = this.maxSlider.getValue();
                if (n > n2) {
                    n = n2;
                }
                if (n != (int)this.minmax[0]) {
                    this.minField.setValue(new Integer(n));
                }
            } else if (jSlider.equals(this.maxSlider)) {
                int n3 = this.minSlider.getValue();
                if (n < n3) {
                    n = n3;
                }
                if (n != (int)this.minmax[1]) {
                    this.maxField.setValue(new Integer(n));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                Number number = (Number)propertyChangeEvent.getNewValue();
                if (number == null) {
                    return;
                }
                double d = number.doubleValue();
                if (object.equals(this.minField) && this.minSlider != null) {
                    int n = this.maxSlider.getValue();
                    if (d > (double)n) {
                        d = n;
                        this.minField.setText(String.valueOf(d));
                    }
                    this.minmax[0] = d;
                    this.minSlider.setValue((int)d);
                } else if (object.equals(this.maxField) && this.maxSlider != null) {
                    int n = this.minSlider.getValue();
                    if (d < (double)n) {
                        d = n;
                        this.maxField.setText(String.valueOf(d));
                    }
                    this.minmax[1] = d;
                    this.maxSlider.setValue((int)d);
                }
            }
        }

        public double[] getRange() {
            return this.minmax;
        }
    }

    private class Animation
    extends JDialog
    implements ActionListener,
    Runnable {
        public static final long serialVersionUID = 240L;
        private final int MAX_ANIMATION_IMAGE_SIZE = 300;
        private Image[] frames;
        private JComponent canvas;
        private Thread engine;
        private int numberOfImages;
        private int currentFrame;
        private int sleepTime;
        private Image offScrImage;
        private Graphics offScrGC;
        private JFrame owner;
        private int x0;
        private int y0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Animation(JFrame jFrame, ScalarDS scalarDS) {
            super(jFrame, "Animation", true);
            this.MAX_ANIMATION_IMAGE_SIZE = 300;
            this.frames = null;
            this.canvas = null;
            this.engine = null;
            this.numberOfImages = 0;
            this.currentFrame = 0;
            this.sleepTime = 200;
            this.x0 = 0;
            this.y0 = 0;
            this.owner = jFrame;
            this.setDefaultCloseOperation(2);
            long[] lArray = scalarDS.getDims();
            long[] lArray2 = scalarDS.getStride();
            long[] lArray3 = scalarDS.getStartDims();
            long[] lArray4 = scalarDS.getSelectedDims();
            int[] nArray = scalarDS.getSelectedIndex();
            int n = scalarDS.getRank();
            if (DefaultImageView.this.animationSpeed != 0) {
                this.sleepTime = 1000 / DefaultImageView.this.animationSpeed;
            }
            long[] lArray5 = new long[n];
            long[] lArray6 = new long[n];
            long[] lArray7 = new long[n];
            System.arraycopy(lArray3, 0, lArray5, 0, n);
            System.arraycopy(lArray4, 0, lArray6, 0, n);
            System.arraycopy(lArray2, 0, lArray7, 0, n);
            int n2 = 1;
            int n3 = (int)Math.max(lArray4[nArray[0]], lArray4[nArray[1]]);
            if (n3 > 300) {
                n2 = n3 / 300;
            }
            lArray3[nArray[0]] = 0L;
            lArray3[nArray[1]] = 0L;
            lArray3[nArray[2]] = 0L;
            lArray4[nArray[0]] = lArray[nArray[0]] / (long)n2;
            lArray4[nArray[1]] = lArray[nArray[1]] / (long)n2;
            lArray4[nArray[2]] = 1L;
            lArray2[nArray[0]] = n2;
            lArray2[nArray[1]] = n2;
            lArray2[nArray[2]] = 1L;
            Object object = null;
            byte[] byArray = null;
            int n4 = (int)lArray4[nArray[0]];
            int n5 = (int)lArray4[nArray[1]];
            int n6 = n5 * n4;
            this.numberOfImages = (int)lArray[nArray[2]];
            this.frames = new Image[this.numberOfImages];
            MemoryImageSource memoryImageSource = DefaultImageView.this.memoryImageSource;
            try {
                for (int i = 0; i < this.numberOfImages; ++i) {
                    DefaultImageView.this.memoryImageSource = null;
                    lArray3[nArray[2]] = i;
                    scalarDS.clearData();
                    try {
                        object = scalarDS.read();
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    byArray = new byte[n6];
                    Tools.getBytes(object, DefaultImageView.this.dataRange, byArray);
                    this.frames[i] = DefaultImageView.this.createIndexedImage(byArray, DefaultImageView.this.imagePalette, n5, n4);
                }
            }
            finally {
                DefaultImageView.this.memoryImageSource = memoryImageSource;
                System.arraycopy(lArray5, 0, lArray3, 0, n);
                System.arraycopy(lArray6, 0, lArray4, 0, n);
                System.arraycopy(lArray7, 0, lArray2, 0, n);
            }
            this.offScrImage = this.owner.createImage(n5, n4);
            this.offScrGC = this.offScrImage.getGraphics();
            this.x0 = Math.max((300 - n5) / 2, 0);
            this.y0 = Math.max((300 - n4) / 2, 0);
            this.canvas = new JComponent(){
                public static final long serialVersionUID = 240L;

                @Override
                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, 300, 300);
                    if (Animation.this.offScrGC == null || Animation.this.frames == null) {
                        return;
                    }
                    Animation.this.offScrGC.drawImage(Animation.this.frames[Animation.this.currentFrame], 0, 0, Animation.this.owner);
                    graphics.drawImage(Animation.this.offScrImage, Animation.this.x0, Animation.this.y0, Animation.this.owner);
                }
            };
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setPreferredSize(new Dimension(300, 300));
            jPanel.setLayout(new BorderLayout());
            JButton jButton = new JButton("Close");
            jButton.setActionCommand("Close animation");
            jButton.addActionListener(this);
            jPanel.add((Component)jButton, "South");
            jPanel.add((Component)this.canvas, "Center");
            this.start();
            Point point = this.getParent().getLocation();
            point.x += 300;
            point.y += 200;
            this.setLocation(point);
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Close animation")) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            this.engine = null;
            this.frames = null;
            super.dispose();
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            this.canvas.paint(graphics);
        }

        private void start() {
            this.engine = new Thread(this);
            this.engine.start();
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            if (this.frames == null || this.canvas == null) {
                return;
            }
            while (thread == this.engine) {
                if (++this.currentFrame >= this.numberOfImages) {
                    this.currentFrame = 0;
                }
                this.repaint();
                this.getToolkit().sync();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Rotate90Filter
    extends ImageFilter {
        private ColorModel defaultRGB = ColorModel.getRGBdefault();
        private double[] coord = new double[2];
        private int[] raster;
        private int xoffset;
        private int yoffset;
        private int srcW;
        private int srcH;
        private int dstW;
        private int dstH;
        private int direction;

        public Rotate90Filter(int n) {
            this.direction = n;
        }

        public void transform(double d, double d2, double[] dArray) {
            if (this.direction == 10) {
                dArray[0] = -d2;
                dArray[1] = d;
            } else {
                dArray[0] = d2;
                dArray[1] = -d;
            }
        }

        public void itransform(double d, double d2, double[] dArray) {
            if (this.direction == 11) {
                dArray[0] = -d2;
                dArray[1] = d;
            } else {
                dArray[0] = d2;
                dArray[1] = -d;
            }
        }

        public void transformBBox(Rectangle rectangle) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (int i = 0; i <= 1; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    this.transform(rectangle.x + j * rectangle.width, rectangle.y + i * rectangle.height, this.coord);
                    d = Math.min(d, this.coord[0]);
                    d2 = Math.min(d2, this.coord[1]);
                    d3 = Math.max(d3, this.coord[0]);
                    d4 = Math.max(d4, this.coord[1]);
                }
            }
            rectangle.x = (int)Math.floor(d);
            rectangle.y = (int)Math.floor(d2);
            rectangle.width = (int)Math.ceil(d3) - rectangle.x;
            rectangle.height = (int)Math.ceil(d4) - rectangle.y;
        }

        @Override
        public void setDimensions(int n, int n2) {
            Rectangle rectangle = new Rectangle(0, 0, n, n2);
            this.transformBBox(rectangle);
            this.xoffset = -rectangle.x;
            this.yoffset = -rectangle.y;
            this.srcW = n;
            this.srcH = n2;
            this.dstW = rectangle.width;
            this.dstH = rectangle.height;
            this.raster = new int[this.srcW * this.srcH];
            this.consumer.setDimensions(this.dstW, this.dstH);
        }

        public void setProperties(Hashtable hashtable) {
            Object v = (hashtable = (Hashtable)hashtable.clone()).get("filters");
            if (v == null) {
                hashtable.put("filters", this.toString());
            } else if (v instanceof String) {
                hashtable.put("filters", (String)v + this.toString());
            }
            this.consumer.setProperties(hashtable);
        }

        @Override
        public void setColorModel(ColorModel colorModel) {
            this.consumer.setColorModel(this.defaultRGB);
        }

        @Override
        public void setHints(int n) {
            this.consumer.setHints(0xE | n & 0x10);
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            int n7 = n5;
            int n8 = n2 * this.srcW + n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.raster[n8++] = colorModel.getRGB(byArray[n7++] & 0xFF);
                }
                n7 += n6 - n3;
                n8 += this.srcW - n3;
            }
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            int n7 = n5;
            int n8 = n2 * this.srcW + n;
            if (colorModel == this.defaultRGB) {
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(nArray, n7, this.raster, n8, n3);
                    n7 += n6;
                    n8 += this.srcW;
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        this.raster[n8++] = colorModel.getRGB(nArray[n7++]);
                    }
                    n7 += n6 - n3;
                    n8 += this.srcW - n3;
                }
            }
        }

        @Override
        public void imageComplete(int n) {
            if (n == 1 || n == 4) {
                this.consumer.imageComplete(n);
                return;
            }
            int[] nArray = new int[this.dstW];
            for (int i = 0; i < this.dstH; ++i) {
                this.itransform(0 - this.xoffset, i - this.yoffset, this.coord);
                double d = this.coord[0];
                double d2 = this.coord[1];
                this.itransform(this.dstW - this.xoffset, i - this.yoffset, this.coord);
                double d3 = this.coord[0];
                double d4 = this.coord[1];
                double d5 = (d3 - d) / (double)this.dstW;
                double d6 = (d4 - d2) / (double)this.dstW;
                for (int j = 0; j < this.dstW; ++j) {
                    int n2 = (int)Math.round(d);
                    int n3 = (int)Math.round(d2);
                    nArray[j] = n2 < 0 || n3 < 0 || n2 >= this.srcW || n3 >= this.srcH ? 0 : this.raster[n3 * this.srcW + n2];
                    d += d5;
                    d2 += d6;
                }
                this.consumer.setPixels(0, i, this.dstW, 1, this.defaultRGB, nArray, 0, this.dstW);
            }
            this.consumer.imageComplete(n);
        }
    }

    private class ContourFilter
    extends ImageFilter {
        private ColorModel defaultRGB = ColorModel.getRGBdefault();
        int level;
        int[] levels;
        int[] levelColors = new int[9];
        private int[] raster = null;
        private int imageWidth;
        private int imageHeight;

        private ContourFilter(int n) {
            if (n < 1) {
                n = 1;
            } else if (n > 9) {
                n = 9;
            }
            this.level = n;
            this.levels = new int[this.level];
            this.levelColors[0] = Color.white.getRGB();
            this.levelColors[1] = Color.red.getRGB();
            this.levelColors[2] = Color.yellow.getRGB();
            this.levelColors[3] = Color.blue.getRGB();
            this.levelColors[4] = Color.orange.getRGB();
            this.levelColors[5] = Color.green.getRGB();
            this.levelColors[6] = Color.cyan.getRGB();
            this.levelColors[7] = Color.pink.getRGB();
            this.levelColors[8] = Color.gray.getRGB();
            int n2 = 255 / this.level;
            for (int i = 0; i < this.level; ++i) {
                this.levels[i] = (i + 1) * n2;
            }
        }

        @Override
        public void setDimensions(int n, int n2) {
            this.imageWidth = n;
            this.imageHeight = n2;
            if (this.raster == null) {
                this.raster = new int[this.imageWidth * this.imageHeight];
            }
            this.consumer.setDimensions(n, n2);
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            int n7 = 0;
            int n8 = n5;
            int n9 = n2 * this.imageWidth + n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    n7 = colorModel.getRGB(byArray[n8++] & 0xFF);
                    this.raster[n9++] = ((n7 >> 16 & 0xFF) + (n7 >> 8 & 0xFF) + (n7 & 0xFF)) / 3;
                }
                n8 += n6 - n3;
                n9 += this.imageWidth - n3;
            }
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            int n7 = 0;
            int n8 = n5;
            int n9 = n2 * this.imageWidth + n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    n7 = colorModel.getRGB(nArray[n8++] & 0xFF);
                    this.raster[n9++] = ((n7 >> 16 & 0xFF) + (n7 >> 8 & 0xFF) + (n7 & 0xFF)) / 3;
                }
                n8 += n6 - n3;
                n9 += this.imageWidth - n3;
            }
        }

        @Override
        public void imageComplete(int n) {
            int n2;
            int n3;
            if (n == 1 || n == 4) {
                this.consumer.imageComplete(n);
                return;
            }
            int[] nArray = new int[this.imageWidth * this.imageHeight];
            for (int i = 0; i < this.levels.length; ++i) {
                n3 = this.levels[i];
                n2 = this.levelColors[i];
                this.setContourLine(this.raster, nArray, n3, n2, this.imageWidth, this.imageHeight);
            }
            int[] nArray2 = new int[this.imageWidth];
            for (n3 = 0; n3 < this.imageHeight; ++n3) {
                for (n2 = 0; n2 < this.imageWidth; ++n2) {
                    nArray2[n2] = nArray[n3 * this.imageWidth + n2];
                }
                this.consumer.setPixels(0, n3, this.imageWidth, 1, this.defaultRGB, nArray2, 0, this.imageWidth);
            }
            this.consumer.imageComplete(n);
        }

        private void setContourLine(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = n5 + (n3 * n4 - 1);
            int n7 = 0 + (n3 - 1);
            while (true) {
                if (n5 < n7) {
                    int n8 = nArray[n5];
                    if (n8 < n) {
                        while (nArray[n5] < n && n5 < n7) {
                            ++n5;
                        }
                        if (nArray[n5] < n) continue;
                        nArray2[n5] = n2;
                        continue;
                    }
                    if (n8 == n) {
                        while (nArray[n5] == n && n5 < n7) {
                            ++n5;
                        }
                        if (nArray[n5] >= n && nArray[n5] <= n) continue;
                        nArray2[n5] = n2;
                        continue;
                    }
                    while (nArray[n5] > n && n5 < n7) {
                        ++n5;
                    }
                    if (nArray[n5] > n) continue;
                    nArray2[n5] = n2;
                    continue;
                }
                if (n7 == n6) break;
                n7 += n3;
                ++n5;
            }
        }
    }

    private class BrightnessFilter
    extends RGBImageFilter {
        int brightLevel = 0;
        float contrastLevel = 0.0f;

        public BrightnessFilter(int n, int n2) {
            this.brightLevel = n < -100 ? -100 : (n > 100 ? 100 : n);
            this.brightLevel *= 2;
            if (n2 < -100) {
                n2 = -100;
            } else if (n2 > 100) {
                n2 = 100;
            }
            this.contrastLevel = n2 > 0 ? ((float)n2 / 100.0f + 1.0f) * 2.0f : (n2 < 0 ? ((float)n2 / 100.0f + 1.0f) / 2.0f : 0.0f);
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (this.brightLevel != 0) {
                n6 = (n3 & 0xFF0000) >> 16;
                n5 = (n3 & 0xFF00) >> 8;
                n4 = n3 & 0xFF;
                n5 += this.brightLevel;
                n4 += this.brightLevel;
                if ((n6 += this.brightLevel) < 0) {
                    n6 = 0;
                }
                if (n6 > 255) {
                    n6 = 255;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > 255) {
                    n5 = 255;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                n6 = n6 << 16 & 0xFF0000;
                n5 = n5 << 8 & 0xFF00;
                n3 = n3 & 0xFF000000 | n6 | n5 | (n4 &= 0xFF);
            }
            if ((double)this.contrastLevel > 1.0E-6) {
                n6 = (n3 & 0xFF0000) >> 16;
                n5 = (n3 & 0xFF00) >> 8;
                n4 = n3 & 0xFF;
                float f = (float)n6 / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                n6 = (int)f;
                f = (float)n5 / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                n5 = (int)f;
                f = (float)n4 / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                n4 = (int)f;
                n6 = n6 << 16 & 0xFF0000;
                n5 = n5 << 8 & 0xFF00;
                n3 = n3 & 0xFF000000 | n6 | n5 | (n4 &= 0xFF);
            }
            return n3;
        }
    }

    private class FlipFilter
    extends ImageFilter {
        private int direction;
        private int[] raster = null;
        private int imageWidth;
        private int imageHeight;

        private FlipFilter(int n) {
            if (n < 0) {
                n = 0;
            } else if (n > 1) {
                n = 1;
            }
            this.direction = n;
        }

        @Override
        public void setDimensions(int n, int n2) {
            this.imageWidth = n;
            this.imageHeight = n2;
            if (this.raster == null) {
                this.raster = new int[this.imageWidth * this.imageHeight];
            }
            this.consumer.setDimensions(this.imageWidth, this.imageHeight);
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            int n7 = n5;
            int n8 = n2 * this.imageWidth + n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.raster[n8++] = colorModel.getRGB(byArray[n7++] & 0xFF);
                }
                n7 += n6 - n3;
                n8 += this.imageWidth - n3;
            }
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            int n7 = n5;
            int n8 = n2 * this.imageWidth + n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.raster[n8++] = colorModel.getRGB(nArray[n7++]);
                }
                n7 += n6 - n3;
                n8 += this.imageWidth - n3;
            }
        }

        @Override
        public void imageComplete(int n) {
            if (n == 1 || n == 4) {
                this.consumer.imageComplete(n);
                return;
            }
            int[] nArray = new int[this.imageWidth];
            for (int i = 0; i < this.imageHeight; ++i) {
                int n2;
                int n3;
                if (this.direction == 1) {
                    n3 = (this.imageHeight - 1 - i) * this.imageWidth;
                    for (n2 = 0; n2 < this.imageWidth; ++n2) {
                        nArray[n2] = this.raster[n3 + n2];
                    }
                } else {
                    n3 = i * this.imageWidth;
                    for (n2 = 0; n2 < this.imageWidth; ++n2) {
                        nArray[n2] = this.raster[n3 + n2];
                    }
                    n2 = this.imageWidth / 2;
                    for (int j = 0; j < n2; ++j) {
                        int n4 = nArray[j];
                        nArray[j] = nArray[this.imageWidth - j - 1];
                        nArray[this.imageWidth - j - 1] = n4;
                    }
                }
                this.consumer.setPixels(0, i, this.imageWidth, 1, ColorModel.getRGBdefault(), nArray, 0, this.imageWidth);
            }
            this.consumer.imageComplete(n);
        }
    }

    private class ImageComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        public static final long serialVersionUID = 240L;
        private Dimension originalSize;
        private Dimension imageSize;
        private Image image;
        private Point startPosition;
        private Point currentPosition;
        private Rectangle selectedArea;
        private Rectangle originalSelectedArea;
        private StringBuffer strBuff;
        private int yMousePosition = 0;
        private Dimension scrollDim = null;
        private JScrollBar hbar = null;
        private JScrollBar vbar = null;

        private ImageComponent(Image image) {
            this.image = image;
            this.originalSize = this.imageSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            this.selectedArea = new Rectangle();
            this.originalSelectedArea = new Rectangle();
            this.setPreferredSize(this.imageSize);
            this.strBuff = new StringBuffer();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(this.image, 0, 0, this.imageSize.width, this.imageSize.height, this);
            if (this.selectedArea.width > 0 && this.selectedArea.height > 0) {
                graphics.setColor(Color.red);
                graphics.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            this.scrollDim = DefaultImageView.this.imageScroller.getSize();
            this.hbar = DefaultImageView.this.imageScroller.getHorizontalScrollBar();
            this.vbar = DefaultImageView.this.imageScroller.getVerticalScrollBar();
            if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
                this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            if (this.hbar.isVisible()) {
                this.hbar.setValue(this.startPosition.x - this.scrollDim.width / 2);
            }
            if (this.vbar.isVisible()) {
                this.vbar.setValue(this.startPosition.y - this.scrollDim.height / 2);
            }
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentPosition = mouseEvent.getPoint();
            if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
                int n = Math.max(0, Math.min(this.startPosition.x, this.currentPosition.x));
                int n2 = Math.max(0, Math.min(this.startPosition.y, this.currentPosition.y));
                int n3 = Math.min(this.imageSize.width, Math.max(this.startPosition.x, this.currentPosition.x));
                int n4 = Math.min(this.imageSize.height, Math.max(this.startPosition.y, this.currentPosition.y));
                int n5 = n3 - n;
                int n6 = n4 - n2;
                this.selectedArea.setBounds(n, n2, n5, n6);
                double d = 1.0 / (double)DefaultImageView.this.zoomFactor;
                this.originalSelectedArea.setBounds((int)((double)n * d), (int)((double)n2 * d), (int)((double)n5 * d), (int)((double)n6 * d));
                this.repaint();
            } else {
                if (this.hbar.isVisible()) {
                    int n = this.startPosition.x - this.currentPosition.x;
                    this.hbar.setValue(this.hbar.getValue() + n);
                }
                if (this.vbar.isVisible()) {
                    int n = this.startPosition.y - this.currentPosition.y;
                    this.vbar.setValue(this.vbar.getValue() + n);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.yMousePosition = mouseEvent.getY();
            this.showPixelValue(mouseEvent.getX(), this.yMousePosition);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollBar jScrollBar = DefaultImageView.this.imageScroller.getVerticalScrollBar();
            int n = mouseWheelEvent.getUnitsToScroll();
            int n2 = mouseWheelEvent.getWheelRotation();
            int n3 = n * jScrollBar.getUnitIncrement();
            int n4 = jScrollBar.getValue();
            if (n4 <= 0 && n2 < 0 || (float)(n4 + jScrollBar.getVisibleAmount() * n2) >= DefaultImageView.this.zoomFactor * (float)this.originalSize.height) {
                return;
            }
            this.yMousePosition += n3;
            jScrollBar.setValue(jScrollBar.getValue() + n3);
            this.showPixelValue(mouseWheelEvent.getX(), this.yMousePosition);
        }

        private void showPixelValue(int n, int n2) {
            if (!DefaultImageView.this.valueField.isVisible() || DefaultImageView.this.rotateCount != 0) {
                return;
            }
            if (DefaultImageView.this.data == null) {
                return;
            }
            n = (int)((float)n / DefaultImageView.this.zoomFactor);
            int n3 = this.originalSize.width;
            if (n < 0 || n >= n3) {
                return;
            }
            n2 = (int)((float)n2 / DefaultImageView.this.zoomFactor);
            int n4 = this.originalSize.height;
            if (n2 < 0 || n2 >= n4) {
                return;
            }
            if (DefaultImageView.this.isHorizontalFlipped) {
                n = n3 - 1 - n;
            }
            if (DefaultImageView.this.isVerticalFlipped) {
                n2 = n4 - 1 - n2;
            }
            this.strBuff.setLength(0);
            this.strBuff.append("x=");
            this.strBuff.append(n);
            this.strBuff.append(",   y=");
            this.strBuff.append(n2);
            this.strBuff.append(",   value=");
            if (DefaultImageView.this.isTrueColor) {
                String string;
                String string2;
                String string3;
                int n5;
                int n6;
                int n7;
                this.strBuff.append("(");
                if (DefaultImageView.this.isPlaneInterlace) {
                    n7 = n2 * n3 + n;
                    n6 = n7 + n3 * n4;
                    n5 = n7 + 2 * n3 * n4;
                } else {
                    n7 = 3 * (n2 * n3 + n);
                    n6 = n7 + 1;
                    n5 = n7 + 2;
                }
                if (DefaultImageView.this.isUnsigned && !DefaultImageView.this.isUnsignedConverted) {
                    string3 = String.valueOf(this.convertUnsignedPoint(n7));
                    string2 = String.valueOf(this.convertUnsignedPoint(n6));
                    string = String.valueOf(this.convertUnsignedPoint(n5));
                } else {
                    string3 = String.valueOf(Array.get(DefaultImageView.this.data, n7));
                    string2 = String.valueOf(Array.get(DefaultImageView.this.data, n6));
                    string = String.valueOf(Array.get(DefaultImageView.this.data, n5));
                }
                this.strBuff.append(string3 + ", " + string2 + ", " + string);
                this.strBuff.append(")");
            } else if (DefaultImageView.this.isUnsigned && !DefaultImageView.this.isUnsignedConverted) {
                this.strBuff.append(this.convertUnsignedPoint(n2 * n3 + n));
            } else {
                this.strBuff.append(Array.get(DefaultImageView.this.data, n2 * n3 + n));
            }
            DefaultImageView.this.valueField.setText(this.strBuff.toString());
        }

        private void selectAll() {
            this.selectedArea.setBounds(0, 0, this.imageSize.width, this.imageSize.height);
            this.originalSelectedArea.setBounds(0, 0, this.originalSize.width, this.originalSize.height);
            this.repaint();
        }

        private long convertUnsignedPoint(int n) {
            long l = 0L;
            if (DefaultImageView.this.NT == 'B') {
                byte by = Array.getByte(DefaultImageView.this.data, n);
                l = by < 0 ? (long)(by + 256) : (long)by;
            } else if (DefaultImageView.this.NT == 'S') {
                short s = Array.getShort(DefaultImageView.this.data, n);
                l = s < 0 ? (long)(s + 65536) : (long)s;
            } else if (DefaultImageView.this.NT == 'I') {
                int n2 = Array.getInt(DefaultImageView.this.data, n);
                l = n2 < 0 ? (long)n2 + 0x100000000L : (long)n2;
            }
            return l;
        }

        private void setImageSize(Dimension dimension) {
            this.imageSize = dimension;
            this.setPreferredSize(this.imageSize);
            int n = this.selectedArea.width;
            int n2 = this.selectedArea.height;
            if (n > 0 && n2 > 0) {
                this.selectedArea.setBounds((int)((float)this.originalSelectedArea.x * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.y * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.width * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.height * DefaultImageView.this.zoomFactor));
            }
            this.repaint();
        }

        private void setImage(Image image) {
            this.image = image;
            this.originalSize = this.imageSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            this.selectedArea.setSize(0, 0);
            this.setPreferredSize(this.imageSize);
            this.setImageSize(new Dimension((int)((float)this.originalSize.width * DefaultImageView.this.zoomFactor), (int)((float)this.originalSize.height * DefaultImageView.this.zoomFactor)));
            this.repaint();
        }
    }

    private class PaletteComponent
    extends JComponent {
        public static final long serialVersionUID = 240L;
        private Color[] colors = null;
        private double[] pixelData = null;
        private Dimension paintSize = new Dimension(25, 2);
        DecimalFormat format = new DecimalFormat("0.00E0");
        double[] dRange = null;

        private PaletteComponent(byte[][] byArray, double[] dArray) {
            this.dRange = dArray;
            double d = 0.0;
            if (byArray != null && dArray != null) {
                double d2 = (this.dRange[1] - this.dRange[0]) / 255.0;
                this.pixelData = new double[256];
                for (int i = 0; i < 256; ++i) {
                    this.pixelData[i] = this.dRange[0] + d2 * (double)i;
                }
            }
            this.updatePalette(byArray);
            this.setPreferredSize(new Dimension(this.paintSize.width + 60, this.paintSize.height * 256));
            this.setVisible(true);
        }

        private void updatePalette(byte[][] byArray) {
            if (byArray != null && this.dRange != null) {
                this.colors = new Color[256];
                for (int i = 0; i < 256; ++i) {
                    int n;
                    int n2;
                    int n3 = byArray[0][i];
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if ((n2 = byArray[1][i]) < 0) {
                        n2 += 256;
                    }
                    if ((n = byArray[2][i]) < 0) {
                        n += 256;
                    }
                    this.colors[i] = new Color(n3, n2, n);
                }
            }
            this.repaint();
        }

        private void updateRange(double[] dArray) {
            if (dArray == null) {
                return;
            }
            this.dRange = dArray;
            double d = (this.dRange[1] - this.dRange[0]) / 255.0;
            for (int i = 0; i < 256; ++i) {
                this.pixelData[i] = this.dRange[0] + d * (double)i;
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            if (this.colors == null && this.pixelData == null) {
                return;
            }
            Font font = graphics.getFont();
            graphics.setFont(new Font(font.getName(), font.getStyle(), 12));
            for (n = 0; n < 256; ++n) {
                graphics.setColor(this.colors[n]);
                graphics.fillRect(0, this.paintSize.height * n, this.paintSize.width, this.paintSize.height);
            }
            graphics.setColor(Color.black);
            for (n = 0; n < 25; ++n) {
                graphics.drawString(this.format.format(this.pixelData[n * 10]), this.paintSize.width + 5, 10 + this.paintSize.height * n * 10);
            }
            graphics.drawString(this.format.format(this.pixelData[255]), this.paintSize.width + 5, this.paintSize.height * 255);
        }
    }
}

