/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.Chart;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultImageView;
import ncsa.hdf.view.DefaultTextView;
import ncsa.hdf.view.MathConversionDialog;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTableView
extends JInternalFrame
implements TableView,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 240L;
    private final ViewManager viewer;
    private char NT = (char)32;
    private Dataset dataset;
    private Object dataValue;
    private JTable table;
    private JLabel cellLabel;
    private JTextArea cellValueField;
    private boolean isValueChanged;
    private final Toolkit toolkit;
    private boolean isReadOnly;
    private boolean isDisplayTypeChar;
    private boolean isDataTransposed;
    private boolean isRegRef;
    private boolean isObjRef;
    private BitSet bitmask;
    private final JCheckBoxMenuItem checkFixedDataLength;
    private int fixedDataLength;
    private final JCheckBoxMenuItem checkScientificNotation;
    private final JCheckBoxMenuItem checkHex;
    private final JCheckBoxMenuItem checkBin;
    private final DecimalFormat scientificFormat = new DecimalFormat("###.#####E0#");
    private final NumberFormat normalFormat;
    private NumberFormat numberFormat = this.normalFormat = null;
    private boolean showAsHex = false;
    private boolean showAsBin = false;
    private final boolean[] startEditing = new boolean[]{false};
    private JPopupMenu popupMenu;
    private ViewType viewType;
    private JTextField frameField;
    private long curFrame = 0L;
    private long maxFrame = 1L;
    private Object fillValue = null;
    private Border border;

    public DefaultTableView(ViewManager viewManager) {
        this(viewManager, null);
    }

    public DefaultTableView(ViewManager viewManager, HashMap hashMap) {
        int n;
        Object object;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isValueChanged = false;
        this.isReadOnly = false;
        this.isRegRef = false;
        this.isObjRef = false;
        this.viewType = ViewType.TABLE;
        this.fixedDataLength = -1;
        HObject hObject = null;
        this.popupMenu = null;
        this.bitmask = null;
        this.border = null;
        this.checkFixedDataLength = new JCheckBoxMenuItem("Fixed Data Length", false);
        this.checkScientificNotation = new JCheckBoxMenuItem("Show Scientific Notation", false);
        this.checkHex = new JCheckBoxMenuItem("Show Hexadecimal", false);
        this.checkBin = new JCheckBoxMenuItem("Show Binary", false);
        if (hashMap != null) {
            hObject = (HObject)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT);
            this.bitmask = (BitSet)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASK);
            object = (Boolean)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.CHAR);
            if (object != null) {
                this.isDisplayTypeChar = (Boolean)object;
            }
            if ((object = (Boolean)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.TRANSPOSED)) != null) {
                this.isDataTransposed = (Boolean)object;
            }
        }
        if (hObject == null) {
            hObject = this.viewer.getTreeView().getCurrentObject();
        }
        if (hObject == null || !(hObject instanceof Dataset)) {
            return;
        }
        this.dataset = (Dataset)hObject;
        this.isReadOnly = this.dataset.getFileFormat().isReadOnly();
        if (this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF")) && this.dataset instanceof CompoundDS) {
            this.isReadOnly = true;
        }
        if (!this.isReadOnly && (object = this.dataset.getCompression()) != null && ((String)object).startsWith("SZIP") && !((String)object).endsWith("ENCODE_ENABLED")) {
            this.isReadOnly = true;
        }
        object = this.dataset.getDatatype();
        boolean bl = this.isDisplayTypeChar = this.isDisplayTypeChar && (((Datatype)object).getDatatypeSize() == 1 || ((Datatype)object).getDatatypeClass() == 10 && ((Datatype)object).getBasetype().getDatatypeClass() == 2);
        if (this.dataset instanceof CompoundDS) {
            this.isDataTransposed = false;
            this.setFrameIcon(ViewProperties.getTableIcon());
            this.table = this.createTable((CompoundDS)this.dataset);
        } else {
            this.setFrameIcon(ViewProperties.getDatasetIcon());
            this.table = this.createTable((ScalarDS)this.dataset);
            if (((Datatype)object).getDatatypeClass() == 7) {
                this.table.addMouseListener(this);
                if (((Datatype)object).getDatatypeSize() > 8) {
                    this.isReadOnly = true;
                    this.isRegRef = true;
                } else {
                    this.isObjRef = true;
                }
            }
        }
        if (this.table == null) {
            this.viewer.showStatus("Creating table failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        ColumnHeader columnHeader = new ColumnHeader(this.table);
        this.table.setTableHeader(columnHeader);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        this.table.setGridColor(Color.gray);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(100);
        RowHeader rowHeader = new RowHeader(this.table, this.dataset);
        JViewport jViewport = new JViewport();
        jViewport.add(rowHeader);
        jViewport.setPreferredSize(rowHeader.getPreferredSize());
        jScrollPane.setRowHeader(jViewport);
        this.cellLabel = new JLabel("");
        this.cellLabel.setBorder(new EtchedBorder(1));
        Dimension dimension = this.cellLabel.getPreferredSize();
        dimension.width = 75;
        this.cellLabel.setPreferredSize(dimension);
        this.cellLabel.setHorizontalAlignment(4);
        this.cellValueField = new JTextArea();
        this.cellValueField.setLineWrap(true);
        this.cellValueField.setWrapStyleWord(true);
        this.cellValueField.setEditable(false);
        this.cellValueField.setBackground(new Color(255, 255, 240));
        JScrollPane jScrollPane2 = new JScrollPane(this.cellValueField);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(50);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(50);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.cellLabel, "West");
        jPanel.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jScrollPane);
        jSplitPane.setDividerLocation(25);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.add(jSplitPane);
        StringBuffer stringBuffer = new StringBuffer("TableView  -  ");
        stringBuffer.append(hObject.getName());
        stringBuffer.append("  -  ");
        stringBuffer.append(hObject.getPath());
        stringBuffer.append("  -  ");
        stringBuffer.append(this.dataset.getFile());
        this.setTitle(stringBuffer.toString());
        int n2 = this.dataset.getRank();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray = this.dataset.getSelectedDims();
        long[] lArray2 = this.dataset.getStride();
        long[] lArray3 = this.dataset.getDims();
        long[] lArray4 = this.dataset.getStartDims();
        int n3 = Math.min(3, n2);
        if (n2 > 2) {
            this.curFrame = lArray4[nArray[2]];
            this.maxFrame = lArray3[nArray[2]];
        }
        stringBuffer.append(" [ dims");
        stringBuffer.append(nArray[0]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(nArray[n]);
        }
        stringBuffer.append(", start");
        stringBuffer.append(lArray4[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray4[nArray[n]]);
        }
        stringBuffer.append(", count");
        stringBuffer.append(lArray[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray[nArray[n]]);
        }
        stringBuffer.append(", stride");
        stringBuffer.append(lArray2[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray2[nArray[n]]);
        }
        stringBuffer.append(" ] ");
        this.setJMenuBar(this.createMenuBar());
        this.viewer.showStatus(stringBuffer.toString());
        n = this.table.getFontMetrics(this.table.getFont()).getHeight();
        rowHeader.setRowHeight(n);
        this.table.setRowHeight(n);
        if (this.isRegRef || this.isObjRef) {
            this.popupMenu = this.createPopupMenu();
        }
        if (this.border != null) {
            this.setBorder(this.border);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        boolean bl = !this.isReadOnly;
        boolean bl2 = this.dataset.getRank() > 2;
        JMenu jMenu = new JMenu("Table", false);
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Export Data to File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save table as text");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Import Data from File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Import data from file");
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenuItem = this.checkFixedDataLength;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Fixed data length");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenuItem);
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Copy data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Paste data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy to New Dataset");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Write selection to dataset");
        jMenuItem.setEnabled(bl && this.dataset instanceof ScalarDS);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Update File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save dataset");
        jMenuItem.setEnabled(bl);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2, true));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Select all data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, true));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Lineplot");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show chart");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Statistics");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show statistics");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Math Conversion");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Math conversion");
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = this.checkScientificNotation;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show scientific notation");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenuItem);
        }
        boolean bl3 = this.NT == 'B' || this.NT == 'S' || this.NT == 'I' || this.NT == 'J';
        jMenuItem = this.checkHex;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show hexadecimal");
        if (this.dataset instanceof ScalarDS && bl3) {
            jMenu.add(jMenuItem);
        }
        jMenuItem = this.checkBin;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show binary");
        if (this.dataset instanceof ScalarDS && bl3) {
            jMenu.add(jMenuItem);
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close");
        jMenu.add(jMenuItem);
        jMenuBar.add(new JLabel("     "));
        Insets insets = new Insets(0, 2, 0, 2);
        JButton jButton = new JButton(ViewProperties.getChartIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Line Plot");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Show chart");
        if (bl2) {
            jMenuBar.add(new JLabel("     "));
            jButton = new JButton(ViewProperties.getFirstIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("First");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("First page");
            jButton = new JButton(ViewProperties.getPreviousIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Previous");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Previous page");
            this.frameField = new JTextField(String.valueOf(this.curFrame));
            this.frameField.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(this.frameField);
            this.frameField.setMargin(insets);
            this.frameField.addActionListener(this);
            this.frameField.setActionCommand("Go to frame");
            JLabel jLabel = new JLabel(String.valueOf(this.maxFrame), 0);
            jLabel.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(jLabel);
            jButton = new JButton(ViewProperties.getNextIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Next");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Next page");
            jButton = new JButton(ViewProperties.getLastIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Last");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Last page");
        }
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent var1_1) {
        block63: {
            block64: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                var2_2 = var1_1.getSource();
                var3_3 = var1_1.getActionCommand();
                if (var3_3.equals("Close")) {
                    this.dispose();
                    return;
                }
                if (var3_3.equals("Save table as text")) {
                    try {
                        this.saveAsText();
                        return;
                    }
                    catch (Exception var4_4) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)this.viewer, var4_4, this.getTitle(), 0);
                        return;
                    }
                }
                if (var3_3.equals("Copy data")) {
                    this.copyData();
                    return;
                }
                if (var3_3.equals("Paste data")) {
                    this.pasteData();
                    return;
                }
                if (!var3_3.equals("Import data from file")) ** GOTO lbl41
                var4_5 = this.dataset.getFileFormat().getParent();
                var5_15 = new JFileChooser(var4_5);
                var5_15.setFileFilter(DefaultFileFilter.getFileFilterText());
                var6_22 = var5_15.showOpenDialog(this);
                if (var6_22 != 0) {
                }
                ** GOTO lbl-1000
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    var7_26 = var5_15.getSelectedFile();
                    if (var7_26 != null) ** GOTO lbl-1000
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    var8_29 = var7_26.getAbsolutePath();
                    this.importTextData(var8_29);
                    return;
lbl41:
                    // 1 sources

                    if (!var3_3.equals("Write selection to dataset")) ** GOTO lbl74
                    var4_6 = this.getTable();
                    if (var4_6.getSelectedColumnCount() > 0 && var4_6.getSelectedRowCount() > 0) ** GOTO lbl-1000
                    JOptionPane.showMessageDialog(this, "Select table cells to write.", "HDFView", 1);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    var5_16 = this.viewer.getTreeView();
                    var6_23 = this.viewer.getTreeView().findTreeNode(this.dataset);
                    var7_27 = (Group)((DefaultMutableTreeNode)var6_23.getParent()).getUserObject();
                    var8_30 = this.dataset.getFileFormat().getRootNode();
                    if (var8_30 != null) ** GOTO lbl-1000
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    var9_31 = new Vector<Object>(this.dataset.getFileFormat().getNumberOfMembers() + 5);
                    var10_32 = null;
                    var11_33 = ((DefaultMutableTreeNode)var8_30).depthFirstEnumeration();
                    while (var11_33.hasMoreElements()) {
                        var10_32 = (DefaultMutableTreeNode)var11_33.nextElement();
                        var9_31.add(var10_32.getUserObject());
                    }
                    var12_34 = new NewDatasetDialog((JFrame)this.viewer, var7_27, var9_31, this);
                    var12_34.setVisible(true);
                    var13_35 = (HObject)var12_34.getObject();
                    if (var13_35 != null) {
                        var14_36 = var12_34.getParentGroup();
                        try {
                            var5_16.addObject(var13_35, var14_36);
                        }
                        catch (Exception var15_37) {
                            // empty catch block
                        }
                    }
                    var9_31.setSize(0);
                    return;
lbl74:
                    // 1 sources

                    if (var3_3.equals("Save dataset")) {
                        try {
                            this.updateValueInFile();
                            return;
                        }
                        catch (Exception var4_7) {
                            this.toolkit.beep();
                            JOptionPane.showMessageDialog((JFrame)this.viewer, var4_7, this.getTitle(), 0);
                            return;
                        }
                    }
                    if (var3_3.equals("Select all data")) {
                        try {
                            this.selectAll();
                            return;
                        }
                        catch (Exception var4_8) {
                            this.toolkit.beep();
                            JOptionPane.showMessageDialog((JFrame)this.viewer, var4_8, this.getTitle(), 0);
                            return;
                        }
                    }
                    if (var3_3.equals("Show chart")) {
                        this.showLineplot();
                        return;
                    }
                    if (var3_3.equals("First page")) {
                        this.firstPage();
                        return;
                    }
                    if (var3_3.equals("Previous page")) {
                        this.previousPage();
                        return;
                    }
                    if (var3_3.equals("Next page")) {
                        this.nextPage();
                        return;
                    }
                    if (var3_3.equals("Last page")) {
                        this.lastPage();
                        return;
                    }
                    if (!var3_3.equals("Show statistics")) break block63;
                    try {
                        var4_9 = null;
                        if (!(this.dataset instanceof CompoundDS)) ** GOTO lbl128
                        var4_9 = this.getSelectedData();
                        var5_17 = this.table.getSelectedColumnCount();
                        if (this.dataset instanceof CompoundDS && var5_17 > 1) {
                            JOptionPane.showMessageDialog(this, "Please select one colunm a time for compound dataset.", this.getTitle(), 0);
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception var4_10) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)this.viewer, var4_10, this.getTitle(), 0);
                        return;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    if (var4_9 != null) break block64;
                    JOptionPane.showMessageDialog(this, "Select a column to show statistics.", this.getTitle(), 0);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            ** try [egrp 11[TRYBLOCK] [16 : 750->1222)] { 
lbl-1000:
            // 1 sources

            {
                block65: {
                    break block65;
lbl128:
                    // 1 sources

                    var4_9 = this.dataValue;
                }
                var5_18 = new double[2];
                var6_24 = new double[2];
                Tools.findMinMax(var4_9, var5_18, this.fillValue);
                if (Tools.computeStatistics(var4_9, var6_24, this.fillValue) > 0) {
                    var7_28 = "Min                      = " + var5_18[0] + "\nMax                      = " + var5_18[1] + "\nMean                     = " + var6_24[0] + "\nStandard deviation = " + var6_24[1];
                    JOptionPane.showMessageDialog(this, var7_28, "Statistics", 1);
                }
                var4_9 = null;
                System.gc();
                return;
            }
        }
        if (var3_3.equals("Math conversion")) {
            try {
                this.mathConversion();
                return;
            }
            catch (Exception var4_11) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)this.viewer, var4_11, this.getTitle(), 0);
                return;
            }
        }
        if (var3_3.startsWith("Go to frame")) {
            var4_12 = 0;
            try {
                var4_12 = Integer.parseInt(this.frameField.getText().trim());
            }
            catch (Exception var5_19) {
                var4_12 = -1;
            }
            this.gotoPage(var4_12);
            return;
        }
        if (var3_3.equals("Show scientific notation")) {
            if (this.checkScientificNotation.isSelected()) {
                this.numberFormat = this.scientificFormat;
                this.checkHex.setSelected(false);
                this.checkBin.setSelected(false);
                this.showAsHex = false;
                this.showAsBin = false;
            } else {
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (var3_3.equals("Show hexadecimal")) {
            this.showAsHex = this.checkHex.isSelected();
            if (this.showAsHex) {
                this.checkScientificNotation.setSelected(false);
                this.checkBin.setSelected(false);
                this.showAsBin = false;
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (var3_3.equals("Show binary")) {
            this.showAsBin = this.checkBin.isSelected();
            if (this.showAsBin) {
                this.checkScientificNotation.setSelected(false);
                this.checkHex.setSelected(false);
                this.showAsHex = false;
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (var3_3.equals("Fixed data length")) {
            if (!this.checkFixedDataLength.isSelected()) {
                this.fixedDataLength = -1;
                this.updateUI();
                return;
            }
            var4_13 = JOptionPane.showInputDialog(this, "Enter fixed data length when importing text data\n\nFor example, for a text string of \"12345678\"\n\t\tenter 2, the data will be 12, 34, 56, 78\n\t\tenter 4, the data will be 1234, 5678\n", "");
            if (var4_13 == null || var4_13.length() < 1) {
                this.checkFixedDataLength.setSelected(false);
                return;
            }
            try {
                this.fixedDataLength = Integer.parseInt(var4_13);
            }
            catch (Exception var5_20) {
                this.fixedDataLength = -1;
            }
            if (this.fixedDataLength >= 1) return;
            this.checkFixedDataLength.setSelected(false);
            return;
        }
        if (var3_3.startsWith("Show data as") == false) return;
        this.viewType = var3_3.endsWith("table") != false ? ViewType.TABLE : (var3_3.endsWith("image") != false ? ViewType.IMAGE : ViewType.TABLE);
        var4_14 = this.getSelectedData();
        if (var4_14 == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
            return;
        }
        var5_21 = Array.getLength(var4_14);
        var6_25 = 0;
        while (var6_25 < var5_21) {
            if (this.isRegRef) {
                this.showRegRefData((String)Array.get(var4_14, var6_25));
            } else if (this.isObjRef) {
                this.showObjRefData(Array.getLong(var4_14, var6_25));
            }
            ++var6_25;
        }
        return;
lbl222:
        // 1 sources

        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public void dispose() {
        int n;
        if (this.isValueChanged && !this.isReadOnly && (n = JOptionPane.showConfirmDialog(this, "\"" + this.dataset.getName() + "\" has changed.\n" + "Do you want to save the changes?", this.getTitle(), 0)) == 0) {
            this.updateValueInFile();
        }
        if (this.dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)this.dataset;
            if (scalarDS.isImage()) {
                scalarDS.clearData();
            }
            this.dataValue = null;
            this.table = null;
        }
        this.viewer.removeDataView(this);
        super.dispose();
    }

    private void previousPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray = this.dataset.getStartDims();
        long[] lArray2 = this.dataset.getDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long l = lArray[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(lArray[nArray[2]] - 1L);
    }

    private void nextPage() {
        long[] lArray;
        int[] nArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long l = lArray2[(nArray = this.dataset.getSelectedIndex())[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray2[nArray[2]] + 1L);
    }

    private void firstPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getDims();
        long l = lArray[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(0L);
    }

    private void lastPage() {
        long[] lArray;
        int[] nArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long l = lArray2[(nArray = this.dataset.getSelectedIndex())[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray[nArray[2]] - 1L);
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    private void showLineplot() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedColumns();
        if (nArray == null || nArray2 == null || nArray.length <= 0 || nArray2.length <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select rows/columns to draw line plot.", this.getTitle(), 0);
            return;
        }
        int n2 = this.table.getRowCount();
        int n3 = this.table.getColumnCount();
        LineplotOption lineplotOption = new LineplotOption((JFrame)((Object)this.viewer), "Line Plot Options -- " + this.dataset.getName(), n2, n3);
        lineplotOption.setVisible(true);
        int n4 = lineplotOption.getPlotBy();
        if (n4 == -1) {
            return;
        }
        boolean bl = n4 == 0;
        int n5 = lineplotOption.getXindex();
        double[][] dArray = null;
        int n6 = 0;
        String string = "Lineplot - " + this.dataset.getPath() + this.dataset.getName();
        String[] stringArray = null;
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] dArray3 = null;
        if (bl) {
            string = string + " - by row";
            n6 = nArray.length;
            if (n6 > 10) {
                this.toolkit.beep();
                n6 = 10;
                JOptionPane.showMessageDialog(this, "More than 10 rows are selected.\nThe first 10 rows will be displayed.", this.getTitle(), 2);
            }
            stringArray = new String[n6];
            dArray = new double[n6][nArray2.length];
            for (n = 0; n < n6; ++n) {
                stringArray[n] = "Row" + String.valueOf(nArray[n] + 1);
                for (int i = 0; i < nArray2.length; ++i) {
                    try {
                        dArray[n][i] = Double.parseDouble(this.table.getValueAt(nArray[n], nArray2[i]).toString());
                        dArray2[0] = Math.min(dArray2[0], dArray[n][i]);
                        dArray2[1] = Math.max(dArray2[1], dArray[n][i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[n][i] = 0.0;
                    }
                }
            }
            if (n5 >= 0) {
                dArray3 = new double[nArray2.length];
                for (n = 0; n < nArray2.length; ++n) {
                    try {
                        dArray3[n] = Double.parseDouble(this.table.getValueAt(n5, n).toString());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray3[n] = 0.0;
                    }
                }
            }
        } else {
            string = string + " - by column";
            n6 = nArray2.length;
            if (n6 > 10) {
                this.toolkit.beep();
                n6 = 10;
                JOptionPane.showMessageDialog(this, "More than 10 columns are selected.\nThe first 10 columns will be displayed.", this.getTitle(), 2);
            }
            stringArray = new String[n6];
            dArray = new double[n6][nArray.length];
            for (n = 0; n < n6; ++n) {
                stringArray[n] = this.table.getColumnName(nArray2[n]);
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        dArray[n][i] = Double.parseDouble(this.table.getValueAt(nArray[i], nArray2[n]).toString());
                        dArray2[0] = Math.min(dArray2[0], dArray[n][i]);
                        dArray2[1] = Math.max(dArray2[1], dArray[n][i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[n][i] = 0.0;
                    }
                }
            }
            if (n5 >= 0) {
                dArray3 = new double[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    try {
                        dArray3[n] = Double.parseDouble(this.table.getValueAt(n, n5).toString());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray3[n] = 0.0;
                    }
                }
            }
        }
        if (dArray2[0] == Double.POSITIVE_INFINITY || dArray2[1] == Double.NEGATIVE_INFINITY || dArray2[0] == dArray2[1]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot show line plot for the selected data. \nPlease check the data range.", this.getTitle(), 0);
            dArray = null;
            return;
        }
        Chart chart = new Chart((JFrame)((Object)this.viewer), string, 1, dArray, dArray3, dArray2);
        chart.setLineLabels(stringArray);
        String string2 = this.dataValue.getClass().getName();
        char c = string2.charAt(string2.lastIndexOf("[") + 1);
        if (c == 'B' || c == 'S' || c == 'I' || c == 'J') {
            chart.setTypeToInteger();
        }
        chart.setVisible(true);
    }

    @Override
    public Object getSelectedData() {
        if (this.dataset instanceof CompoundDS) {
            return this.getSelectedCompoundData();
        }
        return this.getSelectedScalarData();
    }

    private Object getSelectedScalarData() {
        Object[] objectArray = null;
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedColumns();
        if (nArray == null || nArray.length <= 0 || nArray2 == null || nArray2.length <= 0) {
            return null;
        }
        int n = nArray2.length * nArray.length;
        if (this.table.getColumnCount() == nArray2.length && this.table.getRowCount() == nArray.length) {
            return this.dataValue;
        }
        objectArray = null;
        if (this.isRegRef) {
            objectArray = new String[n];
        } else {
            switch (this.NT) {
                case 'B': {
                    objectArray = new byte[n];
                    break;
                }
                case 'S': {
                    objectArray = new short[n];
                    break;
                }
                case 'I': {
                    objectArray = new int[n];
                    break;
                }
                case 'J': {
                    objectArray = new long[n];
                    break;
                }
                case 'F': {
                    objectArray = new float[n];
                    break;
                }
                case 'D': {
                    objectArray = new double[n];
                    break;
                }
                default: {
                    objectArray = null;
                }
            }
        }
        if (objectArray == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getSelectedColumn();
        int n4 = this.table.getColumnCount();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                n5 = nArray[i] * n4 + nArray2[j];
                Array.set(objectArray, n6, Array.get(this.dataValue, n5));
                ++n6;
            }
        }
        return objectArray;
    }

    private Object getSelectedCompoundData() {
        Object[] objectArray = null;
        int n = this.table.getSelectedColumnCount();
        int n2 = this.table.getSelectedRowCount();
        if (n <= 0 || n2 <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return null;
        }
        Object object = null;
        try {
            object = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
        }
        catch (Exception exception) {
            return null;
        }
        int n3 = Array.getLength(object);
        String string = object.getClass().getName();
        int n4 = string.lastIndexOf("[");
        int n5 = 32;
        if (n4 >= 0) {
            n5 = string.charAt(n4 + 1);
        }
        if (n5 == 66) {
            objectArray = new byte[n3];
        } else if (n5 == 83) {
            objectArray = new short[n3];
        } else if (n5 == 73) {
            objectArray = new int[n3];
        } else if (n5 == 74) {
            objectArray = new long[n3];
        } else if (n5 == 70) {
            objectArray = new float[n3];
        } else if (n5 == 68) {
            objectArray = new double[n3];
        } else {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        System.arraycopy(object, 0, objectArray, 0, n3);
        return objectArray;
    }

    private JTable createTable(ScalarDS scalarDS) {
        Datatype datatype;
        int n;
        JTable jTable = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = scalarDS.getRank();
        if (n4 <= 0) {
            scalarDS.init();
            n4 = scalarDS.getRank();
        }
        long[] lArray = scalarDS.getSelectedDims();
        n2 = (int)lArray[0];
        n3 = 1;
        if (n4 > 1) {
            n2 = scalarDS.getHeight();
            n3 = scalarDS.getWidth();
        }
        this.dataValue = null;
        try {
            scalarDS.setEnumConverted(ViewProperties.isConvertEnum());
            this.dataValue = scalarDS.getData();
            if (this.applyBitmask(this.dataValue, this.bitmask)) {
                this.isReadOnly = true;
            } else {
                scalarDS.convertFromUnsignedC();
                this.dataValue = scalarDS.getData();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null) {
            return null;
        }
        this.fillValue = scalarDS.getFillValue();
        String string = this.dataValue.getClass().getName();
        int n5 = string.lastIndexOf("[");
        if (n5 >= 0) {
            this.NT = string.charAt(n5 + 1);
        }
        boolean bl = string.startsWith("[Ljava.lang.String;");
        if (this.isDisplayTypeChar && (this.NT == 'B' || this.NT == 'S')) {
            int n6 = Array.getLength(this.dataValue);
            char[] cArray = new char[n6];
            for (n = 0; n < n6; ++n) {
                if (this.NT == 'B') {
                    cArray[n] = (char)Array.getByte(this.dataValue, n);
                    continue;
                }
                if (this.NT != 'S') continue;
                cArray[n] = (char)Array.getShort(this.dataValue, n);
            }
            this.dataValue = cArray;
        } else if (this.NT == 'B' && this.dataset.getDatatype().getDatatypeClass() == 10 && (datatype = this.dataset.getDatatype().getBasetype()).getDatatypeClass() == 3) {
            this.dataValue = Dataset.byteToString((byte[])this.dataValue, datatype.getDatatypeSize());
        }
        final String[] stringArray = new String[n3];
        final int n7 = n2;
        n = n3;
        long[] lArray2 = this.dataset.getStartDims();
        long[] lArray3 = this.dataset.getStride();
        int[] nArray = this.dataset.getSelectedIndex();
        final int n8 = (int)lArray2[nArray[0]];
        final int n9 = (int)lArray3[nArray[0]];
        int n10 = 0;
        int n11 = 1;
        if (n4 > 1) {
            n10 = (int)lArray2[nArray[1]];
            n11 = (int)lArray3[nArray[1]];
        }
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = String.valueOf(n10 + i * n11);
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 240L;
            private final StringBuffer stringBuffer = new StringBuffer();
            private final Datatype dtype = DefaultTableView.access$000(DefaultTableView.this).getDatatype();
            private final Datatype btype = this.dtype.getBasetype();
            private final int typeSize = this.dtype.getDatatypeSize();
            private final boolean isArray = this.dtype.getDatatypeClass() == 10;
            private final boolean isStr = DefaultTableView.access$100(DefaultTableView.this) == 'L';
            private final boolean isInt = DefaultTableView.access$100(DefaultTableView.this) == 'B' || DefaultTableView.access$100(DefaultTableView.this) == 'S' || DefaultTableView.access$100(DefaultTableView.this) == 'I' || DefaultTableView.access$100(DefaultTableView.this) == 'J';
            private final boolean isFloat = this.dtype.getDatatypeClass() == 1;
            private Object theValue;

            @Override
            public int getColumnCount() {
                return stringArray.length;
            }

            @Override
            public int getRowCount() {
                return n7;
            }

            @Override
            public String getColumnName(int n2) {
                return stringArray[n2];
            }

            @Override
            public Object getValueAt(int n6, int n2) {
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                if (this.isArray) {
                    int n3 = this.dtype.getDatatypeSize() / this.btype.getDatatypeSize();
                    this.stringBuffer.setLength(0);
                    int n4 = (n6 * n + n2) * n3;
                    int n5 = n4 + n3;
                    if (DefaultTableView.this.isDisplayTypeChar) {
                        for (int i = n4; i < n5; ++i) {
                            this.stringBuffer.append(Array.getChar(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= n5 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    } else {
                        for (int i = n4; i < n5; ++i) {
                            this.stringBuffer.append(Array.get(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= n5 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    }
                    this.theValue = this.stringBuffer;
                } else {
                    this.theValue = DefaultTableView.this.isDataTransposed ? Array.get(DefaultTableView.this.dataValue, n2 * n7 + n6) : Array.get(DefaultTableView.this.dataValue, n6 * n + n2);
                    if (!this.isStr) {
                        if (DefaultTableView.this.showAsHex && this.isInt) {
                            this.theValue = Long.toHexString(Long.valueOf(this.theValue.toString()));
                        } else if (DefaultTableView.this.showAsBin && this.isInt) {
                            this.theValue = Tools.toBinaryString(Long.valueOf(this.theValue.toString()), this.typeSize);
                        } else if (DefaultTableView.this.numberFormat != null) {
                            this.theValue = DefaultTableView.this.numberFormat.format(this.theValue);
                        }
                    }
                }
                return this.theValue;
            }
        };
        jTable = new JTable(abstractTableModel){
            private static final long serialVersionUID = 240L;
            private final Datatype dtype;
            private final boolean isArray;
            {
                super(tableModel);
                this.dtype = DefaultTableView.this.dataset.getDatatype();
                this.isArray = this.dtype.getDatatypeClass() == 10;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return !DefaultTableView.this.isReadOnly && !DefaultTableView.this.isDisplayTypeChar && !this.isArray && !DefaultTableView.this.showAsBin && !DefaultTableView.this.showAsHex;
            }

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                KeyEvent keyEvent;
                if (!this.isCellEditable(n, n2)) {
                    return super.editCellAt(n, n2, eventObject);
                }
                if (eventObject instanceof KeyEvent && (keyEvent = (KeyEvent)eventObject).getID() == 401) {
                    ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                super.editingStopped(changeEvent);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string = (String)cellEditor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(string, n, n2);
                    }
                    catch (Exception exception) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int n, int n2) {
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n2) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(n8 + n * n9) + ", " + DefaultTableView.this.table.getColumnName(n2) + "  =  ");
                    Object object = this.getValueAt(n, n2);
                    String string = null;
                    if (DefaultTableView.this.isRegRef) {
                        String string2 = (String)object;
                        String string3 = string2.substring(string2.indexOf(58) + 1, string2.indexOf(32));
                        long[] lArray = new long[]{-1L};
                        try {
                            lArray[0] = Long.valueOf(string3);
                            HObject hObject = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), lArray);
                            string = hObject.getFullName() + " " + string2.substring(string2.indexOf("{"));
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                    } else if (DefaultTableView.this.isObjRef) {
                        Long l = (Long)object;
                        long[] lArray = new long[]{l};
                        try {
                            HObject hObject = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), lArray);
                            string = hObject.getFullName();
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                    }
                    if (string == null) {
                        string = object.toString();
                    }
                    DefaultTableView.this.cellValueField.setText(string);
                }
                return super.isCellSelected(n, n2);
            }
        };
        return jTable;
    }

    private JTable createTable(CompoundDS compoundDS) {
        JTable jTable = null;
        int n = compoundDS.getRank();
        if (n <= 0) {
            compoundDS.init();
        }
        long[] lArray = compoundDS.getStartDims();
        long[] lArray2 = compoundDS.getStride();
        int[] nArray = compoundDS.getSelectedIndex();
        final int n2 = (int)lArray[nArray[0]];
        final int n3 = (int)lArray2[nArray[0]];
        if (compoundDS.getHeight() > 10000) {
            compoundDS.setConvertByteToString(false);
        }
        this.dataValue = null;
        try {
            this.dataValue = compoundDS.getData();
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null || !(this.dataValue instanceof List)) {
            return null;
        }
        final int n4 = compoundDS.getHeight();
        int n5 = compoundDS.getSelectedMemberCount();
        String[] stringArray = new String[n5];
        int n6 = 0;
        String[] stringArray2 = compoundDS.getMemberNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!compoundDS.isMemberSelected(i)) continue;
            stringArray[n6] = stringArray2[i];
            stringArray[n6] = stringArray[n6].replaceAll("\u0095", "->");
            ++n6;
        }
        String[] stringArray3 = stringArray;
        int n7 = compoundDS.getWidth();
        if (n7 > 1) {
            stringArray3 = new String[n7 * stringArray.length];
            int n8 = stringArray.length / 2;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray3[i * stringArray.length + j] = j == n8 ? i + 1 + "\n " + stringArray[j] : " \n " + stringArray[j];
                }
            }
        }
        final String[] stringArray4 = stringArray3;
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 240L;
            List list;
            CompoundDS compound;
            int[] orders;
            Datatype[] types;
            StringBuffer stringBuffer;
            int nFields;
            int nRows;
            int nSubColumns;
            {
                this.list = (List)DefaultTableView.this.dataValue;
                this.compound = (CompoundDS)DefaultTableView.this.dataset;
                this.orders = this.compound.getSelectedMemberOrders();
                this.types = this.compound.getSelectedMemberTypes();
                this.stringBuffer = new StringBuffer();
                this.nFields = this.list.size();
                this.nRows = this.getRowCount();
                this.nSubColumns = this.nFields > 0 ? this.getColumnCount() / this.nFields : 0;
            }

            @Override
            public int getColumnCount() {
                return stringArray4.length;
            }

            @Override
            public int getRowCount() {
                return n4;
            }

            @Override
            public String getColumnName(int n) {
                return stringArray4[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                int n3 = n2;
                int n42 = n;
                if (this.nSubColumns > 1) {
                    int n5 = n2 / this.nFields;
                    n3 = n2 - n5 * this.nFields;
                    n42 = n * this.orders[n3] * this.nSubColumns + n5 * this.orders[n3];
                } else {
                    n42 = n * this.orders[n3];
                }
                Object e = this.list.get(n3);
                if (e == null) {
                    return "Null";
                }
                this.stringBuffer.setLength(0);
                int[] nArray = this.compound.getMemeberDims(n3);
                if (nArray == null) {
                    boolean bl;
                    int n6 = this.types[n3].getDatatypeSize();
                    boolean bl2 = bl = this.types[n3].getDatatypeClass() == 3;
                    if (this.orders[n3] <= 1 && bl && n6 > 0 && !this.compound.getConvertByteToString()) {
                        String string = new String((byte[])e, n42 * n6, n6);
                        int n7 = string.indexOf(0);
                        if (n7 > 0) {
                            string = string.substring(0, n7);
                        }
                        this.stringBuffer.append(string.trim());
                    } else {
                        this.stringBuffer.append(Array.get(e, n42));
                    }
                    for (int i = 1; i < this.orders[n3]; ++i) {
                        this.stringBuffer.append(", ");
                        this.stringBuffer.append(Array.get(e, n42 + i));
                    }
                } else {
                    for (int i = 0; i < this.orders[n3]; ++i) {
                        this.stringBuffer.append(Array.get(e, n42 + i));
                        this.stringBuffer.append(", ");
                    }
                }
                return this.stringBuffer;
            }
        };
        jTable = new JTable(abstractTableModel){
            private static final long serialVersionUID = 240L;
            int lastSelectedRow;
            int lastSelectedColumn;
            {
                super(tableModel);
                this.lastSelectedRow = -1;
                this.lastSelectedColumn = -1;
            }

            @Override
            public boolean isCellEditable(int n, int n22) {
                return !DefaultTableView.this.isReadOnly;
            }

            @Override
            public boolean editCellAt(int n, int n22, EventObject eventObject) {
                KeyEvent keyEvent;
                if (!this.isCellEditable(n, n22)) {
                    return super.editCellAt(n, n22, eventObject);
                }
                if (eventObject instanceof KeyEvent && (keyEvent = (KeyEvent)eventObject).getID() == 401) {
                    ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                }
                return super.editCellAt(n, n22, eventObject);
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n22 = this.getEditingColumn();
                super.editingStopped(changeEvent);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string = (String)cellEditor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(string, n, n22);
                    }
                    catch (Exception exception) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int n, int n22) {
                if (this.lastSelectedRow == n && this.lastSelectedColumn == n22) {
                    return super.isCellSelected(n, n22);
                }
                this.lastSelectedRow = n;
                this.lastSelectedColumn = n22;
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n22) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(n2 + n * n3) + ", " + DefaultTableView.this.table.getColumnName(n22) + "  =  ");
                    DefaultTableView.this.cellValueField.setText(this.getValueAt(n, n22).toString());
                }
                return super.isCellSelected(n, n22);
            }
        };
        if (n7 > 1) {
            MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer(n7, stringArray.length);
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
            }
        }
        return jTable;
    }

    private boolean applyBitmask(Object object, BitSet bitSet) {
        int n;
        if (object == null || Array.getLength(object) <= 0 || bitSet == null) {
            return false;
        }
        int n2 = 48;
        String string = object.getClass().getName();
        int n3 = string.lastIndexOf("[");
        if (n3 >= 0) {
            n2 = string.charAt(n3 + 1);
        }
        if (n2 != 66) {
            return false;
        }
        byte[] byArray = (byte[])object;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < 8; ++n) {
            if (!bitSet.get(n)) continue;
            n4 += 1 << n;
        }
        for (n = 0; n < byArray.length; ++n) {
            n5 = byArray[n] & n4;
            n6 = 0;
            for (int i = 7; i >= 0; --i) {
                if (!this.bitmask.get(i)) continue;
                if (n6 & true) {
                    n6 <<= 1;
                }
                n6 += n5 >> i & 1;
            }
            byArray[n] = (byte)n6;
        }
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "By bitmask " + bitSet, 3, 2, this.getFont(), Color.RED));
        return true;
    }

    private void gotoPage(long l) {
        if (this.dataset.getRank() < 3) {
            return;
        }
        if (this.isValueChanged) {
            this.updateValueInFile();
        }
        long[] lArray = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getDims();
        if (l < 0L || l >= lArray2[nArray[2]]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Frame number must be between 0 and " + (lArray2[nArray[2]] - 1L), this.getTitle(), 0);
            return;
        }
        lArray[nArray[2]] = l;
        this.curFrame = l;
        this.dataset.clearData();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.dataValue = this.dataset.getData();
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).convertFromUnsignedC();
                this.dataValue = this.dataset.getData();
            }
        }
        catch (Exception exception) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dataValue = null;
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.frameField.setText(String.valueOf(this.curFrame));
        this.updateUI();
    }

    private void copyData() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = n + this.table.getSelectedRowCount();
        int n4 = n2 + this.table.getSelectedColumnCount();
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(this.table.getValueAt(i, n2).toString());
            for (int j = n2 + 1; j < n4; ++j) {
                stringBuffer.append("\t");
                stringBuffer.append(this.table.getValueAt(i, j).toString());
            }
            stringBuffer.append("\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private void pasteData() {
        int n = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (n == 1) {
            return;
        }
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getRowCount();
        int n4 = this.table.getSelectedRow();
        int n5 = this.table.getSelectedColumn();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n6 = n4;
        int n7 = n5;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        String string = "";
        try {
            String string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens() && n6 < n3) {
                string = stringTokenizer.nextToken();
                if (this.fixedDataLength < 1) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t");
                    while (stringTokenizer2.hasMoreTokens() && n7 < n2) {
                        try {
                            this.updateValueInMemory(stringTokenizer2.nextToken(), n6, n7);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        ++n7;
                    }
                    ++n6;
                    n7 = n5;
                    continue;
                }
                int n8 = string.length();
                for (int i = 0; i < n8; i += this.fixedDataLength) {
                    try {
                        String string3 = string.substring(i, i + this.fixedDataLength);
                        this.updateValueInMemory(string3, n6, n7);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    ++n7;
                }
            }
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable, this.getTitle(), 0);
        }
        this.table.updateUI();
    }

    private void importTextData(String string) {
        int n = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (n == 1) {
            return;
        }
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getRowCount();
        int n4 = this.table.getSelectedRow();
        int n5 = this.table.getSelectedColumn();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        String string3 = ViewProperties.getDataDelimiter();
        String string4 = "\t";
        if (string3.equalsIgnoreCase("Space")) {
            string4 = " " + string4;
        } else if (string3.equalsIgnoreCase("Comma")) {
            string4 = "," + string4;
        } else if (string3.equalsIgnoreCase("Colon")) {
            string4 = ":" + string4;
        } else if (string3.equalsIgnoreCase("Semi-Colon")) {
            string4 = ";" + string4;
        }
        String string5 = null;
        int n6 = n5;
        for (int i = n4; string2 != null && i < n3; ++i) {
            try {
                stringTokenizer = new StringTokenizer(string2, string4);
                while (stringTokenizer.hasMoreTokens() && n6 < n2) {
                    string5 = stringTokenizer.nextToken();
                    if (this.dataset instanceof ScalarDS) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string5);
                        while (stringTokenizer2.hasMoreTokens() && n6 < n2) {
                            this.updateValueInMemory(stringTokenizer2.nextToken(), i, n6);
                            ++n6;
                        }
                        continue;
                    }
                    this.updateValueInMemory(string5, i, n6);
                    ++n6;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            n6 = 0;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.table.updateUI();
    }

    private void saveAsText() throws Exception {
        int n;
        Object object2;
        JFileChooser jFileChooser = new JFileChooser(this.dataset.getFile());
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterText());
        jFileChooser.setDialogTitle("Save Current Data To Text File --- " + this.dataset.getName());
        File file = new File(this.dataset.getName() + ".txt");
        jFileChooser.setSelectedFile(file);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        List list = this.viewer.getTreeView().getCurrentFiles();
        if (list != null) {
            object2 = null;
            for (Object object2 : list) {
                if (!((FileFormat)object2).getFilePath().equals(string)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + string + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        object2 = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        String string2 = ViewProperties.getDataDelimiter();
        String string3 = "\t";
        if (string2.equalsIgnoreCase("Space")) {
            string3 = " " + string3;
        } else if (string2.equalsIgnoreCase("Comma")) {
            string3 = "," + string3;
        } else if (string2.equalsIgnoreCase("Colon")) {
            string3 = ":" + string3;
        } else if (string2.equalsIgnoreCase("Semi-Colon")) {
            string3 = ";" + string3;
        }
        int n3 = this.table.getColumnCount();
        int n4 = this.table.getRowCount();
        for (int i = 0; i < n4; ++i) {
            ((PrintWriter)object2).print(this.table.getValueAt(i, 0));
            for (int j = 1; j < n3; ++j) {
                ((PrintWriter)object2).print(string3);
                ((PrintWriter)object2).print(this.table.getValueAt(i, j));
            }
            ((PrintWriter)object2).println();
        }
        ((PrintWriter)object2).flush();
        ((PrintWriter)object2).close();
        this.viewer.showStatus("Data save to: " + string);
    }

    @Override
    public void updateValueInFile() {
        if (this.isReadOnly || this.showAsBin || this.showAsHex) {
            return;
        }
        if (!this.isValueChanged) {
            return;
        }
        try {
            this.dataset.write();
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return;
        }
        this.isValueChanged = false;
    }

    private void selectAll() throws Exception {
        this.table.selectAll();
    }

    private void mathConversion() throws Exception {
        if (this.isReadOnly) {
            return;
        }
        int n = this.table.getSelectedColumnCount();
        if (this.dataset instanceof CompoundDS && n > 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Please select one colunm a time for math conversion for compound dataset.", this.getTitle(), 0);
            return;
        }
        Object object = this.getSelectedData();
        if (object == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return;
        }
        MathConversionDialog mathConversionDialog = new MathConversionDialog((JFrame)((Object)this.viewer), object);
        mathConversionDialog.setVisible(true);
        if (mathConversionDialog.isConverted()) {
            if (this.dataset instanceof CompoundDS) {
                Object var4_4 = null;
                try {
                    var4_4 = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var4_4 != null) {
                    int n2 = Array.getLength(object);
                    System.arraycopy(object, 0, var4_4, 0, n2);
                }
            } else {
                int n3 = this.table.getSelectedRowCount();
                int n4 = this.table.getSelectedRow();
                int n5 = this.table.getSelectedColumn();
                int n6 = this.table.getColumnCount();
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n3; ++i) {
                    n8 = (n4 + i) * n6 + n5;
                    System.arraycopy(object, n7, this.dataValue, n8, n);
                    n7 += n;
                }
            }
            object = null;
            System.gc();
            this.table.updateUI();
            this.isValueChanged = true;
        }
    }

    private void updateValueInMemory(String string, int n, int n2) throws Exception {
        if (this.dataset instanceof ScalarDS) {
            this.updateScalarData(string, n, n2);
        } else if (this.dataset instanceof CompoundDS) {
            this.updateCompoundData(string, n, n2);
        }
    }

    private void updateScalarData(String string, int n, int n2) throws Exception {
        if (!(this.dataset instanceof ScalarDS) || string == null || (string = string.trim()) == null || this.showAsBin || this.showAsHex) {
            return;
        }
        int n3 = 0;
        n3 = this.isDataTransposed ? n2 * this.table.getRowCount() + n : n * this.table.getColumnCount() + n2;
        ScalarDS scalarDS = (ScalarDS)this.dataset;
        boolean bl = scalarDS.isUnsigned();
        if (bl) {
            long l = -1L;
            long l2 = Long.MAX_VALUE;
            l = Long.parseLong(string);
            if (l < 0L) {
                throw new NumberFormatException("Negative value for unsigned integer: " + l);
            }
            if (this.NT == 'S') {
                l2 = 255L;
            } else if (this.NT == 'I') {
                l2 = 65535L;
            } else if (this.NT == 'J') {
                l2 = 0xFFFFFFFFL;
            }
            if (l < 0L || l > l2) {
                throw new NumberFormatException("Data value is out of range: " + l);
            }
        }
        switch (this.NT) {
            case 'B': {
                byte by = 0;
                by = Byte.parseByte(string);
                Array.setByte(this.dataValue, n3, by);
                break;
            }
            case 'S': {
                short s = 0;
                s = Short.parseShort(string);
                Array.setShort(this.dataValue, n3, s);
                break;
            }
            case 'I': {
                int n4 = 0;
                n4 = Integer.parseInt(string);
                Array.setInt(this.dataValue, n3, n4);
                break;
            }
            case 'J': {
                long l = 0L;
                l = Long.parseLong(string);
                Array.setLong(this.dataValue, n3, l);
                break;
            }
            case 'F': {
                float f = 0.0f;
                f = Float.parseFloat(string);
                Array.setFloat(this.dataValue, n3, f);
                break;
            }
            case 'D': {
                double d = 0.0;
                d = Double.parseDouble(string);
                Array.setDouble(this.dataValue, n3, d);
            }
        }
        this.isValueChanged = true;
    }

    private void updateCompoundData(String string, int n, int n2) throws Exception {
        StringTokenizer stringTokenizer;
        if (!(this.dataset instanceof CompoundDS) || string == null || (string = string.trim()) == null) {
            return;
        }
        CompoundDS compoundDS = (CompoundDS)this.dataset;
        List list = (List)compoundDS.getData();
        int[] nArray = compoundDS.getSelectedMemberOrders();
        Datatype[] datatypeArray = compoundDS.getSelectedMemberTypes();
        int n3 = list.size();
        int n4 = this.table.getColumnCount() / n3;
        int n5 = this.table.getRowCount();
        int n6 = n2;
        int n7 = 0;
        int n8 = 1;
        if (n4 > 1) {
            int n9 = n2 / n3;
            n6 = n2 - n9 * n3;
            n7 = n * nArray[n6] + n9 * n5 * nArray[n6];
        } else {
            n7 = n * nArray[n6];
        }
        n8 = nArray[n6];
        Object e = list.get(n6);
        if (Array.get(e, 0) instanceof String) {
            Array.set(e, n7, string);
            this.isValueChanged = true;
            return;
        }
        if (datatypeArray[n6].getDatatypeClass() == 3) {
            int n10 = datatypeArray[n6].getDatatypeSize();
            byte[] byArray = string.getBytes();
            byte[] byArray2 = (byte[])e;
            int n11 = Math.min(n10, byArray.length);
            System.arraycopy(byArray, 0, byArray2, n7 *= n10, n11);
            n7 += n11;
            n11 = n10 - byArray.length;
            for (int i = 0; i < n11; ++i) {
                byArray2[n7 + i] = 32;
            }
            this.isValueChanged = true;
            return;
        }
        int n12 = 32;
        String string2 = e.getClass().getName();
        int n13 = string2.lastIndexOf("[");
        if (n13 >= 0) {
            n12 = string2.charAt(n13 + 1);
        }
        if ((stringTokenizer = new StringTokenizer(string, ",")).countTokens() < n8) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of data point < " + n8 + ".", this.getTitle(), 0);
            return;
        }
        String string3 = "";
        this.isValueChanged = true;
        switch (n12) {
            case 66: {
                byte by = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    by = Byte.parseByte(string3);
                    Array.setByte(e, n7 + i, by);
                }
                break;
            }
            case 83: {
                short s = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    s = Short.parseShort(string3);
                    Array.setShort(e, n7 + i, s);
                }
                break;
            }
            case 73: {
                int n14 = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    n14 = Integer.parseInt(string3);
                    Array.setInt(e, n7 + i, n14);
                }
                break;
            }
            case 74: {
                long l = 0L;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    l = Long.parseLong(string3);
                    Array.setLong(e, n7 + i, l);
                }
                break;
            }
            case 70: {
                float f = 0.0f;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    f = Float.parseFloat(string3);
                    Array.setFloat(e, n7 + i, f);
                }
                break;
            }
            case 68: {
                double d = 0.0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    d = Double.parseDouble(string3);
                    Array.setDouble(e, n7 + i, d);
                }
                break;
            }
            default: {
                this.isValueChanged = false;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isRegRef && !this.isObjRef) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if (mouseEvent.isPopupTrigger() || n == 4 || System.getProperty("os.name").startsWith("Mac") && n == 18) {
            if (this.popupMenu != null) {
                this.popupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getClickCount() == 2) {
            this.viewType = ViewType.TABLE;
            Object object = this.getSelectedData();
            if (object == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
                return;
            }
            int n2 = Array.getLength(object);
            for (int i = 0; i < n2; ++i) {
                if (this.isRegRef) {
                    this.showRegRefData((String)Array.get(object, i));
                    continue;
                }
                if (!this.isObjRef) continue;
                this.showObjRefData(Array.getLong(object, i));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show As Table");
        jMenuItem.setMnemonic(84);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show data as table");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show As Image");
        jMenuItem.setMnemonic(73);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show data as image");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void showObjRefData(long l) {
        Class[] classArray;
        long[] lArray = new long[]{l};
        HObject hObject = FileFormat.findObject(this.dataset.getFileFormat(), lArray);
        if (hObject == null || !(hObject instanceof ScalarDS)) {
            return;
        }
        ScalarDS scalarDS = (ScalarDS)hObject;
        ScalarDS scalarDS2 = null;
        Constructor<?> constructor = null;
        Object[] objectArray = null;
        Object object = null;
        try {
            classArray = new Class[]{FileFormat.class, String.class, String.class};
            constructor = scalarDS.getClass().getConstructor(classArray);
            objectArray = new Object[]{scalarDS.getFileFormat(), scalarDS.getName(), scalarDS.getPath()};
            scalarDS2 = (ScalarDS)constructor.newInstance(objectArray);
            object = scalarDS2.getData();
        }
        catch (Exception exception) {
            object = null;
        }
        if (object == null) {
            return;
        }
        classArray = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by object reference", 3, 2, font, Color.RED));
        JInternalFrame jInternalFrame = null;
        HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS> hashMap = new HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS>(1);
        hashMap.put(ViewProperties.DATA_VIEW_KEY.OBJECT, scalarDS2);
        switch (this.viewType) {
            case TEXT: {
                jInternalFrame = new DefaultTextView(this.viewer, hashMap);
                break;
            }
            case IMAGE: {
                jInternalFrame = new DefaultImageView(this.viewer, hashMap);
                break;
            }
            default: {
                jInternalFrame = new DefaultTableView(this.viewer, hashMap);
            }
        }
        if (jInternalFrame != null) {
            this.viewer.addDataView((DataView)((Object)jInternalFrame));
            classArray.append(scalarDS2.getName());
            classArray.append("  -  ");
            classArray.append(scalarDS2.getPath());
            classArray.append("  -  ");
            classArray.append(this.dataset.getFile());
            jInternalFrame.setTitle(classArray.toString());
            jInternalFrame.setBorder(compoundBorder);
        }
    }

    private void showRegRefData(String string) {
        Class[] classArray;
        boolean bl = false;
        if (string == null || string.length() <= 0) {
            return;
        }
        bl = string.indexOf(45) <= 0;
        String string2 = string.substring(string.indexOf(58) + 1, string.indexOf(32));
        long[] lArray = new long[]{-1L};
        try {
            lArray[0] = Long.valueOf(string2);
        }
        catch (Exception exception) {
            return;
        }
        String string3 = string.substring(string.indexOf(123) + 1, string.indexOf(125));
        if (string3 == null || string3.length() <= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            return;
        }
        HObject hObject = FileFormat.findObject(this.dataset.getFileFormat(), lArray);
        if (hObject == null || !(hObject instanceof ScalarDS)) {
            return;
        }
        ScalarDS scalarDS = (ScalarDS)hObject;
        ScalarDS scalarDS2 = null;
        Constructor<?> constructor = null;
        Object[] objectArray = null;
        try {
            classArray = new Class[]{FileFormat.class, String.class, String.class};
            constructor = scalarDS.getClass().getConstructor(classArray);
            objectArray = new Object[]{scalarDS.getFileFormat(), scalarDS.getName(), scalarDS.getPath()};
        }
        catch (Exception exception) {
            constructor = null;
        }
        classArray = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by region reference", 3, 2, font, Color.RED));
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            Object object3;
            try {
                scalarDS2 = (ScalarDS)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                continue;
            }
            if (scalarDS2 == null) continue;
            try {
                scalarDS2.init();
            }
            catch (Exception exception) {
                continue;
            }
            int n2 = scalarDS2.getRank();
            long[] lArray2 = scalarDS2.getStartDims();
            long[] lArray3 = scalarDS2.getSelectedDims();
            int n3 = 0;
            String string4 = null;
            String string5 = stringTokenizer.nextToken();
            classArray.setLength(0);
            classArray.append(string5);
            classArray.append(" at ");
            string5 = string5.replace('(', ' ');
            string5 = string5.replace(')', ' ');
            if (bl) {
                object3 = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    lArray3[n3] = 1L;
                    string4 = ((StringTokenizer)object3).nextToken().trim();
                    lArray2[n3] = Long.valueOf(string4);
                    ++n3;
                }
            } else {
                object3 = string5.substring(0, string5.indexOf(45));
                object2 = string5.substring(string5.indexOf(45) + 1);
                object = new StringTokenizer((String)object3, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    lArray2[n3] = Long.valueOf(string4);
                    ++n3;
                }
                n3 = 0;
                object = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    lArray3[n3] = Long.valueOf(string4) - lArray2[n3] + 1L;
                    ++n3;
                }
            }
            object3 = null;
            try {
                object3 = scalarDS2.getData();
            }
            catch (Exception exception) {
                object3 = null;
            }
            object2 = null;
            object = new HashMap(1);
            ((HashMap)object).put(ViewProperties.DATA_VIEW_KEY.OBJECT, scalarDS2);
            switch (this.viewType) {
                case TEXT: {
                    object2 = new DefaultTextView(this.viewer, (HashMap)object);
                    break;
                }
                case IMAGE: {
                    object2 = new DefaultImageView(this.viewer, (HashMap)object);
                    break;
                }
                default: {
                    object2 = new DefaultTableView(this.viewer, (HashMap)object);
                }
            }
            if (object2 == null) continue;
            this.viewer.addDataView((DataView)object2);
            classArray.append(scalarDS2.getName());
            classArray.append("  -  ");
            classArray.append(scalarDS2.getPath());
            classArray.append("  -  ");
            classArray.append(this.dataset.getFile());
            ((JInternalFrame)object2).setTitle(classArray.toString());
            ((JComponent)object2).setBorder(compoundBorder);
        }
    }

    static /* synthetic */ char access$100(DefaultTableView defaultTableView) {
        return defaultTableView.NT;
    }

    private class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        private static final long serialVersionUID = 240L;
        private final CompoundBorder subBorder = new CompoundBorder(new MatteBorder(1, 0, 1, 0, Color.darkGray), new MatteBorder(1, 0, 1, 0, Color.white));
        private final CompoundBorder majorBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 0, Color.darkGray), new MatteBorder(1, 2, 1, 0, Color.white));
        Vector lines = new Vector();
        int nMajorcolumns = 1;
        int nSubcolumns = 1;

        public MultiLineHeaderRenderer(int n, int n2) {
            this.nMajorcolumns = n;
            this.nSubcolumns = n2;
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            String string = object == null ? "" : object.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.lines.clear();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.lines.addElement(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n2 / this.nSubcolumns * this.nSubcolumns == n2) {
                this.setBorder(this.majorBorder);
            } else {
                this.setBorder(this.subBorder);
            }
            this.setListData(this.lines);
            return this;
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 240L;

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(Color.lightGray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            if (object != null) {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        private static final long serialVersionUID = 240L;
        private int currentRowIndex = -1;
        private int lastRowIndex = -1;
        private JTable parentTable;

        public RowHeader(JTable jTable, Dataset dataset) {
            long[] lArray = dataset.getStartDims();
            long[] lArray2 = dataset.getStride();
            int[] nArray = dataset.getSelectedIndex();
            final int n = (int)lArray[nArray[0]];
            final int n2 = (int)lArray2[nArray[0]];
            final int n3 = jTable.getRowCount();
            this.parentTable = jTable;
            AbstractTableModel abstractTableModel = new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public int getRowCount() {
                    return n3;
                }

                @Override
                public String getColumnName(int n4) {
                    return " ";
                }

                @Override
                public Object getValueAt(int n4, int n22) {
                    return String.valueOf(n + n4 * n2);
                }
            };
            this.setModel(abstractTableModel);
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new RowHeaderRenderer());
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.parentTable == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.parentTable.clearSelection();
            this.parentTable.setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    n = 0;
                }
                if (this.currentRowIndex < 0) {
                    this.currentRowIndex = 0;
                }
                this.parentTable.clearSelection();
                if (n > this.currentRowIndex) {
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, n);
                } else {
                    this.parentTable.setRowSelectionInterval(n, this.currentRowIndex);
                }
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            if (n == 500) {
                if (this.currentRowIndex < 0) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                } else if (mouseEvent.isShiftDown()) {
                    if (this.lastRowIndex < 0) {
                        this.parentTable.addRowSelectionInterval(0, this.currentRowIndex);
                    } else if (this.lastRowIndex < this.currentRowIndex) {
                        this.parentTable.addRowSelectionInterval(this.lastRowIndex, this.currentRowIndex);
                    } else {
                        this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.lastRowIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                }
                this.lastRowIndex = this.currentRowIndex;
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            } else if (n == 501) {
                this.currentRowIndex = this.rowAtPoint(mouseEvent.getPoint());
            }
        }
    }

    private class ColumnHeader
    extends JTableHeader {
        private static final long serialVersionUID = 240L;
        private int currentColumnIndex;
        private int lastColumnIndex;
        private JTable parentTable;

        public ColumnHeader(JTable jTable) {
            super(jTable.getColumnModel());
            this.currentColumnIndex = -1;
            this.lastColumnIndex = -1;
            this.parentTable = jTable;
            this.setReorderingAllowed(false);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            if (mouseEvent.getID() == 506) {
                if (this.getResizingColumn() != null) {
                    return;
                }
                int n = this.columnAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    n = 0;
                }
                if (this.currentColumnIndex < 0) {
                    this.currentColumnIndex = 0;
                }
                this.parentTable.clearSelection();
                if (n > this.currentColumnIndex) {
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, n);
                } else {
                    this.parentTable.setColumnSelectionInterval(n, this.currentColumnIndex);
                }
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            int n = mouseEvent.getID();
            if (n == 500) {
                if (this.currentColumnIndex < 0) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                } else if (mouseEvent.isShiftDown()) {
                    if (this.lastColumnIndex < 0) {
                        this.parentTable.addColumnSelectionInterval(0, this.currentColumnIndex);
                    } else if (this.lastColumnIndex < this.currentColumnIndex) {
                        this.parentTable.addColumnSelectionInterval(this.lastColumnIndex, this.currentColumnIndex);
                    } else {
                        this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.lastColumnIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                }
                this.lastColumnIndex = this.currentColumnIndex;
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            } else if (n == 501) {
                this.currentColumnIndex = this.columnAtPoint(mouseEvent.getPoint());
            }
        }
    }

    private class LineplotOption
    extends JDialog
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = 240L;
        public static final int NO_PLOT = -1;
        public static final int ROW_PLOT = 0;
        public static final int COLUMN_PLOT = 1;
        private int idx_xaxis;
        private int nRows;
        private int nCols;
        private int plotType;
        private JRadioButton rowButton;
        private JRadioButton colButton;
        private JComboBox rowBox;
        private JComboBox colBox;

        public LineplotOption(JFrame jFrame, String string, int n, int n2) {
            int n3;
            super(jFrame, string, true);
            this.idx_xaxis = -1;
            this.nRows = 0;
            this.nCols = 0;
            this.plotType = -1;
            this.nRows = n;
            this.nCols = n2;
            this.rowBox = new JComboBox();
            this.rowBox.setEditable(false);
            this.colBox = new JComboBox();
            this.colBox.setEditable(false);
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setPreferredSize(new Dimension(400, 150));
            jPanel.setLayout(new BorderLayout(10, 10));
            long[] lArray = DefaultTableView.this.dataset.getStartDims();
            long[] lArray2 = DefaultTableView.this.dataset.getStride();
            int[] nArray = DefaultTableView.this.dataset.getSelectedIndex();
            int n4 = (int)lArray[nArray[0]];
            int n5 = (int)lArray2[nArray[0]];
            this.rowBox.addItem("array index");
            for (n3 = 0; n3 < n; ++n3) {
                this.rowBox.addItem("row " + (n4 + n3 * n5));
            }
            this.colBox.addItem("array index");
            for (n3 = 0; n3 < n2; ++n3) {
                this.colBox.addItem("column " + DefaultTableView.this.table.getColumnName(n3));
            }
            this.rowButton = new JRadioButton("Row");
            this.colButton = new JRadioButton("Column", true);
            this.rowButton.addItemListener(this);
            this.colButton.addItemListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rowButton);
            buttonGroup.add(this.colButton);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel2.add(new JLabel(" Series in:", 4));
            jPanel2.add(new JLabel(" For abscissa use:", 4));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel3.add(this.colButton);
            jPanel3.add(this.colBox);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel4.add(this.rowButton);
            jPanel4.add(this.rowBox);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(new LineBorder(Color.lightGray));
            jPanel5.setLayout(new GridLayout(1, 3, 20, 5));
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            JPanel jPanel6 = new JPanel();
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(this);
            jButton.setActionCommand("Ok");
            jPanel6.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(this);
            jButton2.setActionCommand("Cancel");
            jPanel6.add(jButton2);
            jPanel.add((Component)new JLabel(" Select plot options:"), "North");
            jPanel.add((Component)jPanel5, "Center");
            jPanel.add((Component)jPanel6, "South");
            this.colBox.setEnabled(this.colButton.isSelected());
            this.rowBox.setEnabled(this.rowButton.isSelected());
            Point point = this.getParent().getLocation();
            point.x += 450;
            point.y += 200;
            this.setLocation(point);
            this.pack();
        }

        int getXindex() {
            return this.idx_xaxis;
        }

        int getPlotBy() {
            return this.plotType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Cancel")) {
                this.plotType = -1;
                this.dispose();
            } else if (string.equals("Ok")) {
                if (this.colButton.isSelected()) {
                    this.idx_xaxis = this.colBox.getSelectedIndex() - 1;
                    this.plotType = 1;
                } else {
                    this.idx_xaxis = this.rowBox.getSelectedIndex() - 1;
                    this.plotType = 0;
                }
                this.dispose();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object.equals(this.colButton) || object.equals(this.rowButton)) {
                this.colBox.setEnabled(this.colButton.isSelected());
                this.rowBox.setEnabled(this.rowButton.isSelected());
            }
        }
    }

    private static enum ViewType {
        TABLE,
        IMAGE,
        TEXT;

    }
}

