/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTextView
extends JInternalFrame
implements TextView,
ActionListener,
KeyListener {
    public static final long serialVersionUID = 240L;
    private final ViewManager viewer;
    private ScalarDS dataset;
    private String[] text;
    private JTable table;
    private boolean isReadOnly = false;
    private boolean isTextChanged = false;
    private TextAreaEditor textEditor = null;
    private RowHeader rowHeaders = null;

    public DefaultTextView(ViewManager viewManager) {
        this(viewManager, null);
    }

    public DefaultTextView(ViewManager viewManager, HashMap hashMap) {
        this.viewer = viewManager;
        this.text = null;
        this.table = null;
        this.dataset = null;
        this.textEditor = new TextAreaEditor(this);
        HObject hObject = null;
        hObject = hashMap != null ? (HObject)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT) : viewManager.getTreeView().getCurrentObject();
        if (!(hObject instanceof ScalarDS)) {
            return;
        }
        this.dataset = (ScalarDS)hObject;
        if (!this.dataset.isText()) {
            this.viewer.showStatus("Cannot display non-text dataset in text view.");
            this.dataset = null;
            return;
        }
        this.isReadOnly = this.dataset.getFileFormat().isReadOnly();
        try {
            this.text = (String[])this.dataset.getData();
        }
        catch (Exception exception) {
            this.viewer.showStatus(exception.toString());
            this.text = null;
        }
        if (this.text == null) {
            this.viewer.showStatus("Loading text dataset failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        String string = new File(this.dataset.getFile()).getName();
        this.setDefaultCloseOperation(2);
        this.setTitle("TextView  -  " + this.dataset.getName() + "  -  " + this.dataset.getPath() + "  -  " + string);
        this.setFrameIcon(ViewProperties.getTextIcon());
        this.table = this.createTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setBackground(Color.black);
        this.rowHeaders = new RowHeader(this.table, this.dataset);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(100);
        JViewport jViewport = new JViewport();
        jViewport.add(this.rowHeaders);
        jViewport.setPreferredSize(this.rowHeaders.getPreferredSize());
        jScrollPane.setRowHeader(jViewport);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        tableColumnModel.getColumn(0).setCellRenderer(textAreaRenderer);
        tableColumnModel.getColumn(0).setCellEditor(this.textEditor);
        ((JPanel)this.getContentPane()).add(jScrollPane);
        this.setJMenuBar(this.createMenuBar());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.dispose();
        } else if (string.equals("Save to text file")) {
            try {
                this.saveAsText();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
            }
        } else if (string.equals("Save changes")) {
            this.updateValueInFile();
        } else if (string.equals("Print")) {
            this.print();
        }
    }

    private JTable createTable() {
        JTable jTable = null;
        int n = this.text.length;
        jTable = new JTable(n, 1){
            public static final long serialVersionUID = 240L;

            @Override
            public Object getValueAt(int n, int n2) {
                return DefaultTextView.this.text[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return !DefaultTextView.this.isReadOnly;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                super.editingStopped(changeEvent);
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    String string;
                    CellEditor cellEditor = (CellEditor)object;
                    ((DefaultTextView)DefaultTextView.this).text[n] = string = (String)cellEditor.getCellEditorValue();
                }
            }
        };
        return jTable;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.isTextChanged = true;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Text", false);
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Save To Text File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save to text file");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Save Changes");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save changes");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close");
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    @Override
    public void updateValueInFile() {
        if (this.isReadOnly) {
            return;
        }
        if (!(this.dataset instanceof ScalarDS)) {
            return;
        }
        if (!this.isTextChanged) {
            return;
        }
        int n = this.table.getEditingRow();
        if (n >= 0) {
            String string;
            this.text[n] = string = (String)this.textEditor.getCellEditorValue();
        }
        try {
            this.dataset.write();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return;
        }
        this.isTextChanged = false;
    }

    private void saveAsText() throws Exception {
        int n;
        Object object2;
        JFileChooser jFileChooser = new JFileChooser(this.dataset.getFile());
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterText());
        jFileChooser.changeToParentDirectory();
        jFileChooser.setDialogTitle("Save Current Data To Text File --- " + this.dataset.getName());
        File file = new File(this.dataset.getName() + ".txt");
        jFileChooser.setSelectedFile(file);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        List list = this.viewer.getTreeView().getCurrentFiles();
        if (list != null) {
            object2 = null;
            for (Object object2 : list) {
                if (!((FileFormat)object2).getFilePath().equals(string)) continue;
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + string + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        object2 = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        int n3 = this.text.length;
        for (int i = 0; i < n3; ++i) {
            ((PrintWriter)object2).print(this.text[i].trim());
            ((PrintWriter)object2).println();
            ((PrintWriter)object2).println();
        }
        ((PrintWriter)object2).flush();
        ((PrintWriter)object2).close();
        this.viewer.showStatus("Data save to: " + string);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            long l = randomAccessFile.length();
            randomAccessFile.close();
            this.viewer.showStatus("File size (bytes): " + l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        int n;
        if (this.isTextChanged && !this.isReadOnly && (n = JOptionPane.showConfirmDialog(this, "\"" + this.dataset.getName() + "\" has changed.\n" + "Do you want to save the changes?", this.getTitle(), 0)) == 0) {
            this.updateValueInFile();
        }
        this.viewer.removeDataView(this);
        super.dispose();
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public String[] getText() {
        return this.text;
    }

    private void print() {
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(null, null);
        for (int i = 0; i < streamPrintServiceFactoryArray.length; ++i) {
            System.out.println(streamPrintServiceFactoryArray[i]);
        }
        DocFlavor[] docFlavorArray = streamPrintServiceFactoryArray[0].getSupportedDocFlavors();
        for (int i = 0; i < docFlavorArray.length; ++i) {
            System.out.println(docFlavorArray[i]);
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream("e:\\temp\\t.html"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DocFlavor.STRING sTRING = DocFlavor.STRING.TEXT_HTML;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        DocPrintJob docPrintJob = printServiceArray[0].createPrintJob();
        SimpleDoc simpleDoc = new SimpleDoc(bufferedInputStream, sTRING, null);
        try {
            docPrintJob.print(simpleDoc, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        public static final long serialVersionUID = 240L;

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(Color.lightGray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            if (object != null) {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        public static final long serialVersionUID = 240L;
        private int currentRowIndex;
        private int lastRowIndex;
        private JTable parentTable;

        public RowHeader(JTable jTable, Dataset dataset) {
            super(jTable.getRowCount(), 1);
            this.currentRowIndex = -1;
            this.lastRowIndex = -1;
            long[] lArray = dataset.getStartDims();
            long[] lArray2 = dataset.getStride();
            int[] nArray = dataset.getSelectedIndex();
            int n = (int)lArray[nArray[0]];
            int n2 = (int)lArray2[nArray[0]];
            this.parentTable = jTable;
            int n3 = this.parentTable.getRowCount();
            for (int i = 0; i < n3; ++i) {
                this.setValueAt(new Integer(n + i * n2), i, 0);
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new RowHeaderRenderer());
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.parentTable == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.parentTable.clearSelection();
            this.parentTable.setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    n = 0;
                }
                if (this.currentRowIndex < 0) {
                    this.currentRowIndex = 0;
                }
                this.parentTable.clearSelection();
                if (n > this.currentRowIndex) {
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, n);
                } else {
                    this.parentTable.setRowSelectionInterval(n, this.currentRowIndex);
                }
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            if (n == 500) {
                if (this.currentRowIndex < 0) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                } else if (mouseEvent.isShiftDown()) {
                    if (this.lastRowIndex < 0) {
                        this.parentTable.addRowSelectionInterval(0, this.currentRowIndex);
                    } else if (this.lastRowIndex < this.currentRowIndex) {
                        this.parentTable.addRowSelectionInterval(this.lastRowIndex, this.currentRowIndex);
                    } else {
                        this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.lastRowIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                }
                this.lastRowIndex = this.currentRowIndex;
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            } else if (n == 501) {
                this.currentRowIndex = this.rowAtPoint(mouseEvent.getPoint());
            }
        }
    }

    private class TextAreaEditor
    extends DefaultCellEditor {
        public static final long serialVersionUID = 240L;

        public TextAreaEditor(KeyListener keyListener) {
            super(new JTextField());
            final JTextArea jTextArea = new JTextArea();
            jTextArea.addKeyListener(keyListener);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setBorder(null);
            this.editorComponent = jScrollPane;
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                public static final long serialVersionUID = 240L;

                @Override
                public void setValue(Object object) {
                    jTextArea.setText(object != null ? object.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return jTextArea.getText();
                }
            };
        }
    }

    private class TextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        public static final long serialVersionUID = 240L;
        private final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
        private final Map cellSizes = new HashMap();

        public TextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.adaptee.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(this.adaptee.getForeground());
            this.setBackground(this.adaptee.getBackground());
            this.setBorder(this.adaptee.getBorder());
            this.setFont(this.adaptee.getFont());
            this.setText(this.adaptee.getText());
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            this.setSize(tableColumnModel.getColumn(n2).getWidth(), 100000);
            int n3 = (int)this.getPreferredSize().getHeight();
            this.addSize(jTable, n, n2, n3);
            n3 = this.findTotalMaximumRowSize(jTable, n);
            if (n3 != jTable.getRowHeight(n)) {
                jTable.setRowHeight(n, n3);
                DefaultTextView.this.rowHeaders.setRowHeight(n, n3);
            }
            return this;
        }

        private void addSize(JTable jTable, int n, int n2, int n3) {
            HashMap<Integer, Integer> hashMap;
            HashMap<Integer, HashMap<Integer, Integer>> hashMap2 = (HashMap<Integer, HashMap<Integer, Integer>>)this.cellSizes.get(jTable);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Integer, HashMap<Integer, Integer>>();
                this.cellSizes.put(jTable, hashMap2);
            }
            if ((hashMap = (HashMap<Integer, Integer>)hashMap2.get(new Integer(n))) == null) {
                hashMap = new HashMap<Integer, Integer>();
                hashMap2.put(new Integer(n), hashMap);
            }
            hashMap.put(new Integer(n2), new Integer(n3));
        }

        private int findTotalMaximumRowSize(JTable jTable, int n) {
            int n2 = 0;
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (!(tableCellRenderer instanceof TextAreaRenderer)) continue;
                TextAreaRenderer textAreaRenderer = (TextAreaRenderer)tableCellRenderer;
                n2 = Math.max(n2, textAreaRenderer.findMaximumRowSize(jTable, n));
            }
            return n2;
        }

        private int findMaximumRowSize(JTable jTable, int n) {
            Map map = (Map)this.cellSizes.get(jTable);
            if (map == null) {
                return 0;
            }
            Map map2 = (Map)map.get(new Integer(n));
            if (map2 == null) {
                return 0;
            }
            int n2 = 0;
            for (Map.Entry entry : map2.entrySet()) {
                int n3 = (Integer)entry.getValue();
                n2 = Math.max(n2, n3);
            }
            return n2;
        }
    }
}

