/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataOptionDialog;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.NewDatatypeDialog;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.NewGroupDialog;
import ncsa.hdf.view.NewImageDialog;
import ncsa.hdf.view.NewLinkDialog;
import ncsa.hdf.view.NewTableDataDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTreeView
extends JPanel
implements TreeView,
ActionListener {
    public static final long serialVersionUID = 240L;
    private ViewManager viewer;
    private final DefaultMutableTreeNode root;
    private final JTree tree;
    private final DefaultTreeModel treeModel;
    private final List fileList;
    private final Toolkit toolkit;
    private FileFormat selectedFile;
    private DefaultMutableTreeNode selectedNode;
    private HObject selectedObject;
    private boolean isDefaultDisplay;
    private final JPopupMenu popupMenu;
    private List editGUIs;
    private List objectsToCopy;
    private JMenuItem addTableMenuItem;
    private JMenuItem addDatatypeMenuItem;
    private JMenuItem addLinkMenuItem;

    public DefaultTreeView(ViewManager viewManager) {
        this.viewer = viewManager;
        this.root = new DefaultMutableTreeNode(){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.fileList = new Vector();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.editGUIs = new Vector();
        this.objectsToCopy = null;
        this.isDefaultDisplay = true;
        this.addTableMenuItem = new JMenuItem("Table", ViewProperties.getTableIcon());
        this.addTableMenuItem.addActionListener(this);
        this.addTableMenuItem.setActionCommand("Add table");
        this.addDatatypeMenuItem = new JMenuItem("Datatype", ViewProperties.getDatatypeIcon());
        this.addDatatypeMenuItem.addActionListener(this);
        this.addDatatypeMenuItem.setActionCommand("Add datatype");
        this.addLinkMenuItem = new JMenuItem("Link", ViewProperties.getLinkIcon());
        this.addLinkMenuItem.addActionListener(this);
        this.addLinkMenuItem.setActionCommand("Add link");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setLargeModel(true);
        this.tree.setCellRenderer(new HTreeCellRenderer());
        this.tree.addMouseListener(new HTreeMouseAdapter());
        this.tree.setRootVisible(false);
        int n = 23 + (int)((double)(this.tree.getFont().getSize() - 12) * 0.5);
        this.tree.setRowHeight(n);
        this.popupMenu = this.createPopupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    private void insertNode(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == null || treeNode2 == null) {
            return;
        }
        this.treeModel.insertNodeInto((DefaultMutableTreeNode)treeNode, (DefaultMutableTreeNode)treeNode2, treeNode2.getChildCount());
    }

    private boolean isFileOpen(String string) {
        boolean bl = false;
        FileFormat fileFormat2 = null;
        for (FileFormat fileFormat2 : this.fileList) {
            if (!fileFormat2.getFilePath().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open data");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open As");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open data as");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("New");
        jPopupMenu.add(jMenu);
        this.editGUIs.add(jMenu);
        jMenuItem = new JMenuItem("Group", ViewProperties.getFoldercloseIcon());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Add group");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Dataset", ViewProperties.getDatasetIcon());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Add dataset");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Image", ViewProperties.getImageIcon());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Add image");
        jMenu.add(jMenuItem);
        jMenu.add(this.addTableMenuItem);
        jMenu.add(this.addDatatypeMenuItem);
        jMenu.add(this.addLinkMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Copy object");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.setMnemonic(80);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Paste object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.setMnemonic(68);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Cut object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save to");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save object to file");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Rename object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Properties");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show object properties");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Properties As");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show object properties as");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Close File");
        jMenuItem.setMnemonic(70);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close file");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        HObject hObject = (HObject)this.selectedNode.getUserObject();
        boolean bl2 = hObject.getFileFormat().isReadOnly();
        DefaultTreeView.setEnabled(this.editGUIs, !bl2);
        boolean bl3 = bl = !hObject.getFileFormat().isReadOnly();
        if (hObject instanceof Group) {
            this.popupMenu.getComponent(0).setEnabled(false);
            this.popupMenu.getComponent(1).setEnabled(false);
            boolean bl4 = !((Group)hObject).isRoot();
            this.popupMenu.getComponent(5).setEnabled(bl4);
            this.popupMenu.getComponent(6).setEnabled(bl);
            this.popupMenu.getComponent(7).setEnabled(bl4 && bl);
            this.popupMenu.getComponent(9).setEnabled(bl4);
            this.popupMenu.getComponent(10).setEnabled(bl4 && bl);
        } else {
            this.popupMenu.getComponent(0).setEnabled(true);
            this.popupMenu.getComponent(1).setEnabled(true);
            this.popupMenu.getComponent(5).setEnabled(true);
            this.popupMenu.getComponent(6).setEnabled(bl);
            this.popupMenu.getComponent(7).setEnabled(bl);
            this.popupMenu.getComponent(9).setEnabled(true);
            this.popupMenu.getComponent(10).setEnabled(bl);
        }
        if (this.selectedFile != null && this.selectedFile.isThisType(FileFormat.getFileFormat("HDF5"))) {
            this.addTableMenuItem.setVisible(true);
            this.addDatatypeMenuItem.setVisible(true);
            this.addLinkMenuItem.setVisible(true);
        } else {
            this.addTableMenuItem.setVisible(false);
            this.addDatatypeMenuItem.setVisible(false);
            this.addLinkMenuItem.setVisible(false);
        }
        this.popupMenu.show((JComponent)mouseEvent.getSource(), n, n2);
    }

    private static void setEnabled(List list, boolean bl) {
        Component component2 = null;
        for (Component component2 : list) {
            component2.setEnabled(bl);
        }
    }

    private final void saveAsHDF4(FileFormat fileFormat) {
        String string;
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        JFrame jFrame = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog newFileDialog = new NewFileDialog(jFrame, string = fileFormat.getParent(), "HDF", this.getCurrentFiles());
        if (!newFileDialog.isFileCreated()) {
            return;
        }
        String string2 = newFileDialog.getFile();
        int n = 0;
        int n2 = 512;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(fileFormat.getFilePath()));
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage() + "\n" + string2, "HDFView", 0);
            return;
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (Exception exception) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
        byte[] byArray = new byte[n2];
        try {
            n = bufferedInputStream.read(byArray, 0, n2);
        }
        catch (Exception exception) {
            n = 0;
        }
        while (n > 0) {
            try {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, n2);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        try {
            bufferedOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FileFormat fileFormat2 = this.openFile(string2, 1);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage() + "\n" + string2, "HDFView", 0);
        }
    }

    private void saveAsHDF5(FileFormat fileFormat) {
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        TreeNode treeNode = fileFormat.getRootNode();
        if (treeNode == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The file is empty.", "HDFView", 0);
            return;
        }
        JFrame jFrame = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog newFileDialog = new NewFileDialog(jFrame, fileFormat.getParent(), "HDF5", this.getCurrentFiles());
        if (!newFileDialog.isFileCreated()) {
            return;
        }
        String string = newFileDialog.getFile();
        int n = treeNode.getChildCount();
        Vector<Object> vector = new Vector<Object>(n);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            vector.add(defaultMutableTreeNode.getUserObject());
        }
        FileFormat fileFormat2 = null;
        try {
            fileFormat2 = this.openFile(string, 1);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage() + "\n" + string, "HDFView", 0);
            return;
        }
        if (fileFormat2 == null) {
            return;
        }
        TreeNode treeNode2 = fileFormat2.getRootNode();
        this.pasteObject(vector, treeNode2, fileFormat2);
        vector.setSize(0);
        Group group = (Group)((DefaultMutableTreeNode)treeNode).getUserObject();
        Group group2 = (Group)((DefaultMutableTreeNode)fileFormat2.getRootNode()).getUserObject();
        Object[] objectArray = new Object[2];
        Class<?> clazz = null;
        Class[] classArray = new Class[2];
        Method method = null;
        try {
            objectArray[0] = group;
            objectArray[1] = group2;
            classArray[0] = classArray[1] = (clazz = Class.forName("ncsa.hdf.object.HObject"));
            method = fileFormat2.getClass().getMethod("copyAttributes", classArray);
            method.invoke((Object)fileFormat2, objectArray);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
        }
        objectArray[0] = group.getFileFormat();
        objectArray[1] = fileFormat2;
        classArray[0] = classArray[1] = objectArray[0].getClass();
        try {
            method = fileFormat2.getClass().getMethod("updateReferenceDataset", classArray);
            method.invoke((Object)fileFormat2, objectArray);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
        }
    }

    private void copyObject() {
        this.objectsToCopy = this.getSelectedObjects();
    }

    private void pasteObject() {
        int n;
        TreeNode treeNode = this.selectedNode;
        if (this.objectsToCopy == null || this.objectsToCopy.size() <= 0 || treeNode == null) {
            return;
        }
        FileFormat fileFormat = ((HObject)this.objectsToCopy.get(0)).getFileFormat();
        FileFormat fileFormat2 = this.getSelectedFile();
        FileFormat fileFormat3 = FileFormat.getFileFormat("HDF5");
        FileFormat fileFormat4 = FileFormat.getFileFormat("HDF");
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file is null.", "HDFView", 0);
            return;
        }
        if (fileFormat2 == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Destination file is null.", "HDFView", 0);
            return;
        }
        if (fileFormat.isThisType(fileFormat4) && fileFormat2.isThisType(fileFormat3)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF4 object to HDF5 file", "HDFView", 0);
            return;
        }
        if (fileFormat.isThisType(fileFormat3) && fileFormat2.isThisType(fileFormat4)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF5 object to HDF4 file", "HDFView", 0);
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode = treeNode.getParent();
        }
        Group group = (Group)treeNode.getUserObject();
        String string = group.getPath() + group.getName();
        if (group.isRoot()) {
            string = "/";
        }
        String string2 = "";
        int n2 = 3;
        if (fileFormat.isThisType(fileFormat4)) {
            string2 = "WARNING: object can not be deleted after it is copied.\n\n";
            n2 = 2;
        }
        if ((n = JOptionPane.showConfirmDialog(this, string2 = string2 + "Do you want to copy the selected object(s) to \nGroup: " + string + "\nFile: " + fileFormat2.getFilePath(), "Copy object", 0, n2)) == 1) {
            return;
        }
        this.pasteObject(this.objectsToCopy, treeNode, fileFormat2);
    }

    private void pasteObject(List list, TreeNode treeNode, FileFormat fileFormat) {
        if (list == null || list.size() <= 0 || treeNode == null) {
            return;
        }
        FileFormat fileFormat2 = ((HObject)list.get(0)).getFileFormat();
        Group group = (Group)((DefaultMutableTreeNode)treeNode).getUserObject();
        HObject hObject = null;
        TreeNode treeNode2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            treeNode2 = null;
            hObject = (HObject)iterator.next();
            if (hObject instanceof Group && ((Group)hObject).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy the root group", "HDFView", 0);
                return;
            }
            Group group2 = group;
            while (!group2.isRoot()) {
                if (hObject.equals(group2)) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy a group to itself.", "HDFView", 0);
                    return;
                }
                group2 = group2.getParent();
            }
            try {
                treeNode2 = fileFormat.copy(hObject, group);
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            }
            if (treeNode2 == null) continue;
            this.insertNode(treeNode2, treeNode);
        }
    }

    private void removeSelectedObjects() {
        FileFormat fileFormat = this.getSelectedFile();
        if (fileFormat.isThisType(FileFormat.getFileFormat("HDF"))) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete HDF4 object.", "HDFView", 0);
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Do you want to remove all the selected object(s) ?", "Remove object", 0);
        if (n == 1) {
            return;
        }
        String string = "";
        HObject hObject = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            Group group;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            hObject = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject instanceof Group && (group = (Group)hObject).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete the file root.", "HDFView", 0);
                return;
            }
            if (this.isObjectOpen(hObject)) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot delete the selected object: " + hObject + "\nThe dataset or dataset in the group is in use." + "\n\nPlease close the dataset(s) and try again.\n", "HDFView", 0);
                continue;
            }
            try {
                fileFormat.delete(hObject);
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
                continue;
            }
            if (hObject.equals(this.selectedObject)) {
                this.selectedObject = null;
            }
            this.removeNode(defaultMutableTreeNode);
        }
    }

    private void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            Group group = (Group)defaultMutableTreeNode2.getUserObject();
            group.removeFromMemberList((HObject)defaultMutableTreeNode.getUserObject());
            if (defaultMutableTreeNode.equals(this.selectedNode)) {
                this.selectedNode = null;
                this.selectedFile = null;
            }
        }
    }

    private boolean isObjectOpen(HObject hObject) {
        boolean bl = false;
        if (hObject instanceof Group) {
            Group group = (Group)hObject;
            List list = group.getMemberList();
            if (list == null || list.size() == 0) {
                bl = false;
            } else {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    HObject hObject2 = (HObject)list.get(i);
                    boolean bl2 = bl = this.viewer.getDataView(hObject2) != null;
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = this.viewer.getDataView(hObject) != null;
        }
        return bl;
    }

    private final List breadthFirstUserObjects(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.add(defaultMutableTreeNode.getUserObject());
        }
        return vector;
    }

    private void addGroup() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewGroupDialog newGroupDialog = new NewGroupDialog((Frame)((JFrame)((Object)this.viewer)), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newGroupDialog.setVisible(true);
        HObject hObject = (HObject)newGroupDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newGroupDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addDataset() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatasetDialog newDatasetDialog = new NewDatasetDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newDatasetDialog.setVisible(true);
        HObject hObject = (HObject)newDatasetDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newDatasetDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addImage() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewImageDialog newImageDialog = new NewImageDialog((Frame)((JFrame)((Object)this.viewer)), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newImageDialog.setVisible(true);
        HObject hObject = (HObject)newImageDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newImageDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addTable() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewTableDataDialog newTableDataDialog = new NewTableDataDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newTableDataDialog.setVisible(true);
        HObject hObject = (HObject)newTableDataDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newTableDataDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addDatatype() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatatypeDialog newDatatypeDialog = new NewDatatypeDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newDatatypeDialog.setVisible(true);
        HObject hObject = (HObject)newDatatypeDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newDatatypeDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addLink() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewLinkDialog newLinkDialog = new NewLinkDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newLinkDialog.setVisible(true);
        HObject hObject = (HObject)newLinkDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newLinkDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void renameObject() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename the root.", "HDFView", 0);
            return;
        }
        boolean bl = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF"));
        if (bl) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename HDF4 object.", "HDFView", 0);
            return;
        }
        String string = this.selectedObject.getName();
        String string2 = JOptionPane.showInputDialog(this, "Rename \"" + string + "\" to:", "Rename...", 1);
        if (string2 == null) {
            return;
        }
        if ((string2 = string2.trim()) == null || string2.length() == 0 || string2.equals(string)) {
            return;
        }
        try {
            this.selectedObject.setName(string2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), "HDFView", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close file")) {
            ((HDFView)this.viewer).actionPerformed(actionEvent);
        } else if (string.equals("Add group")) {
            this.addGroup();
        } else if (string.equals("Add dataset")) {
            this.addDataset();
        } else if (string.equals("Add image")) {
            this.addImage();
        } else if (string.equals("Add table")) {
            this.addTable();
        } else if (string.equals("Add datatype")) {
            this.addDatatype();
        } else if (string.equals("Add link")) {
            this.addLink();
        } else {
            if (string.startsWith("Open data")) {
                this.isDefaultDisplay = string.equals("Open data");
                try {
                    this.showDataContent(this.selectedObject);
                }
                catch (Throwable throwable) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, throwable, "HDFView", 0);
                    return;
                }
            }
            if (string.equals("Copy object")) {
                this.copyObject();
            } else if (string.equals("Paste object")) {
                this.pasteObject();
            } else if (string.equals("Cut object")) {
                this.removeSelectedObjects();
            } else if (string.equals("Save object to file")) {
                NewFileDialog newFileDialog;
                if (this.selectedObject == null) {
                    return;
                }
                if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Cannot save the root group.\nUse \"Save As\" from file menu to save the whole file", "HDFView", 0);
                    return;
                }
                String string2 = "HDF";
                boolean bl = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
                if (bl) {
                    string2 = "HDF5";
                }
                if (!(newFileDialog = new NewFileDialog((JFrame)((Object)this.viewer), this.selectedObject.getFileFormat().getParent(), string2, this.fileList)).isFileCreated()) {
                    return;
                }
                String string3 = newFileDialog.getFile();
                FileFormat fileFormat = null;
                try {
                    fileFormat = this.openFile(string3, 1);
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, exception.getMessage() + "\n" + string3, "HDFView", 0);
                }
                Vector<HObject> vector = new Vector<HObject>(2);
                vector.add(this.selectedObject);
                this.pasteObject(vector, fileFormat.getRootNode(), fileFormat);
            } else if (string.equals("Rename object")) {
                this.renameObject();
            } else if (string.startsWith("Show object properties")) {
                this.isDefaultDisplay = string.equals("Show object properties");
                try {
                    MetaDataView metaDataView = this.showMetaData(this.selectedObject);
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileFormat openFile(String string, int n) throws Exception {
        FileFormat fileFormat = null;
        MutableTreeNode mutableTreeNode = null;
        String string2 = "";
        if (this.isFileOpen(string)) {
            this.viewer.showStatus("File is in use");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new UnsupportedOperationException("File does not exist.");
        }
        if (!file.canWrite()) {
            n = 0;
        }
        Enumeration enumeration = FileFormat.getFileFormatKeys();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            FileFormat fileFormat2;
            string3 = (String)enumeration.nextElement();
            if (string3.equals("HDF")) {
                try {
                    fileFormat2 = FileFormat.getFileFormat("HDF");
                    if (fileFormat2 == null || !fileFormat2.isThisType(string)) continue;
                    fileFormat = fileFormat2.open(string, n);
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (string3.equals("HDF5")) {
                try {
                    fileFormat2 = FileFormat.getFileFormat("HDF5");
                    if (fileFormat2 == null || !fileFormat2.isThisType(string)) continue;
                    fileFormat = fileFormat2.open(string, n);
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            try {
                fileFormat2 = FileFormat.getFileFormat(string3);
                if (!fileFormat2.isThisType(string)) continue;
                fileFormat = fileFormat2.open(string, n);
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (fileFormat == null) {
            throw new IOException("Unsupported fileformat - " + string);
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            fileFormat.setMaxMembers(ViewProperties.getMaxMembers());
            fileFormat.setStartMembers(ViewProperties.getStartMembers());
            fileFormat.open();
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        mutableTreeNode = (MutableTreeNode)fileFormat.getRootNode();
        if (mutableTreeNode != null) {
            this.insertNode(mutableTreeNode, this.root);
            int n2 = this.tree.getRowCount();
            if (n2 > 0) {
                this.tree.expandRow(this.tree.getRowCount() - 1);
            }
            this.fileList.add(fileFormat);
        }
        return fileFormat;
    }

    @Override
    public void closeFile(FileFormat fileFormat) throws Exception {
        if (fileFormat == null) {
            return;
        }
        FileFormat fileFormat2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Group group = (Group)defaultMutableTreeNode.getUserObject();
            fileFormat2 = group.getFileFormat();
            if (!fileFormat2.equals(fileFormat)) continue;
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            try {
                fileFormat2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileList.remove(fileFormat2);
            if (!fileFormat2.equals(this.selectedFile)) break;
            this.selectedFile = null;
            this.selectedNode = null;
            break;
        }
    }

    @Override
    public void saveFile(FileFormat fileFormat) throws Exception {
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        boolean bl = fileFormat.isThisType(FileFormat.getFileFormat("HDF"));
        boolean bl2 = fileFormat.isThisType(FileFormat.getFileFormat("HDF5"));
        if (!bl && !bl2) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Saving file is not supported for this file type", "HDFView", 0);
            return;
        }
        List list = ((HDFView)this.viewer).getDataViews();
        Object var5_5 = null;
        TableView tableView = null;
        TextView textView = null;
        FileFormat fileFormat2 = null;
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                var5_5 = list.get(i);
                if (var5_5 instanceof TableView) {
                    tableView = var5_5;
                    fileFormat2 = tableView.getDataObject().getFileFormat();
                    if (!fileFormat.equals(fileFormat2)) continue;
                    tableView.updateValueInFile();
                    continue;
                }
                if (!(var5_5 instanceof TextView) || !fileFormat.equals(fileFormat2 = (textView = (TextView)var5_5).getDataObject().getFileFormat())) continue;
                textView.updateValueInFile();
            }
        }
        if (bl2) {
            this.saveAsHDF5(fileFormat);
        } else if (bl) {
            this.saveAsHDF4(fileFormat);
        }
    }

    @Override
    public FileFormat getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    public List getSelectedObjects() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return null;
        }
        Vector<HObject> vector = new Vector<HObject>(treePathArray.length);
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            hObject = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject == null) continue;
            vector.add(hObject);
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            HObject hObject2 = (HObject)defaultMutableTreeNode2.getUserObject();
            vector.remove(hObject2);
        }
        return vector;
    }

    @Override
    public HObject getCurrentObject() {
        return this.selectedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataView showDataContent(HObject hObject) throws Exception {
        Serializable serializable;
        if (hObject == null || !(hObject instanceof Dataset)) {
            return null;
        }
        Dataset dataset = (Dataset)hObject;
        if (dataset.getRank() <= 0) {
            dataset.init();
        }
        boolean bl = dataset instanceof ScalarDS && ((ScalarDS)dataset).isText();
        boolean bl2 = dataset instanceof ScalarDS && ((ScalarDS)dataset).isImage();
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)this.viewer.getDataView(dataset));
        if (this.isDefaultDisplay) {
            if (jInternalFrame != null) {
                jInternalFrame.toFront();
                return null;
            }
            string = bl ? (String)HDFView.getListOfTextView().get(0) : (bl2 ? (String)HDFView.getListOfImageView().get(0) : (String)HDFView.getListOfTableView().get(0));
        } else {
            serializable = new DataOptionDialog(this.viewer, dataset);
            ((Dialog)serializable).setVisible(true);
            if (((DataOptionDialog)serializable).isCancelled()) {
                return null;
            }
            bl2 = ((DataOptionDialog)serializable).isImageDisplay();
            bl3 = ((DataOptionDialog)serializable).isDisplayTypeChar();
            string = ((DataOptionDialog)serializable).getDataViewName();
            bl4 = ((DataOptionDialog)serializable).isTransposed();
        }
        serializable = null;
        try {
            serializable = Class.forName(string);
        }
        catch (Exception exception) {
            try {
                serializable = ViewProperties.loadExtClass().loadClass(string);
            }
            catch (Exception exception2) {
                serializable = null;
            }
        }
        if (serializable == null) {
            string = bl ? "ncsa.hdf.view.DefaultTextView" : (bl2 ? "ncsa.hdf.view.DefaultImageView" : "ncsa.hdf.view.DefaultTableView");
            try {
                serializable = Class.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = null;
        Object[] objectArray = new Object[]{this.viewer};
        if (string.startsWith("ncsa.hdf.view.DefaultTableView")) {
            HashMap<ViewProperties.DATA_VIEW_KEY, Boolean> hashMap = new HashMap<ViewProperties.DATA_VIEW_KEY, Boolean>(4);
            hashMap.put(ViewProperties.DATA_VIEW_KEY.CHAR, new Boolean(bl3));
            hashMap.put(ViewProperties.DATA_VIEW_KEY.TRANSPOSED, new Boolean(bl4));
            Object[] objectArray2 = new Object[]{this.viewer, hashMap};
            objectArray = objectArray2;
        } else if (string.startsWith("ncsa.hdf.view.DefaultImageView")) {
            Object[] objectArray3 = new Object[]{this.viewer};
            objectArray = objectArray3;
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            object = Tools.newInstance((Class)serializable, objectArray);
            this.viewer.addDataView((DataView)object);
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        return (DataView)object;
    }

    @Override
    public MetaDataView showMetaData(HObject hObject) throws Exception {
        if (hObject == null) {
            return null;
        }
        List list = HDFView.getListOfMetaDataView();
        if (list == null || list.size() <= 0) {
            return null;
        }
        int n = list.size();
        Object var4_4 = null;
        String string = (String)list.get(0);
        if (!this.isDefaultDisplay && n > 1) {
            string = (String)JOptionPane.showInputDialog(this, "Select MetaDataView", "HDFView", 1, null, list.toArray(), string);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            clazz = ViewProperties.loadExtClass().loadClass(string);
        }
        Object[] objectArray = new Object[]{this.viewer};
        MetaDataView metaDataView = (MetaDataView)Tools.newInstance(clazz, objectArray);
        return metaDataView;
    }

    @Override
    public void addObject(HObject hObject, Group group) throws Exception {
        if (hObject == null || group == null) {
            return;
        }
        TreeNode treeNode = this.findTreeNode(group);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = hObject instanceof Group ? new DefaultMutableTreeNode(hObject){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        } : new DefaultMutableTreeNode(hObject);
        this.treeModel.insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)treeNode, treeNode.getChildCount());
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List getCurrentFiles() {
        return this.fileList;
    }

    @Override
    public TreeNode findTreeNode(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        TreeNode treeNode = hObject.getFileFormat().getRootNode();
        if (treeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        HObject hObject2 = null;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            hObject2 = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject2 == null || !hObject2.equals(hObject)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    private class HTreeMouseAdapter
    extends MouseAdapter {
        private HTreeMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath = DefaultTreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!defaultMutableTreeNode.equals(DefaultTreeView.this.selectedNode)) {
                DefaultTreeView.this.selectedNode = defaultMutableTreeNode;
                DefaultTreeView.this.selectedObject = (HObject)DefaultTreeView.this.selectedNode.getUserObject();
                FileFormat fileFormat = DefaultTreeView.this.selectedObject.getFileFormat();
                if (fileFormat != null && !fileFormat.equals(DefaultTreeView.this.selectedFile)) {
                    DefaultTreeView.this.selectedFile = fileFormat;
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionPath(treePath);
                }
                DefaultTreeView.this.viewer.mouseEventFired(mouseEvent);
            }
            int n = mouseEvent.getModifiers();
            if (mouseEvent.isPopupTrigger() || n == 4 || System.getProperty("os.name").startsWith("Mac") && n == 18) {
                int n2 = DefaultTreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (!DefaultTreeView.this.tree.isRowSelected(n2)) {
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionRow(n2);
                }
                DefaultTreeView.this.showPopupMenu(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2) {
                DefaultTreeView.this.isDefaultDisplay = true;
                try {
                    DefaultTreeView.this.showDataContent(DefaultTreeView.this.selectedObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class HTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public static final long serialVersionUID = 240L;
        private Icon h4Icon;
        private Icon h5Icon;
        private Icon datasetIcon;
        private Icon imageIcon;
        private Icon tableIcon;
        private Icon textIcon;
        private Icon openFolder = ViewProperties.getFolderopenIcon();
        private Icon closeFolder = ViewProperties.getFoldercloseIcon();
        private Icon datasetIconA;
        private Icon imageIconA;
        private Icon tableIconA;
        private Icon textIconA;
        private Icon openFolderA;
        private Icon closeFolderA;
        private Icon datatypeIcon;
        private Icon datatypeIconA;

        private HTreeCellRenderer() {
            this.datasetIcon = ViewProperties.getDatasetIcon();
            this.imageIcon = ViewProperties.getImageIcon();
            this.h4Icon = ViewProperties.getH4Icon();
            this.h5Icon = ViewProperties.getH5Icon();
            this.tableIcon = ViewProperties.getTableIcon();
            this.textIcon = ViewProperties.getTextIcon();
            this.openFolderA = ViewProperties.getFolderopenIconA();
            this.closeFolderA = ViewProperties.getFoldercloseIconA();
            this.datasetIconA = ViewProperties.getDatasetIconA();
            this.imageIconA = ViewProperties.getImageIconA();
            this.tableIconA = ViewProperties.getTableIconA();
            this.textIconA = ViewProperties.getTextIconA();
            this.datatypeIcon = ViewProperties.getDatatypeIcon();
            this.datatypeIconA = ViewProperties.getDatatypeIconA();
            if (this.openFolder != null) {
                this.openIcon = this.openFolder;
            } else {
                this.openFolder = this.openIcon;
            }
            if (this.closeFolder != null) {
                this.closedIcon = this.closeFolder;
            } else {
                this.closeFolder = this.closedIcon;
            }
            if (this.datasetIcon == null) {
                this.datasetIcon = this.leafIcon;
            }
            if (this.imageIcon == null) {
                this.imageIcon = this.leafIcon;
            }
            if (this.tableIcon == null) {
                this.tableIcon = this.leafIcon;
            }
            if (this.textIcon == null) {
                this.textIcon = this.leafIcon;
            }
            if (this.h4Icon == null) {
                this.h4Icon = this.leafIcon;
            }
            if (this.h5Icon == null) {
                this.h5Icon = this.leafIcon;
            }
            if (this.datatypeIcon == null) {
                this.datatypeIcon = this.leafIcon;
            }
            if (this.openFolderA == null) {
                this.openFolderA = this.openFolder;
            }
            if (this.closeFolderA == null) {
                this.closeFolderA = this.closeFolder;
            }
            if (this.datasetIconA == null) {
                this.datasetIconA = this.datasetIcon;
            }
            if (this.imageIconA == null) {
                this.imageIconA = this.imageIcon;
            }
            if (this.tableIconA == null) {
                this.tableIconA = this.tableIcon;
            }
            if (this.textIconA == null) {
                this.textIconA = this.textIcon;
            }
            if (this.datatypeIconA == null) {
                this.datatypeIconA = this.datatypeIcon;
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            HObject hObject = (HObject)((DefaultMutableTreeNode)object).getUserObject();
            boolean bl5 = false;
            if (hObject instanceof Dataset) {
                if (hObject instanceof ScalarDS) {
                    ScalarDS scalarDS = (ScalarDS)hObject;
                    bl5 = scalarDS.hasAttribute();
                    this.leafIcon = scalarDS.isImage() ? (bl5 ? this.imageIconA : this.imageIcon) : (scalarDS.isText() ? (bl5 ? this.textIconA : this.textIcon) : (bl5 ? this.datasetIconA : this.datasetIcon));
                } else if (hObject instanceof CompoundDS) {
                    this.leafIcon = hObject.hasAttribute() ? this.tableIconA : this.tableIcon;
                }
            } else if (hObject instanceof Group) {
                Group group = (Group)hObject;
                if (group.hasAttribute()) {
                    this.openIcon = this.openFolderA;
                    this.closedIcon = this.closeFolderA;
                } else {
                    this.openIcon = this.openFolder;
                    this.closedIcon = this.closeFolder;
                }
                if (group.isRoot()) {
                    if (group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"))) {
                        this.openIcon = this.closedIcon = this.h5Icon;
                    } else if (group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF"))) {
                        this.openIcon = this.closedIcon = this.h4Icon;
                    }
                }
            } else if (hObject instanceof Datatype) {
                Datatype datatype = (Datatype)hObject;
                this.leafIcon = datatype.hasAttribute() ? this.datatypeIconA : this.datatypeIcon;
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }
}

