/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.FitsException;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    public static void reposition(Object object, long l) throws FitsException {
        if (object == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(object instanceof RandomAccess) || l < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + object + " of type " + object.getClass().getName() + " to " + l);
        }
        try {
            ((RandomAccess)object).seek(l);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to repostion stream " + object + " of type " + object.getClass().getName() + " to " + l + "   Exception:" + iOException);
        }
    }

    public static long findOffset(Object object) {
        if (object instanceof RandomAccess) {
            return ((RandomAccess)object).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int n) {
        int n2 = n % 2880;
        if (n2 > 0) {
            n2 = 2880 - n2;
        }
        return n2;
    }

    public static int addPadding(int n) {
        return n + FitsUtil.padding(n);
    }

    public static boolean isCompressed(String string) {
        int n = string.length();
        return n > 2 && string.substring(n - 3).equalsIgnoreCase(".gz");
    }

    public static int maxLength(String[] stringArray) throws FitsException {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray != null && stringArray[n2].length() > n) {
                n = stringArray[n2].length();
            }
            ++n2;
        }
        return n;
    }

    public static byte[] stringsToByteArray(String[] stringArray, int n) {
        byte[] byArray = new byte[stringArray.length * n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            byte[] byArray2 = stringArray[n2].getBytes();
            int n3 = byArray2.length;
            if (n3 > n) {
                n3 = n;
            }
            System.arraycopy(byArray2, 0, byArray, n2 * n, n3);
            int n4 = n3;
            while (n4 < n) {
                byArray[n2 * n + n4] = 32;
                ++n4;
            }
            ++n2;
        }
        return byArray;
    }

    public static String[] byteArrayToStrings(byte[] byArray, int n) {
        String[] stringArray = new String[byArray.length / n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = new String(byArray, n2 * n, n).trim();
            ++n2;
        }
        return stringArray;
    }

    static byte[] booleanToByte(boolean[] blArray) {
        byte[] byArray = new byte[blArray.length];
        int n = 0;
        while (n < blArray.length) {
            byArray[n] = blArray[n] ? 84 : 70;
            ++n;
        }
        return byArray;
    }

    static boolean[] byteToBoolean(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            blArray[n] = byArray[n] == 84;
            ++n;
        }
        return blArray;
    }
}

