/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.InvalidRangeException;

public final class Range {
    int n;
    int a;
    int d;

    public Range(int first, int last) throws InvalidRangeException {
        if (first < 0) {
            throw new InvalidRangeException();
        }
        if (last < 0) {
            throw new InvalidRangeException();
        }
        this.d = last < first ? -1 : 1;
        this.a = first;
        this.n = Math.max((last - first) / this.d + 1, 1);
    }

    public Range(int first, int last, int step) throws InvalidRangeException {
        if (first < 0) {
            throw new InvalidRangeException();
        }
        if (last < 0) {
            throw new InvalidRangeException();
        }
        this.a = first;
        this.d = step;
        this.n = Math.max((last - first) / step + 1, 1);
    }

    public int length() {
        return this.n;
    }

    public int element(int i) throws InvalidRangeException {
        if (i < 0) {
            throw new InvalidRangeException();
        }
        if (i >= this.n) {
            throw new InvalidRangeException();
        }
        return this.a + i * this.d;
    }

    protected int elementf(int i) {
        return this.a + i * this.d;
    }

    public int first() {
        return this.a;
    }

    public int last() {
        return this.a + (this.n - 1) * this.d;
    }

    public int step() {
        return this.d;
    }

    public int min() {
        if (this.n > 0) {
            if (this.d > 0) {
                return this.a;
            }
            return this.a + (this.n - 1) * this.d;
        }
        return this.a;
    }

    public int max() {
        if (this.n > 0) {
            if (this.d > 0) {
                return this.a + (this.n - 1) * this.d;
            }
            return this.a;
        }
        if (this.d > 0) {
            return this.a - 1;
        }
        return this.a + 1;
    }
}

