/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import ucar.nc2.Variable;
import ucar.netcdf.UnlimitedDimension;

public class Dimension {
    private Variable coordVar;
    private boolean isUnlimited = false;
    private String name;
    protected int length;
    private StringBuffer buff = new StringBuffer();
    private ucar.netcdf.Dimension dim;

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }

    public Variable getCoordinateVariable() {
        return this.coordVar;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Dimension)) {
            return false;
        }
        Dimension d = (Dimension)oo;
        return this.getName().equals(d.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        this.buff.setLength(0);
        this.buff.append("   " + this.getName());
        if (this.isUnlimited()) {
            this.buff.append(" = UNLIMITED;   // (" + this.getLength() + " currently)");
        } else {
            this.buff.append(" = " + this.getLength() + ";");
        }
        if (this.getCoordinateVariable() != null) {
            this.buff.append("   // (has coord.var)");
        }
        return this.buff.toString();
    }

    public void rename(String rename) {
        this.name = rename;
    }

    protected Dimension(String name, int length) {
        this.name = name;
        this.length = length;
    }

    protected void setCoordinateVariable(Variable v) {
        this.coordVar = v;
    }

    protected void setIsUnlimited(boolean b) {
        this.isUnlimited = b;
    }

    Dimension(ucar.netcdf.Dimension dim) {
        this.dim = dim;
        this.name = dim.getName();
        this.length = dim.getLength();
        this.setIsUnlimited(dim instanceof UnlimitedDimension);
    }

    ucar.netcdf.Dimension getOrg() {
        return this.dim;
    }
}

