/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

import es.ehu.www.ccwintco.npp.core.SinglePointNppEstimator;
import es.ehu.www.ccwintco.npp.core.SinglePointNppResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.CycleResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.DailyResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.ClimateDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.DailyDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SeasonDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SiteDataManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public final class ForestBGC
implements SinglePointNppEstimator {
    private String name = null;
    public static final int CNMODEL_RUNNING_88 = 0;
    public static final int CNMODEL_GOWER_91 = 1;
    private int cnModel = 0;
    private ClimateDataManager climateDataManager = null;
    private SiteDataManager siteDataManager = null;
    private DailyDataManager dailyDataManager = null;
    private SeasonDataManager seasonDataManager = null;
    private static final ForestBGC instance = new ForestBGC();

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final int getCnModel() {
        return this.cnModel;
    }

    public final void setCnModel(int cnModel) {
        this.cnModel = cnModel;
    }

    public final ClimateDataManager getClimateDataManager() {
        return this.climateDataManager;
    }

    public final void setClimateDataManager(ClimateDataManager climateDataManager) {
        this.climateDataManager = climateDataManager;
    }

    public final SiteDataManager getSiteDataManager() {
        return this.siteDataManager;
    }

    public final void setSiteDataManager(SiteDataManager siteDataManager) {
        this.siteDataManager = siteDataManager;
    }

    public final DailyDataManager getDailyDataManager() {
        return this.dailyDataManager;
    }

    public final void setDailyDataManager(DailyDataManager dailyDataManager) {
        this.dailyDataManager = dailyDataManager;
    }

    public final SeasonDataManager getSeasonDataManager() {
        return this.seasonDataManager;
    }

    public final void setSeasonDataManager(SeasonDataManager seasonDataManager) {
        this.seasonDataManager = seasonDataManager;
    }

    public static ForestBGC getInstance() {
        return instance;
    }

    @Override
    public String getVersion() {
        return "Forest-BGC model implementation based on the Joseph C. Coughlan's SIMLAT5 version 3.6.";
    }

    @Override
    public SinglePointNppResults estimate() throws Exception {
        if (this.climateDataManager == null) {
            throw new Exception("A climate data manager is needed");
        }
        if (this.siteDataManager == null) {
            throw new Exception("A site data manager is needed");
        }
        ArrayList<DailyResults> dailyResults = new ArrayList<DailyResults>();
        ArrayList<CycleResults> cycleResults = new ArrayList<CycleResults>();
        int startTime = this.siteDataManager.getData(0).intValue();
        int stopTime = this.siteDataManager.getData(1).intValue();
        int loopTime = this.siteDataManager.getData(2).intValue();
        Double[] x = new Double[]{this.siteDataManager.getData(3), this.siteDataManager.getData(4), this.siteDataManager.getData(5), this.siteDataManager.getData(6), this.siteDataManager.getData(7), this.siteDataManager.getData(8), this.siteDataManager.getData(9), this.siteDataManager.getData(10), this.siteDataManager.getData(11), this.siteDataManager.getData(12), this.siteDataManager.getData(13), this.siteDataManager.getData(14), this.siteDataManager.getData(15), this.siteDataManager.getData(16), this.siteDataManager.getData(17), this.siteDataManager.getData(18), this.siteDataManager.getData(19), this.siteDataManager.getData(20), this.siteDataManager.getData(21), this.siteDataManager.getData(22)};
        Double[] dx = new Double[20];
        int i = 0;
        while (i < dx.length) {
            dx[i] = 0.0;
            ++i;
        }
        Double[][] f = new Double[20][20];
        int i2 = 0;
        while (i2 < 20) {
            int j = 0;
            while (j < 20) {
                f[i2][j] = 0.0;
                ++j;
            }
            ++i2;
        }
        Double[] b = new Double[50];
        int i3 = 0;
        while (i3 < b.length) {
            b[i3] = 0.0;
            ++i3;
        }
        b[0] = this.siteDataManager.getData(33);
        b[1] = this.siteDataManager.getData(34);
        b[2] = this.siteDataManager.getData(35);
        b[3] = this.siteDataManager.getData(36);
        b[4] = this.siteDataManager.getData(37);
        b[5] = this.siteDataManager.getData(38);
        b[6] = this.siteDataManager.getData(39);
        b[7] = this.siteDataManager.getData(40);
        b[8] = this.siteDataManager.getData(41);
        b[9] = this.siteDataManager.getData(42);
        b[10] = this.siteDataManager.getData(43);
        b[11] = this.siteDataManager.getData(44);
        b[12] = this.siteDataManager.getData(45);
        b[13] = this.siteDataManager.getData(46);
        b[14] = this.siteDataManager.getData(47);
        b[15] = this.siteDataManager.getData(48);
        b[16] = this.siteDataManager.getData(49);
        b[17] = this.siteDataManager.getData(50);
        b[18] = this.siteDataManager.getData(51);
        b[19] = this.siteDataManager.getData(52);
        b[20] = this.siteDataManager.getData(53);
        b[21] = this.siteDataManager.getData(54);
        b[22] = this.siteDataManager.getData(55);
        b[23] = this.siteDataManager.getData(56);
        b[24] = this.siteDataManager.getData(57);
        b[25] = this.siteDataManager.getData(58);
        b[26] = this.siteDataManager.getData(59);
        b[27] = this.siteDataManager.getData(60);
        b[28] = this.siteDataManager.getData(61);
        b[29] = this.siteDataManager.getData(62);
        b[30] = this.siteDataManager.getData(63);
        b[31] = this.siteDataManager.getData(64);
        b[32] = this.siteDataManager.getData(65);
        b[33] = this.siteDataManager.getData(66);
        b[34] = this.siteDataManager.getData(67);
        b[35] = this.siteDataManager.getData(68);
        b[36] = this.siteDataManager.getData(69);
        b[37] = this.siteDataManager.getData(70);
        b[38] = this.siteDataManager.getData(71);
        b[39] = this.siteDataManager.getData(72);
        b[40] = this.siteDataManager.getData(73);
        b[41] = this.siteDataManager.getData(74);
        b[42] = this.siteDataManager.getData(75);
        b[43] = this.siteDataManager.getData(76);
        b[44] = this.siteDataManager.getData(77);
        b[45] = this.siteDataManager.getData(78);
        b[46] = this.siteDataManager.getData(79);
        b[47] = this.siteDataManager.getData(80);
        b[48] = this.siteDataManager.getData(81);
        b[49] = this.siteDataManager.getData(82);
        Double[] z = new Double[21];
        int i4 = 0;
        while (i4 < z.length) {
            z[i4] = 0.0;
            ++i4;
        }
        Double[] g = new Double[110];
        int i5 = 0;
        while (i5 < g.length) {
            g[i5] = 0.0;
            ++i5;
        }
        int season = 1;
        int yearday = startTime;
        while (yearday <= loopTime) {
            List<SeasonDataManager.SeasonData> seasonDataList;
            List<DailyDataManager.DailyData> dailyDataList;
            if (this.dailyDataManager != null && (dailyDataList = this.dailyDataManager.getDailyData(yearday)) != null) {
                ListIterator<DailyDataManager.DailyData> dailyDataListIterator = dailyDataList.listIterator();
                while (dailyDataListIterator.hasNext()) {
                    DailyDataManager.DailyData dailyData = dailyDataListIterator.next();
                    this.siteDataManager.setData(dailyData.getConstant(), dailyData.getValue());
                }
            }
            if (this.seasonDataManager != null && (seasonDataList = this.seasonDataManager.getSeasonData(season)) != null) {
                ListIterator<SeasonDataManager.SeasonData> seasonDataListIterator = seasonDataList.listIterator();
                while (seasonDataListIterator.hasNext()) {
                    SeasonDataManager.SeasonData seasonData = seasonDataListIterator.next();
                    this.siteDataManager.setData(seasonData.getConstant(), seasonData.getValue());
                }
            }
            int i6 = 0;
            while (i6 < 89) {
                g[i6] = 0.0;
                ++i6;
            }
            switch (this.cnModel) {
                case 1: {
                    z = this.climateBGC(yearday, x, b);
                    g = this.h2oBGC(x, b, z, g);
                    f[5][5] = g[25];
                    f[10][11] = g[101];
                    f[10][12] = 0.0;
                    f[12][11] = g[103];
                    break;
                }
                default: {
                    z = this.climateDC(yearday, x, b);
                    g = this.h2oDC(x, b, z, g);
                    f[5][5] = g[25];
                    f[5][6] = f[5][6] + g[29] + g[30];
                }
            }
            f[1][1] = g[0] + g[5];
            f[0][0] = g[1];
            f[4][4] = g[3];
            f[0][1] = g[2];
            f[1][2] = g[17];
            f[1][3] = g[16];
            if (yearday % stopTime == 0) {
                switch (this.cnModel) {
                    case 1: {
                        x[5] = x[5] - g[99];
                        g = this.growBGC(x, b, g);
                        f[3][3] = -x[3].doubleValue();
                        f[7][10] = x[7] / g[43] * (1.0 - b[32]);
                        f[7][12] = x[7] / g[43] * b[32];
                        f[8][12] = x[8] * b[40];
                        f[9][10] = x[9] * b[41];
                        f[5][6] = g[99] + g[65];
                        f[5][7] = g[66];
                        f[5][8] = g[67];
                        f[5][9] = g[68];
                        f[13][13] = b[38] + b[39];
                        f[13][14] = g[69];
                        f[13][15] = g[70];
                        f[13][16] = g[71];
                        f[14][13] = g[72];
                        f[14][17] = x[14] / g[43] * (1.0 - g[42]);
                        f[15][18] = 0.0;
                        f[16][13] = g[71];
                        f[17][13] = g[93];
                        f[17][18] = x[17] * g[79] * g[80] * b[32];
                        f[17][19] = 0.0;
                        f[18][13] = g[94];
                        f[18][19] = 0.0;
                        f[13][19] = x[13] / b[37];
                        break;
                    }
                    default: {
                        g = this.growDC(x, b, g);
                        f[5][6] = f[5][6] + g[53] + g[54] + g[55];
                        f[5][7] = g[56];
                        f[5][8] = g[57];
                        f[5][9] = g[58];
                        f[7][10] = g[56];
                        f[8][11] = g[60];
                        f[9][12] = g[61];
                    }
                }
                i6 = 89;
                while (i6 < 110) {
                    g[i6] = 0.0;
                    ++i6;
                }
                ++season;
            }
            i6 = 0;
            while (i6 < x.length) {
                dx[i6] = f[i6][i6];
                ++i6;
            }
            i6 = 0;
            while (i6 < x.length - 1) {
                int j = i6 + 1;
                while (j < x.length) {
                    double part = f[j][i6] - f[i6][j];
                    dx[i6] = dx[i6] + part;
                    dx[j] = dx[j] - part;
                    ++j;
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < x.length) {
                int j = 0;
                while (j < x.length) {
                    f[i6][j] = 0.0;
                    ++j;
                }
                ++i6;
            }
            DailyResults results = new DailyResults(x, dx, f, g);
            dailyResults.add(results);
            if (yearday % stopTime == 0) {
                cycleResults.add(new CycleResults(x, dx, f, g));
            }
            int i7 = 0;
            while (i7 < x.length) {
                x[i7] = x[i7] + dx[i7];
                ++i7;
            }
            ++yearday;
        }
        return new ForestBGCResults(this.name, new Date(System.currentTimeMillis()), this, dailyResults, cycleResults);
    }

    private final Double[] climateDC(int yearday, Double[] x, Double[] b) throws Exception {
        Double xTMax = this.climateDataManager.getData(0, yearday);
        Double xTMin = this.climateDataManager.getData(1, yearday);
        Double dewPT = this.climateDataManager.getData(2, yearday);
        Double xRad = this.climateDataManager.getData(3, yearday);
        Double xPPT = this.climateDataManager.getData(4, yearday);
        Double[] z = new Double[21];
        z[0] = 86.0;
        z[1] = new Double(yearday);
        z[2] = xPPT / 1000.0;
        z[3] = xTMax;
        z[4] = xTMin;
        Double tave = (z[3] + z[4]) / 2.0;
        z[5] = 6.1078 * Math.exp(17.269 * dewPT / (237.3 + dewPT)) / (6.1078 * Math.exp(17.269 * tave / (237.3 + tave))) * 100.0;
        z[7] = xRad * b[7];
        z[9] = b[0] * x[7] / b[4];
        z[6] = x[0] > 0.0 ? Double.valueOf(0.0) : tave;
        z[13] = 0.212 * (z[3] - tave) + tave;
        z[14] = (z[13] + z[4]) / 2.0;
        double esd = 6.1078 * Math.exp(17.269 * z[13] / (237.3 + z[13]));
        double es = z[5] / 100.0 * esd;
        z[15] = Math.max(esd - es, 0.0);
        z[16] = 2.17E-4 * z[15] / (z[13] + 273.16);
        int xd = yearday - 79;
        if (xd < 0) {
            xd = 286 + yearday;
        }
        double ampl = Math.exp(7.42 + 0.045 * b[6]) / 3600.0;
        double day = ampl * Math.sin((double)xd * 0.01721) + 12.0;
        z[17] = day * 3600.0 * 0.85;
        z[18] = z[9] < 1.0 ? z[7] : Double.valueOf(z[7] * (1.0 - Math.exp(z[9] / 2.2 * b[1])) / (-b[1].doubleValue() * z[9] / 2.2));
        z[20] = b[25];
        return z;
    }

    private final Double[] climateBGC(int yearday, Double[] x, Double[] b) throws Exception {
        Double xTMax = this.climateDataManager.getData(0, yearday);
        Double xTMin = this.climateDataManager.getData(1, yearday);
        Double dewPT = this.climateDataManager.getData(2, yearday);
        Double xRad = this.climateDataManager.getData(3, yearday);
        Double xPPT = this.climateDataManager.getData(4, yearday);
        Double[] z = new Double[21];
        z[0] = 1987.0;
        z[1] = new Double(yearday);
        z[2] = xPPT / 1000.0;
        z[3] = xTMax;
        z[4] = xTMin;
        Double tave = (z[3] + z[4]) / 2.0;
        z[5] = dewPT;
        z[7] = xRad * b[7];
        z[9] = b[0] * x[7] / b[4];
        if (z[1] < b[35] || z[1] > b[36]) {
            z[9] = 0.1;
        }
        z[6] = x[0] > 0.0 ? Double.valueOf(0.0) : tave;
        z[13] = 0.212 * (z[3] - tave) + tave;
        z[14] = (z[13] + z[4]) / 2.0;
        double esd = 6.1078 * Math.exp(17.269 * z[13] / (237.3 + z[13]));
        double es = z[5] / 100.0 * esd;
        z[15] = Math.max(esd - es, 0.0);
        z[16] = 2.17E-4 * z[15] / (z[13] + 273.16);
        int xd = yearday - 79;
        if (xd < 0) {
            xd = 286 + yearday;
        }
        double ampl = Math.exp(7.42 + 0.045 * b[6]) / 3600.0;
        double day = ampl * Math.sin((double)xd * 0.01721) + 12.0;
        z[17] = day * 3600.0 * 0.85;
        z[18] = z[9] < 1.0 ? z[7] : Double.valueOf(z[7] * (1.0 - Math.exp(z[9] / 2.2 * b[1])) / (-b[1].doubleValue() * z[9] / 2.2));
        z[19] = b[32];
        double maxla = b[30] * b[4] / b[0];
        double nnmax = x[14] / (maxla * b[25]);
        z[20] = (b[25] - b[26]) * nnmax + b[26];
        return z;
    }

    private Double[] h2oDC(Double[] x, Double[] b, Double[] z, Double[] g) {
        Double[] dg = (Double[])g.clone();
        if (z[14] > 0.0) {
            dg[0] = (z[2] - z[9] * b[3]) * b[4];
            if (dg[0] < 0.0) {
                dg[0] = 0.0;
            }
            dg[1] = 0.0;
        } else {
            dg[1] = z[2] * b[4];
            if (dg[1] < 0.0) {
                dg[1] = 0.0;
            }
            dg[0] = 0.0;
        }
        dg[2] = Math.max(b[5] * z[13] * b[4], 0.0);
        if (x[0] - dg[2] < 0.0) {
            dg[2] = x[0];
        }
        dg[3] = z[2] * b[4] - dg[0] - dg[1];
        dg[4] = z[7] / 2500000.0 * b[4];
        if (dg[3] < 0.0) {
            dg[3] = 0.0;
        }
        if (dg[3] > dg[4]) {
            dg[5] = dg[3] - dg[4];
            dg[3] = dg[4];
        } else {
            dg[5] = 0.0;
        }
        dg[9] = Math.max(0.2 / (x[1] / b[2]), b[8]);
        if (z[6] == 0.0) {
            dg[9] = dg[9] * 2.0;
        }
        dg[10] = Math.max(b[10] - b[10] / (b[11] - b[8]) * (dg[9] - b[8]), 5.0E-5);
        dg[11] = z[4] < 0.0 ? Double.valueOf(Math.max(dg[10] + 2.0E-4 * z[4], 5.0E-5)) : Double.valueOf(dg[10] + dg[10] * 3.0E-5 * (z[13] - 10.0));
        dg[12] = Math.max(dg[11] - dg[11] * b[12] * (z[16] * 1000000.0 - 4.0), 5.0E-5);
        dg[13] = Math.min(1.0 / b[9] * z[18], 1.0);
        if (dg[13] == 0.0) {
            dg[13] = 1.0E-8;
        }
        dg[14] = dg[13] * dg[12];
        dg[15] = this.penmon(z, dg[14]);
        dg[16] = dg[15] * z[9] * b[4] * z[17];
        dg[17] = Math.max(x[1] + dg[0] + dg[2] + dg[5] - b[2], 0.0);
        dg[18] = 67.0 * z[20];
        dg[19] = (z[18] - b[13]) / (z[18] + b[14]);
        dg[20] = Math.max(b[22] * (b[17] - z[13]) * (z[13] - b[16]) / Math.pow(b[17] - b[16], 2.0), 0.0);
        dg[21] = b[15] * dg[18] * dg[19] * dg[20];
        dg[22] = 5.3E-4 * (dg[14] / 1.6) * dg[21] / (dg[14] / 1.6 + dg[21]);
        dg[23] = dg[22] * z[17] * z[9] * b[4];
        dg[24] = Math.max(b[18] * Math.exp(b[24] * z[14]) * (24.0 - z[17] / 3600.0) * x[7], 0.0);
        dg[95] = dg[95] + dg[24];
        dg[25] = (dg[23] - dg[24]) * 0.3;
        dg[29] = Math.max(b[19] * Math.exp(b[24] * z[6]) * Math.exp(0.67 * Math.log(x[8])), 0.0);
        dg[30] = Math.max(b[20] * Math.exp(b[24] * z[6]) * x[9], 0.0);
        dg[96] = dg[96] + dg[29];
        dg[97] = dg[97] + dg[30];
        dg[99] = dg[99] + dg[29] + dg[30];
        return dg;
    }

    private Double[] h2oBGC(Double[] x, Double[] b, Double[] z, Double[] g) {
        Double[] dg = (Double[])g.clone();
        if (z[14] > 0.0) {
            dg[0] = (z[2] - z[9] * b[3]) * b[4];
            if (dg[0] < 0.0) {
                dg[0] = 0.0;
            }
            dg[1] = 0.0;
        } else {
            dg[1] = z[2] * b[4];
            if (dg[1] < 0.0) {
                dg[1] = 0.0;
            }
            dg[0] = 0.0;
        }
        dg[2] = Math.max(b[5] * z[13] * b[4], 0.0);
        if (x[0] - dg[2] < 0.0) {
            dg[2] = x[0];
        }
        dg[3] = z[2] * b[4] - dg[0] - dg[1];
        dg[4] = z[7] / 2500000.0 * b[4];
        if (dg[3] < 0.0) {
            dg[3] = 0.0;
        }
        if (dg[3] > dg[4]) {
            dg[5] = dg[3] - dg[4];
            dg[3] = dg[4];
        } else {
            dg[5] = 0.0;
        }
        dg[6] = x[1] / b[2];
        dg[7] = dg[6] * b[28];
        dg[89] = dg[89] + dg[6];
        dg[9] = Math.max(0.2 / dg[6], b[8]);
        if (z[6] == 0.0) {
            dg[9] = dg[9] * 2.0;
        }
        dg[90] = Math.max(dg[90], dg[9]);
        dg[10] = Math.max(b[10] - b[10] / (b[11] - b[8]) * (dg[9] - b[8]), 5.0E-5);
        dg[11] = z[4] < 0.0 ? Double.valueOf(Math.max(dg[10] + 2.0E-4 * z[4], 5.0E-5)) : Double.valueOf(dg[10] + dg[10] * 3.0E-5 * (z[13] - 10.0));
        dg[12] = Math.max(dg[11] - dg[11] * b[12] * (z[16] * 1000000.0 - 4.0), 5.0E-5);
        dg[13] = Math.min(1.0 / b[9] * z[18], 1.0);
        if (dg[13] == 0.0) {
            dg[13] = 1.0E-8;
        }
        dg[14] = dg[13] * dg[12];
        dg[15] = this.penmon(z, dg[14]);
        dg[16] = dg[15] * z[9] * b[4] * z[17];
        dg[17] = Math.max(x[1] + dg[0] + dg[2] + dg[5] - b[2], 0.0);
        dg[18] = 18.2 * z[20] + 0.5;
        dg[19] = (z[18] - b[13]) / (z[18] + b[14]);
        dg[20] = Math.max(b[22] * (b[17] - z[13]) * (z[13] - b[16]) / Math.pow(b[17] - b[16], 2.0), 0.0);
        dg[21] = b[15] * dg[18] * dg[19] * dg[20];
        dg[22] = 5.3E-4 * (dg[14] / 1.6) * dg[21] / (dg[14] / 1.6 + dg[21]);
        dg[23] = dg[22] * z[17] * z[9] * b[4];
        dg[24] = Math.max(b[18] * Math.exp(b[24] * z[14]) * (24.0 - z[17] / 3600.0) * x[7], 0.0);
        dg[95] = dg[95] + dg[24];
        dg[25] = (dg[23] - dg[24]) * 0.3;
        dg[29] = Math.max(b[19] * Math.exp(b[24] * z[6]) * Math.exp(0.67 * Math.log(x[8])), 0.0);
        dg[30] = Math.max(b[20] * Math.exp(b[24] * z[6]) * x[9], 0.0);
        dg[100] = (dg[7] + z[6] / b[45]) / 2.0 * b[47];
        dg[101] = x[10] * dg[100] / 365.0;
        dg[102] = dg[100] * b[46];
        dg[103] = x[12] * dg[102] / 365.0;
        dg[104] = dg[101] + dg[104];
        dg[105] = dg[103] + dg[105];
        dg[91] = dg[91] + z[6];
        dg[99] = dg[99] + dg[29] + dg[30];
        dg[109] = dg[109] + dg[101] + dg[103];
        return dg;
    }

    private Double[] growBGC(Double[] x, Double[] b, Double[] g) {
        Double[] dg = (Double[])g.clone();
        double psn = Math.max(x[5], 0.0);
        dg[39] = b[30] * b[4] / b[0];
        dg[49] = dg[89] / 365.0;
        dg[89] = 0.0;
        dg[50] = Math.min(x[13] / (dg[39] * b[25]) * b[34], 1.0);
        dg[51] = (dg[49] + dg[50]) / 4.0;
        dg[40] = Math.min(x[13] * dg[51] * 2.0 / (dg[39] * b[25]), 1.0);
        dg[41] = (b[25] - b[26]) * dg[40] + b[26];
        dg[42] = b[27];
        dg[43] = b[31];
        dg[52] = Math.max(psn * dg[51] * (1.0 - b[42]), 0.0);
        dg[53] = 1.0 / dg[41] * x[13] * dg[51];
        dg[54] = b[11] / dg[90] * (x[7] / dg[43] * (1.0 + b[42] / (1.0 - b[42])));
        dg[90] = 0.0;
        dg[55] = Math.min(dg[54], Math.min(dg[53], dg[52]));
        dg[56] = psn > 0.0 ? Double.valueOf(dg[55] / psn) : Double.valueOf(Math.min(x[7] / dg[43] / psn, 0.0));
        dg[57] = Math.min(dg[56] * (1.0 / dg[51]), 1.0 - dg[56]);
        dg[58] = 1.0 - dg[56] - dg[57];
        dg[59] = psn * dg[56];
        dg[60] = psn * dg[58];
        dg[61] = psn * dg[57];
        dg[62] = dg[59] * b[42];
        dg[63] = dg[60] * b[43];
        dg[64] = dg[61] * b[44];
        dg[65] = dg[62] + dg[63] + dg[64];
        dg[66] = dg[59] - dg[62];
        dg[67] = dg[60] - dg[63];
        dg[68] = dg[61] - dg[64];
        dg[69] = dg[66] * dg[41];
        dg[70] = dg[67] * dg[41] * 0.05;
        dg[71] = dg[68] * dg[41] * 0.5;
        dg[72] = x[14] / dg[43] * dg[42];
        dg[79] = dg[104] / x[10] * b[29];
        dg[80] = dg[105] / x[12] * b[29];
        dg[93] = x[17] * dg[79];
        dg[94] = x[18] * dg[80];
        dg[91] = 0.0;
        return dg;
    }

    private Double[] growDC(Double[] x, Double[] b, Double[] g) {
        Double[] dg = (Double[])g.clone();
        dg[49] = b[29];
        dg[50] = b[30];
        dg[51] = b[31];
        double tpsn = x[5];
        double lpsn = tpsn * dg[49];
        double spsn = tpsn * dg[50];
        double rpsn = tpsn * dg[51];
        dg[53] = lpsn * b[42];
        dg[54] = spsn * b[43];
        dg[55] = rpsn * b[44];
        dg[56] = lpsn - dg[53];
        dg[57] = spsn - dg[54];
        dg[58] = rpsn - dg[55];
        double plig = 10.0;
        double aet = (x[3] + x[4]) / b[4] * 1000.0;
        dg[79] = (-3.44 + 0.1 * aet - (0.0134 + 0.00147 * aet * plig)) / 100.0;
        dg[59] = dg[56] * b[39];
        dg[60] = dg[57] * b[40];
        dg[61] = dg[58] * b[41];
        return dg;
    }

    private double penmon(Double[] z, Double dg14) {
        double rad = z[18] * 1000.0 / z[17];
        double gamma = 0.646 + 6.0E-4 * z[13];
        double t1 = z[13] + 0.5;
        double t2 = z[13] - 0.5;
        double svp1 = 6.1078 * Math.exp(17.269 * t1 / (237.0 + t1));
        double svp2 = 6.1078 * Math.exp(17.269 * t2 / (237.0 + t2));
        double slope = svp1 - svp2;
        double cp = 1010.0;
        double pa = 1.292 - 0.00428 * z[13];
        double ra = 5.0 / (z[9] / 2.0);
        double rs = 1.0 / dg14;
        double xlat = (2.501 - 0.0024 * z[13]) * 1000000.0;
        double xtrans = (slope * rad + cp * pa * (z[15] / ra)) / (slope + gamma * (1.0 + rs / ra));
        return xtrans / (xlat * 1000.0);
    }

    @Override
    public String getCopyright() {
        return "Copyright 2009 M.A. Veganzones. Copyright 1988 J.C. Coughlan.";
    }
}

