/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.LaiDataManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h4.H4File;
import ncsa.hdf.object.h4.H4SDS;
import ncsa.hdf.object.h5.H5File;
import ncsa.hdf.object.h5.H5ScalarDS;

public class Mod15DataLaiManager
implements LaiDataManager {
    private byte[] lai = null;
    private long[] dims;
    private double scaleFactor = 0.1;

    public Mod15DataLaiManager(File file) throws Exception {
        FileFormat fileFormat = null;
        boolean h4 = true;
        try {
            fileFormat = H4File.getInstance(file.getAbsolutePath());
        }
        catch (Exception e1) {
            try {
                h4 = false;
                fileFormat = H5File.getInstance(file.getAbsolutePath());
            }
            catch (Exception e2) {
                throw new Exception("Cannot load MOD-15 file: " + file.getAbsolutePath());
            }
        }
        if (fileFormat == null) {
            throw new Exception("Cannot load MOD-15 file: " + file.getAbsolutePath());
        }
        fileFormat.open();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)fileFormat.getRootNode();
        if (root == null) {
            throw new Exception("Cannot load MOD-15 file: " + file.getAbsolutePath());
        }
        Group group = (Group)((Group)root.getUserObject()).getMemberList().get(0);
        ListIterator groupIt = group.getMemberList().listIterator();
        block4: while (groupIt.hasNext()) {
            Group member = (Group)groupIt.next();
            if (!member.getName().equalsIgnoreCase("data fields")) continue;
            ListIterator memberIt = member.getMemberList().listIterator();
            while (memberIt.hasNext()) {
                Dataset dataset = (Dataset)memberIt.next();
                if (!dataset.getName().equalsIgnoreCase("Lai_1km")) continue;
                this.lai = h4 ? (byte[])((H4SDS)dataset).getData() : (byte[])((H5ScalarDS)dataset).getData();
                this.dims = dataset.getDims();
                break block4;
            }
            break block4;
        }
        fileFormat.close();
    }

    @Override
    public int getNumData() throws Exception {
        if (this.lai == null) {
            throw new Exception("No data available.");
        }
        return this.lai.length;
    }

    @Override
    public Iterator<LaiDataManager.CoordinatedLai> laiIterator() throws Exception {
        if (this.lai == null) {
            throw new Exception("No data available.");
        }
        return new Mod15Iterator();
    }

    @Override
    public Image getLaiImage() throws Exception {
        int[] pixels = new int[this.lai.length];
        int i = 0;
        while (i < this.lai.length) {
            int c = 0xFF & this.lai[i];
            pixels[i] = 0xFF000000 | c << 16 | c << 8 | c;
            ++i;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource((int)this.dims[0], (int)this.dims[1], (ColorModel)this.getIndexColorModel(), pixels, 0, (int)this.dims[0]));
    }

    public Image getColorScale(int width, int height) throws Exception {
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int c = 255 * j / width;
                pixels[i * height + j] = 0xFF000000 | c << 16 | c << 8 | c;
                ++j;
            }
            ++i;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource((int)this.dims[0], (int)this.dims[1], (ColorModel)this.getIndexColorModel(), pixels, 0, (int)this.dims[0]));
    }

    public LaiDataManager.CoordinatedLai getCoordinatedLai(int index) {
        int y = index / (int)this.dims[0];
        int x = index % (int)this.dims[0];
        int laiValue = this.lai[index] & 0xFF;
        if (laiValue > 100) {
            return null;
        }
        return new LaiDataManager.CoordinatedLai(y, x, (double)laiValue * this.scaleFactor);
    }

    private IndexColorModel getIndexColorModel() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        int i = 0;
        while (i < 101) {
            r[i] = 4 * i > 255 ? (byte)0 : (byte)(255 - 4 * i);
            b[i] = 4 * (100 - i) > 255 ? (byte)0 : (byte)(255 - 4 * (100 - i));
            g[i] = i < 50 ? (6 * (50 - i) > 255 ? (byte)0 : (byte)(255 - 6 * (50 - i))) : (6 * (i - 50) > 255 ? (byte)0 : (byte)(255 - 6 * (i - 50)));
            ++i;
        }
        i = 101;
        while (i < 256) {
            r[i] = 0;
            g[i] = 0;
            b[i] = 0;
            ++i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    private final class Mod15Iterator<E>
    implements Iterator<LaiDataManager.CoordinatedLai> {
        private int index = 0;

        public Mod15Iterator() {
            this.index = 0;
        }

        public Mod15Iterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < Mod15DataLaiManager.this.lai.length;
        }

        @Override
        public LaiDataManager.CoordinatedLai next() {
            LaiDataManager.CoordinatedLai coordinatedLai = Mod15DataLaiManager.this.getCoordinatedLai(this.index);
            ++this.index;
            return coordinatedLai;
        }

        @Override
        public void remove() {
        }
    }
}

