/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.LaiDataManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SimpleLaiDataManager
implements LaiDataManager {
    private List<LaiDataManager.CoordinatedLai> data = new ArrayList<LaiDataManager.CoordinatedLai>();
    int minX;
    int minY;
    int maxX;
    int maxY;

    @Override
    public int getNumData() {
        return this.data.size();
    }

    @Override
    public Iterator<LaiDataManager.CoordinatedLai> laiIterator() {
        return this.data.iterator();
    }

    public SimpleLaiDataManager(File file) throws Exception {
        try {
            if (!file.isFile()) {
                throw new Exception("Provided file is not a file");
            }
            if (!file.canRead()) {
                throw new Exception("Provided file is not readable");
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxY = Integer.MIN_VALUE;
            while (line != null) {
                String[] s = line.split("\t");
                if (s.length != 3) {
                    s = line.split(" ");
                    if (s.length != 3) {
                        throw new Exception("Provided file data are not valid");
                    }
                } else {
                    int y = Integer.valueOf(s[0]);
                    int x = Integer.valueOf(s[1]);
                    if (y < this.minY) {
                        this.minY = y;
                    }
                    if (y > this.maxY) {
                        this.maxY = y;
                    }
                    if (x < this.minX) {
                        this.minX = x;
                    }
                    if (x > this.maxX) {
                        this.maxX = x;
                    }
                    this.data.add(new LaiDataManager.CoordinatedLai(y, x, Double.valueOf(s[2])));
                }
                line = in.readLine();
            }
            Collections.sort(this.data);
        }
        catch (Exception e) {
            throw new Exception("Exception ocurred: " + e.getMessage());
        }
    }

    @Override
    public Image getLaiImage() throws Exception {
        int[] pixels = new int[(this.maxX - this.minX) * (this.maxY - this.minY)];
        ListIterator<LaiDataManager.CoordinatedLai> it = this.data.listIterator();
        int x = 0;
        int y = 0;
        while (it.hasNext()) {
            LaiDataManager.CoordinatedLai clai = it.next();
            int i = y;
            while (i < clai.getY() - this.minY) {
                int j = 0;
                while (j < this.maxX - this.minX) {
                    pixels[i * (this.maxX - this.minX) + j] = 0;
                    ++j;
                }
                ++y;
                ++i;
            }
            i = x;
            while (i < clai.getX() - this.minX) {
                pixels[y * (this.maxX - this.minX) + i] = 0;
                ++x;
                ++i;
            }
            int c = 0xFF & clai.getLai().byteValue();
            pixels[y * (this.maxX - this.minX) + x] = 0xFF000000 | c << 16 | c << 8 | c;
            if (++x != this.maxX - this.minX) continue;
            x = 0;
            ++y;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.maxX - this.minX, this.maxY - this.minY, pixels, 0, this.maxX - this.minX));
    }
}

