/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.outputs;

import es.ehu.www.ccwintco.npp.core.forestbgc.CycleResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.DailyResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.GlobalForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.outputs.ForestBGCOutputManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ListIterator;

public final class Simlat5ForestBGCOutputManager
extends ForestBGCOutputManager {
    private static final Simlat5ForestBGCOutputManager instance = new Simlat5ForestBGCOutputManager();

    public static final Simlat5ForestBGCOutputManager getInstance() {
        return instance;
    }

    private Simlat5ForestBGCOutputManager() {
    }

    @Override
    public void report(ForestBGCResults results, int report, File file) throws Exception {
        if (!(file != null && file.exists() && file.isFile() && file.canWrite())) {
            throw new Exception("File " + file.getAbsolutePath() + " is not valid");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            if (results == null) {
                throw new Exception("Null results found");
            }
            DecimalFormat formatter = new DecimalFormat("#.#");
            List<Integer> xAdditional = this.getStateVariablesReported();
            List<Integer> gAdditional = this.getGVariablesReported();
            writer.append("Simulation: " + results.getSimulationName() + "\n");
            writer.append("Date: " + results.getSimulationDate().toString() + "\n\n");
            writer.append(String.valueOf(results.getEstimator().getVersion()) + "\n");
            writer.append(String.valueOf(results.getEstimator().getCopyright()) + "\n\n");
            writer.append("---------------------------------------------------------\n\n");
            switch (report) {
                case 0: {
                    int value;
                    ListIterator<Integer> it;
                    writer.append("\tX4\t");
                    writer.append("X6\t");
                    writer.append("X8\t");
                    writer.append("X9\t");
                    if (xAdditional != null && !xAdditional.isEmpty()) {
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 4 || value == 6 || value == 8 || value == 9) continue;
                            writer.append("X" + value + "\t");
                        }
                    }
                    writer.append("G58\t");
                    writer.append("G59\t");
                    writer.append("G66\t");
                    writer.append("G100");
                    if (gAdditional != null && !gAdditional.isEmpty()) {
                        writer.append("\t");
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 58 || value == 59 || value == 66 || value == 100) continue;
                            writer.append("G" + value + "\t");
                        }
                    }
                    writer.append("\n");
                    writer.append("Season\t");
                    writer.append("Trans.\t");
                    writer.append("PSN\t");
                    writer.append("Leaf C\t");
                    writer.append("Stem C\t");
                    if (xAdditional != null && !xAdditional.isEmpty()) {
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 4 || value == 6 || value == 8 || value == 9) continue;
                            writer.append("\t");
                        }
                    }
                    writer.append("S_grw\t");
                    writer.append("R_grw\t");
                    writer.append("g_rsp\t");
                    writer.append("m_rsp\t");
                    if (gAdditional != null && !gAdditional.isEmpty()) {
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 58 || value == 59 || value == 66 || value == 100) continue;
                            writer.append("\t");
                        }
                    }
                    writer.append("NPP\t");
                    writer.append("C Fix\n");
                    ListIterator<CycleResults> cycleIt = results.getCycleResultsIterator();
                    int season = 0;
                    while (cycleIt.hasNext()) {
                        CycleResults cycle = cycleIt.next();
                        if (cycle == null) {
                            throw new Exception("Null results found");
                        }
                        writer.append(String.valueOf(++season) + "\t");
                        Double[] x = cycle.getX();
                        writer.append(String.valueOf(formatter.format(x[3])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[5])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[7])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[8])) + "\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            ListIterator<Integer> it2 = xAdditional.listIterator();
                            while (it2.hasNext()) {
                                int value2 = it2.next();
                                if (value2 == 4 || value2 == 6 || value2 == 8 || value2 == 9) continue;
                                writer.append(String.valueOf(formatter.format(x[value2 - 1])) + "\t");
                            }
                        }
                        Double[] g = cycle.getG();
                        writer.append(String.valueOf(formatter.format(g[57])) + "\t");
                        writer.append(String.valueOf(formatter.format(g[58])) + "\t");
                        writer.append(String.valueOf(formatter.format(g[65])) + "\t");
                        writer.append(String.valueOf(formatter.format(g[99])) + "\t");
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            ListIterator<Integer> it3 = xAdditional.listIterator();
                            while (it3.hasNext()) {
                                int value3 = it3.next();
                                if (value3 == 58 || value3 == 59 || value3 == 66 || value3 == 100) continue;
                                writer.append(String.valueOf(formatter.format(g[value3 - 1])) + "\t");
                            }
                        }
                        writer.append(String.valueOf(formatter.format(cycle.getNpp())) + "\t");
                        writer.append(String.valueOf(formatter.format(cycle.getCarbonFixation(this.getCarbonFixationRatio()))) + "\t");
                    }
                    break;
                }
                case 2: {
                    int value;
                    ListIterator<Integer> it;
                    writer.append("\tX1\t");
                    writer.append("X2\t");
                    writer.append("X3\t");
                    writer.append("X4\t");
                    writer.append("X5\t");
                    writer.append("X6\t");
                    if (xAdditional != null && !xAdditional.isEmpty()) {
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 1 || value == 2 || value == 3 || value == 4 || value == 5 || value == 6) continue;
                            writer.append("X" + value + "\t");
                        }
                    }
                    writer.append("G100");
                    if (gAdditional != null && !gAdditional.isEmpty()) {
                        writer.append("\t");
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 100) continue;
                            writer.append("G" + value + "\t");
                        }
                    }
                    writer.append("\n");
                    writer.append("Day\t");
                    writer.append("Snow\t");
                    writer.append("Soil\t");
                    writer.append("Outflow\t");
                    writer.append("Trans.\t");
                    writer.append("Evapor.\t");
                    writer.append("PSN\t");
                    if (xAdditional != null && !xAdditional.isEmpty()) {
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 1 || value == 2 || value == 3 || value == 4 || value == 5 || value == 6) continue;
                            writer.append("\t");
                        }
                    }
                    writer.append("m_rsp");
                    if (gAdditional != null && !gAdditional.isEmpty()) {
                        writer.append("\t");
                        it = xAdditional.listIterator();
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == 100) continue;
                            writer.append("\t");
                        }
                    }
                    writer.append("\n");
                    ListIterator<DailyResults> dailyIt = results.getDailyResultsIterator();
                    int day = 0;
                    while (dailyIt.hasNext()) {
                        DailyResults daily = dailyIt.next();
                        if (daily == null) {
                            throw new Exception("Null results found");
                        }
                        writer.append(String.valueOf(++day) + "\t");
                        Double[] x = daily.getX();
                        writer.append(String.valueOf(formatter.format(x[0])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[1])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[2])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[3])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[4])) + "\t");
                        writer.append(String.valueOf(formatter.format(x[5])) + "\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            ListIterator<Integer> it4 = xAdditional.listIterator();
                            while (it4.hasNext()) {
                                int value4 = it4.next();
                                if (value4 == 1 || value4 == 2 || value4 == 3 || value4 == 4 || value4 == 5 || value4 == 6) continue;
                                writer.append(String.valueOf(formatter.format(x[value4 - 1])) + "\t");
                            }
                        }
                        Double[] g = daily.getG();
                        writer.append(formatter.format(g[99]));
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            writer.append("\t");
                            ListIterator<Integer> it5 = xAdditional.listIterator();
                            while (it5.hasNext()) {
                                int value5 = it5.next();
                                if (value5 == 100) continue;
                                writer.append(String.valueOf(formatter.format(g[value5 - 1])) + "\t");
                            }
                        }
                        writer.append("\n");
                    }
                    break;
                }
                case 1: {
                    ListIterator<DailyResults> dailyIt = results.getDailyResultsIterator();
                    int day = 0;
                    while (dailyIt.hasNext()) {
                        DailyResults daily = dailyIt.next();
                        if (daily == null) {
                            throw new Exception("Null results found");
                        }
                        writer.append("Day " + ++day + "\n\n");
                        writer.append("State variables:\n");
                        Double[] x = daily.getX();
                        int i = 0;
                        while (i < x.length) {
                            writer.append("X[" + (i + 1) + "]: " + formatter.format(x[i]) + "\t");
                            if (i % 10 == 9) {
                                writer.append("\n");
                            }
                            ++i;
                        }
                        writer.append("\n");
                        writer.append("G variables:\n");
                        Double[] g = daily.getG();
                        int i2 = 0;
                        while (i2 < g.length) {
                            writer.append("G[" + (i2 + 1) + "]: " + formatter.format(g[i2]) + "\t");
                            if (i2 % 10 == 9) {
                                writer.append("\n");
                            }
                            ++i2;
                        }
                        writer.append("\n");
                        writer.append("State change variables:\n");
                        Double[] dx = daily.getDx();
                        int i3 = 0;
                        while (i3 < dx.length) {
                            writer.append("dx[" + (i3 + 1) + "]: " + formatter.format(dx[i3]) + "\t");
                            if (i3 % 10 == 9) {
                                writer.append("\n");
                            }
                            ++i3;
                        }
                        writer.append("\n");
                        writer.append("Flux variables:\n");
                        Double[][] f = daily.getF();
                        int i4 = 0;
                        while (i4 < dx.length) {
                            int j = 0;
                            while (j < f[i4].length) {
                                writer.append("f[" + (i4 + 1) + "][" + (j + 1) + "]: " + formatter.format(f[i4][j]) + "\t");
                                ++j;
                            }
                            writer.append("\n");
                            ++i4;
                        }
                        writer.append("\n\n");
                    }
                    break;
                }
                default: {
                    writer.close();
                    throw new Exception("Kind of report not valid: " + report);
                }
            }
            writer.close();
        }
        catch (Exception e) {
            writer.close();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void report(GlobalForestBGCResults results, int report, File file) throws Exception {
        if (!(file != null && file.exists() && file.isFile() && file.canWrite())) {
            throw new Exception("File " + file.getAbsolutePath() + " is not valid");
        }
        writer = new BufferedWriter(new FileWriter(file));
        try {
            point = 0;
            formatter = new DecimalFormat("#.#");
            xAdditional = this.getStateVariablesReported();
            gAdditional = this.getGVariablesReported();
            resultsIt = results.getResultsIterator();
            writer.append("Simulation: " + results.getSimulationName() + "\n");
            writer.append("Date: " + results.getSimulationDate().toString() + "\n\n");
            writer.append(String.valueOf(results.getEstimator().getVersion()) + "\n");
            writer.append(String.valueOf(results.getEstimator().getCopyright()) + "\n\n");
            writer.append("---------------------------------------------------------\n\n");
            if (resultsIt != null && resultsIt.hasNext()) ** GOTO lbl344
            throw new Exception("Null results found");
lbl-1000:
            // 1 sources

            {
                pointResults = resultsIt.next();
                writer.append("Point " + ++point + ":\n\n");
                switch (report) {
                    case 0: {
                        cycleIt = pointResults.getCycleResultsIterator();
                        writer.append("\tX4\t");
                        writer.append("X6\t");
                        writer.append("X8\t");
                        writer.append("X9\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 4 || value == 6 || value == 8 || value == 9) continue;
                                writer.append("X" + value + "\t");
                            }
                        }
                        writer.append("G58\t");
                        writer.append("G59\t");
                        writer.append("G66\t");
                        writer.append("G100");
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            writer.append("\t");
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 58 || value == 59 || value == 66 || value == 100) continue;
                                writer.append("G" + value + "\t");
                            }
                        }
                        writer.append("\n");
                        writer.append("Season\t");
                        writer.append("Trans.\t");
                        writer.append("PSN\t");
                        writer.append("Leaf C\t");
                        writer.append("Stem C\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 4 || value == 6 || value == 8 || value == 9) continue;
                                writer.append("\t");
                            }
                        }
                        writer.append("S_grw\t");
                        writer.append("R_grw\t");
                        writer.append("g_rsp\t");
                        writer.append("m_rsp\t");
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 58 || value == 59 || value == 66 || value == 100) continue;
                                writer.append("\t");
                            }
                        }
                        writer.append("NPP\t");
                        writer.append("C Fix\n");
                        cycleIt = pointResults.getCycleResultsIterator();
                        season = 0;
                        while (cycleIt.hasNext()) {
                            cycle = cycleIt.next();
                            if (cycle == null) {
                                throw new Exception("Null results found");
                            }
                            writer.append(String.valueOf(++season) + "\t");
                            x = cycle.getX();
                            writer.append(String.valueOf(formatter.format(x[3])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[5])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[7])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[8])) + "\t");
                            if (xAdditional != null && !xAdditional.isEmpty()) {
                                it = xAdditional.listIterator();
                                while (it.hasNext()) {
                                    value = it.next();
                                    if (value == 4 || value == 6 || value == 8 || value == 9) continue;
                                    writer.append(String.valueOf(formatter.format(x[value - 1])) + "\t");
                                }
                            }
                            g = cycle.getG();
                            writer.append(String.valueOf(formatter.format(g[57])) + "\t");
                            writer.append(String.valueOf(formatter.format(g[58])) + "\t");
                            writer.append(String.valueOf(formatter.format(g[65])) + "\t");
                            writer.append(String.valueOf(formatter.format(g[99])) + "\t");
                            if (gAdditional != null && !gAdditional.isEmpty()) {
                                it = xAdditional.listIterator();
                                while (it.hasNext()) {
                                    value = it.next();
                                    if (value == 58 || value == 59 || value == 66 || value == 100) continue;
                                    writer.append(String.valueOf(formatter.format(g[value - 1])) + "\t");
                                }
                            }
                            writer.append(String.valueOf(formatter.format(cycle.getNpp())) + "\t");
                            writer.append(String.valueOf(formatter.format(cycle.getCarbonFixation(this.getCarbonFixationRatio()))) + "\t");
                            writer.append("\n\n");
                        }
                        break;
                    }
                    case 2: {
                        writer.append("\tX1\t");
                        writer.append("X2\t");
                        writer.append("X3\t");
                        writer.append("X4\t");
                        writer.append("X5\t");
                        writer.append("X6\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 1 || value == 2 || value == 3 || value == 4 || value == 5 || value == 6) continue;
                                writer.append("X" + value + "\t");
                            }
                        }
                        writer.append("G100");
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            writer.append("\t");
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 100) continue;
                                writer.append("G" + value + "\t");
                            }
                        }
                        writer.append("\n");
                        writer.append("Day\t");
                        writer.append("Snow\t");
                        writer.append("Soil\t");
                        writer.append("Outflow\t");
                        writer.append("Trans.\t");
                        writer.append("Evapor.\t");
                        writer.append("PSN\t");
                        if (xAdditional != null && !xAdditional.isEmpty()) {
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 1 || value == 2 || value == 3 || value == 4 || value == 5 || value == 6) continue;
                                writer.append("\t");
                            }
                        }
                        writer.append("m_rsp");
                        if (gAdditional != null && !gAdditional.isEmpty()) {
                            writer.append("\t");
                            it = xAdditional.listIterator();
                            while (it.hasNext()) {
                                value = it.next();
                                if (value == 100) continue;
                                writer.append("\t");
                            }
                        }
                        writer.append("\n");
                        dailyIt = pointResults.getDailyResultsIterator();
                        day = 0;
                        while (dailyIt.hasNext()) {
                            daily = dailyIt.next();
                            if (daily == null) {
                                throw new Exception("Null results found");
                            }
                            writer.append(String.valueOf(++day) + "\t");
                            x = daily.getX();
                            writer.append(String.valueOf(formatter.format(x[0])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[1])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[2])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[3])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[4])) + "\t");
                            writer.append(String.valueOf(formatter.format(x[5])) + "\t");
                            if (xAdditional != null && !xAdditional.isEmpty()) {
                                it = xAdditional.listIterator();
                                while (it.hasNext()) {
                                    value = it.next();
                                    if (value == 1 || value == 2 || value == 3 || value == 4 || value == 5 || value == 6) continue;
                                    writer.append(String.valueOf(formatter.format(x[value - 1])) + "\t");
                                }
                            }
                            g = daily.getG();
                            writer.append(formatter.format(g[99]));
                            if (gAdditional != null && !gAdditional.isEmpty()) {
                                writer.append("\t");
                                it = xAdditional.listIterator();
                                while (it.hasNext()) {
                                    value = it.next();
                                    if (value == 100) continue;
                                    writer.append(String.valueOf(formatter.format(g[value - 1])) + "\t");
                                }
                            }
                            writer.append("\n");
                        }
                        break;
                    }
                    case 1: {
                        dailyIt = pointResults.getDailyResultsIterator();
                        day = 0;
                        while (dailyIt.hasNext()) {
                            daily = dailyIt.next();
                            if (daily == null) {
                                throw new Exception("Null results found");
                            }
                            writer.append("Day " + ++day + "\n\n");
                            writer.append("State variables:\n");
                            x = daily.getX();
                            i = 0;
                            while (i < x.length) {
                                writer.append("X[" + (i + 1) + "]: " + formatter.format(x[i]) + "\t");
                                if (i % 10 == 9) {
                                    writer.append("\n");
                                }
                                ++i;
                            }
                            writer.append("\n");
                            writer.append("G variables:\n");
                            g = daily.getG();
                            i = 0;
                            while (i < g.length) {
                                writer.append("G[" + (i + 1) + "]: " + formatter.format(g[i]) + "\t");
                                if (i % 10 == 9) {
                                    writer.append("\n");
                                }
                                ++i;
                            }
                            writer.append("\n");
                            writer.append("State change variables:\n");
                            dx = daily.getDx();
                            i = 0;
                            while (i < dx.length) {
                                writer.append("dx[" + (i + 1) + "]: " + formatter.format(dx[i]) + "\t");
                                if (i % 10 == 9) {
                                    writer.append("\n");
                                }
                                ++i;
                            }
                            writer.append("\n");
                            writer.append("Flux variables:\n");
                            f = daily.getF();
                            i = 0;
                            while (i < dx.length) {
                                j = 0;
                                while (j < f[i].length) {
                                    writer.append("f[" + (i + 1) + "][" + (j + 1) + "]: " + formatter.format(f[i][j]) + "\t");
                                    ++j;
                                }
                                writer.append("\n");
                                ++i;
                            }
                            writer.append("\n\n");
                        }
                        break;
                    }
                    default: {
                        writer.close();
                        throw new Exception("Kind of report not valid: " + report);
                    }
                }
                writer.append("---------------------------------------------------------\n\n");
lbl344:
                // 2 sources

                ** while (resultsIt.hasNext())
            }
lbl345:
            // 1 sources

            writer.close();
        }
        catch (Exception e) {
            writer.close();
            throw e;
        }
    }
}

