/*
 * Decompiled with CFR 0.152.
 */
package es.ehu.www.ccwintco.npp.gui;

import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGC;
import es.ehu.www.ccwintco.npp.core.forestbgc.ForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.GlobalForestBGC;
import es.ehu.www.ccwintco.npp.core.forestbgc.GlobalForestBGCResults;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.ClimateDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.DailyDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.LaiDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.Mod15DataLaiManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SeasonDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.Simlat5ClimateDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.Simlat5SiteDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SimpleDailyDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SimpleLaiDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SimpleSeasonDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.inputs.SiteDataManager;
import es.ehu.www.ccwintco.npp.core.forestbgc.outputs.Simlat5ForestBGCOutputManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class NppGui
extends JFrame {
    ClimateDataManager climateDataManager = null;
    SiteDataManager siteDataManager = null;
    DailyDataManager dailyDataManager = null;
    SeasonDataManager seasonDataManager = null;
    LaiDataManager laiDataManager = null;
    Properties defaultProperties = null;
    Properties userProperties = null;
    File clmFile = null;
    File datFile = null;
    File lifFile = null;
    File seaFile = null;
    File laiFile = null;
    private File outputFolder = null;
    JPanel controlPanel = null;
    JPanel dataPanel = null;
    JPanel consolePanel = null;
    JLabel clmFileLabel = null;
    JTextField clmFileTextField = null;
    JButton clmFileButton = null;
    JLabel datFileLabel = null;
    JTextField datFileTextField = null;
    JButton datFileButton = null;
    JLabel lifFileLabel = null;
    JTextField lifFileTextField = null;
    JButton lifFileButton = null;
    JLabel seaFileLabel = null;
    JTextField seaFileTextField = null;
    JButton seaFileButton = null;
    JRadioButton nolaiRadioButton = null;
    JRadioButton laiFileRadioButton = null;
    JTextField laiFileTextField = null;
    JButton laiFileButton = null;
    JCheckBox resumeOutputCheckBox = null;
    JCheckBox dailyOutputCheckBox = null;
    JCheckBox longOutputCheckBox = null;
    JCheckBox mapOutputCheckBox = null;
    JCheckBox textOutputCheckBox = null;
    JLabel folderOutputLabel = null;
    JTextField folderOutputTextField = null;
    JButton folderOutputButton = null;
    JButton optionsOutputsButton = null;
    JLabel startdayLabel = null;
    JSpinner startdaySpinner = null;
    SpinnerNumberModel startdaySpinnerModel = null;
    JLabel stopdayLabel = null;
    JSpinner stopdaySpinner = null;
    SpinnerNumberModel stopdaySpinnerModel = null;
    JLabel seasondaysLabel = null;
    JSpinner seasondaysSpinner = null;
    SpinnerNumberModel seasondaysSpinnerModel = null;
    JLabel carbonRatioLabel = null;
    JSpinner carbonRatioSpinner = null;
    SpinnerNumberModel carbonRatioSpinnerModel = null;
    JButton runButton = null;
    JButton resetButton = null;
    JProgressBar progressBar = null;
    JTabbedPane dataTabbedPane = null;
    JTextPane clmTextPane = null;
    JTextPane xTextPane = null;
    JTextPane bTextPane = null;
    JTextPane laiTextPane = null;
    JScrollPane laiScrollPane = null;
    ImagePanel mod15Pane = null;
    JScrollPane mod15ScrollPane = null;
    ImagePanel landsatPane = null;
    JTextPane dailyTextPane = null;
    JTextPane seasonallyTextPane = null;
    SimpleAttributeSet textAttrs = null;
    JTextPane consoleTextPane = null;
    SimpleAttributeSet infoAttrs = null;
    SimpleAttributeSet configAttrs = null;
    SimpleAttributeSet warningAttrs = null;
    SimpleAttributeSet severeAttrs = null;
    private static final long serialVersionUID = -2985045036743505040L;

    public static void main(String[] args) {
        NppGui nppGui = new NppGui();
        nppGui.setVisible(true);
    }

    public NppGui() throws HeadlessException {
        this.initialize();
    }

    private void initialize() {
        this.setResizable(true);
        this.setPreferredSize(new Dimension(1024, 768));
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("Forest-BGC Net Primary Production (NPP) Estimation Workplace");
        try {
            this.defaultProperties = new Properties();
            this.defaultProperties.load(new FileInputStream("bin/properties/default.props"));
            this.userProperties = new Properties();
            this.userProperties.load(new FileInputStream("bin/properties/user.props"));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.getControlPanel(), "West");
        JPanel monitorPanel = new JPanel();
        monitorPanel.setLayout(new BorderLayout(5, 5));
        monitorPanel.add((Component)this.getDataPanel(), "Center");
        monitorPanel.add((Component)this.getConsolePanel(), "South");
        this.add((Component)monitorPanel, "Center");
        this.pack();
        this.setExtendedState(6);
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            String carbonFixationStr;
            String seasonStr;
            String stopStr;
            String startStr;
            this.controlPanel = new JPanel();
            this.controlPanel.setPreferredSize(new Dimension(400, 600));
            this.controlPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 10, 2, 2, Color.black), BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Controls")));
            this.controlPanel.setLayout(new GridLayout(4, 1, 5, 5));
            JPanel fileControlPanel = new JPanel();
            fileControlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Load data from files"));
            fileControlPanel.setLayout(new GridLayout(4, 1));
            JPanel clmFileControlPanel = new JPanel();
            this.clmFileLabel = new JLabel("CLM files:");
            this.clmFileLabel.setPreferredSize(new Dimension(90, 25));
            clmFileControlPanel.add(this.clmFileLabel);
            this.clmFileTextField = new JTextField(15);
            this.clmFileTextField.setPreferredSize(new Dimension(150, 20));
            this.clmFileTextField.setEditable(false);
            clmFileControlPanel.add(this.clmFileTextField);
            this.clmFileButton = new JButton("Select ...");
            this.clmFileButton.setPreferredSize(new Dimension(85, 25));
            this.clmFileButton.setVerticalTextPosition(0);
            this.clmFileButton.setHorizontalTextPosition(10);
            this.clmFileButton.addActionListener(new ClmFileChooseAction());
            clmFileControlPanel.add(this.clmFileButton);
            fileControlPanel.add(clmFileControlPanel);
            JPanel datFileControlPanel = new JPanel();
            this.datFileLabel = new JLabel("DAT files:");
            this.datFileLabel.setPreferredSize(new Dimension(90, 25));
            datFileControlPanel.add(this.datFileLabel);
            this.datFileTextField = new JTextField(15);
            this.datFileTextField.setPreferredSize(new Dimension(150, 20));
            this.datFileTextField.setEditable(false);
            datFileControlPanel.add(this.datFileTextField);
            this.datFileButton = new JButton("Select ...");
            this.datFileButton.setPreferredSize(new Dimension(85, 25));
            this.datFileButton.setVerticalTextPosition(0);
            this.datFileButton.setHorizontalTextPosition(10);
            this.datFileButton.addActionListener(new DatFileChooseAction());
            datFileControlPanel.add(this.datFileButton);
            fileControlPanel.add(datFileControlPanel);
            JPanel lifFileControlPanel = new JPanel();
            this.lifFileLabel = new JLabel("LIF files:");
            this.lifFileLabel.setPreferredSize(new Dimension(90, 25));
            lifFileControlPanel.add(this.lifFileLabel);
            this.lifFileTextField = new JTextField(15);
            this.lifFileTextField.setPreferredSize(new Dimension(150, 20));
            this.lifFileTextField.setEditable(false);
            lifFileControlPanel.add(this.lifFileTextField);
            this.lifFileButton = new JButton("Select ...");
            this.lifFileButton.setPreferredSize(new Dimension(85, 25));
            this.lifFileButton.setVerticalTextPosition(0);
            this.lifFileButton.setHorizontalTextPosition(10);
            this.lifFileButton.addActionListener(new LifFileChooseAction());
            lifFileControlPanel.add(this.lifFileButton);
            fileControlPanel.add(lifFileControlPanel);
            JPanel seaFileControlPanel = new JPanel();
            this.seaFileLabel = new JLabel("SEA files:");
            this.seaFileLabel.setPreferredSize(new Dimension(90, 25));
            seaFileControlPanel.add(this.seaFileLabel);
            this.seaFileTextField = new JTextField(15);
            this.seaFileTextField.setPreferredSize(new Dimension(150, 20));
            this.seaFileTextField.setEditable(false);
            seaFileControlPanel.add(this.seaFileTextField);
            this.seaFileButton = new JButton("Select ...");
            this.seaFileButton.setPreferredSize(new Dimension(85, 25));
            this.seaFileButton.setVerticalTextPosition(0);
            this.seaFileButton.setHorizontalTextPosition(10);
            this.seaFileButton.addActionListener(new SeaFileChooseAction());
            seaFileControlPanel.add(this.seaFileButton);
            fileControlPanel.add(seaFileControlPanel);
            this.controlPanel.add(fileControlPanel);
            JPanel laidataControlPanel = new JPanel();
            laidataControlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Leaf Area Index (LAI) regional data"));
            laidataControlPanel.setLayout(new GridLayout(2, 1));
            JPanel nolaiFileControlPanel = new JPanel();
            this.nolaiRadioButton = new JRadioButton("No regional LAI data");
            nolaiFileControlPanel.add(this.nolaiRadioButton);
            laidataControlPanel.add(nolaiFileControlPanel);
            JPanel laiFileControlPanel = new JPanel();
            this.laiFileRadioButton = new JRadioButton("LAI file:");
            this.laiFileRadioButton.setPreferredSize(new Dimension(90, 25));
            laiFileControlPanel.add(this.laiFileRadioButton);
            this.laiFileTextField = new JTextField(15);
            this.laiFileTextField.setPreferredSize(new Dimension(150, 20));
            this.laiFileTextField.setEditable(false);
            laiFileControlPanel.add(this.laiFileTextField);
            this.laiFileButton = new JButton("Select ...");
            this.laiFileButton.setPreferredSize(new Dimension(85, 25));
            this.laiFileButton.setVerticalTextPosition(0);
            this.laiFileButton.setHorizontalTextPosition(10);
            this.laiFileButton.addActionListener(new LaiFileChooseAction());
            laiFileControlPanel.add(this.laiFileButton);
            laidataControlPanel.add(laiFileControlPanel);
            ButtonGroup laidataButtonGroup = new ButtonGroup();
            laidataButtonGroup.add(this.nolaiRadioButton);
            laidataButtonGroup.add(this.laiFileRadioButton);
            this.nolaiRadioButton.setSelected(true);
            this.controlPanel.add(laidataControlPanel);
            JPanel outputsControlPanel = new JPanel();
            outputsControlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Outputs configuration"));
            outputsControlPanel.setLayout(new GridLayout(4, 1));
            JPanel tipoOutputsControlPanel = new JPanel();
            JLabel tipoLabel = new JLabel("Type:");
            tipoOutputsControlPanel.add(tipoLabel);
            this.resumeOutputCheckBox = new JCheckBox("Resume");
            this.resumeOutputCheckBox.setPreferredSize(new Dimension(75, 25));
            String selectResume = null;
            this.resumeOutputCheckBox.setSelected(true);
            if (this.userProperties != null) {
                selectResume = this.userProperties.getProperty("selectResume");
            }
            if (selectResume == null && this.defaultProperties != null) {
                selectResume = this.defaultProperties.getProperty("selectResume");
            }
            if (selectResume != null && selectResume.equalsIgnoreCase("false")) {
                this.resumeOutputCheckBox.setSelected(false);
            }
            tipoOutputsControlPanel.add(this.resumeOutputCheckBox);
            this.dailyOutputCheckBox = new JCheckBox("Daily");
            this.dailyOutputCheckBox.setPreferredSize(new Dimension(75, 25));
            String selectDaily = null;
            if (this.userProperties != null) {
                selectDaily = this.userProperties.getProperty("selectDaily");
            }
            if (selectDaily == null && this.defaultProperties != null) {
                selectDaily = this.defaultProperties.getProperty("selectDaily");
            }
            if (selectDaily != null && selectDaily.equalsIgnoreCase("true")) {
                this.dailyOutputCheckBox.setSelected(true);
            }
            tipoOutputsControlPanel.add(this.dailyOutputCheckBox);
            this.longOutputCheckBox = new JCheckBox("Long");
            this.longOutputCheckBox.setPreferredSize(new Dimension(75, 25));
            String selectLong = null;
            if (this.userProperties != null) {
                selectLong = this.userProperties.getProperty("selectLong");
            }
            if (selectLong == null && this.defaultProperties != null) {
                selectLong = this.defaultProperties.getProperty("selectLong");
            }
            if (selectLong != null && selectLong.equalsIgnoreCase("true")) {
                this.longOutputCheckBox.setSelected(true);
            }
            tipoOutputsControlPanel.add(this.longOutputCheckBox);
            this.mapOutputCheckBox = new JCheckBox("Map");
            this.mapOutputCheckBox.setPreferredSize(new Dimension(75, 25));
            this.mapOutputCheckBox.setEnabled(false);
            tipoOutputsControlPanel.add(this.mapOutputCheckBox);
            outputsControlPanel.add(tipoOutputsControlPanel);
            JPanel formatOutputsControlPanel = new JPanel();
            JLabel formatLabel = new JLabel("Format:");
            formatOutputsControlPanel.add(formatLabel);
            this.textOutputCheckBox = new JCheckBox("Simlat5");
            this.textOutputCheckBox.setPreferredSize(new Dimension(75, 25));
            String selectText = null;
            this.textOutputCheckBox.setSelected(true);
            if (this.userProperties != null) {
                selectText = this.userProperties.getProperty("selectText");
            }
            if (selectText == null && this.defaultProperties != null) {
                selectText = this.defaultProperties.getProperty("selectText");
            }
            if (selectText != null && selectText.equalsIgnoreCase("false")) {
                this.textOutputCheckBox.setSelected(false);
            }
            formatOutputsControlPanel.add(this.textOutputCheckBox);
            outputsControlPanel.add(formatOutputsControlPanel);
            JPanel folderOutputsControlPanel = new JPanel();
            this.folderOutputLabel = new JLabel("Outputs folder:");
            this.folderOutputLabel.setPreferredSize(new Dimension(95, 25));
            folderOutputsControlPanel.add(this.folderOutputLabel);
            this.folderOutputTextField = new JTextField(15);
            this.folderOutputTextField.setPreferredSize(new Dimension(130, 20));
            this.folderOutputTextField.setEditable(false);
            folderOutputsControlPanel.add(this.folderOutputTextField);
            this.folderOutputButton = new JButton("Select ...");
            this.folderOutputButton.setPreferredSize(new Dimension(85, 25));
            this.folderOutputButton.setVerticalTextPosition(0);
            this.folderOutputButton.setHorizontalTextPosition(10);
            this.folderOutputButton.addActionListener(new FolderOutputChooseAction());
            folderOutputsControlPanel.add(this.folderOutputButton);
            outputsControlPanel.add(folderOutputsControlPanel);
            JPanel optionsOutputsControlPanel = new JPanel();
            this.optionsOutputsButton = new JButton("Options ...");
            this.optionsOutputsButton.setPreferredSize(new Dimension(100, 25));
            this.optionsOutputsButton.setVerticalTextPosition(0);
            this.optionsOutputsButton.setHorizontalTextPosition(10);
            this.optionsOutputsButton.addActionListener(new OptionsOutputsAction());
            this.optionsOutputsButton.setEnabled(true);
            optionsOutputsControlPanel.add(this.optionsOutputsButton);
            outputsControlPanel.add(optionsOutputsControlPanel);
            this.controlPanel.add(outputsControlPanel);
            JPanel controldataControlPanel = new JPanel();
            controldataControlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Estimation control parameters"));
            controldataControlPanel.setLayout(new GridLayout(4, 1));
            JPanel seasonControldataControlPanel = new JPanel();
            seasonControldataControlPanel.setLayout(new GridLayout(1, 3));
            Integer start = null;
            Integer stop = null;
            Integer season = null;
            Double carbonFixation = null;
            if (this.userProperties != null) {
                String carbonFixationStr2;
                String seasonStr2;
                String stopStr2;
                startStr = this.userProperties.getProperty("start");
                if (startStr != null) {
                    start = Integer.parseInt(startStr);
                }
                if ((stopStr2 = this.userProperties.getProperty("stop")) != null) {
                    stop = Integer.parseInt(stopStr2);
                }
                if ((seasonStr2 = this.userProperties.getProperty("season")) != null) {
                    season = Integer.parseInt(seasonStr2);
                }
                if ((carbonFixationStr2 = this.userProperties.getProperty("carbonFixation")) != null) {
                    carbonFixation = Double.parseDouble(carbonFixationStr2);
                }
            }
            if (start == null && this.defaultProperties != null && (startStr = this.defaultProperties.getProperty("start")) != null) {
                start = Integer.parseInt(startStr);
            }
            if (stop == null && this.defaultProperties != null && (stopStr = this.defaultProperties.getProperty("stop")) != null) {
                stop = Integer.parseInt(stopStr);
            }
            if (season == null && this.defaultProperties != null && (seasonStr = this.defaultProperties.getProperty("season")) != null) {
                season = Integer.parseInt(seasonStr);
            }
            if (carbonFixation == null && this.defaultProperties != null && (carbonFixationStr = this.defaultProperties.getProperty("carbonFixation")) != null) {
                carbonFixation = Double.parseDouble(carbonFixationStr);
            }
            JPanel startdayPanel = new JPanel();
            this.startdayLabel = new JLabel("Start:");
            this.startdayLabel.setPreferredSize(new Dimension(40, 25));
            startdayPanel.add(this.startdayLabel);
            if (start == null || start <= 0) {
                start = 1;
            }
            this.startdaySpinnerModel = new SpinnerNumberModel(start, 1, 10000, 10);
            this.startdaySpinner = new JSpinner(this.startdaySpinnerModel);
            this.startdaySpinner.setPreferredSize(new Dimension(60, 25));
            startdayPanel.add(this.startdaySpinner);
            seasonControldataControlPanel.add(startdayPanel);
            JPanel stopdayPanel = new JPanel();
            this.stopdayLabel = new JLabel("Stop:");
            this.stopdayLabel.setPreferredSize(new Dimension(40, 25));
            stopdayPanel.add(this.stopdayLabel);
            if (stop == null || stop <= 0 || stop < start) {
                stop = start + 364;
            }
            this.stopdaySpinnerModel = new SpinnerNumberModel(stop, 1, 10000, 10);
            this.stopdaySpinner = new JSpinner(this.stopdaySpinnerModel);
            this.stopdaySpinner.setPreferredSize(new Dimension(60, 25));
            stopdayPanel.add(this.stopdaySpinner);
            seasonControldataControlPanel.add(stopdayPanel);
            JPanel seasondaysPanel = new JPanel();
            this.seasondaysLabel = new JLabel("Season:");
            this.seasondaysLabel.setPreferredSize(new Dimension(50, 25));
            seasondaysPanel.add(this.seasondaysLabel);
            if (season == null || season <= 0) {
                season = 365;
            }
            this.seasondaysSpinnerModel = new SpinnerNumberModel(season, 1, 10000, 10);
            this.seasondaysSpinner = new JSpinner(this.seasondaysSpinnerModel);
            this.seasondaysSpinner.setPreferredSize(new Dimension(60, 25));
            seasondaysPanel.add(this.seasondaysSpinner);
            seasonControldataControlPanel.add(seasondaysPanel);
            controldataControlPanel.add(seasonControldataControlPanel);
            JPanel carbonControldataControlPanel = new JPanel();
            this.carbonRatioLabel = new JLabel("Carbon fixation ratio:");
            this.carbonRatioLabel.setPreferredSize(new Dimension(150, 25));
            carbonControldataControlPanel.add(this.carbonRatioLabel);
            if (carbonFixation == null || carbonFixation < 0.0 || carbonFixation > 1.0) {
                carbonFixation = 0.5;
            }
            this.carbonRatioSpinnerModel = new SpinnerNumberModel(carbonFixation, 0.0, 1.0, 0.1);
            this.carbonRatioSpinner = new JSpinner(this.carbonRatioSpinnerModel);
            this.carbonRatioSpinner.setPreferredSize(new Dimension(60, 25));
            carbonControldataControlPanel.add(this.carbonRatioSpinner);
            controldataControlPanel.add(carbonControldataControlPanel);
            JPanel runControldataControlPanel = new JPanel();
            this.runButton = new JButton("Run");
            this.runButton.setPreferredSize(new Dimension(150, 35));
            this.runButton.setVerticalTextPosition(0);
            this.runButton.setHorizontalTextPosition(10);
            this.runButton.addActionListener(new RunAction());
            this.runButton.setEnabled(false);
            runControldataControlPanel.add(this.runButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.setPreferredSize(new Dimension(80, 35));
            this.resetButton.setVerticalTextPosition(0);
            this.resetButton.setHorizontalTextPosition(10);
            this.resetButton.addActionListener(new ResetAction());
            runControldataControlPanel.add(this.resetButton);
            controldataControlPanel.add(runControldataControlPanel);
            JPanel progressControldataControlPanel = new JPanel();
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.progressBar.setPreferredSize(new Dimension(150, 25));
            progressControldataControlPanel.add(this.progressBar);
            controldataControlPanel.add(progressControldataControlPanel);
            this.controlPanel.add(controldataControlPanel);
        }
        return this.controlPanel;
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new JPanel();
            this.dataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 10, 2, 2, Color.black), BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Data and results")));
            this.dataPanel.setLayout(new BorderLayout());
            this.dataTabbedPane = new JTabbedPane();
            this.dataTabbedPane.setPreferredSize(new Dimension(400, 350));
            this.clmTextPane = new JTextPane();
            this.clmTextPane.setAutoscrolls(true);
            this.clmTextPane.setEditable(false);
            this.clmTextPane.setBackground(new Color(240, 240, 240));
            JScrollPane clmScrollPane = new JScrollPane(this.clmTextPane);
            this.dataTabbedPane.add((Component)clmScrollPane, "Climatic data values");
            this.xTextPane = new JTextPane();
            this.xTextPane.setAutoscrolls(true);
            this.xTextPane.setEditable(false);
            this.xTextPane.setBackground(new Color(240, 240, 240));
            JScrollPane xScrollPane = new JScrollPane(this.xTextPane);
            this.dataTabbedPane.add((Component)xScrollPane, "State Variables (X) initial values");
            this.bTextPane = new JTextPane();
            this.bTextPane.setAutoscrolls(true);
            this.bTextPane.setEditable(false);
            this.bTextPane.setBackground(new Color(240, 240, 240));
            JScrollPane bScrollPane = new JScrollPane(this.bTextPane);
            this.dataTabbedPane.add((Component)bScrollPane, "Site Constants (B) values");
            this.dailyTextPane = new JTextPane();
            this.dailyTextPane.setAutoscrolls(true);
            this.dailyTextPane.setEditable(false);
            this.dailyTextPane.setBackground(new Color(240, 240, 240));
            JScrollPane dailyScrollPane = new JScrollPane(this.dailyTextPane);
            this.dataTabbedPane.add((Component)dailyScrollPane, "Ontogeny Site Constants replacing values");
            this.seasonallyTextPane = new JTextPane();
            this.seasonallyTextPane.setAutoscrolls(true);
            this.seasonallyTextPane.setEditable(false);
            this.seasonallyTextPane.setBackground(new Color(240, 240, 240));
            JScrollPane seasonallyScrollPane = new JScrollPane(this.seasonallyTextPane);
            this.dataTabbedPane.add((Component)seasonallyScrollPane, "Philogeny Site Constants replacing values");
            this.dataPanel.add((Component)this.dataTabbedPane, "Center");
            this.textAttrs = new SimpleAttributeSet();
            StyleConstants.setBold(this.textAttrs, true);
            StyleConstants.setForeground(this.textAttrs, new Color(20, 20, 20));
        }
        return this.dataPanel;
    }

    private JPanel getConsolePanel() {
        if (this.consolePanel == null) {
            this.consolePanel = new JPanel();
            this.consolePanel.setPreferredSize(new Dimension(400, 250));
            this.consolePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 10, 2, 2, Color.black), BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Console")));
            this.consolePanel.setLayout(new BorderLayout());
            this.consoleTextPane = new JTextPane();
            this.consoleTextPane.setAutoscrolls(true);
            this.consoleTextPane.setEditable(false);
            this.consoleTextPane.setBackground(new Color(240, 240, 220));
            JScrollPane consoleScrollPane = new JScrollPane(this.consoleTextPane);
            this.infoAttrs = new SimpleAttributeSet();
            StyleConstants.setBold(this.infoAttrs, true);
            StyleConstants.setForeground(this.infoAttrs, new Color(13, 132, 200));
            this.configAttrs = new SimpleAttributeSet();
            StyleConstants.setForeground(this.configAttrs, new Color(13, 132, 9));
            StyleConstants.setBold(this.configAttrs, true);
            this.warningAttrs = new SimpleAttributeSet();
            StyleConstants.setBold(this.warningAttrs, true);
            StyleConstants.setForeground(this.warningAttrs, new Color(200, 100, 9));
            this.severeAttrs = new SimpleAttributeSet();
            StyleConstants.setBold(this.severeAttrs, true);
            StyleConstants.setForeground(this.severeAttrs, Color.red);
            this.consolePanel.add((Component)consoleScrollPane, "Center");
        }
        return this.consolePanel;
    }

    private void log(String message, Level level) {
        StyledDocument doc = this.consoleTextPane.getStyledDocument();
        int length = doc.getLength();
        Date date = new Date(System.currentTimeMillis());
        try {
            if (level.equals(Level.CONFIG)) {
                doc.insertString(length, "[" + DateFormat.getDateTimeInstance(3, 3).format(date) + "] " + message + "\n", this.configAttrs);
            } else if (level.equals(Level.WARNING)) {
                doc.insertString(length, "[" + DateFormat.getDateTimeInstance(3, 3).format(date) + "] WARNING: " + message + "\n", this.warningAttrs);
            } else if (level.equals(Level.SEVERE)) {
                doc.insertString(length, "[" + DateFormat.getDateTimeInstance(3, 3).format(date) + "] ERROR: " + message + "\n", this.severeAttrs);
            } else {
                doc.insertString(length, "[" + DateFormat.getDateTimeInstance(3, 3).format(date) + "] " + message + "\n", this.infoAttrs);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void loadClimateData() throws Exception {
        this.climateDataManager = new Simlat5ClimateDataManager(this.clmFile);
        Double[] tMax = this.climateDataManager.getData(0);
        Double[] tMin = this.climateDataManager.getData(1);
        Double[] dewPoint = this.climateDataManager.getData(2);
        Double[] dayLength = this.climateDataManager.getData(3);
        Double[] precision = this.climateDataManager.getData(4);
        StyledDocument doc = this.clmTextPane.getStyledDocument();
        doc.insertString(doc.getLength(), "DAY\tT_MAX\tT_MIN\tDEW_POINT\tDAY_LENGTH\tPRECISION\n\n", this.infoAttrs);
        int i = 0;
        while (i < this.climateDataManager.getNumDays()) {
            doc.insertString(doc.getLength(), String.valueOf(i + 1) + "\t" + tMax[i] + "\t" + tMin[i] + "\t" + dewPoint[i] + "\t\t" + precision[i] + "\t\t" + dayLength[i] + "\t" + "\n", this.textAttrs);
            ++i;
        }
    }

    private void loadSiteData() throws Exception {
        this.siteDataManager = new Simlat5SiteDataManager(this.datFile);
        StyledDocument bdoc = this.bTextPane.getStyledDocument();
        bdoc.insertString(bdoc.getLength(), "B\tDESCRIPTION\t\t\t\tVALUE\tUNITS\n\n", this.infoAttrs);
        bdoc.insertString(bdoc.getLength(), "1\tSpecific leaf area\t\t\t\t" + this.siteDataManager.getData(33) + "\t(m^2 kg^-1\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "2\tCanopy light extinction coefficient\t\t\t" + this.siteDataManager.getData(34) + "\t(dimensionless)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "3\tSoil water capacity\t\t\t\t" + this.siteDataManager.getData(35) + "\t(m^3 ha^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "4\tWater interception coefficient\t\t\t" + this.siteDataManager.getData(36) + "\t(m L*^-1 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "5\tGround surface area\t\t\t\t" + this.siteDataManager.getData(37) + "\t(m^2 ha^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "6\tSnowmelt coefficient\t\t\t\t" + this.siteDataManager.getData(38) + "\t(m Celsius^-1 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "7\tLatitude\t\t\t\t\t" + this.siteDataManager.getData(39) + "\t(deg)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "8\t1 - surface albedo\t\t\t\t" + this.siteDataManager.getData(40) + "\t(dimensionless)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "9\tMinimum water potential in spring\t\t" + this.siteDataManager.getData(41) + "\t(MPa)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "10\tRadiation reducing leaf conductance threshold\t\t" + this.siteDataManager.getData(42) + "\t(Kj m\u207b2 day^-1 )\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "11\tMaximum canopy average leaf conductance\t\t" + this.siteDataManager.getData(43) + "\t(m s^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "12\tLeaf water potential at stomatal closure\t\t" + this.siteDataManager.getData(44) + "\t(MPa)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "13\tSlope of absolute humidity reduction\t\t" + this.siteDataManager.getData(45) + "\t(m s^-1 Habs^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "14\tPhotosynthesis light compensation point\t\t" + this.siteDataManager.getData(46) + "\t(Kj m^-2)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "15\tPhotosynthesis maximum\t\t\t" + this.siteDataManager.getData(47) + "\t(Kj m^-2 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "16\tMaximum leaf conductance (CO2)\t\t\t" + this.siteDataManager.getData(48) + "\t(m s^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "17\tMinimum temperature for photosynthesis\t\t" + this.siteDataManager.getData(49) + "\t(Celsius)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "18\tMaximum temperature for photosynthesis\t\t" + this.siteDataManager.getData(50) + "\t(Celsius)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "19\tLeaf respireation coefficient\t\t\t" + this.siteDataManager.getData(51) + "(Celsius^-1 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "20\tStem respireation coefficient\t\t\t" + this.siteDataManager.getData(52) + "(Celsius^-1 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "21\tRoot respireation coefficient\t\t\t" + this.siteDataManager.getData(53) + "(Celsius^-1 day^-1)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "22\t\t\t\t\t\t" + this.siteDataManager.getData(54) + "\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "23\tTemperature effect on mesophyll condition coefficient\t" + this.siteDataManager.getData(55) + "(Celsius)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "24\tDecomposition temperature optimum\t\t" + this.siteDataManager.getData(56) + "(Celsius)\n", this.textAttrs);
        bdoc.insertString(bdoc.getLength(), "25\tQ10=2.3 for exponential resiration surface\t\t" + this.siteDataManager.getData(57) + "(Celsius)\n", this.textAttrs);
        if (this.siteDataManager.isStaticBudget()) {
            bdoc.insertString(bdoc.getLength(), "26\tLeaf nitrogen concentration\t\t\t" + this.siteDataManager.getData(58) + "\t(%)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "27\t\t\t\t\t\t" + this.siteDataManager.getData(59) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "28\t\t\t\t\t\t" + this.siteDataManager.getData(60) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "29\t\t\t\t\t\t" + this.siteDataManager.getData(61) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "30\tLeaf carbon allocation fraction\t\t\t" + this.siteDataManager.getData(62) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "31\tStem carbon allocation fraction\t\t\t" + this.siteDataManager.getData(63) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "32\tRoot carbon allocation fraction\t\t\t" + this.siteDataManager.getData(64) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "33\t\t\t\t\t\t" + this.siteDataManager.getData(65) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "34\t\t\t\t\t\t" + this.siteDataManager.getData(66) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "35\t\t\t\t\t\t" + this.siteDataManager.getData(67) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "36\t\t\t\t\t\t" + this.siteDataManager.getData(68) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "37\t\t\t\t\t\t" + this.siteDataManager.getData(69) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "38\t\t\t\t\t\t" + this.siteDataManager.getData(70) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "39\t\t\t\t\t\t" + this.siteDataManager.getData(71) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "40\tLeaf drop coefficient (Coniferous:1.0, Deciduous:0.2)\t" + this.siteDataManager.getData(72) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "41\tStem turnover coefficient\t\t\t" + this.siteDataManager.getData(73) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "42\tRoot turnover coefficient\t\t\t" + this.siteDataManager.getData(74) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "43\tLeaf growth respiration\t\t\t" + this.siteDataManager.getData(75) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "44\tStem growth respiration\t\t\t" + this.siteDataManager.getData(76) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "45\tRoot growth respiration\t\t\t" + this.siteDataManager.getData(77) + "\n", this.textAttrs);
        } else {
            bdoc.insertString(bdoc.getLength(), "26\tMaximum canopy average leaf nitrogen concentration\t" + this.siteDataManager.getData(58) + "\t(N Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "27\tMinimum canopy average leaf nitrogen concentration\t" + this.siteDataManager.getData(59) + "(N Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "28\tMaximum leaf nitrogen retranslocation fraction\t" + this.siteDataManager.getData(60) + "(fraction year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "29\tSoil litter decomposition rate factor (0-1)\t\t" + this.siteDataManager.getData(61) + "(fraction year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "30\tN/C decomposition release fraction\t\t" + this.siteDataManager.getData(62) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "31\tMaximum leaf area index (all sides)\t\t" + this.siteDataManager.getData(63) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "32\tLeaf turnover age\t\t\t\t" + this.siteDataManager.getData(64) + "(years)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "33\tLeaf lignin fraction\t\t\t\t" + this.siteDataManager.getData(65) + "(%)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "34\tSoil water leaf/root allocation factor\t\t" + this.siteDataManager.getData(66) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "35\tNitrogen availability leaf/root allocation factor\t" + this.siteDataManager.getData(67) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "36\tDate of spring leaf growth\t\t\t" + this.siteDataManager.getData(68) + "(yearday)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "37\tDate of fall leaf growth\t\t\t" + this.siteDataManager.getData(69) + "(yearday)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "38\tMobile N retention time\t\t\t" + this.siteDataManager.getData(70) + "(years)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "39\tAtmospheric N deposition\t\t\t" + this.siteDataManager.getData(71) + "(Kg ha^-1 year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "40\tBiological N fixation\t\t\t\t" + this.siteDataManager.getData(72) + "(Kg ha^-1 year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "41\tStem turnover coefficient\t\t\t" + this.siteDataManager.getData(73) + "(fraction year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "42\tRoot turnover coefficient\t\t\t" + this.siteDataManager.getData(74) + "(fraction year^-1)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "43\tLeaf growth respiration\t\t\t" + this.siteDataManager.getData(75) + "(Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "44\tStem growth respiration\t\t\t" + this.siteDataManager.getData(76) + "(Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "45\tRoot growth respiration\t\t\t" + this.siteDataManager.getData(77) + "(Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "46\tDecompositon optimum temperature\t\t" + this.siteDataManager.getData(78) + "(Celsius)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "47\tSoil/litter C decomosition fraction\t\t\t" + this.siteDataManager.getData(79) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "48\tDecomposition rate scalar\t\t\t" + this.siteDataManager.getData(80) + "(dimensionless)\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "49\t\t\t\t\t\t" + this.siteDataManager.getData(81) + "\n", this.textAttrs);
            bdoc.insertString(bdoc.getLength(), "50\t\t\t\t\t\t" + this.siteDataManager.getData(82) + "\n", this.textAttrs);
        }
        StyledDocument xdoc = this.xTextPane.getStyledDocument();
        xdoc.insertString(xdoc.getLength(), "X\tDESCRIPTION\t\tVALUE\tUNITS\n\n", this.infoAttrs);
        xdoc.insertString(xdoc.getLength(), "1\tSnowpack\t\t\t" + this.siteDataManager.getData(3) + "\t(m^3)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "2\tSoil water content\t\t" + this.siteDataManager.getData(4) + "\t(m^3)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "3\tWater outflow\t\t" + this.siteDataManager.getData(5) + "\t(m^3)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "4\tTranspiration\t\t" + this.siteDataManager.getData(6) + "\t(m^3)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "5\tEvaporation\t\t" + this.siteDataManager.getData(7) + "\t(m^3)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "6\tPSN\t\t\t" + this.siteDataManager.getData(8) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "7\tRespiraton autotrophic\t\t" + this.siteDataManager.getData(9) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "8\tLeaf carbon\t\t" + this.siteDataManager.getData(10) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "9\tStem carbon\t\t" + this.siteDataManager.getData(11) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "10\tRoot carbon\t\t" + this.siteDataManager.getData(12) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "11\tLeaf/Root litter carbon\t\t" + this.siteDataManager.getData(13) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "12\tRespiration decompositon, C\t" + this.siteDataManager.getData(14) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "13\tSoil carbon\t\t\t" + this.siteDataManager.getData(15) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "14\tAvailable nitrogen\t\t" + this.siteDataManager.getData(16) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "15\tLeaf nitrogen(1.5% OF X8)\t" + this.siteDataManager.getData(17) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "16\tStem nitrogen\t\t" + this.siteDataManager.getData(18) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "17\tRoot nitrogen\t\t" + this.siteDataManager.getData(19) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "18\tLeaf/Root litter nitrogen\t" + this.siteDataManager.getData(20) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "19\tSoil nitrogen\t\t" + this.siteDataManager.getData(21) + "\t(Kg)\n", this.textAttrs);
        xdoc.insertString(xdoc.getLength(), "20\tNitrogen loss\t\t" + this.siteDataManager.getData(22) + "\t(Kg)\n", this.textAttrs);
    }

    private void loadDailyData() throws Exception {
        this.dailyDataManager = new SimpleDailyDataManager(this.lifFile);
        List<Integer> days = this.dailyDataManager.getDays();
        Collections.sort(days);
        ListIterator<Integer> daysIterator = days.listIterator();
        List<Integer> constants = this.dailyDataManager.getReplacingConstants();
        ListIterator<Integer> constantsIterator = constants.listIterator();
        StyledDocument doc = this.dailyTextPane.getStyledDocument();
        doc.insertString(doc.getLength(), "DAY\t", this.infoAttrs);
        while (constantsIterator.hasNext()) {
            doc.insertString(doc.getLength(), "B(" + constantsIterator.next() + ")\t", this.infoAttrs);
        }
        doc.insertString(doc.getLength(), "\n\n", this.infoAttrs);
        while (daysIterator.hasNext()) {
            Integer day = daysIterator.next();
            doc.insertString(doc.getLength(), day + "\t", this.textAttrs);
            List<DailyDataManager.DailyData> dailyData = this.dailyDataManager.getDailyData(day);
            constantsIterator = constants.listIterator();
            while (constantsIterator.hasNext()) {
                Integer constant = constantsIterator.next();
                boolean notfound = true;
                ListIterator<DailyDataManager.DailyData> dailyDataIterator = dailyData.listIterator();
                while (dailyDataIterator.hasNext()) {
                    DailyDataManager.DailyData data = dailyDataIterator.next();
                    if (data.getConstant() != constant.intValue()) continue;
                    doc.insertString(doc.getLength(), data.getValue() + "\t", this.textAttrs);
                    notfound = false;
                    break;
                }
                if (!notfound) continue;
                doc.insertString(doc.getLength(), "*\t", this.textAttrs);
            }
            doc.insertString(doc.getLength(), "\n", this.textAttrs);
        }
    }

    private void loadSeasonallyData() throws Exception {
        this.seasonDataManager = new SimpleSeasonDataManager(this.seaFile);
        List<Integer> seasons = this.seasonDataManager.getSeasons();
        Collections.sort(seasons);
        ListIterator<Integer> seasonsIterator = seasons.listIterator();
        List<Integer> constants = this.seasonDataManager.getReplacingConstants();
        ListIterator<Integer> constantsIterator = constants.listIterator();
        StyledDocument doc = this.seasonallyTextPane.getStyledDocument();
        doc.insertString(doc.getLength(), "SEASON\t", this.infoAttrs);
        while (constantsIterator.hasNext()) {
            doc.insertString(doc.getLength(), "B(" + constantsIterator.next() + ")\t", this.infoAttrs);
        }
        doc.insertString(doc.getLength(), "\n\n", this.infoAttrs);
        while (seasonsIterator.hasNext()) {
            Integer season = seasonsIterator.next();
            doc.insertString(doc.getLength(), season + "\t", this.textAttrs);
            List<SeasonDataManager.SeasonData> seasonallyData = this.seasonDataManager.getSeasonData(season);
            constantsIterator = constants.listIterator();
            while (constantsIterator.hasNext()) {
                Integer constant = constantsIterator.next();
                boolean notfound = true;
                ListIterator<SeasonDataManager.SeasonData> seasonallyDataIterator = seasonallyData.listIterator();
                while (seasonallyDataIterator.hasNext()) {
                    SeasonDataManager.SeasonData data = seasonallyDataIterator.next();
                    if (data.getConstant() != constant.intValue()) continue;
                    doc.insertString(doc.getLength(), data.getValue() + "\t", this.textAttrs);
                    notfound = false;
                    break;
                }
                if (!notfound) continue;
                doc.insertString(doc.getLength(), "*\t", this.textAttrs);
            }
            doc.insertString(doc.getLength(), "\n", this.textAttrs);
        }
    }

    private void loadLaiData() throws Exception {
        this.laiDataManager = new SimpleLaiDataManager(this.laiFile);
        Iterator<LaiDataManager.CoordinatedLai> laiIterator = this.laiDataManager.laiIterator();
        this.laiTextPane = new JTextPane();
        this.laiTextPane.setAutoscrolls(true);
        this.laiTextPane.setEditable(false);
        this.laiTextPane.setBackground(new Color(240, 240, 240));
        this.laiScrollPane = new JScrollPane(this.laiTextPane);
        this.dataTabbedPane.add((Component)this.laiScrollPane, "Leaf Area index (LAI) values");
        StyledDocument doc = this.laiTextPane.getStyledDocument();
        doc.insertString(doc.getLength(), "X\tY\tLAI\n\n", this.infoAttrs);
        while (laiIterator.hasNext()) {
            LaiDataManager.CoordinatedLai lai = laiIterator.next();
            doc.insertString(doc.getLength(), lai.getX() + "\t" + lai.getY() + "\t" + lai.getLai() + "\n", this.textAttrs);
        }
    }

    private void loadMod15Data() throws Exception {
        this.laiDataManager = new Mod15DataLaiManager(this.laiFile);
        Image laiImage = this.laiDataManager.getLaiImage();
        this.mod15Pane = new ImagePanel(laiImage);
        this.mod15Pane.setAutoscrolls(true);
        this.mod15Pane.setBackground(new Color(240, 240, 240));
        this.mod15ScrollPane = new JScrollPane(this.mod15Pane);
        this.dataTabbedPane.add((Component)this.mod15ScrollPane, "MOD-15 Leaf Area index (LAI) Map");
    }

    private void loadLandsatData() throws Exception {
    }

    private void reset() {
        this.climateDataManager = null;
        this.siteDataManager = null;
        this.dailyDataManager = null;
        this.seasonDataManager = null;
        this.laiDataManager = null;
        this.clmFile = null;
        this.datFile = null;
        this.lifFile = null;
        this.seaFile = null;
        this.laiFile = null;
        this.clmFileTextField.setText("");
        this.datFileTextField.setText("");
        this.lifFileTextField.setText("");
        this.seaFileTextField.setText("");
        this.laiFileTextField.setText("");
        this.nolaiRadioButton.setSelected(true);
        try {
            this.clmTextPane.getStyledDocument().remove(0, this.clmTextPane.getStyledDocument().getLength());
            this.xTextPane.getStyledDocument().remove(0, this.xTextPane.getStyledDocument().getLength());
            this.bTextPane.getStyledDocument().remove(0, this.bTextPane.getStyledDocument().getLength());
            this.dailyTextPane.getStyledDocument().remove(0, this.dailyTextPane.getStyledDocument().getLength());
            this.seasonallyTextPane.getStyledDocument().remove(0, this.seasonallyTextPane.getStyledDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int numTabs = this.dataTabbedPane.getTabCount();
        int i = 5;
        while (i < numTabs) {
            this.dataTabbedPane.removeTabAt(5);
            ++i;
        }
        this.resumeOutputCheckBox.setSelected(true);
        this.dailyOutputCheckBox.setSelected(false);
        this.longOutputCheckBox.setSelected(false);
        this.mapOutputCheckBox.setSelected(false);
        this.mapOutputCheckBox.setEnabled(false);
        this.startdaySpinnerModel.setMaximum(Integer.valueOf(10000));
        this.startdaySpinnerModel.setValue(1);
        this.stopdaySpinnerModel.setMaximum(Integer.valueOf(10000));
        this.stopdaySpinnerModel.setValue(365);
        this.seasondaysSpinnerModel.setMaximum(Integer.valueOf(10000));
        this.seasondaysSpinnerModel.setValue(365);
        this.carbonRatioSpinnerModel.setValue(0.5);
        this.runButton.setEnabled(false);
        this.progressBar.setValue(0);
    }

    private void giveOutput(ForestBGCResults results, double carbonFixationRatio) {
        int i;
        if (this.outputFolder == null) {
            String folderOutputPath = null;
            if (this.userProperties != null) {
                folderOutputPath = this.userProperties.getProperty("outputFolder");
            }
            if (folderOutputPath == null && this.defaultProperties != null) {
                folderOutputPath = this.defaultProperties.getProperty("outputFolder");
            }
            if (folderOutputPath == null) {
                folderOutputPath = ".";
            }
            this.outputFolder = new File(folderOutputPath);
        }
        Simlat5ForestBGCOutputManager outputManager = Simlat5ForestBGCOutputManager.getInstance();
        outputManager.setCarbonFixationRatio(carbonFixationRatio);
        if (this.resumeOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File resumeFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_resume.txt");
            i = 0;
            while (resumeFile.exists()) {
                resumeFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_resume_" + i + ".txt");
                ++i;
            }
            try {
                if (!resumeFile.createNewFile() || !resumeFile.canWrite()) {
                    this.log("Error creating resume output file.", Level.SEVERE);
                }
                outputManager.report(results, 0, resumeFile);
                this.log("Resume output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating resume output file.", Level.SEVERE);
            }
        }
        if (this.dailyOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File dailyFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_daily.txt");
            i = 0;
            while (dailyFile.exists()) {
                dailyFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_daily_" + i + ".txt");
                ++i;
            }
            try {
                if (!dailyFile.createNewFile() || !dailyFile.canWrite()) {
                    this.log("Error creating daily output file.", Level.SEVERE);
                }
                outputManager.report(results, 2, dailyFile);
                this.log("Daily output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating daily output file.", Level.SEVERE);
            }
        }
        if (this.longOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File longFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_long.txt");
            i = 0;
            while (longFile.exists()) {
                longFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_long_" + i + ".txt");
                ++i;
            }
            try {
                if (!longFile.createNewFile() || !longFile.canWrite()) {
                    this.log("Error creating long output file.", Level.SEVERE);
                }
                outputManager.report(results, 1, longFile);
                this.log("Long output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating long output file.", Level.SEVERE);
            }
        }
    }

    private void giveOutput(GlobalForestBGCResults results, double carbonFixationRatio) {
        int i;
        if (this.outputFolder == null) {
            String folderOutputPath = null;
            if (this.userProperties != null) {
                folderOutputPath = this.userProperties.getProperty("outputFolder");
            }
            if (folderOutputPath == null && this.defaultProperties != null) {
                folderOutputPath = this.defaultProperties.getProperty("outputFolder");
            }
            if (folderOutputPath == null) {
                folderOutputPath = ".";
            }
            this.outputFolder = new File(folderOutputPath);
        }
        Simlat5ForestBGCOutputManager outputManager = Simlat5ForestBGCOutputManager.getInstance();
        outputManager.setCarbonFixationRatio(carbonFixationRatio);
        if (this.resumeOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File resumeFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_resume.txt");
            i = 0;
            while (resumeFile.exists()) {
                resumeFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_resume_" + i + ".txt");
                ++i;
            }
            try {
                if (!resumeFile.createNewFile() || !resumeFile.canWrite()) {
                    this.log("Error creating resume output file.", Level.SEVERE);
                }
                outputManager.report(results, 0, resumeFile);
                this.log("Resume output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating resume output file.", Level.SEVERE);
            }
        }
        if (this.dailyOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File dailyFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_daily.txt");
            i = 0;
            while (dailyFile.exists()) {
                dailyFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_daily_" + i + ".txt");
                ++i;
            }
            try {
                if (!dailyFile.createNewFile() || !dailyFile.canWrite()) {
                    this.log("Error creating daily output file.", Level.SEVERE);
                }
                outputManager.report(results, 2, dailyFile);
                this.log("Daily output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating daily output file.", Level.SEVERE);
            }
        }
        if (this.longOutputCheckBox.isSelected() && this.textOutputCheckBox.isSelected()) {
            File longFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_long.txt");
            i = 0;
            while (longFile.exists()) {
                longFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + results.getSimulationName() + "_long_" + i + ".txt");
                ++i;
            }
            try {
                if (!longFile.createNewFile() || !longFile.canWrite()) {
                    this.log("Error creating long output file.", Level.SEVERE);
                }
                outputManager.report(results, 1, longFile);
                this.log("Long output file created", Level.CONFIG);
            }
            catch (Exception e) {
                this.log("Error creating long output file.", Level.SEVERE);
            }
        }
    }

    private class ClmFileChooseAction
    implements ActionListener {
        private ClmFileChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String clmPath = null;
            if (NppGui.this.userProperties != null && (clmPath = NppGui.this.userProperties.getProperty("clmFolder")) == null) {
                clmPath = NppGui.this.userProperties.getProperty("dataFolder");
            }
            if (clmPath == null && NppGui.this.defaultProperties != null && (clmPath = NppGui.this.defaultProperties.getProperty("clmFolder")) == null) {
                clmPath = NppGui.this.defaultProperties.getProperty("dataFolder");
            }
            JFileChooser fileChooser = clmPath == null ? new JFileChooser() : new JFileChooser(clmPath);
            fileChooser.setFileFilter(new ClimateFileFilter());
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.clmFile = fileChooser.getSelectedFile();
                NppGui.this.clmFileTextField.setText(NppGui.this.clmFile.getAbsolutePath());
                try {
                    NppGui.this.log("Loading climate file: " + NppGui.this.clmFile.getName(), Level.INFO);
                    NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    NppGui.this.loadClimateData();
                    NppGui.this.log("Number of days for the model: " + NppGui.this.climateDataManager.getNumDays(), Level.INFO);
                    NppGui.this.log("Climate data successfully loaded", Level.CONFIG);
                    NppGui.this.startdaySpinnerModel.setMaximum(Integer.valueOf(NppGui.this.climateDataManager.getNumDays()));
                    NppGui.this.stopdaySpinnerModel.setMaximum(Integer.valueOf(NppGui.this.climateDataManager.getNumDays()));
                    NppGui.this.seasondaysSpinnerModel.setMaximum(Integer.valueOf(NppGui.this.climateDataManager.getNumDays()));
                    if (NppGui.this.datFile != null) {
                        NppGui.this.runButton.setEnabled(true);
                        NppGui.this.log("Forest-BGC model can be runned now", Level.CONFIG);
                    }
                    NppGui.this.setCursor(null);
                }
                catch (Exception exc) {
                    NppGui.this.log("The climate data file contains errors. Data couldn't be loaded.", Level.SEVERE);
                    NppGui.this.clmFile = null;
                    NppGui.this.clmFileTextField.setText("");
                    NppGui.this.climateDataManager = null;
                    NppGui.this.runButton.setEnabled(false);
                    NppGui.this.setCursor(null);
                }
            }
        }

        private class ClimateFileFilter
        extends FileFilter {
            private ClimateFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".clm");
            }

            @Override
            public String getDescription() {
                return "Climate files (*.clm)";
            }
        }
    }

    private class DatFileChooseAction
    implements ActionListener {
        private DatFileChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String datPath = null;
            if (NppGui.this.userProperties != null && (datPath = NppGui.this.userProperties.getProperty("datFolder")) == null) {
                datPath = NppGui.this.userProperties.getProperty("dataFolder");
            }
            if (datPath == null && NppGui.this.defaultProperties != null && (datPath = NppGui.this.defaultProperties.getProperty("datFolder")) == null) {
                datPath = NppGui.this.defaultProperties.getProperty("dataFolder");
            }
            JFileChooser fileChooser = datPath == null ? new JFileChooser() : new JFileChooser(datPath);
            fileChooser.setFileFilter(new SiteDataFileFilter());
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.datFile = fileChooser.getSelectedFile();
                NppGui.this.datFileTextField.setText(NppGui.this.datFile.getAbsolutePath());
                try {
                    NppGui.this.log("Loading site data file: " + NppGui.this.datFile.getName(), Level.INFO);
                    NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    NppGui.this.loadSiteData();
                    if (NppGui.this.siteDataManager.isStaticBudget()) {
                        NppGui.this.log("The provided data indicate a 'Static' carbon budget", Level.INFO);
                    } else {
                        NppGui.this.log("The provided data indicate a 'Dynamic' carbon and nitrogen budget", Level.INFO);
                    }
                    NppGui.this.log("Site data successfully loaded", Level.CONFIG);
                    if (NppGui.this.clmFile != null) {
                        NppGui.this.runButton.setEnabled(true);
                        NppGui.this.log("Forest-BGC model can be runned now", Level.CONFIG);
                    }
                    NppGui.this.setCursor(null);
                }
                catch (Exception exc) {
                    NppGui.this.log("The site data file contains errors. Data couldn't be loaded.", Level.SEVERE);
                    NppGui.this.datFile = null;
                    NppGui.this.datFileTextField.setText("");
                    NppGui.this.siteDataManager = null;
                    NppGui.this.runButton.setEnabled(false);
                    NppGui.this.setCursor(null);
                }
            }
        }

        private class SiteDataFileFilter
        extends FileFilter {
            private SiteDataFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".dat");
            }

            @Override
            public String getDescription() {
                return "Site data files (*.dat)";
            }
        }
    }

    private class FolderOutputChooseAction
    implements ActionListener {
        private FolderOutputChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String folderOutputPath = null;
            if (NppGui.this.userProperties != null && (folderOutputPath = NppGui.this.userProperties.getProperty("outputFolder")) == null) {
                folderOutputPath = NppGui.this.userProperties.getProperty("outputFolder");
            }
            if (folderOutputPath == null && NppGui.this.defaultProperties != null && (folderOutputPath = NppGui.this.defaultProperties.getProperty("outputFolder")) == null) {
                folderOutputPath = NppGui.this.defaultProperties.getProperty("outputFolder");
            }
            JFileChooser fileChooser = folderOutputPath == null ? new JFileChooser() : new JFileChooser(folderOutputPath);
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.outputFolder = fileChooser.getSelectedFile();
                NppGui.this.folderOutputTextField.setText(NppGui.this.outputFolder.getAbsolutePath());
                NppGui.this.log("Ouputs folder selected: " + NppGui.this.outputFolder.getAbsolutePath(), Level.INFO);
            }
        }
    }

    private final class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 2531069603340756535L;
        private final Image image;

        public ImagePanel(Image image) {
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int h = this.image.getHeight(null);
            int w = this.image.getWidth(null);
            int hh = this.getHeight();
            int ww = this.getWidth();
            int x = 0;
            int y = 0;
            if (ww - w > 0) {
                x = (ww - w) / 2;
            } else {
                w = ww;
            }
            if (hh - h > 0) {
                x = (hh - h) / 2;
            } else {
                h = hh;
            }
            g.drawImage(this.image, x, y, w, h, null);
        }
    }

    private class LaiFileChooseAction
    implements ActionListener {
        private LaiFileChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String laiPath = null;
            if (NppGui.this.userProperties != null && (laiPath = NppGui.this.userProperties.getProperty("laiFolder")) == null) {
                laiPath = NppGui.this.userProperties.getProperty("dataFolder");
            }
            if (laiPath == null && NppGui.this.defaultProperties != null && (laiPath = NppGui.this.defaultProperties.getProperty("laiFolder")) == null) {
                laiPath = NppGui.this.defaultProperties.getProperty("dataFolder");
            }
            JFileChooser fileChooser = laiPath == null ? new JFileChooser() : new JFileChooser(laiPath);
            fileChooser.addChoosableFileFilter(new LaiFileFilter());
            fileChooser.addChoosableFileFilter(new Mod15FileFilter());
            fileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.laiFile = fileChooser.getSelectedFile();
                NppGui.this.laiFileTextField.setText(NppGui.this.laiFile.getAbsolutePath());
                try {
                    NppGui.this.dataTabbedPane.remove(NppGui.this.laiScrollPane);
                    NppGui.this.dataTabbedPane.remove(NppGui.this.mod15ScrollPane);
                    NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    if (NppGui.this.laiFile.getName().endsWith(".lai")) {
                        NppGui.this.log("Loading Leaf Area Index (LAI) file: " + NppGui.this.laiFile.getName(), Level.INFO);
                        NppGui.this.loadLaiData();
                    } else if (NppGui.this.laiFile.getName().endsWith(".hdf")) {
                        NppGui.this.log("Loading MODIS LAI (MOD-15) file: " + NppGui.this.laiFile.getName(), Level.INFO);
                        NppGui.this.loadMod15Data();
                    } else {
                        NppGui.this.log("Loading Landsat file: " + NppGui.this.laiFile.getName(), Level.INFO);
                        NppGui.this.loadLandsatData();
                    }
                    NppGui.this.laiFileRadioButton.setSelected(true);
                    NppGui.this.mapOutputCheckBox.setEnabled(true);
                    NppGui.this.log("LAI data successfully loaded", Level.CONFIG);
                    NppGui.this.setCursor(null);
                }
                catch (Exception exc) {
                    NppGui.this.log("The LAI data file contains errors. Data couldn't be loaded.", Level.SEVERE);
                    NppGui.this.laiFile = null;
                    NppGui.this.laiFileTextField.setText("");
                    NppGui.this.laiDataManager = null;
                    NppGui.this.setCursor(null);
                }
            }
        }

        private class LaiFileFilter
        extends FileFilter {
            private LaiFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".lai");
            }

            @Override
            public String getDescription() {
                return "Leaf Area Index (LAI) files (*.lai)";
            }
        }

        private class Mod15FileFilter
        extends FileFilter {
            private Mod15FileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".hdf");
            }

            @Override
            public String getDescription() {
                return "MOD-15 HDF files (*.hdf)";
            }
        }
    }

    private class LifFileChooseAction
    implements ActionListener {
        private LifFileChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lifPath = null;
            if (NppGui.this.userProperties != null && (lifPath = NppGui.this.userProperties.getProperty("lifFolder")) == null) {
                lifPath = NppGui.this.userProperties.getProperty("dataFolder");
            }
            if (lifPath == null && NppGui.this.defaultProperties != null && (lifPath = NppGui.this.defaultProperties.getProperty("lifFolder")) == null) {
                lifPath = NppGui.this.defaultProperties.getProperty("dataFolder");
            }
            JFileChooser fileChooser = lifPath == null ? new JFileChooser() : new JFileChooser(lifPath);
            fileChooser.setFileFilter(new DailyFileFilter());
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.lifFile = fileChooser.getSelectedFile();
                NppGui.this.lifFileTextField.setText(NppGui.this.lifFile.getAbsolutePath());
                try {
                    NppGui.this.log("Loading ontogeny file: " + NppGui.this.lifFile.getName(), Level.INFO);
                    NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    NppGui.this.loadDailyData();
                    NppGui.this.log("Ontogeny data successfully loaded", Level.CONFIG);
                    NppGui.this.setCursor(null);
                }
                catch (Exception exc) {
                    NppGui.this.log("The ontogeny data file contains errors. Data couldn't be loaded.", Level.SEVERE);
                    NppGui.this.lifFile = null;
                    NppGui.this.lifFileTextField.setText("");
                    NppGui.this.dailyDataManager = null;
                    NppGui.this.setCursor(null);
                }
            }
        }

        private class DailyFileFilter
        extends FileFilter {
            private DailyFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".lif");
            }

            @Override
            public String getDescription() {
                return "Ontogeny files (*.lif)";
            }
        }
    }

    private class OptionsOutputsAction
    implements ActionListener {
        private OptionsOutputsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ResetAction
    implements ActionListener {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NppGui.this.log("Model reset by user", Level.WARNING);
            NppGui.this.reset();
        }
    }

    private class RunAction
    implements ActionListener {
        private RunAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
            NppGui.this.clmFileButton.setEnabled(false);
            NppGui.this.datFileButton.setEnabled(false);
            NppGui.this.lifFileButton.setEnabled(false);
            NppGui.this.seaFileButton.setEnabled(false);
            NppGui.this.nolaiRadioButton.setEnabled(false);
            NppGui.this.laiFileRadioButton.setEnabled(false);
            NppGui.this.laiFileButton.setEnabled(false);
            NppGui.this.resumeOutputCheckBox.setEnabled(false);
            NppGui.this.dailyOutputCheckBox.setEnabled(false);
            NppGui.this.longOutputCheckBox.setEnabled(false);
            NppGui.this.mapOutputCheckBox.setEnabled(false);
            NppGui.this.startdaySpinner.setEnabled(false);
            NppGui.this.stopdaySpinner.setEnabled(false);
            NppGui.this.seasondaysSpinner.setEnabled(false);
            NppGui.this.carbonRatioSpinner.setEnabled(false);
            NppGui.this.runButton.setEnabled(false);
            NppGui.this.resetButton.setEnabled(false);
            if (NppGui.this.nolaiRadioButton.isSelected()) {
                NppGui.this.log("Running single-point ForestBGC model", Level.CONFIG);
                NppGui.this.progressBar.setIndeterminate(true);
                ForestBGC.getInstance().setClimateDataManager(NppGui.this.climateDataManager);
                ForestBGC.getInstance().setSiteDataManager(NppGui.this.siteDataManager);
                ForestBGC.getInstance().setDailyDataManager(NppGui.this.dailyDataManager);
                ForestBGC.getInstance().setSeasonDataManager(NppGui.this.seasonDataManager);
                String name = NppGui.this.datFile.getName();
                ForestBGC.getInstance().setName(name.substring(0, name.length() - 4));
                try {
                    ForestBGCResults results = (ForestBGCResults)ForestBGC.getInstance().estimate();
                    NppGui.this.log("Npp estimate concluded", Level.INFO);
                    NppGui.this.giveOutput(results, (Double)NppGui.this.carbonRatioSpinnerModel.getValue());
                    NppGui.this.progressBar.setIndeterminate(false);
                    NppGui.this.progressBar.setValue(100);
                }
                catch (Exception exc) {
                    NppGui.this.log("Forest-BGC model cannot estimate Npp for current data", Level.SEVERE);
                    NppGui.this.progressBar.setIndeterminate(false);
                    NppGui.this.progressBar.setValue(0);
                }
            } else {
                NppGui.this.log("Running global ForestBGC model", Level.CONFIG);
                NppGui.this.progressBar.setIndeterminate(true);
                GlobalForestBGC.getInstance().setClimateDataManager(NppGui.this.climateDataManager);
                GlobalForestBGC.getInstance().setSiteDataManager(NppGui.this.siteDataManager);
                GlobalForestBGC.getInstance().setDailyDataManager(NppGui.this.dailyDataManager);
                GlobalForestBGC.getInstance().setSeasonDataManager(NppGui.this.seasonDataManager);
                GlobalForestBGC.getInstance().setLaiDataManager(NppGui.this.laiDataManager);
                String name = NppGui.this.datFile.getName();
                GlobalForestBGC.getInstance().setName(name.substring(0, name.length() - 4));
                try {
                    NppGui.this.log("Forest-BGC is going to run " + NppGui.this.laiDataManager.getNumData() + " simulations. This could take a long time ...", Level.WARNING);
                    GlobalForestBGCResults results = (GlobalForestBGCResults)GlobalForestBGC.getInstance().estimate(NppGui.this.progressBar);
                    NppGui.this.log("Npp estimates concluded", Level.INFO);
                    NppGui.this.giveOutput(results, (Double)NppGui.this.carbonRatioSpinnerModel.getValue());
                    NppGui.this.progressBar.setIndeterminate(false);
                    NppGui.this.progressBar.setValue(100);
                }
                catch (Exception exc) {
                    NppGui.this.log("Forest-BGC model cannot estimate Npp for current data", Level.SEVERE);
                    NppGui.this.progressBar.setIndeterminate(false);
                    NppGui.this.progressBar.setValue(0);
                }
            }
            NppGui.this.clmFileButton.setEnabled(true);
            NppGui.this.datFileButton.setEnabled(true);
            NppGui.this.lifFileButton.setEnabled(true);
            NppGui.this.seaFileButton.setEnabled(true);
            NppGui.this.nolaiRadioButton.setEnabled(true);
            NppGui.this.laiFileRadioButton.setEnabled(true);
            NppGui.this.laiFileButton.setEnabled(true);
            NppGui.this.resumeOutputCheckBox.setEnabled(true);
            NppGui.this.dailyOutputCheckBox.setEnabled(true);
            NppGui.this.longOutputCheckBox.setEnabled(true);
            if (NppGui.this.laiDataManager != null) {
                NppGui.this.mapOutputCheckBox.setEnabled(true);
            }
            NppGui.this.startdaySpinner.setEnabled(true);
            NppGui.this.stopdaySpinner.setEnabled(true);
            NppGui.this.seasondaysSpinner.setEnabled(true);
            NppGui.this.carbonRatioSpinner.setEnabled(true);
            NppGui.this.runButton.setEnabled(true);
            NppGui.this.resetButton.setEnabled(true);
            NppGui.this.setCursor(null);
        }
    }

    private class SeaFileChooseAction
    implements ActionListener {
        private SeaFileChooseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String seaPath = null;
            if (NppGui.this.userProperties != null && (seaPath = NppGui.this.userProperties.getProperty("seaFolder")) == null) {
                seaPath = NppGui.this.userProperties.getProperty("dataFolder");
            }
            if (seaPath == null && NppGui.this.defaultProperties != null && (seaPath = NppGui.this.defaultProperties.getProperty("seaFolder")) == null) {
                seaPath = NppGui.this.defaultProperties.getProperty("dataFolder");
            }
            JFileChooser fileChooser = seaPath == null ? new JFileChooser() : new JFileChooser(seaPath);
            fileChooser.setFileFilter(new SeasonallyFileFilter());
            int returnVal = fileChooser.showOpenDialog(NppGui.this);
            if (returnVal == 0) {
                NppGui.this.seaFile = fileChooser.getSelectedFile();
                NppGui.this.seaFileTextField.setText(NppGui.this.seaFile.getAbsolutePath());
                try {
                    NppGui.this.log("Loading philogeny file: " + NppGui.this.seaFile.getName(), Level.INFO);
                    NppGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    NppGui.this.loadSeasonallyData();
                    NppGui.this.log("Philogeny data successfully loaded", Level.CONFIG);
                    NppGui.this.setCursor(null);
                }
                catch (Exception exc) {
                    NppGui.this.log("The philogeny data file contains errors. Data couldn't be loaded.", Level.SEVERE);
                    NppGui.this.seaFile = null;
                    NppGui.this.seaFileTextField.setText("");
                    NppGui.this.seasonDataManager = null;
                    NppGui.this.setCursor(null);
                }
            }
        }

        private class SeasonallyFileFilter
        extends FileFilter {
            private SeasonallyFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f != null && f.getName().toLowerCase().endsWith(".sea");
            }

            @Override
            public String getDescription() {
                return "Philogeny files (*.sea)";
            }
        }
    }
}

