/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import ncsa.hdf.object.Datatype;

public class H4Datatype
extends Datatype {
    public static final long serialVersionUID = 240L;

    public H4Datatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public H4Datatype(int n) {
        super(n);
        this.fromNative(n);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public void fromNative(int n) {
        this.datatypeOrder = -1;
        this.datatypeSign = -1;
        switch (n) {
            case 4: {
                this.datatypeClass = 2;
                this.datatypeSize = 1;
                break;
            }
            case 3: {
                this.datatypeClass = 2;
                this.datatypeSize = 1;
                this.datatypeSign = 0;
                break;
            }
            case 20: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                break;
            }
            case 21: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                this.datatypeSign = 0;
                break;
            }
            case 22: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                break;
            }
            case 23: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                this.datatypeSign = 0;
                break;
            }
            case 24: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                break;
            }
            case 25: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                this.datatypeSign = 0;
                break;
            }
            case 26: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                break;
            }
            case 27: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                this.datatypeSign = 0;
                break;
            }
            case 5: {
                this.datatypeClass = 1;
                this.datatypeSize = 4;
                break;
            }
            case 6: {
                this.datatypeClass = 1;
                this.datatypeSize = 8;
                break;
            }
            default: {
                this.datatypeClass = -1;
            }
        }
    }

    public static final Object allocateArray(int n, int n2) throws OutOfMemoryError {
        if (n2 <= 0) {
            return null;
        }
        Object[] objectArray = null;
        switch (n) {
            case 3: 
            case 4: 
            case 20: 
            case 21: {
                objectArray = new byte[n2];
                break;
            }
            case 22: 
            case 23: {
                objectArray = new short[n2];
                break;
            }
            case 24: 
            case 25: {
                objectArray = new int[n2];
                break;
            }
            case 26: 
            case 27: {
                objectArray = new long[n2];
                break;
            }
            case 5: {
                objectArray = new float[n2];
                break;
            }
            case 6: {
                objectArray = new double[n2];
                break;
            }
            default: {
                objectArray = null;
            }
        }
        return objectArray;
    }

    @Override
    public String getDatatypeDescription() {
        return H4Datatype.getDatatypeDescription(this.toNative());
    }

    public static final String getDatatypeDescription(int n) {
        String string = "Unknown";
        switch (n) {
            case 4: {
                string = "8-bit character";
                break;
            }
            case 3: {
                string = "8-bit unsigned character";
                break;
            }
            case 21: {
                string = "8-bit unsigned integer";
                break;
            }
            case 20: {
                string = "8-bit integer";
                break;
            }
            case 22: {
                string = "16-bit integer";
                break;
            }
            case 23: {
                string = "16-bit unsigned integer";
                break;
            }
            case 24: {
                string = "32-bit integer";
                break;
            }
            case 25: {
                string = "32-bit unsigned integer";
                break;
            }
            case 26: {
                string = "64-bit integer";
                break;
            }
            case 27: {
                string = "64-bit unsigned integer";
                break;
            }
            case 5: {
                string = "32-bit floating-point";
                break;
            }
            case 6: {
                string = "64-bit floating-point";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    @Override
    public boolean isUnsigned() {
        return H4Datatype.isUnsigned(this.toNative());
    }

    public static final boolean isUnsigned(int n) {
        boolean bl = false;
        switch (n) {
            case 3: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int toNative() {
        int n = -1;
        int n2 = this.getDatatypeClass();
        int n3 = this.getDatatypeSize();
        int n4 = this.getDatatypeOrder();
        int n5 = this.getDatatypeSign();
        switch (n2) {
            case 0: {
                if (n3 == 1) {
                    if (n5 == 0) {
                        n = 21;
                        break;
                    }
                    n = 20;
                    break;
                }
                if (n3 == 2) {
                    if (n5 == 0) {
                        n = 23;
                        break;
                    }
                    n = 22;
                    break;
                }
                if (n3 == 4 || n3 == -1) {
                    if (n5 == 0) {
                        n = 25;
                        break;
                    }
                    n = 24;
                    break;
                }
                if (n3 != 8) break;
                if (n5 == 0) {
                    n = 27;
                    break;
                }
                n = 26;
                break;
            }
            case 1: {
                if (n3 == -1) {
                    n = 5;
                    break;
                }
                if (n3 == 4) {
                    n = 5;
                    break;
                }
                if (n3 != 8) break;
                n = 6;
                break;
            }
            case 2: {
                if (n5 == 0) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            case 3: {
                n = 4;
            }
        }
        return n;
    }

    @Override
    public void close(int n) {
    }
}

