/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultTreeView;
import ncsa.hdf.view.FileConversionDialog;
import ncsa.hdf.view.HelpView;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.UserOptionsDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class HDFView
extends JFrame
implements ViewManager,
ActionListener,
HyperlinkListener,
ChangeListener,
DropTargetListener {
    public static final long serialVersionUID = 240L;
    public static final int MODULE_TREEVIEW = 100;
    public static final int MODULE_IMAGEVIEW = 101;
    public static final int MODULE_TABLEVIEW = 102;
    public static final int MODULE_TEXTVIEW = 103;
    public static final int MODULE_METADATAVIEW = 104;
    public static final int MODULE_PALETTEVIEW = 105;
    private static List treeViews;
    private static List imageViews;
    private static List tableViews;
    private static List textViews;
    private static List metaDataViews;
    private static List paletteViews;
    private static List helpViews;
    private static final String aboutHDFView;
    private static final String JAVA_COMPILER;
    private String rootDir;
    private String currentDir;
    private String currentFile;
    private ViewProperties props;
    private TreeView treeView;
    private int frameOffset;
    private final JDesktopPane contentPane;
    private final JTextArea statusArea;
    private final JTextArea attributeArea;
    private final JTabbedPane infoTabbedPane;
    private JMenuBar menuBar;
    private final JMenu windowMenu;
    private final JMenu fileMenu;
    private final JFrame usersGuideWindow;
    private final JEditorPane usersGuideEditorPane;
    private final StringBuffer message;
    private final StringBuffer metadata;
    private final Toolkit toolkit;
    private final List editGUIs;
    private final List h5GUIs;
    private final List h4GUIs;
    private URL usersGuideURL;
    private URL previousUsersGuideURL;
    private JTextField ugField;
    private Stack visitedUsersGuideURLs;
    private JButton usersGuideBackButton;
    private JComboBox urlBar;
    private UserOptionsDialog userOptionDialog;
    private Constructor ctrSrbFileDialog = null;
    private JDialog srbFileDialog = null;

    public HDFView(String string, List list, int n, int n2, int n3, int n4) {
        super("HDFView");
        Object object;
        this.setDefaultCloseOperation(2);
        this.rootDir = string;
        this.currentFile = null;
        this.frameOffset = 0;
        this.userOptionDialog = null;
        this.ctrSrbFileDialog = null;
        this.toolkit = Toolkit.getDefaultToolkit();
        ViewProperties.loadIcons(this.rootDir);
        ViewProperties.loadExtClass();
        this.editGUIs = new Vector();
        this.h4GUIs = new Vector();
        this.h5GUIs = new Vector();
        this.props = new ViewProperties(this.rootDir);
        try {
            this.props.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentDir = ViewProperties.getWorkDir();
        if (this.currentDir == null) {
            this.currentDir = System.getProperty("user.dir");
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        helpViews = ViewProperties.getHelpViewList();
        this.statusArea = new JTextArea();
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(new Color(240, 240, 240));
        this.statusArea.setLineWrap(true);
        this.message = new StringBuffer();
        this.metadata = new StringBuffer();
        this.showStatus("HDFView root - " + this.rootDir);
        this.showStatus("User property file - " + ViewProperties.getPropertyFile());
        this.attributeArea = new JTextArea();
        this.attributeArea.setEditable(false);
        this.attributeArea.setBackground(new Color(240, 240, 240));
        this.attributeArea.setLineWrap(true);
        this.infoTabbedPane = new JTabbedPane(3);
        this.infoTabbedPane.addChangeListener(this);
        this.usersGuideWindow = new JFrame("HDFView User's Guide");
        this.usersGuideEditorPane = new JEditorPane();
        this.contentPane = new JDesktopPane();
        this.windowMenu = new JMenu("Window");
        this.fileMenu = new JMenu("File");
        int n5 = treeViews.size();
        Class<?> clazz = null;
        for (int i = 0; i < n5; ++i) {
            object = (String)treeViews.get(i);
            try {
                clazz = Class.forName((String)object);
            }
            catch (Exception exception) {
                try {
                    clazz = ViewProperties.loadExtClass().loadClass((String)object);
                }
                catch (Exception exception2) {
                    clazz = null;
                }
            }
            if (clazz != null) break;
        }
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Class.forName("ncsa.hdf.view.ViewManager")};
                object = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this};
                this.treeView = (TreeView)((Constructor)object).newInstance(objectArray);
            }
            catch (Exception exception) {
                this.treeView = null;
            }
        }
        if (this.treeView == null) {
            this.treeView = new DefaultTreeView(this);
        }
        this.createMainWindow(n, n2, n3, n4);
        try {
            Font font = null;
            object = ViewProperties.getFontType();
            int n6 = ViewProperties.getFontSize();
            try {
                font = new Font((String)object, 0, n6);
            }
            catch (Exception exception) {
                font = null;
            }
            if (font != null) {
                this.updateFontSize(font);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pack();
        new DropTarget(this, this);
        int n7 = list.size();
        object = null;
        for (int i = 0; i < n7; ++i) {
            object = (File)list.get(i);
            if (((File)object).isFile()) {
                this.currentDir = ((File)object).getParentFile().getAbsolutePath();
                this.currentFile = ((File)object).getAbsolutePath();
                try {
                    this.treeView.openFile(this.currentFile, 1);
                    try {
                        this.urlBar.removeItem(this.currentFile);
                        this.urlBar.insertItemAt(this.currentFile, 0);
                        this.urlBar.setSelectedIndex(0);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    this.showStatus(exception.toString());
                }
                continue;
            }
            this.currentDir = ((File)object).getAbsolutePath();
        }
        if (FileFormat.getFileFormat("HDF") == null) {
            HDFView.setEnabled(this.h4GUIs, false);
        }
        if (FileFormat.getFileFormat("HDF5") == null) {
            HDFView.setEnabled(this.h5GUIs, false);
        }
    }

    private void updateFontSize(Font font) {
        if (font == null) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        for (Object k : uIDefaults.keySet()) {
            if (uIDefaults.getFont(k) == null) continue;
            UIManager.put(k, new FontUIResource(font));
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void createMainWindow(int n, int n2, int n3, int n4) {
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.treeView));
        JScrollPane jScrollPane2 = new JScrollPane(this.contentPane);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(200);
        this.infoTabbedPane.addTab("Log Info", new JScrollPane(this.statusArea));
        this.infoTabbedPane.addTab("Metadata ", new JScrollPane(this.attributeArea));
        this.infoTabbedPane.setSelectedIndex(1);
        jSplitPane.setBorder(null);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.infoTabbedPane);
        float f = 0.04f;
        Dimension dimension = this.toolkit.getScreenSize();
        dimension.height = n2 > 300 ? n2 : (int)((1.0f - 2.0f * f) * (float)dimension.height);
        dimension.width = n > 300 ? n : (int)(0.9 * (double)dimension.height);
        if (this.treeView.getClass().getName().startsWith("ext.erdc")) {
            jSplitPane.setDividerLocation(500);
            dimension.width = (int)(0.9 * (double)this.toolkit.getScreenSize().width);
            dimension.height = (int)((double)dimension.width * 0.618);
        }
        jSplitPane2.setDividerLocation(dimension.height - 180);
        this.setLocation(n3, n4);
        try {
            this.setIconImage(((ImageIcon)ViewProperties.getHdfIcon()).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.menuBar = this.createMenuBar();
        this.setJMenuBar(this.menuBar);
        JToolBar jToolBar = this.createToolBar();
        this.urlBar = new JComboBox(ViewProperties.getMRF());
        this.urlBar.setMaximumRowCount(15);
        this.urlBar.setEditable(true);
        this.urlBar.addActionListener(this);
        this.urlBar.setActionCommand("Open file: from file bar");
        this.urlBar.setSelectedIndex(-1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("File/URL");
        jPanel.add((Component)jButton, "West");
        jButton.addActionListener(this);
        jButton.setActionCommand("Popup URL list");
        jPanel.add((Component)this.urlBar, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 0, 0));
        jPanel2.add(jToolBar);
        jPanel2.add(jPanel);
        JPanel jPanel3 = (JPanel)this.getContentPane();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jSplitPane2, "Center");
        jPanel3.setPreferredSize(dimension);
        this.createUsersGuidePane();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        this.fileMenu.setMnemonic('f');
        jMenuBar.add(this.fileMenu);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open Read-Only");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open file read-only");
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        JMenu jMenu2 = new JMenu("New");
        jMenuItem = new JMenuItem("HDF4");
        jMenuItem.setActionCommand("New HDF4 file");
        jMenuItem.setMnemonic(52);
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5");
        jMenuItem.setActionCommand("New HDF5 file");
        jMenuItem.setMnemonic(53);
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu2.add(jMenuItem);
        this.fileMenu.add(jMenu2);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close file");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close all file");
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save current file");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save current file as");
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(69);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Exit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2, true));
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        this.windowMenu.setMnemonic('w');
        jMenuBar.add(this.windowMenu);
        jMenuItem = new JMenuItem("Cascade");
        jMenuItem.setMnemonic(67);
        jMenuItem.setActionCommand("Cascade all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Tile");
        jMenuItem.setMnemonic(84);
        jMenuItem.setActionCommand("Tile all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        this.windowMenu.addSeparator();
        jMenuItem = new JMenuItem("Close Window");
        jMenuItem.setMnemonic(87);
        jMenuItem.setActionCommand("Close a window");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("Close all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        this.windowMenu.addSeparator();
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JMenu jMenu3 = new JMenu("Convert Image To");
        jMenuItem = new JMenuItem("HDF4");
        jMenuItem.setActionCommand("Convert image file: Image to HDF4");
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5");
        jMenuItem.setActionCommand("Convert image file: Image to HDF5");
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu3.add(jMenuItem);
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("User Options");
        jMenuItem.setMnemonic(79);
        jMenuItem.setActionCommand("User options");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Register File Format");
        jMenuItem.setMnemonic(82);
        jMenuItem.setActionCommand("Register file format");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Unregister File Format");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("Unregister file format");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic('H');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("User's Guide");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("Users guide");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        if (helpViews != null && helpViews.size() > 0) {
            int n = helpViews.size();
            for (int i = 0; i < n; ++i) {
                HelpView helpView = (HelpView)helpViews.get(i);
                jMenuItem = new JMenuItem(helpView.getLabel());
                jMenuItem.setActionCommand(helpView.getActionCommand());
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            jMenu.addSeparator();
        }
        jMenuItem = new JMenuItem("HDF4 Library Version");
        jMenuItem.setMnemonic(52);
        jMenuItem.setActionCommand("HDF4 library");
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5 Library Version");
        jMenuItem.setMnemonic(53);
        jMenuItem.setActionCommand("HDF5 library");
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Java Version");
        jMenuItem.setMnemonic(53);
        jMenuItem.setActionCommand("Java version");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Supported File Formats");
        jMenuItem.setMnemonic(76);
        jMenuItem.setActionCommand("File format list");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("About...");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(ViewProperties.getFileopenIcon());
        jToolBar.add(jButton);
        jButton.setToolTipText("Open");
        jButton.addActionListener(this);
        jButton.setActionCommand("Open file");
        jButton = new JButton(ViewProperties.getFilecloseIcon());
        jToolBar.add(jButton);
        jButton.setToolTipText("Close");
        jButton.addActionListener(this);
        jButton.setActionCommand("Close file");
        jToolBar.addSeparator(new Dimension(20, 20));
        jButton = new JButton(ViewProperties.getHelpIcon());
        jToolBar.add(jButton);
        jButton.setToolTipText("Help");
        jButton.addActionListener(this);
        jButton.setActionCommand("Users guide");
        jButton = new JButton(ViewProperties.getH4Icon());
        jToolBar.add(jButton);
        jButton.setToolTipText("HDF4 Library Version");
        jButton.addActionListener(this);
        jButton.setActionCommand("HDF4 library");
        if (FileFormat.getFileFormat("HDF") == null) {
            jButton.setEnabled(false);
        }
        jButton = new JButton(ViewProperties.getH5Icon());
        jToolBar.add(jButton);
        jButton.setToolTipText("HDF5 Library Version");
        jButton.addActionListener(this);
        jButton.setActionCommand("HDF5 library");
        if (FileFormat.getFileFormat("HDF5") == null) {
            jButton.setEnabled(false);
        }
        return jToolBar;
    }

    private void createUsersGuidePane() {
        Object object;
        String string = ViewProperties.getUsersGuide();
        try {
            this.usersGuideURL = new URL(string);
            this.usersGuideEditorPane.setPage(this.usersGuideURL);
        }
        catch (Exception exception) {
            this.usersGuideURL = null;
            this.showStatus(exception.toString());
        }
        if (this.usersGuideURL == null) {
            object = System.getProperty("file.separator");
            try {
                string = "file:" + this.rootDir + (String)object + "UsersGuide" + (String)object + "index.html";
                ViewProperties.setUsersGuide(string);
                this.usersGuideURL = new URL(string);
            }
            catch (Exception exception) {
                this.usersGuideURL = null;
                this.showStatus(exception.toString());
            }
        }
        if (this.usersGuideURL == null) {
            return;
        }
        this.showStatus(this.usersGuideURL.toString());
        this.previousUsersGuideURL = this.usersGuideURL;
        this.visitedUsersGuideURLs = new Stack();
        this.usersGuideWindow.setLocation(20, 20);
        this.usersGuideWindow.setSize(800, 850);
        ((JPanel)this.usersGuideWindow.getContentPane()).setPreferredSize(new Dimension(500, 600));
        try {
            object = ((ImageIcon)ViewProperties.getHelpIcon()).getImage();
            this.usersGuideWindow.setIconImage((Image)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new JToolBar();
        JButton jButton = new JButton(ViewProperties.getFirstIcon());
        ((Container)object).add(jButton);
        jButton.setToolTipText("Home");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
        jButton.setActionCommand("Users guide home");
        jButton = new JButton(ViewProperties.getPreviousIcon());
        ((Container)object).add(jButton);
        jButton.setToolTipText("Back");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
        jButton.setActionCommand("Users guide back");
        jButton.setEnabled(false);
        this.usersGuideBackButton = jButton;
        jButton = new JButton("Close");
        ((JToolBar)object).addSeparator();
        ((JToolBar)object).addSeparator();
        ((Container)object).add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
        jButton.setActionCommand("Close users guide");
        this.usersGuideEditorPane.setEditable(false);
        try {
            this.usersGuideEditorPane.setPage(this.usersGuideURL);
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
        }
        this.usersGuideEditorPane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.usersGuideEditorPane);
        JPanel jPanel = (JPanel)this.usersGuideWindow.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add((Component)object);
        this.ugField = new JTextField();
        jPanel2.add(this.ugField);
        this.ugField.setEditable(false);
        if (this.usersGuideURL != null) {
            this.ugField.setText(this.usersGuideURL.toString());
        }
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
    }

    private void showWindow(String string) {
        int n = this.contentPane.getComponentCount();
        if (n <= 0) {
            return;
        }
        Component component = null;
        JInternalFrame jInternalFrame = null;
        for (int i = 0; i < n; ++i) {
            component = this.contentPane.getComponent(i);
            if (!(component instanceof JInternalFrame) || !(jInternalFrame = (JInternalFrame)this.contentPane.getComponent(i)).getName().equals(string)) continue;
            jInternalFrame.toFront();
            return;
        }
    }

    private void cascadeWindow() {
        int n = 2;
        int n2 = 2;
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        Dimension dimension = this.contentPane.getSize();
        int n3 = Math.max(50, dimension.width - 100);
        int n4 = Math.max(50, dimension.height - 100);
        for (int i = 0; i < componentArray.length; ++i) {
            jInternalFrame = (JInternalFrame)componentArray[i];
            jInternalFrame.setBounds(n2, n, n3, n4);
            this.contentPane.moveToFront(jInternalFrame);
            n2 += 20;
            n += 20;
        }
    }

    private void tileWindow() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        int n4 = componentArray.length;
        int n5 = (int)Math.sqrt(n4);
        int n6 = (int)Math.ceil((double)n4 / (double)n5);
        Dimension dimension = this.contentPane.getSize();
        int n7 = dimension.width / n5;
        int n8 = dimension.height / n6;
        for (int i = 0; i < n6; ++i) {
            n2 = 0;
            for (int j = 0; j < n5; ++j) {
                n3 = i * n5 + j;
                if (n3 >= n4) {
                    return;
                }
                jInternalFrame = (JInternalFrame)componentArray[n3];
                jInternalFrame.setBounds(n2, n, n7, n8);
                n2 += n7;
            }
            n += n8;
        }
    }

    private void closeAllWindow() {
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            jInternalFrame = (JInternalFrame)componentArray[i];
            jInternalFrame.dispose();
            jInternalFrame = null;
        }
    }

    private static void setEnabled(List list, boolean bl) {
        Component component2 = null;
        for (Component component2 : list) {
            component2.setEnabled(bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Exit")) {
            this.dispose();
            return;
        }
        if (string.startsWith("Open file")) {
            int n = 1;
            String string2 = null;
            if (string.equals("Open file: from file bar")) {
                string2 = (String)this.urlBar.getSelectedItem();
                if (string2 == null) return;
                if (string2.length() < 1) {
                    return;
                }
                if (!string2.startsWith("http://") && !string2.startsWith("ftp://")) {
                    File file = new File(string2);
                    if (!file.exists()) {
                        return;
                    }
                    if (file.isDirectory()) {
                        this.currentDir = string2;
                        string2 = this.openLocalFile();
                    }
                }
            } else if (string.equals("Open file read-only")) {
                n = 0;
                string2 = this.openLocalFile();
            } else {
                string2 = string.startsWith("Open file://") ? string.substring(12) : this.openLocalFile();
            }
            if (string2 == null) {
                return;
            }
            if (string2.startsWith("http://") || string2.startsWith("ftp://")) {
                string2 = this.openRemoteFile(string2);
            }
            if (string2 == null) return;
            if (string2.length() < 1) return;
            if (string2.equals(this.currentFile)) {
                return;
            }
            this.currentFile = string2;
            try {
                this.urlBar.removeItem(string2);
                this.urlBar.insertItemAt(string2, 0);
                this.urlBar.setSelectedIndex(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.treeView.openFile(string2, n);
                return;
            }
            catch (Throwable throwable) {
                try {
                    this.treeView.openFile(string2, 0);
                    return;
                }
                catch (Throwable throwable2) {
                    String string3 = "Failed to open file " + string2 + "\n" + throwable2;
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, string3, this.getTitle(), 0);
                }
            }
            return;
        }
        if (string.equals("Open from irods")) {
            try {
                this.openFromSRB();
                return;
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            }
            return;
        }
        if (string.startsWith("New HDF")) {
            NewFileDialog newFileDialog;
            String string4 = "HDF5";
            if (string.equals("New HDF4 file")) {
                string4 = "HDF";
            }
            if (!(newFileDialog = new NewFileDialog(this, this.currentDir, string4, this.treeView.getCurrentFiles())).isFileCreated()) {
                return;
            }
            String string5 = newFileDialog.getFile();
            if (string5 == null) {
                return;
            }
            try {
                this.treeView.openFile(string5, 1);
                this.currentFile = string5;
                try {
                    this.urlBar.removeItem(string5);
                    this.urlBar.insertItemAt(string5, 0);
                    this.urlBar.setSelectedIndex(0);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception.getMessage() + "\n" + string5, this.getTitle(), 0);
            }
            return;
        }
        if (string.equals("Close file")) {
            FileFormat fileFormat = this.treeView.getSelectedFile();
            if (fileFormat == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Select a file to close", this.getTitle(), 0);
                return;
            }
            JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
            if (jInternalFrameArray != null) {
                for (int i = 0; i < jInternalFrameArray.length; ++i) {
                    HObject hObject = ((DataView)((Object)jInternalFrameArray[i])).getDataObject();
                    if (hObject == null || !hObject.getFileFormat().equals(fileFormat)) continue;
                    jInternalFrameArray[i].dispose();
                    jInternalFrameArray[i] = null;
                }
            }
            String string6 = (String)this.urlBar.getSelectedItem();
            if (fileFormat.getFilePath().equals(string6)) {
                this.currentFile = null;
                this.urlBar.setSelectedIndex(-1);
            }
            try {
                this.treeView.closeFile(fileFormat);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileFormat = null;
            System.gc();
            return;
        }
        if (string.equals("Close all file")) {
            this.closeAllWindow();
            List list = this.treeView.getCurrentFiles();
            while (!list.isEmpty()) {
                try {
                    this.treeView.closeFile((FileFormat)list.get(0));
                }
                catch (Exception exception) {}
            }
            this.currentFile = null;
            return;
        }
        if (string.equals("Save current file as")) {
            try {
                this.treeView.saveFile(this.treeView.getSelectedFile());
                return;
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            }
            return;
        }
        if (string.equals("Save current file")) {
            try {
                FileFormat fileFormat = this.treeView.getSelectedFile();
                List list = this.getDataViews();
                Object var5_42 = null;
                TableView tableView = null;
                TextView textView = null;
                FileFormat fileFormat2 = null;
                if (list == null) return;
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    var5_42 = list.get(n2);
                    if (var5_42 instanceof TableView) {
                        tableView = var5_42;
                        fileFormat2 = tableView.getDataObject().getFileFormat();
                        if (fileFormat.equals(fileFormat2)) {
                            tableView.updateValueInFile();
                        }
                    } else if (var5_42 instanceof TextView && fileFormat.equals(fileFormat2 = (textView = (TextView)var5_42).getDataObject().getFileFormat())) {
                        textView.updateValueInFile();
                    }
                    ++n2;
                }
                return;
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                return;
            }
        }
        if (string.equals("Cascade all windows")) {
            this.cascadeWindow();
            return;
        }
        if (string.equals("Tile all windows")) {
            this.tileWindow();
            return;
        }
        if (string.equals("Close a window")) {
            JInternalFrame jInternalFrame = this.contentPane.getSelectedFrame();
            if (jInternalFrame == null) return;
            jInternalFrame.dispose();
            return;
        }
        if (string.equals("Close all windows")) {
            this.closeAllWindow();
            return;
        }
        if (string.startsWith("SHOW WINDOW")) {
            this.showWindow(string);
            return;
        }
        if (string.startsWith("Convert image file:")) {
            String string7 = null;
            String string8 = null;
            if (string.equals("Convert image file: Image to HDF5")) {
                string7 = "IMG";
                string8 = "HDF5";
            } else {
                if (!string.equals("Convert image file: Image to HDF4")) return;
                string7 = "IMG";
                string8 = "HDF";
            }
            FileConversionDialog fileConversionDialog = new FileConversionDialog(this, string7, string8, this.currentDir, this.treeView.getCurrentFiles());
            fileConversionDialog.setVisible(true);
            if (!fileConversionDialog.isFileConverted()) return;
            String string9 = fileConversionDialog.getConvertedFile();
            File file = new File(string9);
            if (!file.exists()) return;
            if (!file.exists()) {
                return;
            }
            this.currentDir = file.getParentFile().getAbsolutePath();
            this.currentFile = file.getAbsolutePath();
            try {
                this.treeView.openFile(string9, 1);
                try {
                    this.urlBar.removeItem(string9);
                    this.urlBar.insertItemAt(string9, 0);
                    this.urlBar.setSelectedIndex(0);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            catch (Exception exception) {
                this.showStatus(exception.toString());
            }
            return;
        }
        if (string.equals("User options")) {
            Object object;
            if (this.userOptionDialog == null) {
                this.userOptionDialog = new UserOptionsDialog(this, this.rootDir);
            }
            this.userOptionDialog.setVisible(true);
            if (this.userOptionDialog.isWorkDirChanged()) {
                this.currentDir = ViewProperties.getWorkDir();
            }
            if (this.userOptionDialog.isUserGuideChanged()) {
                object = ViewProperties.getUsersGuide();
                try {
                    this.usersGuideURL = new URL((String)object);
                }
                catch (Exception exception) {
                    this.showStatus(exception.toString());
                    return;
                }
                this.visitedUsersGuideURLs.clear();
                try {
                    this.usersGuideEditorPane.setPage(this.usersGuideURL);
                    this.ugField.setText((String)object);
                }
                catch (IOException iOException) {
                    this.showStatus(iOException.toString());
                }
            }
            if (!this.userOptionDialog.isFontChanged()) return;
            object = null;
            try {
                object = new Font(ViewProperties.getFontType(), 0, ViewProperties.getFontSize());
            }
            catch (Exception exception) {
                return;
            }
            if (object == null) return;
            this.updateFontSize((Font)object);
            return;
        }
        if (string.equals("Register file format")) {
            String string10 = "Register a new file format by \nKEY:FILE_FORMAT:FILE_EXTENSION\nwhere, KEY: the unique identifier for the file format\n           FILE_FORMAT: the full class name of the file format\n           FILE_EXTENSION: the file extension for the file format\n\nFor example, the following line registers HDF4 file format:\nHDF:ncsa.hdf.object.h4.H4File:hdf\n\n";
            String string11 = JOptionPane.showInputDialog(this, (Object)string10);
            if (string11 == null) return;
            if (string11.length() < 1) {
                return;
            }
            int n = string11.indexOf(58);
            int n3 = string11.lastIndexOf(58);
            if (n < 0 || n3 <= n) {
                JOptionPane.showMessageDialog(this, "Failed to register " + string11 + "\n\nMust in the form of KEY:FILE_FORMAT:FILE_EXTENSION", "Register File Format", 0);
                return;
            }
            String string12 = string11.substring(0, n);
            String string13 = string11.substring(n + 1, n3);
            String string14 = string11.substring(n3 + 1);
            String string15 = null;
            String string16 = null;
            Enumeration enumeration = FileFormat.getFileFormatKeys();
            while (enumeration.hasMoreElements()) {
                string15 = (String)enumeration.nextElement();
                if (string15.endsWith(string12)) {
                    JOptionPane.showMessageDialog(this, "Invalid key: " + string12 + " is taken.", "Register File Format", 0);
                    return;
                }
                string16 = FileFormat.getFileFormat(string15).getClass().getName();
                if (!string16.endsWith(string13)) continue;
                JOptionPane.showMessageDialog(this, "The file format has already been registered: " + string13, "Register File Format", 0);
                return;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string13);
            }
            catch (Exception exception) {
                try {
                    clazz = ViewProperties.loadExtClass().loadClass(string13);
                }
                catch (Exception exception2) {
                    return;
                }
            }
            if (clazz == null) {
                return;
            }
            try {
                Object obj = clazz.newInstance();
                if (obj instanceof FileFormat) {
                    FileFormat.addFileFormat(string12, (FileFormat)obj);
                }
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, "Failed to register " + string11 + "\n\n" + throwable, "Register File Format", 0);
                return;
            }
            if (string14 == null) return;
            if (string14.length() <= 0) return;
            string14 = string14.trim();
            String string18 = ViewProperties.getFileExtension();
            string18 = string18 + ", " + string14;
            ViewProperties.setFileExtension(string18);
            return;
        }
        if (string.equals("Unregister file format")) {
            Enumeration enumeration = FileFormat.getFileFormatKeys();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            String string19 = (String)JOptionPane.showInputDialog(this, "Unregister file format", "Unregister file format", 2, ViewProperties.getHdfIcon(), arrayList.toArray(), null);
            if (string19 == null) {
                return;
            }
            FileFormat.removeFileFormat(string19);
            return;
        } else if (string.equals("Users guide")) {
            if (this.usersGuideURL == null) return;
            this.usersGuideWindow.setVisible(true);
            return;
        } else if (string.equals("Close users guide")) {
            if (this.usersGuideURL == null) return;
            this.usersGuideWindow.setVisible(false);
            return;
        } else if (string.equals("Users guide home")) {
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this.usersGuideEditorPane, HyperlinkEvent.EventType.ACTIVATED, this.usersGuideURL);
            this.hyperlinkUpdate(hyperlinkEvent);
            return;
        } else if (string.equals("Users guide back")) {
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this.usersGuideEditorPane, HyperlinkEvent.EventType.ACTIVATED, (URL)this.visitedUsersGuideURLs.pop());
            this.hyperlinkUpdate(hyperlinkEvent);
            this.visitedUsersGuideURLs.pop();
            if (!this.visitedUsersGuideURLs.empty()) return;
            this.usersGuideBackButton.setEnabled(false);
            return;
        } else if (string.equals("HDF4 library")) {
            FileFormat fileFormat = FileFormat.getFileFormat("HDF");
            if (fileFormat == null) {
                return;
            }
            JOptionPane.showMessageDialog(this, fileFormat.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (string.equals("HDF5 library")) {
            FileFormat fileFormat = FileFormat.getFileFormat("HDF5");
            if (fileFormat == null) {
                return;
            }
            JOptionPane.showMessageDialog(this, fileFormat.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (string.equals("Java version")) {
            String string20 = "Compiled at " + JAVA_COMPILER + "\nRunning at " + System.getProperty("java.vm.version");
            JOptionPane.showMessageDialog(this, string20, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (string.equals("File format list")) {
            FileFormat[] fileFormatArray = FileFormat.getFileFormats();
            if (fileFormatArray == null) return;
            if (fileFormatArray.length <= 0) {
                return;
            }
            String string21 = "\nSupported File Formats: \n";
            for (int i = 0; i < fileFormatArray.length; ++i) {
                string21 = string21 + "        " + fileFormatArray[i].getClass().getName() + "\n";
            }
            JOptionPane.showMessageDialog(this, string21, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (string.equals("About")) {
            JOptionPane.showMessageDialog(this, aboutHDFView, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (string.equals("Popup URL list")) {
            this.urlBar.setPopupVisible(true);
            return;
        } else {
            if (helpViews == null) return;
            if (helpViews.size() <= 0) {
                return;
            }
            int n = helpViews.size();
            int n4 = 0;
            while (n4 < n) {
                HelpView helpView = (HelpView)helpViews.get(n4);
                if (string.equals(helpView.getActionCommand())) {
                    helpView.show();
                    return;
                }
                ++n4;
            }
            return;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            try {
                URL uRL = hyperlinkEvent.getURL();
                String string = uRL.getFile();
                string = string.toLowerCase();
                if (string.length() <= 1 || !string.endsWith("html") && !string.endsWith("htm")) {
                    return;
                }
                jEditorPane.setPage(uRL);
                if (this.visitedUsersGuideURLs.isEmpty()) {
                    this.usersGuideBackButton.setEnabled(true);
                }
                this.visitedUsersGuideURLs.push(this.previousUsersGuideURL);
                this.previousUsersGuideURL = uRL;
                this.ugField.setText(uRL.toString());
            }
            catch (Throwable throwable) {
                try {
                    jEditorPane.setPage(this.previousUsersGuideURL);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                this.showStatus(throwable.toString());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Object object = changeEvent.getSource();
        if (object.equals(this.infoTabbedPane) && (n = this.infoTabbedPane.getSelectedIndex()) == 1) {
            this.attributeArea.setText("");
            this.showMetaData(this.treeView.getCurrentObject());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block11: {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        String string;
                        File file = (File)list.get(i);
                        if (file.isDirectory()) continue;
                        this.currentFile = string = file.getAbsolutePath();
                        try {
                            this.treeView.openFile(string, 1);
                        }
                        catch (Throwable throwable) {
                            try {
                                this.treeView.openFile(string, 0);
                            }
                            catch (Throwable throwable2) {
                                String string2 = "Failed to open file " + string + "\n" + throwable2;
                                this.toolkit.beep();
                                JOptionPane.showMessageDialog(this, string2, this.getTitle(), 0);
                                continue;
                            }
                        }
                        try {
                            this.urlBar.removeItem(string);
                            this.urlBar.insertItemAt(string, 0);
                            this.urlBar.setSelectedIndex(0);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    break block11;
                }
                dropTargetDropEvent.rejectDrop();
            }
            catch (IOException iOException) {
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dispose() {
        try {
            this.props.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeAllWindow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            List list = this.treeView.getCurrentFiles();
            if (list != null && list.size() > 0) {
                Object[] objectArray = list.toArray();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        this.treeView.closeFile((FileFormat)objectArray[i]);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public void addDataView(DataView dataView) {
        Object object;
        if (dataView == null) {
            return;
        }
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported DataView: the dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        JInternalFrame jInternalFrame = null;
        if (jInternalFrameArray != null) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!dataView.equals(jInternalFrameArray[i])) continue;
                jInternalFrame = jInternalFrameArray[i];
                break;
            }
        }
        if (jInternalFrame != null) {
            jInternalFrame.toFront();
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        JInternalFrame jInternalFrame2 = (JInternalFrame)((Object)dataView);
        this.contentPane.add(jInternalFrame2);
        HObject hObject = dataView.getDataObject();
        String string = hObject.getPath() + hObject.getName();
        String string2 = "SHOW WINDOW" + hObject.getFID() + string;
        jInternalFrame2.setName(string2);
        jInternalFrame2.setMaximizable(true);
        jInternalFrame2.setClosable(true);
        jInternalFrame2.setResizable(true);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        if (this.windowMenu.getMenuComponentCount() == 6) {
            object = this.windowMenu.getMenuComponents();
            for (int i = 0; i < 6; ++i) {
                object[i].setEnabled(true);
            }
        }
        this.windowMenu.add(jMenuItem);
        jInternalFrame2.setLocation(this.frameOffset, this.frameOffset);
        this.frameOffset = this.frameOffset < 60 ? (this.frameOffset += 15) : 0;
        object = this.contentPane.getSize();
        jInternalFrame2.setSize(object.width - 60, object.height - 60);
        jInternalFrame2.show();
    }

    @Override
    public void removeDataView(DataView dataView) {
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)dataView);
        String string = jInternalFrame.getName();
        int n = this.windowMenu.getItemCount();
        JMenuItem jMenuItem = null;
        for (int i = 6; i < n; ++i) {
            jMenuItem = this.windowMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getActionCommand().equals(string)) continue;
            this.windowMenu.remove(i);
            jMenuItem = null;
            break;
        }
        if (this.windowMenu.getMenuComponentCount() == 6) {
            Component[] componentArray = this.windowMenu.getMenuComponents();
            for (int i = 0; i < 6; ++i) {
                componentArray[i].setEnabled(false);
            }
        }
    }

    @Override
    public TreeView getTreeView() {
        return this.treeView;
    }

    @Override
    public void mouseEventFired(MouseEvent mouseEvent) {
        HObject hObject = this.treeView.getCurrentObject();
        if (hObject == null) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            String string = hObject.getFile();
            this.urlBar.setSelectedItem(string);
            if (this.infoTabbedPane.getSelectedIndex() == 1) {
                this.showMetaData(hObject);
            }
        }
    }

    private void showMetaData(HObject hObject) {
        int n;
        if (hObject == null || this.currentFile == null) {
            return;
        }
        this.metadata.setLength(0);
        this.metadata.append(hObject.getName());
        String string = null;
        long[] lArray = hObject.getOID();
        if (lArray != null) {
            string = String.valueOf(lArray[0]);
            for (int i = 1; i < lArray.length; ++i) {
                string = string + ", " + lArray[i];
            }
        }
        this.metadata.append(" (");
        this.metadata.append(string);
        this.metadata.append(")");
        if (hObject instanceof Group) {
            Group group = (Group)hObject;
            this.metadata.append("\n    Group size = ");
            this.metadata.append(group.getMemberList().size());
        } else if (hObject instanceof Dataset) {
            Object object;
            Dataset dataset = (Dataset)hObject;
            if (dataset.getRank() <= 0) {
                dataset.init();
            }
            this.metadata.append("\n    ");
            if (dataset instanceof ScalarDS) {
                object = dataset.getDatatype();
                if (object != null) {
                    this.metadata.append(((Datatype)object).getDatatypeDescription());
                }
            } else if (dataset instanceof CompoundDS) {
                this.metadata.append("Compound/Vdata");
            }
            this.metadata.append(",    ");
            object = dataset.getDims();
            if (object != null) {
                this.metadata.append((long)object[0]);
                for (n = 1; n < ((Object)object).length; ++n) {
                    this.metadata.append(" x ");
                    this.metadata.append((long)object[n]);
                }
            }
        }
        List list = null;
        try {
            list = hObject.getMetadata();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list == null) {
            this.metadata.append("\n    Number of attributes = 0");
        } else {
            int n2 = list.size();
            this.metadata.append("\n    Number of attributes = ");
            this.metadata.append(n2);
            for (n = 0; n < n2; ++n) {
                Object e = list.get(n);
                if (!(e instanceof Attribute)) continue;
                Attribute attribute = (Attribute)e;
                this.metadata.append("\n        ");
                this.metadata.append(attribute.getName());
                this.metadata.append(" = ");
                this.metadata.append(attribute.toString(","));
            }
        }
        this.attributeArea.setText(this.metadata.toString());
        this.attributeArea.setCaretPosition(0);
    }

    @Override
    public DataView getDataView(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        JInternalFrame jInternalFrame = null;
        if (jInternalFrameArray == null) {
            return null;
        }
        HObject hObject2 = null;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!(jInternalFrameArray[i] instanceof DataView) || !hObject.equals(hObject2 = ((DataView)((Object)jInternalFrameArray[i])).getDataObject())) continue;
            jInternalFrame = jInternalFrameArray[i];
            break;
        }
        return (DataView)((Object)jInternalFrame);
    }

    public List getDataViews() {
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        Object var2_2 = null;
        if (jInternalFrameArray == null || jInternalFrameArray.length <= 0) {
            return null;
        }
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>(jInternalFrameArray.length);
        Object var4_4 = null;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!(jInternalFrameArray[i] instanceof DataView)) continue;
            vector.add(jInternalFrameArray[i]);
        }
        return vector;
    }

    public static final List getListOfTreeView() {
        return treeViews;
    }

    public static final List getListOfImageView() {
        return imageViews;
    }

    public static final List getListOfTableView() {
        return tableViews;
    }

    public static final List getListOfTextView() {
        return textViews;
    }

    public static final List getListOfMetaDataView() {
        return metaDataViews;
    }

    public static final List getListOfPaletteView() {
        return paletteViews;
    }

    @Override
    public void showStatus(String string) {
        this.message.append(string);
        this.message.append("\n");
        this.statusArea.setText(this.message.toString());
    }

    private String openLocalFile() {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir);
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        this.currentDir = file.isDirectory() ? file.getPath() : file.getParent();
        return file.getAbsolutePath();
    }

    private String openRemoteFile(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (string.startsWith("http://")) {
            string2 = string.substring(7);
        } else if (string.startsWith("ftp://")) {
            string2 = string.substring(6);
        } else {
            return null;
        }
        string2 = string2.replace('/', '@');
        string2 = string2.replace('\\', '@');
        String string3 = System.getProperty("java.io.tmpdir");
        File file = new File(string3);
        if (!file.canWrite()) {
            string3 = System.getProperty("user.home");
        }
        if ((file = new File(string2 = string3 + string2)).exists()) {
            return string2;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            bufferedInputStream = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        byte[] byArray = new byte[512];
        try {
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return string2;
    }

    private void openFromSRB() throws Exception {
        Object[] objectArray;
        if (this.ctrSrbFileDialog == null) {
            objectArray = null;
            try {
                objectArray = Class.forName("ncsa.hdf.srb.SRBFileDialog");
            }
            catch (Exception exception) {
                objectArray = null;
                this.showStatus(exception.toString());
                throw new ClassNotFoundException("Cannot find SRBFileDialog");
            }
            try {
                Class[] classArray = new Class[]{Class.forName("java.awt.Frame")};
                this.ctrSrbFileDialog = objectArray.getConstructor(classArray);
            }
            catch (Exception exception) {
                this.ctrSrbFileDialog = null;
                throw new InstantiationException("Cannot construct SRBFileDialog");
            }
        }
        if (this.srbFileDialog == null) {
            objectArray = new Object[]{this};
            this.srbFileDialog = (JDialog)this.ctrSrbFileDialog.newInstance(objectArray);
        } else {
            this.srbFileDialog.setVisible(true);
        }
        this.currentFile = this.srbFileDialog.getName();
    }

    private static final void loadExtModules() throws Exception {
        int n;
        ClassLoader classLoader = ViewProperties.loadExtClass();
        Vector vector = ViewProperties.getTreeViewList();
        Vector vector2 = ViewProperties.getImageViewList();
        if (classLoader == null || vector == null || vector2 == null) {
            return;
        }
        String[] stringArray = new String[]{"ext.erdc.TreeViewERDC", "ext.npoess.TreeViewNPOESS"};
        String[] stringArray2 = new String[]{"ext.erdc.ImageViewERDC"};
        for (n = 0; n < stringArray.length; ++n) {
            if (vector.contains(stringArray[n])) continue;
            classLoader.loadClass(stringArray[n]);
            vector.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (vector2.contains(stringArray2[n])) continue;
            classLoader.loadClass(stringArray2[n]);
            vector2.add(stringArray2[n]);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = System.getProperty("user.dir");
        File file = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if ("-root".equalsIgnoreCase(stringArray[n])) {
                try {
                    file = new File(stringArray[++n]);
                    n2 = n;
                    if (file.isDirectory()) {
                        string = file.getPath();
                        continue;
                    }
                    if (!file.isFile()) continue;
                    string = file.getParent();
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-g".equalsIgnoreCase(stringArray[n]) || "-geometry".equalsIgnoreCase(stringArray[n])) {
                try {
                    object = stringArray[++n];
                    n2 = n;
                    int n7 = 0;
                    int n8 = ((String)object).lastIndexOf(45);
                    int n9 = ((String)object).lastIndexOf(43);
                    n7 = Math.max(n8, n9);
                    if (n7 > 0) {
                        n6 = Integer.parseInt(((String)object).substring(n7 + 1));
                        if (n7 == n8) {
                            n6 = -n6;
                        }
                        if ((n7 = Math.max(n8 = ((String)(object = ((String)object).substring(0, n7))).lastIndexOf(45), n9 = ((String)object).lastIndexOf(43))) > 0) {
                            n5 = Integer.parseInt(((String)object).substring(n7 + 1));
                            if (n7 == n8) {
                                n5 = -n5;
                            }
                            object = ((String)object).substring(0, n7);
                        }
                    }
                    if ((n7 = ((String)object).indexOf(120)) <= 0) continue;
                    n3 = Integer.parseInt(((String)object).substring(0, n7));
                    n4 = Integer.parseInt(((String)object).substring(n7 + 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (!"-java.vm.version".equalsIgnoreCase(stringArray[n])) continue;
            object = "Compiled at " + JAVA_COMPILER + "\nRunning at " + System.getProperty("java.vm.version");
            JOptionPane.showMessageDialog(new JFrame(), object, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            System.exit(0);
        }
        object = new Vector();
        file = null;
        if (n2 >= 0) {
            for (n = n2; n < stringArray.length; ++n) {
                file = new File(stringArray[n]);
                if (!file.exists() || !file.isFile()) continue;
                ((Vector)object).add(new File(file.getAbsolutePath()));
            }
        }
        HDFView hDFView = new HDFView(string, (List)object, n3, n4, n5, n6);
        hDFView.setVisible(true);
        try {
            HDFView.loadExtModules();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        aboutHDFView = "HDF Viewer, Version 2.5\nFor " + System.getProperty("os.name") + "\n\n" + "Copyright " + '\u00a9' + " 2006-2008 The HDF Group.\n" + "All rights reserved.";
        JAVA_COMPILER = System.getProperty("java.vm.version");
    }
}

