/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewGroupDialog
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JComboBox parentChoice;
    private List groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewGroupDialog(Frame frame, Group group, List list) {
        super(frame, "New Group...", true);
        Serializable serializable;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object e2 = null;
        for (Object e2 : list) {
            if (!(e2 instanceof Group)) continue;
            this.groupList.add(e2);
            serializable = (Group)e2;
            if (((Group)serializable).isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(((HObject)serializable).getPath() + ((HObject)serializable).getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        serializable = (JPanel)this.getContentPane();
        ((Container)serializable).setLayout(new BorderLayout(5, 5));
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 120 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)serializable).setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        ((Container)serializable).add(jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Group name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)serializable).add(jPanel2, "Center");
        Point point = frame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.newObject = this.create();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
        }
    }

    private HObject create() {
        String string = null;
        Group group = null;
        string = this.nameField.getText();
        if (string == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        Group group2 = null;
        try {
            group2 = this.fileFormat.createGroup(string, group);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        return group2;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

