/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.ArrayAbstract;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexImpl;
import ucar.ma2.IndexIterator;

public class ArrayChar
extends ArrayAbstract {
    protected char[] storage;

    static ArrayChar factory(IndexImpl index) {
        return ArrayChar.factory(index, null);
    }

    static ArrayChar factory(IndexImpl index, char[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(index, storage);
            }
            case 1: {
                return new D1(index, storage);
            }
            case 2: {
                return new D2(index, storage);
            }
            case 3: {
                return new D3(index, storage);
            }
            case 4: {
                return new D4(index, storage);
            }
            case 5: {
                return new D5(index, storage);
            }
            case 6: {
                return new D6(index, storage);
            }
            case 7: {
                return new D7(index, storage);
            }
        }
        return new ArrayChar(index, storage);
    }

    public ArrayChar(int[] dimensions) {
        super(dimensions);
        this.storage = new char[(int)this.indexCalc.getSize()];
    }

    private ArrayChar(IndexImpl ima, char[] data) {
        super(ima);
        this.storage = data != null ? data : new char[(int)ima.getSize()];
    }

    ArrayAbstract createView(IndexImpl index) {
        return ArrayChar.factory(index, this.storage);
    }

    public Object getStorage() {
        return this.storage;
    }

    void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        char[] ja = (char[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            iter.setCharNext(ja[i]);
        }
    }

    void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        char[] ja = (char[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getCharNext();
        }
    }

    public Class getElementType() {
        return Character.TYPE;
    }

    public char get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, char value) {
        this.storage[i.currentElement()] = value;
    }

    public double getDouble(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setDouble(Index i, double value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public float getFloat(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setFloat(Index i, float value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public long getLong(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setLong(Index i, long value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public int getInt(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setInt(Index i, int value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public short getShort(Index i) {
        return (short)this.storage[i.currentElement()];
    }

    public void setShort(Index i, short value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public byte getByte(Index i) {
        return (byte)this.storage[i.currentElement()];
    }

    public void setByte(Index i, byte value) {
        this.storage[i.currentElement()] = (char)value;
    }

    public char getChar(Index i) {
        return this.storage[i.currentElement()];
    }

    public void setChar(Index i, char value) {
        this.storage[i.currentElement()] = value;
    }

    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    public Object getObject(Index i) {
        return new Character(this.storage[i.currentElement()]);
    }

    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = ((Character)value).charValue();
    }

    public String getString() {
        int rank = this.getRank();
        if (rank != 1) {
            throw new IllegalArgumentException("ArayChar.getString rank must be 1");
        }
        int strLen = this.getShape()[0];
        int count = 0;
        for (int k = 0; k < strLen && '\u0000' != this.storage[k]; ++k) {
            ++count;
        }
        return new String(this.storage, 0, count);
    }

    public String getString(int index) {
        int rank = this.getRank();
        if (rank != 2) {
            throw new IllegalArgumentException("ArayChar.getString rank must be 2");
        }
        Index ima = this.getIndex();
        return this.getString(ima.set(index));
    }

    public String getString(Index ima) {
        int rank = this.getRank();
        if (rank == 0) {
            throw new IllegalArgumentException("ArayChar.getString rank must not be 0");
        }
        if (rank == 1) {
            return this.getString();
        }
        int strLen = this.getShape()[rank - 1];
        char[] carray = new char[strLen];
        int count = 0;
        for (int k = 0; k < strLen; ++k) {
            ima.setDim(rank - 1, k);
            carray[k] = this.getChar(ima);
            if ('\u0000' == carray[k]) break;
            ++count;
        }
        return new String(carray, 0, count);
    }

    public void setString(String val) {
        int rank = this.getRank();
        if (rank != 1) {
            throw new IllegalArgumentException("ArayChar.setString rank must be 1");
        }
        int arrayLen = this.getShape()[0];
        int strLen = Math.min(val.length(), arrayLen);
        for (int k = 0; k < strLen; ++k) {
            this.storage[k] = val.charAt(k);
        }
        char c = '\u0000';
        for (int k = strLen; k < arrayLen; ++k) {
            this.storage[k] = c;
        }
    }

    public void setString(int index, String val) {
        int rank = this.getRank();
        if (rank != 2) {
            throw new IllegalArgumentException("ArayChar.setString rank must be 2");
        }
        Index ima = this.getIndex();
        this.setString(ima.set(index), val);
    }

    public void setString(Index ima, String val) {
        int rank = this.getRank();
        if (rank == 0) {
            throw new IllegalArgumentException("ArayChar.setString rank must not be 0");
        }
        int arrayLen = this.getShape()[rank - 1];
        int strLen = Math.min(val.length(), arrayLen);
        int count = 0;
        for (int k = 0; k < strLen; ++k) {
            ima.setDim(rank - 1, k);
            this.setChar(ima, val.charAt(k));
            ++count;
        }
        char c = '\u0000';
        for (int k = count; k < arrayLen; ++k) {
            ima.setDim(rank - 1, k);
            this.setChar(ima, c);
        }
    }

    double getDouble(int index) {
        return this.storage[index];
    }

    void setDouble(int index, double value) {
        this.storage[index] = (char)value;
    }

    float getFloat(int index) {
        return this.storage[index];
    }

    void setFloat(int index, float value) {
        this.storage[index] = (char)value;
    }

    long getLong(int index) {
        return this.storage[index];
    }

    void setLong(int index, long value) {
        this.storage[index] = (char)value;
    }

    int getInt(int index) {
        return this.storage[index];
    }

    void setInt(int index, int value) {
        this.storage[index] = (char)value;
    }

    short getShort(int index) {
        return (short)this.storage[index];
    }

    void setShort(int index, short value) {
        this.storage[index] = (char)value;
    }

    byte getByte(int index) {
        return (byte)this.storage[index];
    }

    void setByte(int index, byte value) {
        this.storage[index] = (char)value;
    }

    char getChar(int index) {
        return this.storage[index];
    }

    void setChar(int index, char value) {
        this.storage[index] = value;
    }

    boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    Object getObject(int index) {
        return new Character(this.getChar(index));
    }

    public StringIterator getStringIterator() {
        return new StringIterator();
    }

    public class StringIterator {
        private IndexIterator ii;
        private int strLen;
        private char[] carray;

        StringIterator() {
            this.ii = ArrayChar.this.getIndexIterator();
            if (ArrayChar.this.rank == 0) {
                throw new IllegalArgumentException("ArayChar.getStringIterator rank must not be 0");
            }
            this.strLen = ArrayChar.this.getShape()[ArrayChar.this.rank - 1];
            this.carray = new char[this.strLen];
        }

        public int getNumElems() {
            return (int)ArrayChar.this.getSize() / this.strLen;
        }

        public boolean hasNext() {
            return this.ii.hasNext();
        }

        public String next() {
            int stop = this.strLen;
            for (int k = 0; k < this.strLen; ++k) {
                this.carray[k] = this.ii.getCharNext();
                if ('\u0000' != this.carray[k] || stop != this.strLen) continue;
                stop = k;
            }
            return new String(this.carray, 0, stop);
        }
    }

    public static class D7
    extends ArrayChar {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayChar {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayChar {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m) {
            return this.storage[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayChar {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayChar {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public char get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayChar {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public char get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayChar {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public char get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, char value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayChar {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(IndexImpl i, char[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public char get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(char value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

