/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;

class TabDescriptor {
    String theType = "";
    Class theClass = null;
    int nfields;
    int totalsize = 0;
    Field[] flds;
    String[] fldTypeName;
    Class[] fldType;
    int[] fldLen;
    Object[] theFields;

    TabDescriptor(Object object) throws HDFException, IllegalAccessException {
        this.theClass = object.getClass();
        this.theType = this.theClass.toString();
        int n = 0;
        this.flds = this.theClass.getFields();
        this.nfields = Array.getLength(this.flds);
        this.fldType = new Class[this.nfields];
        this.fldTypeName = new String[this.nfields];
        this.fldLen = new int[this.nfields];
        this.theFields = new Object[this.nfields];
        for (n = 0; n < this.nfields; ++n) {
            this.fldType[n] = this.flds[n].getType();
            this.fldTypeName[n] = this.fldType[n].getName();
            this.theFields[n] = this.flds[n].get(object);
            if (this.theFields[n] == null) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Field not defined: " + this.flds[n].getName());
                throw hDFJavaException;
            }
            this.fldLen[n] = this.calcsize(this.fldType[n], this.flds[n].get(object));
            this.totalsize += this.fldLen[n];
        }
    }

    int calcsize(Class clazz, Object object) throws HDFException {
        String string = clazz.toString();
        if (string.equals("int")) {
            return 4;
        }
        if (string.equals("byte")) {
            return 1;
        }
        if (string.equals("short")) {
            return 2;
        }
        if (string.equals("float")) {
            return 4;
        }
        if (string.equals("long")) {
            return 8;
        }
        if (string.equals("double")) {
            return 16;
        }
        if (string.equals("class java.lang.String")) {
            return ((String)object).length();
        }
        if (string.startsWith("class [")) {
            if (!object.getClass().isArray()) {
                System.out.println("Error:  byteify requires array");
                return -1;
            }
            int n = 0;
            int n2 = 32;
            for (int i = 6; i < string.length(); ++i) {
                n2 = string.charAt(i);
                if (n2 != 91) continue;
                ++n;
            }
            int n3 = n2;
            int n4 = 0;
            if (n3 == 66) {
                n4 = 1;
            } else if (n3 == 83) {
                n4 = 2;
            } else if (n3 == 73 || n3 == 70) {
                n4 = 4;
            } else if (n3 == 74 || n3 == 68) {
                n4 = 8;
            } else {
                System.out.println("Error:  array is not numeric?");
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Array is not numeric?: " + string);
                throw hDFJavaException;
            }
            Object object2 = object;
            int n5 = 1;
            int n6 = n4;
            for (int i = 1; i <= n; ++i) {
                n5 = Array.getLength(object2);
                n6 *= n5;
                object2 = Array.get(object2, 0);
            }
            return n6;
        }
        HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Unsupported data type: " + string);
        throw hDFJavaException;
    }
}

