/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.IndexImpl;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MultiArray;

public class MultiArraySlice
implements MultiArray {
    private MultiArray ma;
    private int[] aShape;
    private int[] aOrigin;
    private int[] shape;
    private int[] origin;
    private int rank;
    private int dim;
    private int value;
    private long size;

    public MultiArraySlice(MultiArray ma, int dim, int value) {
        this.ma = ma;
        this.dim = dim;
        this.value = value;
        int[] org_shape = ma.getShape();
        if (dim < 0 || dim >= ma.getRank()) {
            throw new IllegalArgumentException("MultiArraySlice: bad dim " + dim);
        }
        if (value < 0 || value >= org_shape[dim]) {
            throw new IllegalArgumentException("MultiArraySlice: bad index value " + value);
        }
        this.rank = ma.getRank() - 1;
        this.shape = new int[this.rank];
        int count = 0;
        for (int i = 0; i < this.rank + 1; ++i) {
            if (i == dim) continue;
            this.shape[count++] = org_shape[i];
        }
        this.size = IndexImpl.computeSize(this.shape);
        this.origin = new int[this.rank];
        this.aShape = new int[this.rank + 1];
        this.aOrigin = new int[this.rank + 1];
    }

    public Class getElementType() {
        return this.ma.getElementType();
    }

    public int getRank() {
        return this.rank;
    }

    public long getSize() {
        return this.size;
    }

    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    public Array read(int[] origin, int[] shape) throws InvalidRangeException, IOException {
        int count = 0;
        for (int i = 0; i < this.rank + 1; ++i) {
            this.aShape[i] = i == this.dim ? 1 : shape[count];
            int n = this.aOrigin[i] = i == this.dim ? this.value : origin[count];
            if (i == this.dim) continue;
            ++count;
        }
        return this.ma.read(this.aOrigin, this.aShape).reduce(this.dim);
    }

    public Array read() throws IOException {
        try {
            return this.read(this.origin, this.shape);
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException();
        }
    }
}

