/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.ArrayAbstract;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IteratorFast;
import ucar.ma2.Range;

public class IndexImpl
implements Index,
Cloneable {
    protected int[] shape;
    protected int rank;
    protected long size;
    protected int[] stride;
    protected int offset;
    protected int[] current;
    protected boolean fastIterator = true;
    private StringBuffer sbuff = new StringBuffer(100);

    protected IndexImpl(int rank) {
        this.shape = new int[rank];
        this.rank = rank;
        this.current = new int[rank];
        this.stride = new int[rank];
    }

    protected IndexImpl(int[] shape) {
        this.shape = (int[])shape.clone();
        this.rank = shape.length;
        this.current = new int[this.rank];
        this.stride = new int[this.rank];
        this.size = IndexImpl.computeStrides(shape, this.stride);
        this.offset = 0;
    }

    protected void precalc() {
    }

    IndexImpl flip(int index) {
        if (index < 0 || index >= this.rank) {
            throw new IllegalArgumentException();
        }
        IndexImpl i = (IndexImpl)this.clone();
        i.offset += this.stride[index] * (this.shape[index] - 1);
        i.stride[index] = -this.stride[index];
        i.fastIterator = false;
        i.precalc();
        return i;
    }

    IndexImpl section(Range[] ranges) throws InvalidRangeException {
        if (ranges.length != this.rank) {
            throw new InvalidRangeException("Bad ranges [] length");
        }
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ranges[ii] == null) continue;
            if (ranges[ii].first() < 0 || ranges[ii].first() >= this.shape[ii]) {
                throw new InvalidRangeException("Bad range starting value at index " + ii + " == " + ranges[ii].first());
            }
            if (ranges[ii].last() >= 0 && ranges[ii].last() < this.shape[ii]) continue;
            throw new InvalidRangeException("Bad range ending value at index " + ii + " == " + ranges[ii].last());
        }
        int reducedRank = this.rank;
        for (int ii = 0; ii < ranges.length; ++ii) {
            if (ranges[ii] == null || ranges[ii].length() != 1) continue;
            --reducedRank;
        }
        IndexImpl newindex = IndexImpl.factory(reducedRank);
        newindex.offset = this.offset;
        int newDim = 0;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ranges[ii] == null) {
                newindex.shape[newDim] = this.shape[ii];
                newindex.stride[newDim] = this.stride[ii];
                ++newDim;
                continue;
            }
            if (ranges[ii].length() != 1) {
                newindex.shape[newDim] = ranges[ii].length();
                newindex.stride[newDim] = this.stride[ii] * ranges[ii].step();
                newindex.offset += this.stride[ii] * ranges[ii].first();
                ++newDim;
                continue;
            }
            newindex.offset += this.stride[ii] * ranges[ii].first();
        }
        newindex.size = IndexImpl.computeSize(newindex.shape);
        newindex.fastIterator = false;
        newindex.precalc();
        return newindex;
    }

    IndexImpl sectionNoReduce(Range[] ranges) throws InvalidRangeException {
        if (ranges.length != this.rank) {
            throw new InvalidRangeException("Bad ranges [] length");
        }
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ranges[ii] == null) continue;
            if (ranges[ii].first() < 0 || ranges[ii].first() >= this.shape[ii]) {
                throw new InvalidRangeException("Bad range starting value at index " + ii + " == " + ranges[ii].first());
            }
            if (ranges[ii].last() >= 0 && ranges[ii].last() < this.shape[ii]) continue;
            throw new InvalidRangeException("Bad range ending value at index " + ii + " == " + ranges[ii].last());
        }
        IndexImpl newindex = IndexImpl.factory(this.rank);
        newindex.offset = this.offset;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ranges[ii] == null) {
                newindex.shape[ii] = this.shape[ii];
                newindex.stride[ii] = this.stride[ii];
                continue;
            }
            newindex.shape[ii] = ranges[ii].length();
            newindex.stride[ii] = this.stride[ii] * ranges[ii].step();
            newindex.offset += this.stride[ii] * ranges[ii].first();
        }
        newindex.size = IndexImpl.computeSize(newindex.shape);
        newindex.fastIterator = false;
        newindex.precalc();
        return newindex;
    }

    IndexImpl reduce() {
        IndexImpl c = this;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (this.shape[ii] != 1) continue;
            IndexImpl newc = c.reduce(ii);
            return newc.reduce();
        }
        return c;
    }

    IndexImpl reduce(int dim) {
        if (dim < 0 || dim >= this.rank) {
            throw new IllegalArgumentException("illegal reduce dim " + dim);
        }
        if (this.shape[dim] != 1) {
            throw new IllegalArgumentException("illegal reduce dim " + dim + " : length != 1");
        }
        IndexImpl newindex = IndexImpl.factory(this.rank - 1);
        newindex.offset = this.offset;
        int count = 0;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ii == dim) continue;
            newindex.shape[count] = this.shape[ii];
            newindex.stride[count] = this.stride[ii];
            ++count;
        }
        newindex.size = IndexImpl.computeSize(newindex.shape);
        newindex.fastIterator = this.fastIterator;
        newindex.precalc();
        return newindex;
    }

    IndexImpl transpose(int index1, int index2) {
        if (index1 < 0 || index1 >= this.rank) {
            throw new IllegalArgumentException();
        }
        if (index2 < 0 || index2 >= this.rank) {
            throw new IllegalArgumentException();
        }
        IndexImpl newIndex = (IndexImpl)this.clone();
        newIndex.stride[index1] = this.stride[index2];
        newIndex.stride[index2] = this.stride[index1];
        newIndex.shape[index1] = this.shape[index2];
        newIndex.shape[index2] = this.shape[index1];
        newIndex.fastIterator = false;
        newIndex.precalc();
        return newIndex;
    }

    IndexImpl permute(int[] dims) {
        if (dims.length != this.shape.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] >= 0 && dims[i] < this.rank) continue;
            throw new IllegalArgumentException();
        }
        IndexImpl newIndex = (IndexImpl)this.clone();
        for (int i = 0; i < dims.length; ++i) {
            newIndex.stride[i] = this.stride[dims[i]];
            newIndex.shape[i] = this.shape[dims[i]];
        }
        newIndex.fastIterator = false;
        newIndex.precalc();
        return newIndex;
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    IndexIterator getIndexIterator(ArrayAbstract maa) {
        if (this.fastIterator) {
            return new IteratorFast(this.size, maa);
        }
        return new IteratorImpl(maa);
    }

    IteratorFast getIndexIteratorFast(ArrayAbstract maa) {
        return new IteratorFast(this.size, maa);
    }

    public long getSize() {
        return this.size;
    }

    public int currentElement() {
        int value = this.offset;
        for (int ii = 0; ii < this.rank; ++ii) {
            value += this.current[ii] * this.stride[ii];
        }
        return value;
    }

    protected int incr() {
        for (int digit = this.rank - 1; digit >= 0; --digit) {
            int n = digit;
            this.current[n] = this.current[n] + 1;
            if (this.current[digit] < this.shape[digit]) break;
            this.current[digit] = 0;
        }
        return this.currentElement();
    }

    public Index set(int[] index) {
        if (index.length != this.rank) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int ii = 0; ii < this.rank; ++ii) {
            this.current[ii] = index[ii];
        }
        return this;
    }

    public void setDim(int dim, int value) {
        if (value < 0 || value >= this.shape[dim]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.current[dim] = value;
    }

    public Index set0(int v) {
        this.setDim(0, v);
        return this;
    }

    public Index set1(int v) {
        this.setDim(1, v);
        return this;
    }

    public Index set2(int v) {
        this.setDim(2, v);
        return this;
    }

    public Index set3(int v) {
        this.setDim(3, v);
        return this;
    }

    public Index set4(int v) {
        this.setDim(4, v);
        return this;
    }

    public Index set5(int v) {
        this.setDim(5, v);
        return this;
    }

    public Index set6(int v) {
        this.setDim(6, v);
        return this;
    }

    public Index set(int v0) {
        this.setDim(0, v0);
        return this;
    }

    public Index set(int v0, int v1) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        return this;
    }

    public Index set(int v0, int v1, int v2) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4, int v5) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        this.setDim(5, v5);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4, int v5, int v6) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        this.setDim(5, v5);
        this.setDim(6, v6);
        return this;
    }

    public String toString() {
        int ii;
        this.sbuff.setLength(0);
        this.sbuff.append(" shape= ");
        for (ii = 0; ii < this.rank; ++ii) {
            this.sbuff.append(this.shape[ii]);
            this.sbuff.append(" ");
        }
        this.sbuff.append(" stride= ");
        for (ii = 0; ii < this.rank; ++ii) {
            this.sbuff.append(this.stride[ii]);
            this.sbuff.append(" ");
        }
        this.sbuff.append(" offset= " + this.offset);
        this.sbuff.append(" rank= " + this.rank);
        this.sbuff.append(" size= " + this.size);
        this.sbuff.append(" current= ");
        for (ii = 0; ii < this.rank; ++ii) {
            this.sbuff.append(this.current[ii]);
            this.sbuff.append(" ");
        }
        return this.sbuff.toString();
    }

    public Object clone() {
        IndexImpl i;
        try {
            i = (IndexImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        i.stride = (int[])this.stride.clone();
        i.shape = (int[])this.shape.clone();
        i.current = new int[this.rank];
        return i;
    }

    public static IndexImpl factory(int[] shape) {
        int rank = shape.length;
        switch (rank) {
            case 0: {
                return new Index0D(shape);
            }
            case 1: {
                return new Index1D(shape);
            }
            case 2: {
                return new Index2D(shape);
            }
            case 3: {
                return new Index3D(shape);
            }
            case 4: {
                return new Index4D(shape);
            }
            case 5: {
                return new Index5D(shape);
            }
            case 6: {
                return new Index6D(shape);
            }
            case 7: {
                return new Index7D(shape);
            }
        }
        return new IndexImpl(shape);
    }

    private static IndexImpl factory(int rank) {
        switch (rank) {
            case 0: {
                return new Index0D();
            }
            case 1: {
                return new Index1D();
            }
            case 2: {
                return new Index2D();
            }
            case 3: {
                return new Index3D();
            }
            case 4: {
                return new Index4D();
            }
            case 5: {
                return new Index5D();
            }
            case 6: {
                return new Index6D();
            }
            case 7: {
                return new Index7D();
            }
        }
        return new IndexImpl(rank);
    }

    public static long computeSize(int[] shape) {
        long product = 1L;
        for (int ii = shape.length - 1; ii >= 0; --ii) {
            product *= (long)shape[ii];
        }
        return product;
    }

    private static long computeStrides(int[] shape, int[] stride) {
        long product = 1L;
        for (int ii = shape.length - 1; ii >= 0; --ii) {
            int thisDim = shape[ii];
            if (thisDim < 0) {
                throw new NegativeArraySizeException();
            }
            stride[ii] = (int)product;
            product *= (long)thisDim;
        }
        return product;
    }

    private class IteratorImpl
    implements IndexIterator {
        private int count = 0;
        private int currElement = 0;
        private IndexImpl counter;
        private ArrayAbstract maa;

        private IteratorImpl(ArrayAbstract maa) {
            this.maa = maa;
            this.counter = (IndexImpl)IndexImpl.this.clone();
            if (IndexImpl.this.rank > 0) {
                this.counter.current[IndexImpl.this.rank - 1] = -1;
            }
            this.counter.precalc();
        }

        public boolean hasNext() {
            return (long)this.count < IndexImpl.this.size;
        }

        public String toString() {
            return this.counter.toString() + this.count;
        }

        public Object next() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getObject(this.currElement);
        }

        public double getDoubleCurrent() {
            return this.maa.getDouble(this.currElement);
        }

        public double getDoubleNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getDouble(this.currElement);
        }

        public void setDoubleCurrent(double val) {
            this.maa.setDouble(this.currElement, val);
        }

        public void setDoubleNext(double val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setDouble(this.currElement, val);
        }

        public float getFloatCurrent() {
            return this.maa.getFloat(this.currElement);
        }

        public float getFloatNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getFloat(this.currElement);
        }

        public void setFloatCurrent(float val) {
            this.maa.setFloat(this.currElement, val);
        }

        public void setFloatNext(float val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setFloat(this.currElement, val);
        }

        public long getLongCurrent() {
            return this.maa.getLong(this.currElement);
        }

        public long getLongNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getLong(this.currElement);
        }

        public void setLongCurrent(long val) {
            this.maa.setLong(this.currElement, val);
        }

        public void setLongNext(long val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setLong(this.currElement, val);
        }

        public int getIntCurrent() {
            return this.maa.getInt(this.currElement);
        }

        public int getIntNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getInt(this.currElement);
        }

        public void setIntCurrent(int val) {
            this.maa.setInt(this.currElement, val);
        }

        public void setIntNext(int val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setInt(this.currElement, val);
        }

        public short getShortCurrent() {
            return this.maa.getShort(this.currElement);
        }

        public short getShortNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getShort(this.currElement);
        }

        public void setShortCurrent(short val) {
            this.maa.setShort(this.currElement, val);
        }

        public void setShortNext(short val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setShort(this.currElement, val);
        }

        public byte getByteCurrent() {
            return this.maa.getByte(this.currElement);
        }

        public byte getByteNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getByte(this.currElement);
        }

        public void setByteCurrent(byte val) {
            this.maa.setByte(this.currElement, val);
        }

        public void setByteNext(byte val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setByte(this.currElement, val);
        }

        public char getCharCurrent() {
            return this.maa.getChar(this.currElement);
        }

        public char getCharNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getChar(this.currElement);
        }

        public void setCharCurrent(char val) {
            this.maa.setChar(this.currElement, val);
        }

        public void setCharNext(char val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setChar(this.currElement, val);
        }

        public boolean getBooleanCurrent() {
            return this.maa.getBoolean(this.currElement);
        }

        public boolean getBooleanNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getBoolean(this.currElement);
        }

        public void setBooleanCurrent(boolean val) {
            this.maa.setBoolean(this.currElement, val);
        }

        public void setBooleanNext(boolean val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setBoolean(this.currElement, val);
        }
    }
}

