/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import ucar.nc2.DataType;

public class Attribute {
    private ucar.netcdf.Attribute att;
    protected String name;

    protected Attribute() {
    }

    Attribute(ucar.netcdf.Attribute att) {
        this.att = att;
        this.name = att.getName();
    }

    public String getName() {
        return this.name;
    }

    public Class getValueType() {
        Object val = this.att.getValue();
        Class<?> c = val.getClass();
        if (c.isArray()) {
            return c.getComponentType();
        }
        return c;
    }

    public DataType getDataType() {
        return DataType.getType(this.getValueType());
    }

    public boolean isString() {
        return this.att.isString();
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public int getLength() {
        if (this.isString()) {
            return 1;
        }
        return this.att.getLength();
    }

    public Object getValue() {
        if (this.att.isString()) {
            return this.getStringValue();
        }
        return this.att.getValue();
    }

    public String getStringValue() {
        int len;
        String v = this.att.getStringValue();
        for (len = v.length(); len > 0 && v.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != v.length()) {
            return v.substring(0, len);
        }
        return v;
    }

    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    public Number getNumericValue(int index) {
        if (this.isString() || index < 0 || index >= this.att.getLength()) {
            return null;
        }
        return this.att.getNumericValue(index);
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Attribute)) {
            return false;
        }
        Attribute d = (Attribute)oo;
        return this.getName().equals(d.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        if (this.isString()) {
            buff.append(" = \"" + this.getStringValue() + "\"");
        } else if (this.isArray()) {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append(this.getNumericValue(i));
            }
        } else {
            buff.append(" = " + this.getNumericValue());
        }
        return buff.toString();
    }

    public void rename(String rename) {
        this.name = rename;
    }
}

