/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayAbstract;
import ucar.ma2.IOArray;
import ucar.ma2.InvalidRangeException;
import ucar.multiarray.MultiArray;
import ucar.nc2.Attribute;
import ucar.nc2.DataType;
import ucar.nc2.Dimension;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.DimensionIterator;

public class Variable
implements IOArray {
    protected String name;
    protected int[] shape;
    protected Class elementType;
    protected ArrayList dimensions = new ArrayList();
    protected ArrayList attributes = new ArrayList();
    protected boolean isCoordinateVariable = false;
    private ucar.netcdf.Variable ncvar;
    protected StringBuffer buf = new StringBuffer(200);
    static /* synthetic */ Class class$java$lang$String;

    public String getName() {
        return this.name;
    }

    protected String getNameForDisplay() {
        return this.name;
    }

    public List getDimensions() {
        return new ArrayList(this.dimensions);
    }

    public Dimension getDimension(int i) {
        return (Dimension)this.dimensions.get(i);
    }

    public int findDimensionIndex(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = (Dimension)this.dimensions.get(i);
            if (!name.equals(d.getName())) continue;
            return i;
        }
        return -1;
    }

    public Iterator getAttributeIterator() {
        return this.attributes.iterator();
    }

    public List getAttributes() {
        return new ArrayList(this.attributes);
    }

    public Attribute findAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = (Attribute)this.attributes.get(i);
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = (Attribute)this.attributes.get(i);
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public boolean isUnlimited() {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = (Dimension)this.dimensions.get(i);
            if (!d.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoordinateVariable() {
        return this.isCoordinateVariable;
    }

    public Class getElementType() {
        return this.elementType;
    }

    public DataType getDataType() {
        return DataType.getType(this.getElementType());
    }

    public int getRank() {
        return this.shape.length;
    }

    public long getSize() {
        int[] shape = this.getShape();
        long size = 1L;
        for (int i = 0; i < shape.length; ++i) {
            size *= (long)shape[i];
        }
        return size;
    }

    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    public Array read(int[] origin, int[] shape) throws IOException, InvalidRangeException {
        MultiArray ma = this.ncvar.copyout(origin, shape);
        Object storage = ma.getStorage();
        ArrayAbstract aa = ArrayAbstract.factory(ma.getComponentType(), ma.getLengths(), storage);
        return aa;
    }

    public Array read() throws IOException {
        Object storage = this.ncvar.toArray();
        ArrayAbstract aa = ArrayAbstract.factory(this.ncvar.getComponentType(), this.ncvar.getLengths(), storage);
        return aa;
    }

    protected void getFullName(StringBuffer buf) {
        buf.append(this.getElementType());
        buf.append(" ");
        buf.append(this.getNameForDisplay());
        if (this.getRank() > 0) {
            buf.append("(");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension myd = (Dimension)this.dimensions.get(i);
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(myd.getName());
        }
        if (this.getRank() > 0) {
            buf.append(")");
        }
    }

    public String getNameAndDimensions() {
        StringBuffer sb = new StringBuffer();
        this.getFullName(sb);
        return sb.toString();
    }

    public String toString() {
        this.buf.setLength(0);
        this.buf.append("   ");
        this.getFullName(this.buf);
        this.buf.append(";\n");
        Iterator iter = this.getAttributeIterator();
        while (iter.hasNext()) {
            this.buf.append("    :");
            Attribute att = (Attribute)iter.next();
            this.buf.append(att.toString());
            this.buf.append(";");
            if (att.getValueType() != (class$java$lang$String == null ? Variable.class$("java.lang.String") : class$java$lang$String)) {
                this.buf.append(" // " + att.getValueType().getName());
            }
            this.buf.append("\n");
        }
        return this.buf.toString();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Variable)) {
            return false;
        }
        Variable d = (Variable)oo;
        return this.getName().equals(d.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected Variable(String name) {
        this.name = name;
    }

    protected Variable(String name, Variable from) {
        this.name = name;
        this.shape = from.getShape();
        this.elementType = from.getElementType();
        this.dimensions = new ArrayList(from.getDimensions());
        this.attributes = new ArrayList(from.getAttributes());
        this.isCoordinateVariable = from.isCoordinateVariable();
    }

    protected void setIfCoordinateVariable() {
        Dimension firstd;
        int n = this.getRank();
        if (n == 1 && this.dimensions.size() == 1 && (firstd = (Dimension)this.dimensions.get(0)).getName().equals(this.getName())) {
            firstd.setCoordinateVariable(this);
            this.isCoordinateVariable = true;
        }
        if (n == 2 && this.dimensions.size() == 2 && (firstd = (Dimension)this.dimensions.get(0)).getName().equals(this.getName()) && this.getElementType() == Character.TYPE) {
            firstd.setCoordinateVariable(this);
            this.isCoordinateVariable = true;
        }
    }

    Variable(ucar.netcdf.Variable ncvar, ArrayList myDims) {
        this.ncvar = ncvar;
        this.name = ncvar.getName();
        this.shape = ncvar.getLengths();
        this.elementType = ncvar.getComponentType();
        DimensionIterator iter = ncvar.getDimensionIterator();
        block0: while (iter.hasNext()) {
            ucar.netcdf.Dimension d = iter.next();
            String name = d.getName();
            for (int i = 0; i < myDims.size(); ++i) {
                Dimension myd = (Dimension)myDims.get(i);
                if (!name.equals(myd.getName())) continue;
                this.dimensions.add(myd);
                continue block0;
            }
        }
        if (ncvar.getRank() != this.dimensions.size()) {
            throw new IllegalStateException("Netcdf file inconsistent");
        }
        AttributeIterator attIter = ncvar.getAttributes().iterator();
        while (attIter.hasNext()) {
            ucar.netcdf.Attribute a = attIter.next();
            this.attributes.add(new Attribute(a));
        }
        this.setIfCoordinateVariable();
    }

    ucar.netcdf.Variable getNetcdfVariable() {
        return this.ncvar;
    }

    private void getFullNameN(StringBuffer buf) {
        buf.append(this.ncvar.getComponentType());
        buf.append(" ");
        buf.append(this.ncvar.getName());
        buf.append("(");
        DimensionIterator iter = this.ncvar.getDimensionIterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getName());
            if (!iter.hasNext()) break;
            buf.append(",");
        }
        buf.append(")");
    }

    public String toStringN() {
        this.buf.setLength(0);
        this.buf.append("    ");
        this.getFullNameN(this.buf);
        AttributeIterator iter = this.ncvar.getAttributes().iterator();
        while (iter.hasNext()) {
            this.buf.append("\n                  ");
            iter.next().toCdl(this.buf);
        }
        this.buf.append("\n");
        return this.buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

