/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5ScalarDS;

public class H5File
extends FileFormat {
    public static final long serialVersionUID = 240L;
    private int flag;
    private DefaultMutableTreeNode rootNode = null;
    private static final int attrNameLen = 256;

    public H5File() {
        this("", 0);
    }

    public H5File(String string) {
        this(string, 1);
    }

    public H5File(String string, int n) {
        super(string);
        this.fid = -1;
        boolean bl = this.isReadOnly = n == 0;
        this.flag = n == 0 ? HDF5Constants.H5F_ACC_RDONLY : (n == 1 ? HDF5Constants.H5F_ACC_RDWR : (n == 2 ? HDF5Constants.H5F_ACC_CREAT : n));
    }

    public static final void copyAttributes(HObject hObject, HObject hObject2) {
        if (hObject != null && hObject2 != null) {
            int n = hObject.open();
            int n2 = hObject2.open();
            if (n >= 0 && n2 >= 0) {
                H5File.copyAttributes(n, n2);
            }
            if (n >= 0) {
                hObject.close(n);
            }
            if (n2 >= 0) {
                hObject2.close(n2);
            }
        }
    }

    public static final void copyAttributes(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String[] stringArray = new String[]{""};
        try {
            n7 = H5.H5Aget_num_attrs((int)n);
        }
        catch (Exception exception) {
            n7 = -1;
        }
        if (n7 < 0) {
            return;
        }
        for (int i = 0; i < n7; ++i) {
            stringArray[0] = new String("");
            try {
                n3 = H5.H5Aopen_idx((int)n, (int)i);
                H5.H5Aget_name((int)n3, (long)256L, (String[])stringArray);
                n5 = H5.H5Aget_type((int)n3);
                n6 = H5.H5Aget_space((int)n3);
                n4 = H5.H5Acreate((int)n2, (String)stringArray[0], (int)n5, (int)n6, (int)HDF5Constants.H5P_DEFAULT);
                H5.H5Acopy((int)n3, (int)n4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Sclose((int)n6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Tclose((int)n5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Aclose((int)n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Aclose((int)n4);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getAttribute(int n) throws HDF5Exception {
        Vector<Attribute> vector = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        n5 = H5.H5Aget_num_attrs((int)n);
        if (n5 <= 0) {
            vector = new Vector<Attribute>();
            return vector;
        }
        vector = new Vector(n5);
        for (int i = 0; i < n5; ++i) {
            try {
                int n6;
                n2 = H5.H5Aopen_idx((int)n, (int)i);
                n3 = H5.H5Aget_space((int)n2);
                long[] lArray = null;
                int n7 = H5.H5Sget_simple_extent_ndims((int)n3);
                if (n7 == 0) {
                    n7 = 1;
                    lArray = new long[]{1L};
                } else {
                    lArray = new long[n7];
                    H5.H5Sget_simple_extent_dims((int)n3, (long[])lArray, null);
                }
                String[] stringArray = new String[]{""};
                H5.H5Aget_name((int)n2, (long)256L, (String[])stringArray);
                int n8 = -1;
                try {
                    n8 = H5.H5Aget_type((int)n2);
                    n4 = H5.H5Tget_native_type((int)n8);
                }
                finally {
                    try {
                        H5.H5Tclose((int)n8);
                    }
                    catch (Exception exception) {}
                }
                Attribute attribute = new Attribute(stringArray[0], (Datatype)new H5Datatype(n4), lArray);
                vector.add(attribute);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    bl = H5.H5Tis_variable_str((int)n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bl2 = H5.H5Tget_class((int)n4) == HDF5Constants.H5T_VLEN;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bl3 = H5.H5Tget_class((int)n4) == HDF5Constants.H5T_COMPOUND;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l = 1L;
                for (int j = 0; j < lArray.length; ++j) {
                    l *= lArray[j];
                }
                if (l <= 0L) continue;
                Object[] objectArray = null;
                if (bl2 || bl || bl3) {
                    String[] stringArray2 = new String[(int)l];
                    n6 = 0;
                    while ((long)n6 < l) {
                        stringArray2[n6] = "";
                        ++n6;
                    }
                    H5.H5AreadVL((int)n2, (int)n4, (String[])stringArray2);
                    objectArray = stringArray2;
                } else {
                    objectArray = H5Datatype.allocateArray(n4, (int)l);
                    if (objectArray == null) continue;
                    if (H5.H5Tget_class((int)n4) == HDF5Constants.H5T_ARRAY) {
                        int n9 = -1;
                        n6 = -1;
                        try {
                            n9 = H5.H5Tget_super((int)n4);
                            n6 = H5.H5Tget_native_type((int)n9);
                            H5.H5Aread((int)n2, (int)n6, (Object)objectArray);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            try {
                                H5.H5Tclose((int)n9);
                            }
                            catch (Exception exception) {}
                            try {
                                H5.H5Tclose((int)n6);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        H5.H5Aread((int)n2, (int)n4, (Object)objectArray);
                    }
                    int n10 = H5.H5Tget_class((int)n4);
                    if (n10 == HDF5Constants.H5T_STRING) {
                        objectArray = Dataset.byteToString((byte[])((byte[])objectArray), (int)H5.H5Tget_size((int)n4));
                    } else if (n10 == HDF5Constants.H5T_REFERENCE) {
                        objectArray = HDFNativeData.byteToLong((byte[])((byte[])objectArray));
                    }
                }
                attribute.setValue((Object)objectArray);
                continue;
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose((int)n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose((int)n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose((int)n2);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        return vector;
    }

    private static final void createImageAttributes(Dataset dataset, int n) throws Exception {
        String string = null;
        String string2 = null;
        if (n == 0) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PIXEL";
        } else if (n == 2) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PLANE";
        } else if (n == -1) {
            string = "IMAGE_INDEXED";
        } else {
            throw new HDF5Exception("The selectionFlag is invalid.");
        }
        long[] lArray = new long[]{1L};
        String string3 = "CLASS";
        String[] stringArray = new String[]{"IMAGE"};
        H5Datatype h5Datatype = new H5Datatype(3, stringArray[0].length() + 1, -1, -1);
        Attribute attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
        attribute.setValue((Object)stringArray);
        dataset.writeMetadata((Object)attribute);
        string3 = "IMAGE_VERSION";
        String[] stringArray2 = new String[]{"1.2"};
        h5Datatype = new H5Datatype(3, stringArray2[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
        attribute.setValue((Object)stringArray2);
        dataset.writeMetadata((Object)attribute);
        lArray[0] = 2L;
        string3 = "IMAGE_MINMAXRANGE";
        byte[] byArray = new byte[]{0, -1};
        h5Datatype = new H5Datatype(2, 1, -1, 0);
        attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
        attribute.setValue((Object)byArray);
        dataset.writeMetadata((Object)attribute);
        lArray[0] = 1L;
        string3 = "IMAGE_SUBCLASS";
        String[] stringArray3 = new String[]{string};
        h5Datatype = new H5Datatype(3, stringArray3[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
        attribute.setValue((Object)stringArray3);
        dataset.writeMetadata((Object)attribute);
        if (n == 0 || n == 2) {
            string3 = "INTERLACE_MODE";
            String[] stringArray4 = new String[]{string2};
            h5Datatype = new H5Datatype(3, stringArray4[0].length() + 1, -1, -1);
            attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
            attribute.setValue((Object)stringArray4);
            dataset.writeMetadata((Object)attribute);
        } else {
            string3 = "PALETTE";
            long[] lArray2 = new long[]{-1L};
            h5Datatype = new H5Datatype(7, 1, -1, 0);
            attribute = new Attribute(string3, (Datatype)h5Datatype, lArray);
            attribute.setValue((Object)lArray2);
            dataset.writeMetadata((Object)attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateReferenceDataset(H5File h5File, H5File h5File2) throws Exception {
        H5ScalarDS h5ScalarDS;
        if (h5File == null || h5File2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)h5File.getRootNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)h5File2.getRootNode();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.breadthFirstEnumeration();
        int n = -1;
        int n2 = -1;
        Hashtable<String, long[]> hashtable = new Hashtable<String, long[]>();
        Vector<H5ScalarDS> vector = new Vector<H5ScalarDS>();
        while (enumeration2.hasMoreElements() && enumeration.hasMoreElements()) {
            HObject hObject = (HObject)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            HObject hObject2 = (HObject)((DefaultMutableTreeNode)enumeration2.nextElement()).getUserObject();
            hashtable.put(String.valueOf(hObject.getOID()[0]), hObject2.getOID());
            n = -1;
            n2 = -1;
            if (!(hObject2 instanceof ScalarDS)) continue;
            h5ScalarDS = (ScalarDS)hObject2;
            n = h5ScalarDS.open();
            if (n > 0) {
                try {
                    n2 = H5.H5Dget_type((int)n);
                    if (H5.H5Tequal((int)n2, (int)HDF5Constants.H5T_STD_REF_OBJ)) {
                        vector.add(h5ScalarDS);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        H5.H5Tclose((int)n2);
                    }
                    catch (Exception exception) {}
                }
            }
            h5ScalarDS.close(n);
        }
        h5ScalarDS = null;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = vector.size();
        for (int i = 0; i < n6; ++i) {
            h5ScalarDS = (H5ScalarDS)((Object)vector.get(i));
            byte[] byArray = null;
            long[] lArray = null;
            try {
                n = h5ScalarDS.open();
                n2 = H5.H5Dget_type((int)n);
                n3 = H5.H5Dget_space((int)n);
                n5 = H5.H5Sget_simple_extent_ndims((int)n3);
                n4 = 1;
                if (n5 > 0) {
                    long[] lArray2 = new long[n5];
                    H5.H5Sget_simple_extent_dims((int)n3, (long[])lArray2, null);
                    for (int j = 0; j < n5; ++j) {
                        n4 *= (int)lArray2[j];
                    }
                    lArray2 = null;
                }
                byArray = new byte[n4 * 8];
                H5.H5Dread((int)n, (int)n2, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (byte[])byArray);
                lArray = HDFNativeData.byteToLong((byte[])byArray);
                n4 = lArray.length;
                for (int j = 0; j < n4; ++j) {
                    long[] lArray3 = (long[])hashtable.get(String.valueOf(lArray[j]));
                    if (lArray3 == null) continue;
                    lArray[j] = lArray3[0];
                }
                H5.H5Dwrite((int)n, (int)n2, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (Object)lArray);
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose((int)n2);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Sclose((int)n3);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Dclose((int)n);
                }
                catch (Exception exception) {}
            }
            lArray = null;
            byArray = null;
        }
    }

    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF5 ";
        try {
            H5.H5get_libversion((int[])nArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        string = string + nArray[0] + "." + nArray[1] + "." + nArray[2];
        return string;
    }

    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H5File;
    }

    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = H5.H5Fis_hdf5((String)string);
        }
        catch (HDF5Exception hDF5Exception) {
            bl = false;
        }
        return bl;
    }

    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if (n == 11 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = H5.H5Fcreate((String)string, (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            try {
                H5.H5Fclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {
                // empty catch block
            }
        }
        return new H5File(string, 1);
    }

    public FileFormat createInstance(String string, int n) throws Exception {
        return new H5File(string, n);
    }

    public int open() throws Exception {
        return this.open(true);
    }

    public void close() throws HDF5Exception {
        Object object;
        H5.H5Dchdir_ext((String)System.getProperty("user.dir"));
        if (this.rootNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            HObject hObject = null;
            object = this.rootNode.breadthFirstEnumeration();
            while (object.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Dataset) {
                    ((Dataset)hObject).clear();
                    continue;
                }
                if (!(hObject instanceof Group)) continue;
                ((Group)hObject).clear();
            }
        }
        try {
            int n = 0;
            int n2 = -1;
            n = H5.H5Fget_obj_count((int)this.fid, (int)HDF5Constants.H5F_OBJ_ALL);
            if (n > 0) {
                object = new int[n];
                H5.H5Fget_obj_ids((int)this.fid, (int)HDF5Constants.H5F_OBJ_ALL, (int)n, (int[])object);
                for (int i = 0; i < n; ++i) {
                    n2 = H5.H5Iget_type((int)object[i]);
                    if (HDF5Constants.H5I_DATASET == n2) {
                        try {
                            H5.H5Dclose((int)object[i]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_GROUP == n2) {
                        try {
                            H5.H5Gclose((int)object[i]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_DATATYPE == n2) {
                        try {
                            H5.H5Tclose((int)object[i]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_ATTR != n2) continue;
                    try {
                        H5.H5Aclose((int)object[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Fflush((int)this.fid, (int)HDF5Constants.H5F_SCOPE_GLOBAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Fclose((int)this.fid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fid = -1;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HObject get(String string) throws Exception {
        Object object;
        block38: {
            int n;
            object = null;
            if (string == null || string.length() <= 0) {
                return null;
            }
            string = string.replace('\\', '/');
            string = "/" + string;
            string = string.replaceAll("//", "/");
            if (this.rootNode != null) {
                object = H5File.findObject((FileFormat)this, (String)string);
            }
            if (object != null) {
                return object;
            }
            String string2 = null;
            String string3 = null;
            if (string.equals("/")) {
                string2 = "/";
            } else {
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 2);
                }
                n = string.lastIndexOf(47);
                string2 = string.substring(n + 1);
                string3 = n == 0 ? "/" : string.substring(0, n);
            }
            n = this.fid;
            this.fid = this.open(false);
            if (this.fid < 0) {
                return null;
            }
            try {
                HDF5GroupInfo hDF5GroupInfo = new HDF5GroupInfo();
                H5.H5Gget_objinfo((int)this.fid, (String)string, (boolean)false, (HDF5GroupInfo)hDF5GroupInfo);
                int n2 = hDF5GroupInfo.getType();
                if (n2 == HDF5Constants.H5G_DATASET) {
                    int n3 = -1;
                    try {
                        n3 = H5.H5Dopen((int)this.fid, (String)string);
                        object = this.getDataset(n3, string2, string3);
                        break block38;
                    }
                    finally {
                        try {
                            H5.H5Dclose((int)n3);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (n2 == HDF5Constants.H5G_GROUP) {
                    int n4 = -1;
                    try {
                        n4 = H5.H5Gopen((int)this.fid, (String)string);
                        H5Group h5Group = null;
                        if (string3 != null) {
                            h5Group = new H5Group(this, null, string3, null);
                            object = this.getGroup(n4, string2, h5Group);
                            h5Group.addToMemberList((HObject)object);
                        } else {
                            object = this.getGroup(n4, string2, h5Group);
                        }
                        break block38;
                    }
                    finally {
                        try {
                            H5.H5Gclose((int)n4);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (n2 == HDF5Constants.H5G_TYPE) {
                    object = new H5Datatype(this, string2, string3);
                }
            }
            catch (Exception exception) {
                object = null;
            }
            finally {
                if (n <= 0 && object == null) {
                    try {
                        H5.H5Fclose((int)this.fid);
                    }
                    catch (Exception exception) {}
                    this.fid = n;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        int n5 = -1;
        H5Datatype h5Datatype = null;
        try {
            H5Datatype h5Datatype2 = (H5Datatype)this.createDatatype(n, n2, n3, n4);
            n5 = h5Datatype2.toNative();
            H5.H5Tcommit((int)this.fid, (String)string, (int)n5);
            byte[] byArray = H5.H5Rcreate((int)this.fid, (String)string, (int)HDF5Constants.H5R_OBJECT, (int)-1);
            long l = HDFNativeData.byteToLong((byte[])byArray, (int)0);
            long[] lArray = new long[]{l};
            h5Datatype = new H5Datatype(this, null, string);
        }
        finally {
            if (n5 > 0) {
                H5.H5Tclose((int)n5);
            }
        }
        return h5Datatype;
    }

    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        return new H5Datatype(n, n2, n3, n4);
    }

    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        return H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
    }

    public Dataset createCompoundDS(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        int n2 = stringArray.length;
        int[] nArray2 = new int[n2];
        int[][] nArray3 = new int[n2][1];
        Dataset dataset = null;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = 1;
            nArray3[i][0] = nArray == null ? 1 : nArray[i];
        }
        if (group == null) {
            group = (Group)this.get("/");
        }
        dataset = H5CompoundDS.create(string, group, lArray, lArray2, lArray3, n, stringArray, datatypeArray, nArray2, nArray3, object);
        return dataset;
    }

    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        H5ScalarDS h5ScalarDS = H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
        try {
            H5File.createImageAttributes((Dataset)h5ScalarDS, n3);
            h5ScalarDS.setIsImage(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h5ScalarDS;
    }

    public Group createGroup(String string, Group group) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        return H5Group.create(string, group);
    }

    public HObject createLink(Group group, String string, HObject hObject) throws Exception {
        Object object = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (hObject == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        if (hObject instanceof Group && ((Group)hObject).isRoot()) {
            throw new HDF5Exception("Cannot make a link to the root group.");
        }
        string4 = group == null || group.isRoot() ? "/" : group.getPath() + "/" + group.getName() + "/";
        string3 = string4 + string;
        string2 = hObject.getPath() + "/" + hObject.getName();
        H5.H5Glink((int)this.fid, (int)HDF5Constants.H5G_LINK_HARD, (String)string2, (String)string3);
        if (hObject instanceof Group) {
            object = new H5Group(this, string, string4, group);
        } else if (hObject instanceof H5Datatype) {
            object = new H5Datatype(this, string, string4);
        } else if (hObject instanceof H5CompoundDS) {
            object = new H5CompoundDS(this, string, string4);
        } else if (hObject instanceof H5ScalarDS) {
            object = new H5ScalarDS(this, string, string4);
        }
        return object;
    }

    public void reloadTree(Group group) {
        if (this.fid < 0 || this.rootNode == null || group == null) {
            return;
        }
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (group.equals(this.rootNode.getUserObject())) {
            defaultMutableTreeNode = this.rootNode;
        } else {
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements() && !group.equals(hObject = (HObject)(defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject())) {
            }
        }
        defaultMutableTreeNode.removeAllChildren();
        this.depth_first(defaultMutableTreeNode);
    }

    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        if (hObject instanceof Dataset) {
            treeNode = this.copyDataset((Dataset)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Group) {
            treeNode = this.copyGroup((H5Group)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Datatype) {
            treeNode = this.copyDatatype((H5Datatype)hObject, (H5Group)group, string);
        }
        return treeNode;
    }

    public void delete(HObject hObject) throws Exception {
        if (hObject == null || this.fid < 0) {
            return;
        }
        String string = hObject.getPath() + hObject.getName();
        H5.H5Gunlink((int)this.fid, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws HDF5Exception {
        int n;
        block26: {
            String string = attribute.getName();
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            n = hObject.open();
            if (n < 0) {
                return;
            }
            try {
                n2 = attribute.getType().toNative();
                n3 = H5.H5Screate_simple((int)attribute.getRank(), (long[])attribute.getDataDims(), null);
                n4 = bl ? H5.H5Aopen_name((int)n, (String)string) : H5.H5Acreate((int)n, (String)string, (int)n2, (int)n3, (int)HDF5Constants.H5P_DEFAULT);
                Object object = attribute.getValue();
                if (object == null) break block26;
                if (attribute.getType().getDatatypeClass() == 7 && object instanceof String) {
                    object = H5.H5Rcreate((int)this.getFID(), (String)((String)object), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                } else if (Array.get(object, 0) instanceof String) {
                    String string2 = (String)Array.get(object, 0);
                    int n5 = H5.H5Tget_size((int)n2);
                    if (string2.length() > n5) {
                        string2 = string2.substring(0, n5);
                        Array.set(object, 0, string2);
                    } else {
                        for (int i = string2.length(); i < n5; ++i) {
                            string2 = string2 + " ";
                        }
                    }
                    byte[] byArray = string2.getBytes();
                    byArray[string2.length() - 1] = 0;
                    object = byArray;
                }
                try {
                    int n6 = n2;
                    n2 = H5.H5Tget_native_type((int)n6);
                    try {
                        H5.H5Tclose((int)n6);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                    H5.H5Awrite((int)n4, (int)n2, (Object)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    H5.H5Tclose((int)n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose((int)n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose((int)n4);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        hObject.close(n);
    }

    public int open(int n) throws Exception {
        return this.open(true, n);
    }

    private int open(boolean bl) throws Exception {
        int n = -1;
        int n2 = HDF5Constants.H5P_DEFAULT;
        n = this.open(bl, n2);
        return n;
    }

    private int open(boolean bl, int n) throws Exception {
        if (this.fid > 0) {
            return this.fid;
        }
        H5.H5Dchdir_ext((String)System.getProperty("user.dir"));
        if (this.flag < 0) {
            throw new HDF5Exception("Invalid access identifer -- " + this.flag);
        }
        if (HDF5Constants.H5F_ACC_CREAT == this.flag) {
            this.fid = H5.H5Fcreate((String)this.fullFileName, (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Fflush((int)this.fid, (int)HDF5Constants.H5F_SCOPE_LOCAL);
            H5.H5Fclose((int)this.fid);
            this.flag = HDF5Constants.H5F_ACC_RDWR;
        } else {
            if (!this.exists()) {
                throw new HDF5Exception("File does not exist -- " + this.fullFileName);
            }
            if (!(this.flag != HDF5Constants.H5F_ACC_RDWR && this.flag != HDF5Constants.H5F_ACC_CREAT || this.canWrite())) {
                throw new HDF5Exception("Cannot write file, try open as read-only -- " + this.fullFileName);
            }
            if (this.flag == HDF5Constants.H5F_ACC_RDONLY && !this.canRead()) {
                throw new HDF5Exception("Cannot read file -- " + this.fullFileName);
            }
        }
        try {
            this.fid = H5.H5Fopen((String)this.fullFileName, (int)this.flag, (int)n);
        }
        catch (Exception exception) {
            this.isReadOnly = true;
            this.fid = H5.H5Fopen((String)this.fullFileName, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (this.fid >= 0 && bl) {
            this.rootNode = this.loadTree();
        }
        return this.fid;
    }

    private DefaultMutableTreeNode loadTree() {
        if (this.fid < 0) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        long[] lArray = new long[]{0L};
        H5Group h5Group = new H5Group(this, this.getName(), null, null, lArray);
        defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h5Group){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.depth_first(defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depth_first(MutableTreeNode mutableTreeNode) {
        Object[] objectArray;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
        int n = -1;
        H5Group h5Group = (H5Group)((Object)defaultMutableTreeNode2.getUserObject());
        string2 = h5Group.getPath();
        if (string2 == null) {
            string = "/";
            string3 = "/";
        } else {
            string3 = h5Group.getName();
            string = string2 + h5Group.getName() + "/";
        }
        int n2 = 0;
        try {
            n = h5Group.open();
            objectArray = new long[]{0L};
            H5.H5Gget_num_objs((int)n, (long[])objectArray);
            n2 = objectArray[0];
        }
        catch (HDF5Exception hDF5Exception) {
            n2 = -1;
        }
        if (n2 <= 0) {
            h5Group.close(n);
            return;
        }
        objectArray = new int[n2];
        long[] lArray = new long[n2];
        String[] stringArray = new String[n2];
        try {
            H5.H5Gget_obj_info_all((int)this.fid, (String)string, (String[])stringArray, (int[])objectArray, (long[])lArray);
        }
        catch (HDF5Exception hDF5Exception) {
            return;
        }
        int n3 = Math.max(0, this.getStartMembers());
        int n4 = this.getMaxMembers();
        if (n4 >= n2) {
            n4 = n2;
            n3 = 0;
        }
        n4 += n3;
        n4 = Math.min(n4, n2);
        long[] lArray2 = null;
        for (int i = n3; i < n4; ++i) {
            Object object;
            Object object2;
            lArray2 = null;
            String string4 = stringArray[i];
            int n5 = objectArray[i];
            long l = lArray[i];
            if (string4 == null) continue;
            try {
                if (n5 == HDF5Constants.H5G_LINK) {
                    object2 = null;
                    String[] stringArray2 = new String[]{""};
                    H5.H5Gget_linkval((int)this.fid, (String)(string + string4), (int)100, (String[])stringArray2);
                    if (stringArray2[0] != null && !stringArray2[0].startsWith("/")) {
                        stringArray2[0] = string + stringArray2[0];
                    }
                    object2 = H5.H5Rcreate((int)this.fid, (String)stringArray2[0], (int)HDF5Constants.H5R_OBJECT, (int)-1);
                    if (stringArray2[0] != null && stringArray2[0].length() > 0 && object2 != null) {
                        n5 = H5.H5Rget_obj_type((int)this.fid, (int)HDF5Constants.H5R_OBJECT, (byte[])object2);
                    }
                }
                lArray2 = new long[]{l};
            }
            catch (HDF5Exception hDF5Exception) {
                hDF5Exception.printStackTrace();
            }
            if (lArray2 == null) continue;
            if (n5 == HDF5Constants.H5G_GROUP) {
                object2 = new H5Group(this, string4, string, h5Group, lArray2);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object2){
                    public static final long serialVersionUID = 240L;

                    @Override
                    public boolean isLeaf() {
                        return false;
                    }
                };
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h5Group.addToMemberList((HObject)object2);
                boolean bl = false;
                HObject hObject = null;
                for (object = defaultMutableTreeNode2; object != null; object = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent()) {
                    hObject = (HObject)((DefaultMutableTreeNode)object).getUserObject();
                    if (!hObject.equalsOID(lArray2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.depth_first(defaultMutableTreeNode);
                continue;
            }
            if (n5 == HDF5Constants.H5G_DATASET) {
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                try {
                    n6 = H5.H5Dopen((int)this.fid, (String)(string + string4));
                    n7 = H5.H5Dget_type((int)n6);
                    n8 = H5.H5Tget_class((int)n7);
                    if (n8 == HDF5Constants.H5T_ARRAY || n8 == HDF5Constants.H5T_VLEN) {
                        int n9 = H5.H5Tget_super((int)n7);
                        n8 = H5.H5Tget_class((int)n9);
                        try {
                            H5.H5Tclose((int)n9);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            // empty catch block
                        }
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                }
                finally {
                    try {
                        H5.H5Tclose((int)n7);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Dclose((int)n6);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
                object = null;
                object = n8 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string4, string, lArray2) : new H5ScalarDS(this, string4, string, lArray2);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h5Group.addToMemberList((HObject)object);
                continue;
            }
            if (n5 != HDF5Constants.H5G_TYPE) continue;
            object2 = new H5Datatype(this, string4, string, lArray2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(object2);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h5Group.addToMemberList((HObject)object2);
        }
        h5Group.close(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TreeNode copyDataset(Dataset dataset, H5Group h5Group, String string) throws Exception {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block49: {
            Object object = null;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            String string2 = null;
            String string3 = null;
            string3 = h5Group.isRoot() ? "/" : h5Group.getPath() + h5Group.getName() + "/";
            if (string == null || string.equals("/") || string.length() < 1) {
                string = dataset.getName();
            }
            string2 = string3 + string;
            try {
                int n6;
                int n7;
                int n8;
                block48: {
                    n = dataset.open();
                    n3 = H5.H5Dget_type((int)n);
                    n4 = H5.H5Dget_space((int)n);
                    n5 = H5.H5Dget_create_plist((int)n);
                    n2 = H5.H5Dcreate((int)h5Group.getFID(), (String)string2, (int)n3, (int)n4, (int)n5);
                    H5.H5Dcopy((int)n, (int)n2);
                    H5File.copyAttributes(n, n2);
                    object = dataset instanceof H5ScalarDS ? new H5ScalarDS(h5Group.getFileFormat(), string, string3) : new H5CompoundDS(h5Group.getFileFormat(), string, string3);
                    h5Group.addToMemberList((HObject)object);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                    n8 = -1;
                    n7 = -1;
                    n6 = -1;
                    n8 = H5.H5Aopen_name((int)n, (String)"PALETTE");
                    n7 = H5.H5Aopen_name((int)n2, (String)"PALETTE");
                    n6 = H5.H5Aget_type((int)n8);
                    if (H5.H5Tget_class((int)n6) != HDF5Constants.H5T_REFERENCE) break block48;
                    long[] lArray = new long[1];
                    H5.H5Aread((int)n8, (int)n6, (Object)lArray);
                    HObject hObject = H5File.findObject((FileFormat)dataset.getFileFormat(), (long[])lArray);
                    if (hObject == null || !(hObject instanceof Dataset)) break block48;
                    try {
                        this.copy(hObject, h5Group, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byte[] byArray = H5.H5Rcreate((int)h5Group.getFID(), (String)(string3 + hObject.getName()), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                    H5.H5Awrite((int)n7, (int)n6, (byte[])byArray);
                }
                try {
                    H5.H5Tclose((int)n6);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    H5.H5Aclose((int)n8);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    H5.H5Aclose((int)n7);
                }
                catch (Exception exception) {}
                break block49;
                catch (Exception exception) {
                    try {
                        H5.H5Tclose((int)n6);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        H5.H5Aclose((int)n8);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        H5.H5Aclose((int)n7);
                    }
                    catch (Exception exception4) {}
                    break block49;
                    catch (Throwable throwable) {
                        try {
                            H5.H5Tclose((int)n6);
                        }
                        catch (Exception exception5) {
                            // empty catch block
                        }
                        try {
                            H5.H5Aclose((int)n8);
                        }
                        catch (Exception exception6) {
                            // empty catch block
                        }
                        try {
                            H5.H5Aclose((int)n7);
                        }
                        catch (Exception exception7) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    H5.H5Pclose((int)n5);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Sclose((int)n4);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Tclose((int)n3);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Dclose((int)n);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Dclose((int)n2);
                }
                catch (Exception exception) {}
            }
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset getDataset(int n, String string, String string2) throws HDF5Exception {
        Object object = null;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = H5.H5Dget_type((int)n);
            n3 = H5.H5Tget_class((int)n2);
            if (n3 == HDF5Constants.H5T_ARRAY) {
                int n4 = H5.H5Tget_super((int)n2);
                n3 = H5.H5Tget_class((int)n4);
                try {
                    H5.H5Tclose((int)n4);
                }
                catch (HDF5Exception hDF5Exception) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                H5.H5Tclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        object = n3 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string, string2) : new H5ScalarDS(this, string, string2);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyDatatype(Datatype datatype, H5Group h5Group, String string) throws Exception {
        H5Datatype h5Datatype = null;
        String string2 = null;
        String string3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        string3 = h5Group.isRoot() ? "/" : h5Group.getPath() + h5Group.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = datatype.getName();
        }
        string2 = string3 + string;
        int n = datatype.open();
        int n2 = H5.H5Tcopy((int)n);
        try {
            H5.H5Tcommit((int)h5Group.getFID(), (String)string2, (int)n2);
            h5Datatype = new H5Datatype(h5Group.getFileFormat(), string, string3);
            h5Group.addToMemberList((HObject)h5Datatype);
            defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h5Datatype);
        }
        finally {
            try {
                H5.H5Tclose((int)n);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose((int)n2);
            }
            catch (Exception exception) {}
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyGroup(H5Group h5Group, H5Group h5Group2, String string) throws Exception {
        H5Group h5Group3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        string3 = h5Group2.isRoot() ? "/" : h5Group2.getPath() + h5Group2.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = h5Group.getName();
        }
        string2 = string3 + string;
        try {
            n = h5Group.open();
            n2 = H5.H5Gcreate((int)h5Group2.getFID(), (String)string2, (int)0);
            h5Group3 = new H5Group(h5Group2.getFileFormat(), string, string3, h5Group2);
            H5File.copyAttributes(n, n2);
            defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h5Group3){
                public static final long serialVersionUID = 240L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            h5Group2.addToMemberList((HObject)h5Group3);
            List list = h5Group.getMemberList();
            if (list != null && list.size() > 0) {
                for (HObject hObject : list) {
                    try {
                        defaultMutableTreeNode.add((MutableTreeNode)this.copy(hObject, h5Group3, null));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            try {
                h5Group.close(n);
            }
            catch (Exception exception) {}
            try {
                H5.H5Gclose((int)n2);
            }
            catch (Exception exception) {}
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private H5Group getGroup(int n, String string, Group group) throws HDF5Exception {
        Object[] objectArray;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (group == null) {
            string = "/";
            string3 = "/";
        } else {
            string2 = group.getFullName();
            string3 = string2 == null || string2.equals("/") ? "/" + string : string2 + "/" + string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("//", "/");
        }
        if (string3 != null) {
            string3 = string3.replaceAll("//", "/");
        }
        H5Group h5Group = new H5Group(this, string, string2, group);
        int n2 = 0;
        try {
            objectArray = new long[]{0L};
            H5.H5Gget_num_objs((int)n, (long[])objectArray);
            n2 = (int)objectArray[0];
        }
        catch (HDF5Exception hDF5Exception) {
            n2 = -1;
        }
        objectArray = new int[1];
        String[] stringArray = new String[1];
        for (int i = 0; i < n2; ++i) {
            stringArray[0] = "";
            objectArray[0] = -1;
            try {
                H5.H5Gget_objname_by_idx((int)n, (long)i, (String[])stringArray, (long)256L);
                objectArray[0] = H5.H5Gget_objtype_by_idx((int)n, (long)i);
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            if (objectArray[0] == HDF5Constants.H5G_GROUP) {
                H5Group h5Group2 = new H5Group(this, stringArray[0], string3, h5Group);
                h5Group.addToMemberList((HObject)h5Group2);
                continue;
            }
            if (objectArray[0] != HDF5Constants.H5G_DATASET) continue;
            int n3 = -1;
            Dataset dataset = null;
            string4 = string3 == null || string3.equals("/") ? "/" + stringArray[0] : string3 + "/" + stringArray[0];
            try {
                n3 = H5.H5Dopen((int)this.fid, (String)string4);
                dataset = this.getDataset(n3, stringArray[0], string3);
            }
            finally {
                try {
                    H5.H5Dclose((int)n3);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            h5Group.addToMemberList((HObject)dataset);
        }
        return h5Group;
    }
}

