/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ncsa.hdf.view.ViewProperties;

public class Chart
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 240L;
    public static final int HISTOGRAM = 0;
    public static final int LINEPLOT = 1;
    public static final Color[] LINE_COLORS = new Color[]{Color.black, Color.red, Color.green.darker(), Color.blue, Color.magenta, Color.pink, Color.yellow, Color.orange, Color.gray, Color.cyan};
    protected double[][] data;
    protected ChartPanel chartP;
    protected int numberOfPoints;
    private int chartStyle;
    private double ymax;
    private double ymin;
    private double xmax;
    private double xmin;
    private String[] lineLabels;
    private Color[] lineColors;
    private int numberOfLines;
    private double[] xData = null;
    private boolean isInteger;
    private DecimalFormat format;

    public Chart(Frame frame, String string, int n, double[][] dArray, double[] dArray2, double[] dArray3) {
        super(frame, string, false);
        this.setDefaultCloseOperation(2);
        this.format = new DecimalFormat("0.00E0");
        if (dArray == null) {
            return;
        }
        this.chartStyle = n;
        this.data = dArray;
        this.isInteger = n == 0;
        if (dArray2 != null) {
            int n2 = dArray2.length;
            if (n2 == 2) {
                this.xmin = dArray2[0];
                this.xmax = dArray2[1];
            } else {
                this.xData = dArray2;
                this.xmin = this.xmax = dArray2[0];
                for (int i = 0; i < n2; ++i) {
                    if (dArray2[i] < this.xmin) {
                        this.xmin = dArray2[i];
                    }
                    if (!(dArray2[i] > this.xmax)) continue;
                    this.xmax = dArray2[i];
                }
            }
        } else {
            this.xmin = 1.0;
            this.xmax = dArray[0].length;
        }
        this.numberOfLines = Array.getLength(dArray);
        this.numberOfPoints = Array.getLength(dArray[0]);
        this.lineColors = LINE_COLORS;
        if (dArray3 != null) {
            this.ymin = dArray3[0];
            this.ymax = dArray3[1];
        } else {
            this.findDataRange();
        }
        if (this.ymax > 1.0E-6 && this.ymax < 1000000.0) {
            this.format = new DecimalFormat("0.######");
        }
        this.chartP = new ChartPanel();
        this.chartP.setBackground(Color.white);
        this.createUI();
    }

    protected void createUI() {
        Window window = this.getOwner();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n = 640 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 400 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.add((Component)this.chartP, "Center");
        JButton jButton = new JButton("Close");
        jButton.addActionListener(this);
        jButton.setActionCommand("Close");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        Point point = window.getLocation();
        point.x += 220;
        point.y += 100;
        this.setLocation(point);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.dispose();
        }
    }

    public void setLineColors(Color[] colorArray) {
        this.lineColors = colorArray;
    }

    public void setLineLabels(String[] stringArray) {
        this.lineLabels = stringArray;
    }

    public void setTypeToInteger() {
        this.isInteger = true;
    }

    private void findDataRange() {
        if (this.data == null) {
            return;
        }
        this.ymin = this.ymax = this.data[0][0];
        for (int i = 0; i < this.numberOfLines; ++i) {
            for (int j = 0; j < this.numberOfPoints; ++j) {
                if (this.data[i][j] < this.ymin) {
                    this.ymin = this.data[i][j];
                }
                if (!(this.data[i][j] > this.ymax)) continue;
                this.ymax = this.data[i][j];
            }
        }
    }

    private class ChartPanel
    extends JComponent {
        public static final long serialVersionUID = 240L;

        private ChartPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (Chart.this.numberOfLines <= 0) {
                return;
            }
            Dimension dimension = this.getSize();
            int n = 20;
            int n2 = 2 * n;
            int n3 = 2 * n;
            int n4 = 0;
            if (Chart.this.chartStyle == 1 && Chart.this.lineLabels != null) {
                n4 = 60;
            }
            int n5 = dimension.height - n;
            int n6 = dimension.width - (3 * n + n4);
            int n7 = Math.min(10, Chart.this.numberOfPoints - 1);
            int n8 = 10;
            graphics.drawLine(n2, n5, n6 + n2, n5);
            graphics.drawLine(n3, n5, n3, 0);
            double d = 0.0;
            double d2 = Chart.this.xmin;
            double d3 = (double)n6 / (double)n7;
            double d4 = (Chart.this.xmax - Chart.this.xmin) / (double)n7;
            boolean bl = d4 >= 1.0;
            for (int i = 0; i <= n7; ++i) {
                d2 = Chart.this.xmin + (double)i * d4;
                d = (double)n2 + (double)i * d3;
                graphics.drawLine((int)d, n5, (int)d, n5 - 5);
                if (bl) {
                    graphics.drawString(String.valueOf((int)d2), (int)d - 5, n5 + n);
                    continue;
                }
                graphics.drawString(String.valueOf(d2), (int)d - 5, n5 + n);
            }
            double d5 = 0.0;
            double d6 = Chart.this.ymin;
            double d7 = (double)n5 / (double)n8;
            double d8 = (Chart.this.ymax - Chart.this.ymin) / (double)n8;
            if (d8 > 1.0) {
                d8 = (double)Math.round(d8 * 10.0) / 10.0;
            }
            for (int i = 0; i <= n8; ++i) {
                d5 = (double)i * d7;
                d6 = (double)i * d8 + Chart.this.ymin;
                graphics.drawLine(n3, n5 - (int)d5, n3 + 5, n5 - (int)d5);
                if (Chart.this.isInteger) {
                    graphics.drawString(String.valueOf((int)d6), 0, n5 - (int)d5 + 8);
                    continue;
                }
                graphics.drawString(Chart.this.format.format(d6), 0, n5 - (int)d5 + 8);
            }
            Color color = graphics.getColor();
            if (Chart.this.chartStyle == 1) {
                d3 = (double)n6 / (double)(Chart.this.numberOfPoints - 1);
                double d9 = (double)n5 / (Chart.this.ymin - Chart.this.ymax);
                double d10 = -d9 * Chart.this.ymax;
                boolean bl2 = Chart.this.xData != null && Chart.this.xData.length >= Chart.this.numberOfPoints;
                double d11 = 1.0 / (Chart.this.xmax - Chart.this.xmin) * (double)n6;
                double d12 = Chart.this.xmin / (Chart.this.xmax - Chart.this.xmin) * (double)n6;
                for (int i = 0; i < Chart.this.numberOfLines; ++i) {
                    if (Chart.this.lineColors != null && Chart.this.lineColors.length >= Chart.this.numberOfLines) {
                        graphics.setColor(Chart.this.lineColors[i]);
                    }
                    double d13 = bl2 ? (double)n2 + Chart.this.xData[0] * d11 - d12 : (double)n2;
                    double d14 = d10 + d9 * Chart.this.data[i][0];
                    for (int j = 1; j < Chart.this.numberOfPoints; ++j) {
                        double d15 = bl2 ? (double)n2 + Chart.this.xData[j] * d11 - d12 : (double)n2 + (double)j * d3;
                        double d16 = d10 + d9 * Chart.this.data[i][j];
                        graphics.drawLine((int)d13, (int)d14, (int)d15, (int)d16);
                        d13 = d15;
                        d14 = d16;
                    }
                    if (Chart.this.lineLabels == null || Chart.this.lineLabels.length < Chart.this.numberOfLines) continue;
                    d13 = n6 + n4;
                    d14 = n + n * i;
                    graphics.drawLine((int)d13, (int)d14, (int)d13 + 7, (int)d14);
                    graphics.drawString(Chart.this.lineLabels[i], (int)d13 + 10, (int)d14 + 3);
                }
                graphics.setColor(color);
                if (Chart.this.lineLabels != null && Chart.this.lineLabels.length >= Chart.this.numberOfLines) {
                    graphics.drawRect(n6 + n4 - 10, 10, n4, 10 * n);
                }
            } else if (Chart.this.chartStyle == 0) {
                d = n2;
                d5 = 0.0;
                graphics.setColor(Color.blue);
                int n9 = n6 / Chart.this.numberOfPoints;
                if (n9 <= 0) {
                    n9 = 1;
                }
                d3 = (double)n6 / (double)Chart.this.numberOfPoints;
                for (int i = 0; i < Chart.this.numberOfPoints; ++i) {
                    d = (double)n2 + (double)i * d3;
                    d5 = (int)((double)n5 * (Chart.this.data[0][i] - Chart.this.ymin) / (Chart.this.ymax - Chart.this.ymin));
                    graphics.fillRect((int)d, (int)((double)n5 - d5), n9, (int)d5);
                }
                graphics.setColor(color);
            }
        }
    }
}

