/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewAttributeDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultMetaDataView
extends JDialog
implements ActionListener,
MetaDataView {
    public static final long serialVersionUID = 240L;
    private ViewManager viewer;
    private HObject hObject;
    private JTabbedPane tabbedPane = null;
    private JTextArea attrContentArea;
    private JTable attrTable;
    private DefaultTableModel attrTableModel;
    private JLabel attrNumberLabel;
    private int numAttributes;
    private boolean isH5;
    private boolean isH4;
    private byte[] userBlock;
    private JTextArea userBlockArea;
    private JButton jamButton;

    public DefaultMetaDataView(ViewManager viewManager) {
        super((Frame)((JFrame)((Object)viewManager)), false);
        boolean bl;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.hObject = this.viewer.getTreeView().getCurrentObject();
        this.numAttributes = 0;
        this.userBlock = null;
        this.userBlockArea = null;
        if (this.hObject == null) {
            this.dispose();
        } else if (this.hObject.getPath() == null) {
            this.setTitle("Properties - " + this.hObject.getName());
        } else {
            this.setTitle("Properties - " + this.hObject.getPath() + this.hObject.getName());
        }
        this.isH5 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.isH4 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF"));
        this.tabbedPane = new JTabbedPane();
        try {
            this.hObject.getMetadata();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tabbedPane.addTab("General", this.createGeneralPropertyPanel());
        this.tabbedPane.addTab("Attributes", this.createAttributePanel());
        boolean bl2 = bl = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        if (this.isH5 && bl) {
            this.tabbedPane.addTab("User Block", this.createUserBlockPanel());
        }
        this.tabbedPane.setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("  Close  ");
        jButton.setMnemonic(67);
        jButton.setActionCommand("Close");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setPreferredSize(new Dimension(620, 400));
        jPanel2.add("Center", this.tabbedPane);
        jPanel2.add("South", jPanel);
        Point point = this.getParent().getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.dispose();
        } else if (string.equals("Add attribute")) {
            this.addAttribute(this.hObject);
        } else if (string.equals("Delete attribute")) {
            this.deleteAttribute(this.hObject);
        } else if (string.equals("Jam user block")) {
            this.writeUserBlock();
        } else if (string.equals("Display user block as")) {
            int n = 0;
            String string2 = (String)((JComboBox)object).getSelectedItem();
            this.jamButton.setEnabled(false);
            this.userBlockArea.setEditable(false);
            if (string2.equalsIgnoreCase("Text")) {
                n = 0;
                this.jamButton.setEnabled(true);
                this.userBlockArea.setEditable(true);
            } else if (string2.equalsIgnoreCase("Binary")) {
                n = 2;
            } else if (string2.equalsIgnoreCase("Octal")) {
                n = 8;
            } else if (string2.equalsIgnoreCase("Hexadecimal")) {
                n = 16;
            } else if (string2.equalsIgnoreCase("Decimal")) {
                n = 10;
            }
            this.showUserBlockAs(n);
        }
    }

    @Override
    public HObject getDataObject() {
        return this.hObject;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Attribute addAttribute(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hObject.getFileFormat().getRootNode();
        NewAttributeDialog newAttributeDialog = new NewAttributeDialog((Dialog)this, hObject, defaultMutableTreeNode.breadthFirstEnumeration());
        newAttributeDialog.setVisible(true);
        Attribute attribute = newAttributeDialog.getAttribute();
        if (attribute == null) {
            return null;
        }
        Object[] objectArray = new String[4];
        boolean bl = false;
        objectArray[0] = attribute.getName();
        objectArray[2] = attribute.getType().getDatatypeDescription();
        bl = attribute.getType().isUnsigned();
        objectArray[1] = attribute.toString(", ");
        long[] lArray = attribute.getDataDims();
        objectArray[3] = String.valueOf(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            objectArray[3] = (String)objectArray[3] + " x " + lArray[i];
        }
        this.attrTableModel.addRow(objectArray);
        this.attrTableModel.fireTableRowsInserted(this.attrTableModel.getRowCount() - 1, this.attrTableModel.getRowCount() - 1);
        ++this.numAttributes;
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attribute;
    }

    @Override
    public Attribute deleteAttribute(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        int n = this.attrTable.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(this.getOwner(), "No attribute is selected.", this.getTitle(), 0);
            return null;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected attribute?", this.getTitle(), 0, 2);
        if (n2 == 1) {
            return null;
        }
        List list = null;
        try {
            list = hObject.getMetadata();
        }
        catch (Exception exception) {
            list = null;
        }
        if (list == null) {
            return null;
        }
        Attribute attribute = (Attribute)list.get(n);
        try {
            hObject.removeMetadata((Object)attribute);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.attrTableModel.removeRow(n);
        --this.numAttributes;
        this.attrTableModel.fireTableRowsDeleted(n, n);
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attribute;
    }

    private JPanel createGeneralPropertyPanel() {
        Serializable serializable;
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        boolean bl = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        FileFormat fileFormat = this.hObject.getFileFormat();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(4, 1));
        if (bl) {
            jPanel3.add(new JLabel("File Name: "));
            jPanel3.add(new JLabel("File Path: "));
            jPanel3.add(new JLabel("File Type: "));
        } else {
            jPanel3.add(new JLabel("Name: "));
            jPanel3.add(new JLabel("Path: "));
            jPanel3.add(new JLabel("Type: "));
            if (this.isH4) {
                jPanel3.add(new JLabel("Tag, Ref:        "));
            } else {
                jPanel3.add(new JLabel("Object Ref:       "));
            }
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(4, 1));
        JLabel jLabel = new JLabel(this.hObject.getName());
        jPanel4.add(jLabel);
        JLabel jLabel2 = new JLabel();
        if (bl) {
            jLabel2.setText(new File(this.hObject.getFile()).getParent());
        } else {
            jLabel2.setText(this.hObject.getPath());
        }
        jPanel4.add(jLabel2);
        String string = "Unknown";
        String string2 = "";
        if (bl) {
            long l = 0L;
            try {
                l = new File(this.hObject.getFile()).length();
            }
            catch (Exception exception) {
                l = -1L;
            }
            l /= 1024L;
            int n2 = 0;
            n = 0;
            serializable = (DefaultMutableTreeNode)fileFormat.getRootNode();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            Enumeration<TreeNode> enumeration = serializable.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode.getUserObject() instanceof Group) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            string2 = "size=" + l + "K,  groups=" + n2 + ",  datasets=" + n;
        }
        if (bl) {
            string = this.isH5 ? "HDF5,  " + string2 : (this.isH4 ? "HDF4,  " + string2 : string2);
        } else if (this.isH5) {
            if (this.hObject instanceof Group) {
                string = "HDF5 Group";
            } else if (this.hObject instanceof ScalarDS) {
                string = "HDF5 Scalar Dataset";
            } else if (this.hObject instanceof CompoundDS) {
                string = "HDF5 Compound Dataset";
            } else if (this.hObject instanceof Datatype) {
                string = "HDF5 Named Datatype";
            }
        } else if (this.isH4) {
            if (this.hObject instanceof Group) {
                string = "HDF4 Group";
            } else if (this.hObject instanceof ScalarDS) {
                ScalarDS scalarDS = (ScalarDS)this.hObject;
                string = scalarDS.isImage() ? "HDF4 Raster Image" : "HDF4 SDS";
            } else if (this.hObject instanceof CompoundDS) {
                string = "HDF4 Vdata";
            }
        } else if (this.hObject instanceof Group) {
            string = "Group";
        } else if (this.hObject instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)this.hObject;
            string = "Scalar Dataset";
        } else if (this.hObject instanceof CompoundDS) {
            string = "Compound Dataset";
        }
        JLabel jLabel3 = new JLabel(string);
        jPanel4.add(jLabel3);
        String string3 = null;
        long[] lArray = this.hObject.getOID();
        if (lArray != null) {
            string3 = String.valueOf(lArray[0]);
            for (n = 1; n < lArray.length; ++n) {
                string3 = string3 + ", " + lArray[n];
            }
        }
        if (!bl) {
            JLabel jLabel4 = new JLabel(string3);
            jPanel4.add(jLabel4);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add("West", jPanel3);
        jPanel5.add("Center", jPanel4);
        jPanel5.setBorder(new TitledBorder(""));
        jPanel2.add("North", new JLabel(""));
        jPanel2.add("Center", jPanel5);
        serializable = null;
        if (this.hObject instanceof Group) {
            serializable = this.createGroupInfoPanel((Group)this.hObject);
        } else if (this.hObject instanceof Dataset) {
            serializable = this.createDatasetInfoPanel((Dataset)this.hObject);
        } else if (this.hObject instanceof Datatype) {
            serializable = this.createNamedDatatypeInfoPanel((Datatype)this.hObject);
        }
        jPanel.add((Component)jPanel2, "North");
        if (serializable != null) {
            jPanel.add((Component)serializable, "Center");
        }
        return jPanel;
    }

    private JPanel createGroupInfoPanel(Group group) {
        Object object;
        JPanel jPanel = new JPanel();
        List list = group.getMemberList();
        if (list == null) {
            return jPanel;
        }
        int n = list.size();
        if (n <= 0) {
            return jPanel;
        }
        Object[][] objectArray = new String[n][2];
        for (int i = 0; i < n; ++i) {
            object = (HObject)list.get(i);
            objectArray[i][0] = object.getName();
            if (object instanceof Group) {
                objectArray[i][1] = "Group";
                continue;
            }
            if (!(object instanceof Dataset)) continue;
            objectArray[i][1] = "Dataset";
        }
        Object[] objectArray2 = new String[]{"Name", "Type"};
        object = new JTable(objectArray, objectArray2){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((JTable)object).setCellSelectionEnabled(false);
        int n2 = Math.max(16, ((JComponent)object).getFontMetrics(((Component)object).getFont()).getHeight());
        ((JTable)object).setRowHeight(n2);
        ((JTable)object).getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        jPanel.setLayout(new BorderLayout());
        if (group.getNumberOfMembersInFile() < ViewProperties.getMaxMembers()) {
            jPanel.add((Component)new JLabel("Number of members: " + n), "North");
        } else {
            jPanel.add((Component)new JLabel("Number of members: " + n + " (in memory), " + group.getNumberOfMembersInFile() + " (in file)"), "North");
        }
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(new TitledBorder("Group Members"));
        return jPanel;
    }

    private JPanel createNamedDatatypeInfoPanel(Datatype datatype) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea(datatype.getDatatypeDescription());
        jTextArea.setEditable(false);
        jPanel.add((Component)jTextArea, "Center");
        return jPanel;
    }

    private JPanel createDatasetInfoPanel(Dataset dataset) {
        Object object;
        Object object2;
        Object object3;
        int n;
        CharSequence charSequence;
        Serializable serializable;
        Object object4;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        jPanel.add(new JLabel("No. of Dimension(s): "));
        jPanel.add(new JLabel("Dimension Size(s): "));
        jPanel.add(new JLabel("Max Dimension Size(s): "));
        jPanel.add(new JLabel("Data Type: "));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        if (dataset.getRank() <= 0) {
            dataset.init();
        }
        JTextField jTextField = new JTextField("" + dataset.getRank());
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        String string = null;
        String string2 = null;
        long[] lArray = dataset.getDims();
        long[] lArray2 = dataset.getMaxDims();
        if (lArray != null) {
            object4 = dataset.getDimNames();
            boolean bl = object4 != null && ((String[])object4).length == lArray.length;
            serializable = new StringBuffer();
            charSequence = new StringBuffer();
            ((StringBuffer)serializable).append(lArray[0]);
            if (bl) {
                ((StringBuffer)serializable).append(" (");
                ((StringBuffer)serializable).append(object4[0]);
                ((StringBuffer)serializable).append(")");
            }
            if (lArray2[0] < 0L) {
                charSequence.append("Unlimited");
            } else {
                charSequence.append(lArray2[0]);
            }
            for (n = 1; n < lArray.length; ++n) {
                ((StringBuffer)serializable).append(" x ");
                ((StringBuffer)serializable).append(lArray[n]);
                if (bl) {
                    ((StringBuffer)serializable).append(" (");
                    ((StringBuffer)serializable).append(object4[n]);
                    ((StringBuffer)serializable).append(")");
                }
                charSequence.append(" x ");
                if (lArray2[n] < 0L) {
                    charSequence.append("Unlimited");
                    continue;
                }
                charSequence.append(lArray2[n]);
            }
            string = ((StringBuffer)serializable).toString();
            string2 = charSequence.toString();
        }
        jTextField = new JTextField(string);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        object4 = null;
        if (dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)dataset;
            object4 = scalarDS.getDatatype().getDatatypeDescription();
        } else if (dataset instanceof CompoundDS) {
            object4 = this.isH4 ? "Vdata" : "Compound";
        }
        jTextField = new JTextField((String)object4);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.setBorder(new TitledBorder(""));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add(jPanel3, "North");
        ((JComponent)serializable).setBorder(new TitledBorder("Dataspace and Datatype"));
        if (dataset instanceof CompoundDS && (n = (charSequence = (CompoundDS)dataset).getMemberCount()) > 0) {
            Object object5;
            object3 = new String[n][3];
            object2 = charSequence.getMemberNames();
            object = charSequence.getMemberTypes();
            int[] nArray = charSequence.getMemberOrders();
            for (int i = 0; i < n; ++i) {
                object3[i][0] = object2[i];
                object5 = charSequence.getMemeberDims(i);
                if (object5 == null) {
                    object3[i][2] = String.valueOf(nArray[i]);
                    if (this.isH4 && object[i].getDatatypeClass() == 3) {
                        object3[i][2] = String.valueOf(object[i].getDatatypeSize());
                    }
                } else {
                    String string3 = String.valueOf(object5[0]);
                    int n2 = ((int[])object5).length;
                    for (int j = 1; j < n2; ++j) {
                        string3 = string3 + " x " + (int)object5[j];
                    }
                    object3[i][2] = string3;
                }
                object3[i][1] = object[i].getDatatypeDescription();
            }
            Object[] objectArray = new String[]{"Name", "Type", "Array Size"};
            object5 = new JTable((Object[][])object3, objectArray){
                public static final long serialVersionUID = 240L;

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            object5.setCellSelectionEnabled(false);
            object5.getTableHeader().setReorderingAllowed(false);
            ((Container)serializable).add(new JScrollPane((Component)object5), "Center");
            int n3 = Math.max(16, object5.getFontMetrics(object5.getFont()).getHeight());
            object5.setRowHeight(n3);
        }
        charSequence = "";
        long[] lArray3 = dataset.getChunkSize();
        if (lArray3 == null) {
            charSequence = "NONE";
        } else {
            int n4 = lArray3.length;
            charSequence = String.valueOf(lArray3[0]);
            for (int i = 1; i < n4; ++i) {
                charSequence = (String)charSequence + " X " + lArray3[i];
            }
        }
        object3 = new JPanel();
        ((JComponent)object3).setBorder(new TitledBorder(""));
        ((Container)object3).setLayout(new BorderLayout());
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add(new JLabel("Chunking: "));
        jPanel.add(new JLabel("Compression: "));
        jPanel.add(new JLabel("Fill value: "));
        ((Container)object3).add((Component)jPanel, "West");
        object2 = null;
        object = "NONE";
        if (dataset instanceof ScalarDS) {
            object2 = ((ScalarDS)dataset).getFillValue();
        }
        if (object2 != null) {
            if (object2.getClass().isArray()) {
                int n5 = Array.getLength(object2);
                object = Array.get(object2, 0).toString();
                for (int i = 1; i < n5; ++i) {
                    object = (String)object + ", ";
                    object = (String)object + Array.get(object2, i).toString();
                }
            } else {
                object = object2.toString();
            }
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(new JLabel((String)charSequence));
        jPanel2.add(new JLabel(dataset.getCompression()));
        jPanel2.add(new JLabel((String)object));
        ((Container)object3).add((Component)jPanel2, "Center");
        ((Container)serializable).add((Component)object3, "South");
        return serializable;
    }

    private JPanel createAttributePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.attrNumberLabel = new JLabel("Number of attributes = 0");
        jPanel2.add((Component)this.attrNumberLabel, "West");
        FileFormat fileFormat = this.hObject.getFileFormat();
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(" Add ");
        jButton.setMnemonic('A');
        jButton.addActionListener(this);
        jButton.setActionCommand("Add attribute");
        jPanel3.add(jButton);
        jButton.setEnabled(!fileFormat.isReadOnly());
        if (this.isH5) {
            jButton = new JButton("Delete");
            jButton.setMnemonic('D');
            jButton.addActionListener(this);
            jButton.setActionCommand("Delete attribute");
            jPanel3.add(jButton);
            jButton.setEnabled(!fileFormat.isReadOnly());
        }
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "North");
        List list = null;
        try {
            list = this.hObject.getMetadata();
        }
        catch (Exception exception) {
            list = null;
        }
        if (list != null) {
            this.numAttributes = list.size();
        }
        Object[] objectArray = new String[]{"Name", "Value", "Type", "Array Size"};
        this.attrTableModel = new DefaultTableModel(objectArray, this.numAttributes);
        this.attrTable = new JTable(this.attrTableModel){
            public static final long serialVersionUID = 240L;
            int lastSelectedRow;
            int lastSelectedCol;
            {
                this.lastSelectedRow = -1;
                this.lastSelectedCol = -1;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                String string = (String)this.getValueAt(n, n2);
                super.editingStopped(changeEvent);
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string2 = (String)cellEditor.getCellEditorValue();
                    this.setValueAt(string, n, n2);
                    DefaultMetaDataView.this.updateAttributeValue(string2, n, n2);
                }
            }

            @Override
            public boolean isCellSelected(int n, int n2) {
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n2 && (this.lastSelectedRow != n || this.lastSelectedCol != n2)) {
                    Object object = this.getValueAt(n, n2);
                    if (object != null) {
                        DefaultMetaDataView.this.attrContentArea.setText(object.toString());
                    }
                    this.lastSelectedRow = n;
                    this.lastSelectedCol = n2;
                }
                return super.isCellSelected(n, n2);
            }
        };
        this.attrTable.setRowSelectionAllowed(false);
        this.attrTable.setCellSelectionEnabled(true);
        this.attrTable.getTableHeader().setReorderingAllowed(false);
        this.attrTable.setSelectionMode(0);
        int n = Math.max(16, this.attrTable.getFontMetrics(this.attrTable.getFont()).getHeight());
        this.attrTable.setRowHeight(n);
        JScrollPane jScrollPane = new JScrollPane(this.attrTable);
        this.attrContentArea = new JTextArea();
        this.attrContentArea.setLineWrap(true);
        this.attrContentArea.setEditable(false);
        Insets insets = new Insets(5, 5, 5, 5);
        this.attrContentArea.setMargin(insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.attrContentArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        int n2 = Math.min((this.numAttributes + 2) * this.attrTable.getRowHeight(), jScrollPane.getPreferredSize().height - 40);
        jSplitPane.setDividerLocation(n2);
        jPanel.add((Component)jSplitPane, "Center");
        if (list == null) {
            return jPanel;
        }
        Attribute attribute = null;
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        for (int i = 0; i < this.numAttributes; ++i) {
            attribute = (Attribute)list.get(i);
            String string = attribute.getName();
            boolean bl = false;
            String string2 = attribute.getType().getDatatypeDescription();
            bl = attribute.getType().isUnsigned();
            long[] lArray = attribute.getDataDims();
            String string3 = String.valueOf(lArray[0]);
            for (int j = 1; j < lArray.length; ++j) {
                string3 = string3 + " x " + lArray[j];
            }
            this.attrTable.setValueAt(string, i, 0);
            this.attrTable.setValueAt(attribute.toString(", "), i, 1);
            this.attrTable.setValueAt(string2, i, 2);
            this.attrTable.setValueAt(string3, i, 3);
        }
        return jPanel;
    }

    private JPanel createUserBlockPanel() {
        JPanel jPanel = new JPanel();
        this.userBlock = DefaultFileFilter.getHDF5UserBlock(this.hObject.getFile());
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.userBlockArea = new JTextArea();
        this.userBlockArea.setEditable(true);
        this.userBlockArea.setLineWrap(true);
        Insets insets = new Insets(5, 5, 5, 5);
        this.userBlockArea.setMargin(insets);
        String[] stringArray = new String[]{"Text", "Binary", "Octal", "Hexadecimal", "Decimal"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(0);
        jComboBox.addActionListener(this);
        jComboBox.setEditable(false);
        jComboBox.setActionCommand("Display user block as");
        JLabel jLabel = new JLabel("Header Size (Bytes): 0");
        this.jamButton = new JButton("Save User Block");
        this.jamButton.setActionCommand("Jam user block");
        this.jamButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 5));
        jPanel2.add((Component)new JLabel("Display As:"), "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 10, 5));
        jPanel3.add(jComboBox);
        jPanel3.add(jLabel);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)this.jamButton, "East");
        JScrollPane jScrollPane = new JScrollPane(this.userBlockArea);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        int n = 0;
        if (this.userBlock != null) {
            n = this.showUserBlockAs(0);
            jLabel.setText("Header Size (Bytes): " + n);
        } else {
            jComboBox.setEnabled(false);
        }
        return jPanel;
    }

    private int showUserBlockAs(int n) {
        int n2 = 0;
        if (this.userBlock == null) {
            return 0;
        }
        String string = null;
        if (n == 2 || n == 8 || n == 16 || n == 10) {
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < this.userBlock.length; ++n2) {
                int n3 = this.userBlock[n2];
                if (n3 < 0) {
                    n3 += 256;
                } else if (n3 == 0) break;
                stringBuffer.append(Integer.toString(n3, n));
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        } else {
            string = new String(this.userBlock).trim();
            if (string != null) {
                n2 = string.length();
            }
        }
        this.userBlockArea.setText(string);
        return n2;
    }

    private void updateAttributeValue(String string, int n, int n2) {
        if (n2 != 1) {
            return;
        }
        String string2 = (String)this.attrTable.getValueAt(n, 0);
        List list = null;
        try {
            list = this.hObject.getMetadata();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getOwner(), exception.getMessage(), this.getTitle(), 0);
            return;
        }
        Attribute attribute = (Attribute)list.get(n);
        Object object = attribute.getValue();
        if (object == null) {
            return;
        }
        int n3 = Array.getLength(object);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < n3) {
            JOptionPane.showMessageDialog(this.getOwner(), "More data value needed: " + string, this.getTitle(), 0);
            return;
        }
        int n4 = 32;
        String string3 = object.getClass().getName();
        int n5 = string3.lastIndexOf("[");
        if (n5 >= 0) {
            n4 = string3.charAt(n5 + 1);
        }
        boolean bl = attribute.isUnsigned();
        double d = 0.0;
        String string4 = null;
        long l = 0L;
        long l2 = 0L;
        block13: for (int i = 0; i < n3; ++i) {
            l2 = 0L;
            l = 0L;
            string4 = stringTokenizer.nextToken().trim();
            try {
                if (!(Array.get(object, i) instanceof String)) {
                    d = Double.parseDouble(string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.getOwner(), numberFormatException.getMessage(), this.getTitle(), 0);
                return;
            }
            if (bl && d < 0.0) {
                JOptionPane.showMessageDialog(this.getOwner(), "Negative value for unsigned integer: " + string, this.getTitle(), 0);
                return;
            }
            switch (n4) {
                case 66: {
                    if (bl) {
                        l2 = 0L;
                        l = 255L;
                    } else {
                        l2 = -128L;
                        l = 127L;
                    }
                    if (d > (double)l || d < (double)l2) {
                        JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                        continue block13;
                    }
                    Array.setByte(object, i, (byte)d);
                    continue block13;
                }
                case 83: {
                    if (bl) {
                        l2 = 0L;
                        l = 65535L;
                    } else {
                        l2 = -32768L;
                        l = 32767L;
                    }
                    if (d > (double)l || d < (double)l2) {
                        JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                        continue block13;
                    }
                    Array.setShort(object, i, (short)d);
                    continue block13;
                }
                case 73: {
                    if (bl) {
                        l2 = 0L;
                        l = 0xFFFFFFFFL;
                    } else {
                        l2 = Integer.MIN_VALUE;
                        l = Integer.MAX_VALUE;
                    }
                    if (d > (double)l || d < (double)l2) {
                        JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                        continue block13;
                    }
                    Array.setInt(object, i, (int)d);
                    continue block13;
                }
                case 74: {
                    Array.setLong(object, i, (long)d);
                    continue block13;
                }
                case 70: {
                    Array.setFloat(object, i, (float)d);
                    continue block13;
                }
                default: {
                    Array.set(object, i, string);
                }
            }
        }
        try {
            this.hObject.getFileFormat().writeAttribute(this.hObject, attribute, true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getOwner(), exception.getMessage(), this.getTitle(), 0);
            return;
        }
        this.attrTable.setValueAt(attribute.toString(", "), n, 1);
    }

    private void writeUserBlock() {
        int n;
        if (!this.isH5) {
            return;
        }
        int n2 = 0;
        if (this.userBlock != null && (n2 = this.userBlock.length) > 0) {
            for (n = 512; n < n2; n *= 2) {
            }
            n2 = n;
        }
        n = 0;
        String string = this.userBlockArea.getText();
        if (string == null) {
            if (n2 <= 0) {
                return;
            }
            string = " ";
        }
        byte[] byArray = null;
        byArray = string.getBytes();
        n = byArray.length;
        if (n <= n2) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.hObject.getFile(), "rw");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Can't open output file: " + this.hObject.getFile(), this.getTitle(), 0);
                return;
            }
            try {
                randomAccessFile.seek(0L);
                randomAccessFile.write(byArray, 0, byArray.length);
                randomAccessFile.seek(byArray.length);
                if (n2 > byArray.length) {
                    byte[] byArray2 = new byte[n2 - byArray.length];
                    randomAccessFile.write(byArray2, 0, byArray2.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this, "Saving user block is successful.", this.getTitle(), 1);
        } else {
            Serializable serializable;
            int n3 = JOptionPane.showConfirmDialog(this, "The user block to write is " + n + " (bytes),\n" + "which is larger than the user block space in file " + n2 + " (bytes).\n" + "To expand the user block, the file must be rewriten.\n\n" + "Do you want to replace the current file? Click " + "\n\"Yes\" to replace the current file," + "\n\"No\" to save to a different file, " + "\n\"Cancel\" to quit without saving the change.\n\n ", this.getTitle(), 1, 2);
            if (n3 == 2) {
                return;
            }
            String string2 = this.hObject.getFile();
            String string3 = string2 + "~copy.h5";
            if (string2.endsWith(".h5")) {
                string3 = string2.substring(0, string2.length() - 3) + "~copy.h5";
            } else if (string2.endsWith(".hdf5")) {
                string3 = string2.substring(0, string2.length() - 5) + "~copy.h5";
            }
            File file = null;
            if (n3 == 1) {
                serializable = new JFileChooser();
                ((JFileChooser)serializable).setFileFilter(DefaultFileFilter.getFileFilterHDF5());
                ((JFileChooser)serializable).setSelectedFile(new File(string3));
                int n4 = ((JFileChooser)serializable).showSaveDialog(this);
                if (n4 != 0) {
                    return;
                }
                File file2 = ((JFileChooser)serializable).getSelectedFile();
                if (file2 == null) {
                    return;
                }
                file = file2;
                string3 = file.getAbsolutePath();
            } else {
                file = new File(string3);
            }
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                    return;
                }
            }
            serializable = new ActionEvent(this, 1001, "Close file");
            ((HDFView)this.viewer).actionPerformed((ActionEvent)serializable);
            if (DefaultFileFilter.setHDF5UserBlock(string2, string3, byArray)) {
                if (n3 == 1) {
                    string2 = string3;
                } else {
                    File file3 = new File(string2);
                    boolean bl = file3.delete();
                    if (bl) {
                        file.renameTo(file3);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot replace the current file.\nPlease save to a different file.", this.getTitle(), 0);
                        file.delete();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                file.delete();
            }
            this.dispose();
            serializable = new ActionEvent(this, 1001, "Open file://" + string2);
            ((HDFView)this.viewer).actionPerformed((ActionEvent)serializable);
        }
    }
}

