/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.ViewProperties;

public class NewDatasetDialog
extends JDialog
implements ActionListener,
ItemListener,
HyperlinkListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JTextField currentSizeField;
    private JTextField maxSizeField;
    private JTextField chunkSizeField;
    private JTextField stringLengthField;
    private JComboBox parentChoice;
    private JComboBox classChoice;
    private JComboBox sizeChoice;
    private JComboBox endianChoice;
    private JComboBox rankChoice;
    private JComboBox compressionLevel;
    private JCheckBox checkUnsigned;
    private JCheckBox checkCompression;
    private JRadioButton checkContinguous;
    private JRadioButton checkChunked;
    private JDialog helpDialog = null;
    private boolean isH5;
    private List groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private final DataView dataView;

    public NewDatasetDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Dataset...", true);
        Object object;
        this.dataView = null;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object e2 = null;
        for (Object e2 : list) {
            if (!(e2 instanceof Group)) continue;
            object = (Group)e2;
            this.groupList.add(e2);
            if (object.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(object.getPath() + object.getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        object = (JPanel)this.getContentPane();
        ((Container)object).setLayout(new BorderLayout(5, 5));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 350 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object).setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Help");
        jButton3.setMnemonic(72);
        jButton3.setActionCommand("Show help");
        jButton3.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        ((Container)object).add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Dataset name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)object).add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 4, 15, 3));
        TitledBorder titledBorder = new TitledBorder("Datatype");
        titledBorder.setTitleColor(Color.blue);
        jPanel4.setBorder(titledBorder);
        this.stringLengthField = new JTextField("String length");
        this.stringLengthField.setEnabled(false);
        this.endianChoice = new JComboBox();
        this.classChoice = new JComboBox();
        this.sizeChoice = new JComboBox();
        this.endianChoice.setEnabled(this.isH5);
        this.classChoice.addItem("INTEGER");
        this.classChoice.addItem("FLOAT");
        this.classChoice.addItem("CHAR");
        if (this.isH5) {
            this.classChoice.addItem("STRING");
            this.classChoice.addItem("REFERENCE");
            this.classChoice.addItem("ENUM");
            this.sizeChoice.addItem("NATIVE");
            this.endianChoice.addItem("NATIVE");
            this.endianChoice.addItem("LITTLE ENDIAN");
            this.endianChoice.addItem("BIG ENDIAN");
        } else {
            this.sizeChoice.addItem("DEFAULT");
            this.endianChoice.addItem("DEFAULT");
        }
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("32");
        this.sizeChoice.addItem("64");
        jPanel4.add(new JLabel("Datatype class"));
        jPanel4.add(new JLabel("Size (bits)"));
        jPanel4.add(new JLabel("Byte ordering"));
        this.checkUnsigned = new JCheckBox("Unsigned");
        jPanel4.add(this.checkUnsigned);
        jPanel4.add(this.classChoice);
        jPanel4.add(this.sizeChoice);
        jPanel4.add(this.endianChoice);
        jPanel4.add(this.stringLengthField);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 3, 15, 3));
        titledBorder = new TitledBorder("Dataspace");
        titledBorder.setTitleColor(Color.blue);
        jPanel5.setBorder(titledBorder);
        this.rankChoice = new JComboBox();
        for (int i = 1; i < 33; ++i) {
            this.rankChoice.addItem(String.valueOf(i));
        }
        this.rankChoice.setSelectedIndex(1);
        this.currentSizeField = new JTextField("1 x 1");
        this.maxSizeField = new JTextField("0 x 0");
        jPanel5.add(new JLabel("No. of dimensions"));
        jPanel5.add(new JLabel("Current size"));
        jPanel5.add(new JLabel(""));
        jPanel5.add(this.rankChoice);
        jPanel5.add(this.currentSizeField);
        JButton jButton4 = new JButton("Set Max Size");
        jButton4.setActionCommand("Set max size");
        jButton4.addActionListener(this);
        jPanel5.add(jButton4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        titledBorder = new TitledBorder("Data Layout and Compression");
        titledBorder.setTitleColor(Color.blue);
        jPanel6.setBorder(titledBorder);
        this.checkContinguous = new JRadioButton("Contiguous");
        this.checkContinguous.setSelected(true);
        this.checkChunked = new JRadioButton("Chunked");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkChunked);
        buttonGroup.add(this.checkContinguous);
        this.chunkSizeField = new JTextField("1 x 1");
        this.chunkSizeField.setEnabled(false);
        this.checkCompression = new JCheckBox("gzip");
        this.compressionLevel = new JComboBox();
        for (int i = 0; i < 10; ++i) {
            this.compressionLevel.addItem(String.valueOf(i));
        }
        this.compressionLevel.setSelectedIndex(6);
        this.compressionLevel.setEnabled(false);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Storage layout:  "));
        jPanel3.add(new JLabel("Compression:  "));
        jPanel6.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2));
        jPanel7.add(this.checkContinguous);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 3));
        jPanel8.add(this.checkChunked);
        jPanel8.add(new JLabel("          Size: "));
        jPanel8.add(this.chunkSizeField);
        jPanel7.add(jPanel8);
        jPanel3.add(jPanel7);
        jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 7));
        jPanel7.add(this.checkCompression);
        jPanel7.add(new JLabel("      Level: "));
        jPanel7.add(this.compressionLevel);
        jPanel7.add(new JLabel(""));
        jPanel7.add(new JLabel(""));
        jPanel7.add(new JLabel(""));
        jPanel7.add(new JLabel(""));
        jPanel3.add(jPanel7);
        jPanel6.add((Component)jPanel3, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(3, 1, 5, 10));
        jPanel9.add(jPanel4);
        jPanel9.add(jPanel5);
        jPanel9.add(jPanel6);
        ((Container)object).add((Component)jPanel9, "Center");
        this.classChoice.addItemListener(this);
        this.sizeChoice.addItemListener(this);
        this.rankChoice.addItemListener(this);
        this.checkCompression.addItemListener(this);
        this.checkContinguous.addItemListener(this);
        this.checkChunked.addItemListener(this);
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    public NewDatasetDialog(JFrame jFrame, Group group, List list, DataView dataView) {
        super(jFrame, "New Dataset...", true);
        Object object;
        this.dataView = dataView;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object e2 = null;
        for (Object e2 : list) {
            if (!(e2 instanceof Group)) continue;
            object = (Group)e2;
            this.groupList.add(e2);
            if (object.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(object.getPath() + object.getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        object = (JPanel)this.getContentPane();
        ((Container)object).setLayout(new BorderLayout(5, 5));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 120 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object).setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        ((Container)object).add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Dataset name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField(dataView.getDataObject().getName() + "~copy", 40);
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)object).add((Component)jPanel2, "Center");
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.dataView instanceof TableView) {
                this.newObject = this.createFromTable();
            } else if (this.dataView instanceof ImageView) {
                this.newObject = this.createFromImage();
            } else if (this.dataView == null) {
                this.newObject = this.createFromScratch();
            }
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        } else if (string.equals("Show help")) {
            if (this.helpDialog == null) {
                this.createHelpDialog();
            }
            this.helpDialog.setVisible(true);
        } else if (string.equals("Hide help")) {
            if (this.helpDialog != null) {
                this.helpDialog.setVisible(false);
            }
        } else if (string.equals("Set max size")) {
            String string2 = JOptionPane.showInputDialog(this, "Enter max dimension sizes. \nUse \"unlimited\" for unlimited dimension size.\n\nFor example,\n    200 x 100\n    100 x unlimited\n\n", this.currentSizeField.getText());
            if (string2 == null || string2.length() < 1) {
                this.maxSizeField.setText(this.currentSizeField.getText());
            } else {
                this.maxSizeField.setText(string2);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.classChoice)) {
            int n = this.classChoice.getSelectedIndex();
            this.sizeChoice.setSelectedIndex(0);
            this.endianChoice.setSelectedIndex(0);
            this.stringLengthField.setEnabled(false);
            if (n == 0) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
                if (this.sizeChoice.getItemCount() == 3) {
                    this.sizeChoice.removeItem("32");
                    this.sizeChoice.removeItem("64");
                    this.sizeChoice.addItem("8");
                    this.sizeChoice.addItem("16");
                    this.sizeChoice.addItem("32");
                    this.sizeChoice.addItem("64");
                }
                if (this.sizeChoice.getSelectedItem().equals("64")) {
                    this.checkUnsigned.setSelected(false);
                    this.checkUnsigned.setEnabled(false);
                }
            } else if (n == 1) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(false);
                if (this.sizeChoice.getItemCount() == 5) {
                    this.sizeChoice.removeItem("16");
                    this.sizeChoice.removeItem("8");
                }
            } else if (n == 2) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
            } else if (n == 3) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("String length");
            } else if (n == 4) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(false);
            } else if (n == 5) {
                this.sizeChoice.setEnabled(true);
                this.checkUnsigned.setEnabled(true);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("R=0,G=1,B=2,...");
            }
        } else if (object.equals(this.sizeChoice)) {
            if (this.classChoice.getSelectedIndex() == 0) {
                if (this.sizeChoice.getSelectedItem().equals("64")) {
                    this.checkUnsigned.setSelected(false);
                    this.checkUnsigned.setEnabled(false);
                } else {
                    this.checkUnsigned.setEnabled(true);
                }
            }
        } else if (object.equals(this.rankChoice)) {
            int n = this.rankChoice.getSelectedIndex() + 1;
            String string = "1";
            String string2 = "0";
            for (int i = 1; i < n; ++i) {
                string = string + " x 1";
                string2 = string2 + " x 0";
            }
            this.currentSizeField.setText(string);
            this.maxSizeField.setText(string2);
            String string3 = this.currentSizeField.getText();
            int n2 = string3.lastIndexOf("x");
            String string4 = "1";
            if (n <= 1) {
                string4 = string3;
            } else {
                for (int i = 1; i < n - 1; ++i) {
                    string4 = string4 + " x 1";
                }
                if (n2 > 0) {
                    string4 = string4 + " x " + string3.substring(n2 + 1);
                }
            }
            this.chunkSizeField.setText(string4);
        } else if (object.equals(this.checkContinguous)) {
            this.chunkSizeField.setEnabled(false);
        } else if (object.equals(this.checkChunked)) {
            this.chunkSizeField.setEnabled(true);
            String string = "";
            StringTokenizer stringTokenizer = new StringTokenizer(this.currentSizeField.getText(), "x");
            int n = this.rankChoice.getSelectedIndex() + 1;
            while (stringTokenizer.hasMoreTokens()) {
                long l = Math.max(1L, Long.valueOf(stringTokenizer.nextToken().trim()) / (long)(2 * n));
                string = string + String.valueOf(l) + "x";
            }
            string = string.substring(0, string.lastIndexOf(120));
            this.chunkSizeField.setText(string);
        } else if (object.equals(this.checkCompression)) {
            boolean bl = this.checkCompression.isSelected();
            if (bl) {
                if (!this.checkChunked.isSelected()) {
                    String string = this.currentSizeField.getText();
                    int n = string.lastIndexOf("x");
                    String string5 = "1";
                    int n3 = this.rankChoice.getSelectedIndex() + 1;
                    if (n3 <= 1) {
                        string5 = string;
                    } else {
                        for (int i = 1; i < n3 - 1; ++i) {
                            string5 = string5 + " x 1";
                        }
                        if (n > 0) {
                            string5 = string5 + " x " + string.substring(n + 1);
                        }
                    }
                    this.chunkSizeField.setText(string5);
                }
                this.compressionLevel.setEnabled(true);
                this.checkContinguous.setEnabled(false);
                this.checkChunked.setSelected(true);
                this.chunkSizeField.setEnabled(true);
            } else {
                this.compressionLevel.setEnabled(false);
                this.checkContinguous.setEnabled(true);
            }
        }
    }

    private void createHelpDialog() {
        Serializable serializable;
        this.helpDialog = new JDialog((Dialog)this, "Create New Dataset");
        JPanel jPanel = (JPanel)this.helpDialog.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 400 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("  Ok  ");
        jButton.addActionListener(this);
        jButton.setActionCommand("Hide help");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jPanel.add((Component)jScrollPane, "Center");
        try {
            serializable = null;
            URL uRL = null;
            URL uRL2 = null;
            String string = ViewProperties.getViewRoot();
            try {
                serializable = new URL("file:" + string + "/lib/jhdfview.jar");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                uRL = new URL("file:" + string + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                uRL2 = new URL("file:" + string + "/src/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            URL[] uRLArray = new URL[]{serializable, uRL, uRL2};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            URL uRL3 = uRLClassLoader.findResource("ncsa/hdf/view/NewDatasetHelp.html");
            jEditorPane.setPage(uRL3);
            jEditorPane.addHyperlinkListener(this);
        }
        catch (Exception exception) {
            jEditorPane.setContentType("text/html");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("<body>");
            stringBuffer.append("ERROR: cannot load help information.");
            stringBuffer.append("</body>");
            stringBuffer.append("</html>");
            jEditorPane.setText(stringBuffer.toString());
        }
        serializable = this.helpDialog.getOwner().getLocation();
        ((Point)serializable).x += 50;
        ((Point)serializable).y += 80;
        this.helpDialog.setLocation((Point)serializable);
        this.helpDialog.validate();
        this.helpDialog.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private HObject createFromScratch() {
        int n;
        String string = null;
        Group group = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        string = this.nameField.getText().trim();
        if (string == null || string.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        int n8 = this.classChoice.getSelectedIndex();
        if (n8 == 0) {
            n4 = 0;
            if (this.checkUnsigned.isSelected()) {
                n7 = 0;
            }
        } else if (n8 == 1) {
            n4 = 1;
        } else if (n8 == 2) {
            n4 = 2;
            if (this.checkUnsigned.isSelected()) {
                n7 = 0;
            }
        } else if (n8 == 3) {
            n4 = 3;
        } else if (n8 == 4) {
            n4 = 7;
        } else if (n8 == 5) {
            n4 = 8;
        }
        n8 = this.sizeChoice.getSelectedIndex();
        if (n4 == 3) {
            int n9 = 0;
            try {
                n9 = Integer.parseInt(this.stringLengthField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n9 = -1;
            }
            if (n9 <= 0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid string length: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
            n5 = n9;
        } else if (n4 == 8) {
            String string2 = this.stringLengthField.getText();
            if (string2 == null || string2.length() < 1 || string2.endsWith("...")) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid member values: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
        } else {
            n5 = n4 == 7 ? 1 : (n8 == 0 ? -1 : (n4 == 1 ? n8 * 4 : 1 << n8 - 1));
        }
        if (n5 == 8 && !this.isH5 && n4 == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "HDF4 does not support 64-bit integer.", this.getTitle(), 0);
            return null;
        }
        n8 = this.endianChoice.getSelectedIndex();
        n6 = n8 == 0 ? -1 : (n8 == 1 ? 0 : 1);
        n2 = this.rankChoice.getSelectedIndex() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.currentSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n2) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the current dimension size is less than " + n2, this.getTitle(), 0);
            return null;
        }
        long l = 0L;
        long[] lArray = new long[n2];
        String string3 = null;
        for (n = 0; n < n2; ++n) {
            string3 = stringTokenizer.nextToken().trim();
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + this.currentSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l <= 0L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size must be greater than zero.", this.getTitle(), 0);
                return null;
            }
            lArray[n] = l;
        }
        stringTokenizer = new StringTokenizer(this.maxSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n2) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the max dimension size is less than " + n2, this.getTitle(), 0);
            return null;
        }
        l = 0L;
        long[] lArray2 = new long[n2];
        for (n = 0; n < n2; ++n) {
            string3 = stringTokenizer.nextToken().trim();
            if ((string3 = string3.toLowerCase()).startsWith("unl")) {
                l = -1L;
            } else {
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + this.maxSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
            }
            if (l < -1L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size cannot be less than -1.", this.getTitle(), 0);
                return null;
            }
            if (l == 0L) {
                l = lArray[n];
            }
            lArray2[n] = l;
        }
        long[] lArray3 = null;
        if (this.checkChunked.isSelected()) {
            int n10;
            stringTokenizer = new StringTokenizer(this.chunkSizeField.getText(), "x");
            if (stringTokenizer.countTokens() < n2) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the chunk size is less than " + n2, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            lArray3 = new long[n2];
            for (n = 0; n < n2; ++n) {
                string3 = stringTokenizer.nextToken().trim();
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid chunk dimension size: " + this.chunkSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
                if (l < 1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Chunk size cannot be less than 1.", this.getTitle(), 0);
                    return null;
                }
                lArray3[n] = l;
            }
            long l2 = 1L;
            long l3 = 1L;
            for (n10 = 0; n10 < n2; ++n10) {
                l2 *= lArray3[n10];
                l3 *= lArray[n10];
            }
            if (l2 >= l3) {
                this.toolkit.beep();
                n10 = JOptionPane.showConfirmDialog(this, "Chunk size is equal/greater than the current size. \nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n10 == 1) {
                    return null;
                }
            }
            if (l2 == 1L) {
                this.toolkit.beep();
                n10 = JOptionPane.showConfirmDialog(this, "Chunk size is one, which may cause large memory overhead for large dataset.\nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n10 == 1) {
                    return null;
                }
            }
        }
        n3 = this.checkCompression.isSelected() ? this.compressionLevel.getSelectedIndex() : 0;
        Dataset dataset = null;
        try {
            Datatype datatype = this.fileFormat.createDatatype(n4, n5, n6, n7);
            if (n4 == 8) {
                datatype.setEnumMembers(this.stringLengthField.getText());
            }
            dataset = this.fileFormat.createScalarDS(string, group, datatype, lArray, lArray2, lArray3, n3, null);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
        return dataset;
    }

    private HObject createFromTable() {
        Object object;
        Dataset dataset = null;
        String string = null;
        Group group = null;
        string = this.nameField.getText();
        if (string == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        TableView tableView = (TableView)this.dataView;
        Object object2 = tableView.getSelectedData();
        if (object2 == null) {
            return null;
        }
        int n = tableView.getTable().getSelectedColumnCount();
        int n2 = tableView.getTable().getSelectedRowCount();
        Dataset dataset2 = (Dataset)tableView.getDataObject();
        if (dataset2 instanceof ScalarDS && (object = (ScalarDS)dataset2).isUnsigned()) {
            object2 = Dataset.convertToUnsignedC((Object)object2);
        }
        try {
            object = new long[]{n2, n};
            dataset = dataset2.copy(group, string, (long[])object, object2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        return dataset;
    }

    private HObject createFromImage() {
        Dataset dataset = null;
        String string = null;
        Group group = null;
        string = this.nameField.getText();
        if (string == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        ImageView imageView = (ImageView)this.dataView;
        ScalarDS scalarDS = (ScalarDS)imageView.getDataObject();
        Object object = imageView.getSelectedData();
        if (object == null) {
            return null;
        }
        if (scalarDS.isUnsigned()) {
            object = Dataset.convertToUnsignedC((Object)object);
        }
        int n = imageView.getSelectedArea().width;
        int n2 = imageView.getSelectedArea().height;
        try {
            long[] lArray = null;
            if (this.isH5) {
                if (imageView.isTrueColor()) {
                    lArray = new long[3];
                    if (imageView.isPlaneInterlace()) {
                        lArray[0] = 3L;
                        lArray[1] = n2;
                        lArray[2] = n;
                    } else {
                        lArray[0] = n2;
                        lArray[1] = n;
                        lArray[2] = 3L;
                    }
                } else {
                    lArray = new long[]{n2, n};
                }
            } else {
                lArray = new long[]{n, n2};
            }
            dataset = scalarDS.copy(group, string, lArray, object);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        return dataset;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

