/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewDatatypeDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JTextField stringLengthField;
    private JComboBox parentChoice;
    private JComboBox classChoice;
    private JComboBox sizeChoice;
    private JComboBox endianChoice;
    private JCheckBox checkUnsigned;
    private boolean isH5;
    private List groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewDatatypeDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Datatype...", true);
        Object object;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector(list.size());
        Object e2 = null;
        for (Object e2 : list) {
            if (!(e2 instanceof Group)) continue;
            object = (Group)e2;
            this.groupList.add(e2);
            if (object.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(object.getPath() + object.getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        object = (JPanel)this.getContentPane();
        ((Container)object).setLayout(new BorderLayout(5, 5));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 200 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object).setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        ((Container)object).add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Datatype name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)object).add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 4, 15, 3));
        TitledBorder titledBorder = new TitledBorder("Datatype");
        titledBorder.setTitleColor(Color.blue);
        jPanel4.setBorder(titledBorder);
        this.stringLengthField = new JTextField("String length");
        this.stringLengthField.setEnabled(false);
        this.endianChoice = new JComboBox();
        this.classChoice = new JComboBox();
        this.sizeChoice = new JComboBox();
        this.endianChoice.setEnabled(this.isH5);
        this.classChoice.addItem("INTEGER");
        this.classChoice.addItem("FLOAT");
        this.classChoice.addItem("CHAR");
        if (this.isH5) {
            this.classChoice.addItem("STRING");
            this.classChoice.addItem("REFERENCE");
            this.sizeChoice.addItem("NATIVE");
            this.endianChoice.addItem("NATIVE");
            this.endianChoice.addItem("LITTLE ENDIAN");
            this.endianChoice.addItem("BIG ENDIAN");
        } else {
            this.sizeChoice.addItem("DEFAULT");
            this.endianChoice.addItem("DEFAULT");
            jPanel4.add(new JLabel());
        }
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("32");
        this.sizeChoice.addItem("64");
        jPanel4.add(new JLabel("Datatype class"));
        jPanel4.add(new JLabel("Size (bits)"));
        jPanel4.add(new JLabel("Byte ordering"));
        this.checkUnsigned = new JCheckBox("Unsigned");
        jPanel4.add(this.checkUnsigned);
        jPanel4.add(this.classChoice);
        jPanel4.add(this.sizeChoice);
        jPanel4.add(this.endianChoice);
        jPanel4.add(this.stringLengthField);
        ((Container)object).add((Component)jPanel4, "Center");
        this.classChoice.addItemListener(this);
        this.sizeChoice.addItemListener(this);
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 100;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.newObject = this.createDatatype();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.classChoice)) {
            int n = this.classChoice.getSelectedIndex();
            this.sizeChoice.setSelectedIndex(0);
            this.endianChoice.setSelectedIndex(0);
            this.stringLengthField.setEnabled(false);
            if (n == 0) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
                if (this.sizeChoice.getItemCount() == 3) {
                    this.sizeChoice.removeItem("32");
                    this.sizeChoice.removeItem("64");
                    this.sizeChoice.addItem("8");
                    this.sizeChoice.addItem("16");
                    this.sizeChoice.addItem("32");
                    this.sizeChoice.addItem("64");
                }
                if (this.sizeChoice.getSelectedItem().equals("64")) {
                    this.checkUnsigned.setSelected(false);
                    this.checkUnsigned.setEnabled(false);
                }
            } else if (n == 1) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(false);
                if (this.sizeChoice.getItemCount() == 5) {
                    this.sizeChoice.removeItem("16");
                    this.sizeChoice.removeItem("8");
                }
            } else if (n == 2) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
            } else if (n == 3) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("String length");
            } else if (n == 4) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(false);
            }
        } else if (object.equals(this.sizeChoice) && this.classChoice.getSelectedIndex() == 0) {
            if (this.sizeChoice.getSelectedItem().equals("64")) {
                this.checkUnsigned.setSelected(false);
                this.checkUnsigned.setEnabled(false);
            } else {
                this.checkUnsigned.setEnabled(true);
            }
        }
    }

    private HObject createDatatype() {
        String string = null;
        Group group = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        string = this.nameField.getText().trim();
        if (string == null || string.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Datatype name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Datatype name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        int n5 = this.classChoice.getSelectedIndex();
        if (n5 == 0) {
            n = 0;
            if (this.checkUnsigned.isSelected()) {
                n4 = 0;
            }
        } else if (n5 == 1) {
            n = 1;
        } else if (n5 == 2) {
            n = 2;
            if (this.checkUnsigned.isSelected()) {
                n4 = 0;
            }
        } else if (n5 == 3) {
            n = 3;
        } else if (n5 == 4) {
            n = 7;
        }
        n5 = this.sizeChoice.getSelectedIndex();
        if (n == 3) {
            int n6 = 0;
            try {
                n6 = Integer.parseInt(this.stringLengthField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n6 = -1;
            }
            if (n6 <= 0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid string length: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
            n2 = n6;
        } else {
            n2 = n == 7 ? 1 : (n5 == 0 ? -1 : (n == 1 ? n5 * 4 : 1 << n5 - 1));
        }
        if (n2 == 8 && !this.isH5 && n == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "HDF4 does not support 64-bit integer.", this.getTitle(), 0);
            return null;
        }
        n5 = this.endianChoice.getSelectedIndex();
        n3 = n5 == 0 ? -1 : (n5 == 1 ? 0 : 1);
        Datatype datatype = null;
        try {
            Datatype datatype2;
            String string2 = "/";
            string2 = group.isRoot() ? string2 + string : group.getPath() + "/" + group.getName() + "/" + string;
            datatype = datatype2 = this.fileFormat.createDatatype(n, n2, n3, n4, string2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
        return datatype;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

