/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.ViewProperties;

public class NewTableDataDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private static final String[] DATATYPE_NAMES = new String[]{"byte (8-bit)", "short (16-bit)", "int (32-bit)", "unsigned byte (8-bit)", "unsigned short (16-bit)", "unsigned int (32-bit)", "long (64-bit)", "float", "double", "string", "enum"};
    private FileFormat fileformat;
    private JComboBox parentChoice;
    private JComboBox nFieldBox;
    private JComboBox templateChoice;
    private boolean isH5;
    private Vector groupList;
    private Vector compoundDSList;
    private HObject newObject = null;
    private final Toolkit toolkit;
    private final DataView dataView = null;
    private int numberOfMembers = 2;
    private JTable table;
    private DefaultTableModel tableModel;
    private RowEditorModel rowEditorModel;
    private DefaultCellEditor cellEditor;
    private JTextField nameField;
    private JTextField currentSizeField;
    private JTextField maxSizeField;
    private JTextField chunkSizeField;
    private JComboBox compressionLevel;
    private JComboBox rankChoice;
    private JComboBox memberTypeChoice;
    private JCheckBox checkCompression;
    private JRadioButton checkContinguous;
    private JRadioButton checkChunked;

    public NewTableDataDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Compound Dataset...", true);
        Object object;
        this.fileformat = group.getFileFormat();
        this.memberTypeChoice = new JComboBox<String>(DATATYPE_NAMES);
        this.cellEditor = new DefaultCellEditor(this.memberTypeChoice);
        this.rowEditorModel = new RowEditorModel(this.numberOfMembers, this.cellEditor);
        Object[] objectArray = new String[]{"Name", "Datatype", "Array size / String length / Enum names"};
        this.tableModel = new DefaultTableModel(objectArray, this.numberOfMembers);
        this.table = new JTable(this.tableModel){
            public static final long serialVersionUID = 240L;
            RowEditorModel rm;
            {
                this.rm = NewTableDataDialog.this.rowEditorModel;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TableCellEditor tableCellEditor = this.rm.getEditor(n);
                if (tableCellEditor == null || n2 != 1) {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
                return tableCellEditor;
            }
        };
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        int n = Math.max(16, this.table.getFontMetrics(this.table.getFont()).getHeight());
        this.table.setRowHeight(n);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.parentChoice = new JComboBox();
        String[] stringArray = new String[100];
        for (int i = 0; i < 100; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        this.nFieldBox = new JComboBox<String>(stringArray);
        this.nFieldBox.setEditable(true);
        this.nFieldBox.addActionListener(this);
        this.nFieldBox.setActionCommand("Change number of members");
        this.nFieldBox.setSelectedItem(String.valueOf(this.numberOfMembers));
        this.groupList = new Vector(list.size());
        Object e = null;
        Iterator iterator = list.iterator();
        this.compoundDSList = new Vector(list.size());
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof Group) {
                object = (Group)e;
                this.groupList.add(e);
                if (object.isRoot()) {
                    this.parentChoice.addItem("/");
                    continue;
                }
                this.parentChoice.addItem(object.getPath() + object.getName() + "/");
                continue;
            }
            if (!(e instanceof CompoundDS)) continue;
            this.compoundDSList.add(e);
        }
        this.templateChoice = new JComboBox(this.compoundDSList);
        this.templateChoice.setSelectedIndex(-1);
        this.templateChoice.addItemListener(this);
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        object = (JPanel)this.getContentPane();
        ((Container)object).setLayout(new BorderLayout(5, 5));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n2 = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n3 = 500 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object).setPreferredSize(new Dimension(n2, n3));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(new JLabel("   Dataset name: "));
        jPanel2.add(new JLabel("   Parent group: "));
        jPanel2.add(new JLabel("Import template: "));
        jPanel.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        this.nameField = new JTextField();
        jPanel2.add(this.nameField);
        jPanel2.add(this.parentChoice);
        jPanel2.add(this.templateChoice);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 3, 15, 3));
        TitledBorder titledBorder = new TitledBorder("Dataspace");
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        this.rankChoice = new JComboBox();
        for (int i = 1; i < 33; ++i) {
            this.rankChoice.addItem(String.valueOf(i));
        }
        this.rankChoice.setSelectedIndex(0);
        this.currentSizeField = new JTextField("1");
        this.maxSizeField = new JTextField("0");
        jPanel3.add(new JLabel("No. of dimensions"));
        jPanel3.add(new JLabel("Current size"));
        jPanel3.add(new JLabel("Max size (-1 for unlimited)"));
        jPanel3.add(this.rankChoice);
        jPanel3.add(this.currentSizeField);
        jPanel3.add(this.maxSizeField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        titledBorder = new TitledBorder("Data Layout and Compression");
        titledBorder.setTitleColor(Color.BLUE);
        jPanel4.setBorder(titledBorder);
        this.checkContinguous = new JRadioButton("Contiguous");
        this.checkContinguous.setSelected(true);
        this.checkChunked = new JRadioButton("Chunked");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkChunked);
        buttonGroup.add(this.checkContinguous);
        this.chunkSizeField = new JTextField("1");
        this.chunkSizeField.setEnabled(false);
        this.checkCompression = new JCheckBox("gzip");
        this.compressionLevel = new JComboBox();
        for (int i = 0; i < 10; ++i) {
            this.compressionLevel.addItem(String.valueOf(i));
        }
        this.compressionLevel.setSelectedIndex(6);
        this.compressionLevel.setEnabled(false);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel("Storage layout:  "));
        jPanel2.add(new JLabel("Compression:  "));
        jPanel4.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.add(this.checkContinguous);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 3));
        jPanel6.add(this.checkChunked);
        jPanel6.add(new JLabel("          Size: "));
        jPanel6.add(this.chunkSizeField);
        jPanel5.add(jPanel6);
        jPanel2.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 7));
        jPanel5.add(this.checkCompression);
        jPanel5.add(new JLabel("      Level: "));
        jPanel5.add(this.compressionLevel);
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel2.add(jPanel5);
        jPanel4.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel4, "South");
        ((Container)object).add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)new JLabel(" Number of Members:"), "West");
        jPanel5.add((Component)this.nFieldBox, "Center");
        jPanel2.add((Component)jPanel5, "North");
        JScrollPane jScrollPane = new JScrollPane(this.table);
        titledBorder = new TitledBorder("Compound Datatype Properties");
        titledBorder.setTitleColor(Color.BLUE);
        jPanel2.setBorder(titledBorder);
        jPanel2.add((Component)jScrollPane, "Center");
        ((Container)object).add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        ((Container)object).add((Component)jPanel7, "South");
        this.rankChoice.addItemListener(this);
        this.checkCompression.addItemListener(this);
        this.checkContinguous.addItemListener(this);
        this.checkChunked.addItemListener(this);
        this.memberTypeChoice.addItemListener(this);
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 120;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            try {
                this.newObject = this.createCompoundDS();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            }
            if (this.newObject != null) {
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            this.groupList.setSize(0);
        } else if (string.equals("Change number of members")) {
            int n = 0;
            try {
                n = Integer.valueOf((String)this.nFieldBox.getSelectedItem());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == this.numberOfMembers) {
                return;
            }
            this.tableModel.setRowCount(n);
            for (int i = this.numberOfMembers; i < n; ++i) {
                this.rowEditorModel.addEditorForRow(i, this.cellEditor);
            }
            this.numberOfMembers = n;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.rankChoice)) {
            int n = this.rankChoice.getSelectedIndex() + 1;
            String string = "1";
            String string2 = "0";
            for (int i = 1; i < n; ++i) {
                string = string + " x 1";
                string2 = string2 + " x 0";
            }
            this.currentSizeField.setText(string);
            this.maxSizeField.setText(string2);
            String string3 = this.currentSizeField.getText();
            int n2 = string3.lastIndexOf("x");
            String string4 = "1";
            if (n <= 1) {
                string4 = string3;
            } else {
                for (int i = 1; i < n - 1; ++i) {
                    string4 = string4 + " x 1";
                }
                if (n2 > 0) {
                    string4 = string4 + " x " + string3.substring(n2 + 1);
                }
            }
            this.chunkSizeField.setText(string4);
        } else if (object.equals(this.checkContinguous)) {
            this.chunkSizeField.setEnabled(false);
        } else if (object.equals(this.checkChunked)) {
            this.chunkSizeField.setEnabled(true);
            String string = this.currentSizeField.getText();
            int n = string.lastIndexOf("x");
            String string5 = "1";
            int n3 = this.rankChoice.getSelectedIndex() + 1;
            if (n3 <= 1) {
                string5 = string;
            } else {
                for (int i = 1; i < n3 - 1; ++i) {
                    string5 = string5 + " x 1";
                }
                if (n > 0) {
                    string5 = string5 + " x " + string.substring(n + 1);
                }
            }
            this.chunkSizeField.setText(string5);
        } else if (object.equals(this.checkCompression)) {
            boolean bl = this.checkCompression.isSelected();
            if (bl) {
                if (!this.checkChunked.isSelected()) {
                    String string = this.currentSizeField.getText();
                    int n = string.lastIndexOf("x");
                    String string6 = "1";
                    int n4 = this.rankChoice.getSelectedIndex() + 1;
                    if (n4 <= 1) {
                        string6 = string;
                    } else {
                        for (int i = 1; i < n4 - 1; ++i) {
                            string6 = string6 + " x 1";
                        }
                        if (n > 0) {
                            string6 = string6 + " x " + string.substring(n + 1);
                        }
                    }
                    this.chunkSizeField.setText(string6);
                }
                this.compressionLevel.setEnabled(true);
                this.checkContinguous.setEnabled(false);
                this.checkChunked.setSelected(true);
                this.chunkSizeField.setEnabled(true);
            } else {
                this.compressionLevel.setEnabled(false);
                this.checkContinguous.setEnabled(true);
            }
        } else if (object.equals(this.memberTypeChoice)) {
            String string = (String)this.memberTypeChoice.getSelectedItem();
            if (string == null || !string.equals("enum")) {
                return;
            }
            int n = this.table.getSelectedRow();
            this.table.setValueAt("mb1=0,mb=1,...", n, 2);
        } else if (object.equals(this.templateChoice)) {
            int n;
            int n5;
            String string;
            Object object2 = this.templateChoice.getSelectedItem();
            if (!(object2 instanceof CompoundDS)) {
                return;
            }
            CompoundDS compoundDS = (CompoundDS)object2;
            int n6 = compoundDS.getRank();
            if (n6 < 1) {
                compoundDS.init();
            }
            n6 = compoundDS.getRank();
            this.rankChoice.setSelectedIndex(n6 - 1);
            long[] lArray = compoundDS.getDims();
            String[] stringArray = compoundDS.getMemberNames();
            int[] nArray = compoundDS.getMemberOrders();
            Datatype[] datatypeArray = compoundDS.getMemberTypes();
            String string7 = String.valueOf(lArray[0]);
            for (int i = 1; i < n6; ++i) {
                string7 = string7 + "x" + lArray[i];
            }
            this.currentSizeField.setText(string7);
            try {
                compoundDS.getMetadata();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long[] lArray2 = compoundDS.getChunkSize();
            if (lArray2 != null) {
                this.checkChunked.setSelected(true);
                string7 = String.valueOf(lArray2[0]);
                for (int i = 1; i < n6; ++i) {
                    string7 = string7 + "x" + lArray2[i];
                }
                this.chunkSizeField.setText(string7);
            }
            if ((string = compoundDS.getCompression()) != null) {
                n5 = string.indexOf("GZIP: level = ");
                n = -1;
                try {
                    n = Integer.parseInt(string.substring(n5 + 14, n5 + 15));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n > 0) {
                    this.checkCompression.setSelected(true);
                    this.compressionLevel.setSelectedIndex(n);
                }
            }
            this.numberOfMembers = compoundDS.getMemberCount();
            this.nFieldBox.setSelectedIndex(this.numberOfMembers - 1);
            this.tableModel.setRowCount(this.numberOfMembers);
            for (n5 = 0; n5 < this.numberOfMembers; ++n5) {
                this.rowEditorModel.addEditorForRow(n5, this.cellEditor);
                this.tableModel.setValueAt(stringArray[n5], n5, 0);
                n = -1;
                int n7 = datatypeArray[n5].getDatatypeClass();
                int n8 = datatypeArray[n5].getDatatypeSize();
                if (n7 == 0) {
                    int n9 = datatypeArray[n5].getDatatypeSign();
                    if (n9 == 0) {
                        if (n8 == 1) {
                            n = 3;
                        } else if (n8 == 2) {
                            n = 4;
                        } else if (n8 == 4) {
                            n = 5;
                        }
                    } else {
                        n = n8 == 1 ? 0 : (n8 == 2 ? 1 : (n8 == 4 ? 2 : 6));
                    }
                } else if (n7 == 1) {
                    n = n8 == 4 ? 7 : 8;
                } else if (n7 == 3) {
                    n = 9;
                } else if (n7 == 8) {
                    n = 10;
                }
                if (n < 0) continue;
                this.memberTypeChoice.setSelectedIndex(n);
                this.tableModel.setValueAt(this.memberTypeChoice.getSelectedItem(), n5, 1);
                if (n7 == 3) {
                    this.tableModel.setValueAt(String.valueOf(n8), n5, 2);
                    continue;
                }
                if (n7 == 8) {
                    this.tableModel.setValueAt(datatypeArray[n5].getEnumMembers(), n5, 2);
                    continue;
                }
                this.tableModel.setValueAt(String.valueOf(nArray[n5]), n5, 2);
            }
        }
    }

    private HObject createCompoundDS() throws Exception {
        int n;
        String string;
        Object object;
        Dataset dataset = null;
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getSelectedColumn();
        if (n2 >= 0 && n3 > 0 && (object = this.table.getCellEditor(n2, n3)) != null) {
            object.stopCellEditing();
        }
        long[] lArray = null;
        long[] lArray2 = null;
        object = this.nameField.getText();
        if (object == null || ((String)object).length() <= 0) {
            throw new IllegalArgumentException("Dataset name is empty");
        }
        Group group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            throw new IllegalArgumentException("Invalid parent group");
        }
        int n4 = this.table.getRowCount();
        if (n4 <= 0) {
            return null;
        }
        String[] stringArray = new String[n4];
        Datatype[] datatypeArray = new Datatype[n4];
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            String string2 = (String)this.table.getValueAt(i, 0);
            if (string2 == null || string2.length() <= 0) {
                throw new IllegalArgumentException("Member name is empty");
            }
            stringArray[i] = string2;
            int n5 = 1;
            string = (String)this.table.getValueAt(i, 2);
            if (string != null) {
                try {
                    n5 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nArray[i] = n5;
            String string3 = (String)this.table.getValueAt(i, 1);
            Datatype datatype = null;
            if (DATATYPE_NAMES[0].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 1, -1, -1);
            } else if (DATATYPE_NAMES[1].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 2, -1, -1);
            } else if (DATATYPE_NAMES[2].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 4, -1, -1);
            } else if (DATATYPE_NAMES[3].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 1, -1, 0);
            } else if (DATATYPE_NAMES[4].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 2, -1, 0);
            } else if (DATATYPE_NAMES[5].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 4, -1, 0);
            } else if (DATATYPE_NAMES[6].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 8, -1, -1);
            } else if (DATATYPE_NAMES[7].equals(string3)) {
                datatype = this.fileformat.createDatatype(1, 4, -1, -1);
            } else if (DATATYPE_NAMES[8].equals(string3)) {
                datatype = this.fileformat.createDatatype(1, 8, -1, -1);
            } else if (DATATYPE_NAMES[9].equals(string3)) {
                datatype = this.fileformat.createDatatype(3, n5, -1, -1);
            } else if (DATATYPE_NAMES[10].equals(string3)) {
                datatype = this.fileformat.createDatatype(8, 4, -1, -1);
                if (string == null || string.length() < 1 || string.endsWith("...")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid member values: " + string, this.getTitle(), 0);
                    return null;
                }
                datatype.setEnumMembers(string);
            } else {
                throw new IllegalArgumentException("Invalid data type.");
            }
            datatypeArray[i] = datatype;
        }
        int n6 = this.rankChoice.getSelectedIndex() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.currentSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n6) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the current dimension size is less than " + n6, this.getTitle(), 0);
            return null;
        }
        long l = 0L;
        long[] lArray3 = new long[n6];
        string = null;
        for (n = 0; n < n6; ++n) {
            string = stringTokenizer.nextToken().trim();
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + this.currentSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l <= 0L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size must be greater than zero.", this.getTitle(), 0);
                return null;
            }
            lArray3[n] = l;
        }
        stringTokenizer = new StringTokenizer(this.maxSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n6) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the max dimension size is less than " + n6, this.getTitle(), 0);
            return null;
        }
        l = 0L;
        lArray2 = new long[n6];
        for (n = 0; n < n6; ++n) {
            string = stringTokenizer.nextToken().trim();
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + this.maxSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l < -1L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size cannot be less than -1.", this.getTitle(), 0);
                return null;
            }
            if (l == 0L) {
                l = lArray3[n];
            }
            lArray2[n] = l;
        }
        lArray = null;
        if (this.checkChunked.isSelected()) {
            int n7;
            stringTokenizer = new StringTokenizer(this.chunkSizeField.getText(), "x");
            if (stringTokenizer.countTokens() < n6) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the chunk size is less than " + n6, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            lArray = new long[n6];
            string = null;
            for (n = 0; n < n6; ++n) {
                string = stringTokenizer.nextToken().trim();
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid chunk dimension size: " + this.chunkSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
                if (l < 1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Chunk size cannot be less than 1.", this.getTitle(), 0);
                    return null;
                }
                lArray[n] = l;
            }
            long l2 = 1L;
            long l3 = 1L;
            for (n7 = 0; n7 < n6; ++n7) {
                l2 *= lArray[n7];
                l3 *= lArray3[n7];
            }
            if (l2 >= l3) {
                this.toolkit.beep();
                n7 = JOptionPane.showConfirmDialog(this, "Chunk size is equal/greater than the current size. \nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n7 == 1) {
                    return null;
                }
            }
            if (l2 == 1L) {
                this.toolkit.beep();
                n7 = JOptionPane.showConfirmDialog(this, "Chunk size is one, which may cause large memory overhead for large dataset.\nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n7 == 1) {
                    return null;
                }
            }
        }
        int n8 = 0;
        if (this.checkCompression.isSelected()) {
            n8 = this.compressionLevel.getSelectedIndex();
        }
        dataset = this.checkChunked.isSelected() ? this.fileformat.createCompoundDS((String)object, group, lArray3, lArray2, lArray, n8, stringArray, datatypeArray, nArray, null) : this.fileformat.createCompoundDS((String)object, group, lArray3, lArray2, null, -1, stringArray, datatypeArray, nArray, null);
        return dataset;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    private class RowEditorModel {
        private Hashtable data = new Hashtable();

        public RowEditorModel() {
        }

        public RowEditorModel(int n, TableCellEditor tableCellEditor) {
            for (int i = 0; i < n; ++i) {
                this.data.put(new Integer(i), tableCellEditor);
            }
        }

        public void addEditorForRow(int n, TableCellEditor tableCellEditor) {
            this.data.put(new Integer(n), tableCellEditor);
        }

        public void removeEditorForRow(int n) {
            this.data.remove(new Integer(n));
        }

        public TableCellEditor getEditor(int n) {
            return (TableCellEditor)this.data.get(new Integer(n));
        }
    }
}

