/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

/**
 * Provides results for each cycle.
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 *
 */
public final class CycleResults extends DailyResults {
	
	/**
	 * Constructor.
	 * @param dailyResults
	 * @param npp
	 */
	public CycleResults(Double[] x, Double[] dx, Double[][] f, Double[] g) {
		super(x, dx, f, g);
	}

	/**
	 * @return the npp
	 */
	public final Double getNpp() {
		double npp = this.getX()[5] - this.getG()[99];
		if (npp < 0.0) return 0.0;
		else return npp;
	}
	
	/**
	 * Get the amount of estimated fixated carbon 
	 * @param ratio
	 * @return
	 */
	public final Double getCarbonFixation(Double ratio) {
		return getNpp() * ratio;
	}
	
}