/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

import java.util.Arrays;

/**
 * Provides results for each day.
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 *
 */
public class DailyResults {
	
	/**
	 * Constructor.
	 * @param x State variables
	 * @param dx State variables increments
	 * @param f Flux variables
	 * @param g G variables
	 */
	public DailyResults(Double[] x, Double[] dx, Double[][] f, Double[] g) {
		this.x = x;
		this.dx = dx;
		this.f = f;
		this.g = g;
	}

	/** State variables */
	private final Double[] x;

	/** State variables increments */
	private final Double[] dx;

	/** Flux variables */
	private final Double[][] f;

	/** G variables */
	private final Double[] g;
	
	/**
	 * @return the x
	 */
	public final Double[] getX() {
		return x;
	}

	/**
	 * @return the dx
	 */
	public final Double[] getDx() {
		return dx;
	}

	/**
	 * @return the f
	 */
	public final Double[][] getF() {
		return f;
	}

	/**
	 * @return the g
	 */
	public final Double[] getG() {
		return g;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(dx);
		result = prime * result + Arrays.hashCode(f);
		result = prime * result + Arrays.hashCode(g);
		result = prime * result + Arrays.hashCode(x);
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DailyResults other = (DailyResults) obj;
		if (!Arrays.equals(dx, other.dx))
			return false;
		if (!Arrays.equals(f, other.f))
			return false;
		if (!Arrays.equals(g, other.g))
			return false;
		if (!Arrays.equals(x, other.x))
			return false;
		return true;
	}

}