/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core;

import java.util.Date;


/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Interface for multiple points Net Primary Production (NPP) estimates.
 * A class implementing this interface must provide methods to get the results of NPP estimates.
 */
public interface MultiplePointsNppResults {

	/**
	 * Gets the estimator used.
	 * @return the estimator
	 */
	public MultiplePointsNppEstimator getEstimator();
	
	/**
	 * gets the number of points for which NPP value has been estimated
	 * @return the number of estimates
	 */
	public int getNumberNppEstimates();

	/**
	 * Gets the simulation name. 
	 * @return
	 */
	public String getSimulationName();
	
	/**
	 * Gets the simulation date. 
	 * @return
	 */
	public Date getSimulationDate();
	
}
