/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core;

import java.io.File;


/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Interface for managing the Forest-BGC simulations outputs.
 */
public interface OutputManager {

	/**
	 * Reports the simulation output into the provided file.
	 * @param results the result to be reported.
	 * @param file the file where the report is writed. It has to be an existing and writable file. The report is appended to the end of the file.
	 * @throws Exception
	 */
	public void report(SinglePointNppResults results, File file) throws Exception;
	
	/**
	 * Reports the simulation output into the provided file.
	 * @param results the result to be reported.
	 * @param file the file where the report is writed. It has to be an existing and writable file. The report is appended to the end of the file.
	 * @throws Exception
	 */
	public void report(MultiplePointsNppResults results, File file) throws Exception;
	
}
