/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
 package es.ehu.www.ccwintco.npp.core;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Interface for single points Net Primary Production (NPP) estimators.
 */
public interface SinglePointNppEstimator {
	
	/**
	 * Estimates the NPP value for the single point.
	 * @return The results of the single point NPP estimate.
	 * @throws Exception if cannot estimate.
	 */
	public SinglePointNppResults estimate() throws Exception;
	
	/**
	 * returns the simulator version.
	 * @return
	 */
	public String getVersion();
	
	/**
	 * Returns the copyright info.
	 * @return
	 */
	public String getCopyright();
	
}