/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

import java.util.Date;
import java.util.List;
import java.util.ListIterator;

import es.ehu.www.ccwintco.npp.core.SinglePointNppEstimator;
import es.ehu.www.ccwintco.npp.core.SinglePointNppResults;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Provides resuts for the NPP estimates by ForestBGC.
 */
public final class ForestBGCResults implements SinglePointNppResults {

	/** The name of the simulation */
	private final String name;
	
	/** The date of the simulatio */
	private final Date date;
	
	/** The estimator */
	private final ForestBGC estimator;
	
	/** Daily results */
	private final List<DailyResults> dailyResults;
	
	/** Cycle results */
	private final List<CycleResults> cycleResults;

	/**
	 * Constructor
	 * @param name
	 * @param estimator
	 * @param dailyResults
	 * @param cycleResults
	 */
	public ForestBGCResults(String name, Date date, ForestBGC estimator,
			List<DailyResults> dailyResults, List<CycleResults> cycleResults) {
		this.name = name;
		this.date = date;
		this.estimator = estimator;
		this.dailyResults = dailyResults;
		this.cycleResults = cycleResults;
	}

	/**
	 * gets the iterator to access daily results.
	 * @return the daily iterator
	 */
	public ListIterator<DailyResults> getDailyResultsIterator() {
		return dailyResults.listIterator();
	}
	
	/**
	 * gets the iterator to access cycle results.
	 * @return the cycle iterator
	 */
	public ListIterator<CycleResults> getCycleResultsIterator() {
		return cycleResults.listIterator();
	}
	
	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.SinglePointNppResults#getEstimator()
	 */
	public SinglePointNppEstimator getEstimator() {
		return estimator;
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.SinglePointNppResults#getSimulationName()
	 */
	@Override
	public String getSimulationName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.SinglePointNppResults#getSimulationDate()
	 */
	@Override
	public Date getSimulationDate() {
		return date;
	}
	
}