/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc;

import java.util.Date;
import java.util.List;
import java.util.ListIterator;

import es.ehu.www.ccwintco.npp.core.MultiplePointsNppEstimator;
import es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 *
 */
public final class GlobalForestBGCResults implements MultiplePointsNppResults {

	/** Name of the simulations */
	private final String name;
	
	/** The estimator */
	private final MultiplePointsNppEstimator estimator;
	
	/** The results */
	private final List<ForestBGCResults> results;
	
	/** Date of the simulation */
	private final Date date;
	
	/**
	 * @param estimator
	 * @param results
	 */
	public GlobalForestBGCResults(String name, Date date, MultiplePointsNppEstimator estimator,
			List<ForestBGCResults> results) {
		this.name = name;
		this.date = date;
		this.estimator = estimator;
		this.results = results;
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults#getEstimator()
	 */
	public MultiplePointsNppEstimator getEstimator() {
		return estimator;
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults#getNumberNppEstimates()
	 */
	public int getNumberNppEstimates() {
		return results.size();
	}
	
	/**
	 * Gets the iterator to access each point estimate results.
	 * @return the iterator
	 */
	public ListIterator<ForestBGCResults> getResultsIterator() {
		return results.listIterator();
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults#getSimulationName()
	 */
	@Override
	public String getSimulationName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see es.ehu.www.ccwintco.npp.core.MultiplePointsNppResults#getSimulationDate()
	 */
	@Override
	public Date getSimulationDate() {
		return date;
	}

}
