/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional.
 * NPP software reimplements part of the code provided by SIMLAT5 v3.6 under Copyright 1998 J.C. Coughlan.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Abstract class for managing specific-species data of the study site needed for the ForestBGC ecophysiological model.
 */
public abstract class AbstractSiteDataManager implements SiteDataManager {

	// Parameters
	/** Start time (usually initial day) */
	public static final int START_TIME = 0;
	/** Stop time (usually final day) */
	public static final int STOP_TIME = 1;
	/** Loop time to the Carbon/Nitrogen submodel (usually number of days for each cycle) */
	public static final int LOOP_TIME = 2;
	/** X1: Snowpack (m^3) */
	public static final int X_1 = 3;
	/** X2: Soil water content (m^3) */
	public static final int X_2 = 4;
	/** X3: Water outflow (m^3) */
	public static final int X_3 = 5;
	/** X4: Transpiration (m^3) */
	public static final int X_4 = 6;
	/** X5: Evaporation (m^3) */
	public static final int X_5 = 7;
	/** X6: PSN (kg) */
	public static final int X_6 = 8;
	/** X7: Respiraton autotrophic (kg) */
	public static final int X_7 = 9;
	/** X8: Leaf carbon (kg) */
	public static final int X_8 = 10;
	/** X9: Stem carbon (kg) */
	public static final int X_9 = 11;
	/** X10: Root carbon (kg) */
	public static final int X_10 = 12;
	/** X11: Leaf/Root litter carbon (kg) */
	public static final int X_11 = 13;
	/** X12: Respiration decompositon, C (kg) */
	public static final int X_12 = 14;
	/** X13: Soil carbon (kg) */
	public static final int X_13 = 15;
	/** X14: Available nitrogen (kg) */
	public static final int X_14 = 16;
	/** X15: Leaf nitrogen (kg) */
	public static final int X_15 = 17;
	/** X16: Stem nitrogen (kg) */
	public static final int X_16 = 18;
	/** X17: Root nitrogen (kg) */
	public static final int X_17 = 19;
	/** X18: Leaf/Root litter nitrogen (kg) */
	public static final int X_18 = 20;
	/** X19: Soil nitrogen (kg) */
	public static final int X_19 = 21;
	/** X20: Nitrogen loss (kg) */
	public static final int X_20 = 22;
	/** B1: Specific leaf area (m^2 kg^-1 c^-1) */
	public static final int B_1 = 33;
	/** B2: Canopy light extinction coefficient (dimensionless) */
	public static final int B_2 = 34;
	/** B3: Soil water capacity (m^3) */
	public static final int B_3 = 35;
	/** B4: Interception coefficient (m lai^-1 day^-1) */
	public static final int B_4 = 36;
	/** B5: Ground surface area (m^2 ha^-1) */
	public static final int B_5 = 37;
	/** B6: Snowmelt coefficient (m deg^-1 c day^-1) */
	public static final int B_6 = 38;
	/** B7: Latitude (deg) */
	public static final int B_7 = 39;
	/** B8: 1 - Surface albedo (dimensionless) */
	public static final int B_8 = 40;
	/** B9: Spring min. PMS (mpa) */
	public static final int B_9 = 41;
	/** B10: */
	public static final int B_10 = 42;
	/** B11: */
	public static final int B_11 = 43;
	/** B12: */
	public static final int B_12 = 44;
	/** B13: */
	public static final int B_13 = 45;
	/** B14: */
	public static final int B_14 = 46;
	/** B15: */
	public static final int B_15 = 47;
	/** B16: */
	public static final int B_16 = 48;
	/** B17: */
	public static final int B_17 = 49;
	/** B18: */
	public static final int B_18 = 50;
	/** B19: */
	public static final int B_19 = 51;
	/** B20: */
	public static final int B_20 = 52;
	/** B21: */
	public static final int B_21 = 53;
	/** B22: */
	public static final int B_22 = 54;
	/** B23: */
	public static final int B_23 = 55;
	/** B24: */
	public static final int B_24 = 56;
	/** B25: */
	public static final int B_25 = 57;
	/** B26: */
	public static final int B_26 = 58;
	/** B27: */
	public static final int B_27 = 59;
	/** B28: */
	public static final int B_28 = 60;
	/** B29: */
	public static final int B_29 = 61;
	/** B30: */
	public static final int B_30 = 62;
	/** B31: */
	public static final int B_31 = 63;
	/** B32: */
	public static final int B_32 = 64;
	/** B33: */
	public static final int B_33 = 65;
	/** B34: */
	public static final int B_34 = 66;
	/** B35: */
	public static final int B_35 = 67;
	/** B36: */
	public static final int B_36 = 68;
	/** B37: */
	public static final int B_37 = 69;
	/** B38: */
	public static final int B_38 = 70;
	/** B39: */
	public static final int B_39 = 71;
	/** B40: */
	public static final int B_40 = 72;
	/** B41: */
	public static final int B_41 = 73;
	/** B42: */
	public static final int B_42 = 74;
	/** B43: */
	public static final int B_43 = 75;
	/** B44: */
	public static final int B_44 = 76;
	/** B45: */
	public static final int B_45 = 77;
	/** B46: */
	public static final int B_46 = 78;
	/** B47: */
	public static final int B_47 = 79;
	/** B48: */
	public static final int B_48 = 80;
	/** B49: */
	public static final int B_49 = 81;
	/** B50: */
	public static final int B_50 = 82;
	/** Num of parameters */
	public static final int NUM_PARAMETERS = 83;

	/**
	 * Gets the description of the given state variable X.
	 * @param X the state variable
	 * @return the description
	 * @throws Exception if X doesn't exist
	 */
	public static String getXDescription(int X) throws Exception {
		if (X<AbstractSiteDataManager.X_1 || X>=AbstractSiteDataManager.X_20) throw new Exception("Given X doesn't exist: " + X);
		switch (X) {
		case X_1: return "Snowpack";
		case X_2: return "Soil water content";
		case X_3: return "Water outflow";
		case X_4: return "Transpiration";
		case X_5: return "Evaporation";
		case X_6: return "PSN";
		case X_7: return "Respiraton autotrophic";
		case X_8: return "Leaf carbon";
		case X_9: return "Stem carbon";
		case X_10: return "Root carbon";
		case X_11: return "Leaf/Root litter carbon";
		case X_12: return "Respiration decompositon, C";
		case X_13: return "Soil carbon";
		case X_14: return "Available nitrogen";
		case X_15: return "Leaf nitrogen";
		case X_16: return "Stem nitrogen";
		case X_17: return "Root nitrogen";
		case X_18: return "Leaf/Root litter nitrogen";
		case X_19: return "Soil nitrogen";
		case X_20: return "Nitrogen loss";
		default: return "";
		}
	}
	
	/**
	 * Gets the units of the given state variable X.
	 * @param X the state variable
	 * @return the units
	 * @throws Exception if X doesn't exist
	 */
	public static String getXUnits(int X) throws Exception {
		if (X<AbstractSiteDataManager.X_1 || X>=AbstractSiteDataManager.X_20) throw new Exception("Given X doesn't exist: " + X);
		switch (X) {
		case X_1: return "m^3";
		case X_2: return "m^3";
		case X_3: return "m^3";
		case X_4: return "m^3";
		case X_5: return "m^3";
		case X_6: return "Kg";
		case X_7: return "Kg";
		case X_8: return "Kg";
		case X_9: return "Kg";
		case X_10: return "Kg";
		case X_11: return "Kg";
		case X_12: return "Kg";
		case X_13: return "Kg";
		case X_14: return "Kg";
		case X_15: return "Kg";
		case X_16: return "Kg";
		case X_17: return "Kg";
		case X_18: return "Kg";
		case X_19: return "Kg";
		case X_20: return "m^2 kg^-1 c^-1";
		default: return "";
		}
	}

}