/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional, Universidad del País Vasco (UPV/EHU).
 * NPP software provides different Net Primary Production (NPP) estimators.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

import java.util.List;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Interface for managing site information constants seasonally.
 */
public interface SeasonDataManager {

	/**
	 * 
	 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
	 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
	 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
	 * Site information constants season data.
	 */
	public final class SeasonData {
		
		/** 
		 * Constant.
		 */
		private final int constant;
		
		/** Value */
		private final Double value;

		/**
		 * @param constant
		 * @param value
		 */
		public SeasonData(int constant, Double value) {
			super();
			this.constant = constant;
			this.value = value;
		}

		/**
		 * @return the constant
		 */
		public final int getConstant() {
			return constant;
		}

		/**
		 * @return the value
		 */
		public final Double getValue() {
			return value;
		}
		
	}
	
	/**
	 * Gets a list of site constants to be replaced for the given season.
	 * @param season
	 * @return
	 */
	public List<SeasonData> getSeasonData(int season);
	
	/**
	 * Gets a list of seasons with replacing philogeny data.
	 * @return
	 */
	public List<Integer> getSeasons();
	
	/**
	 * Gets a list of the site constants (B) to be replaced.
	 * @return
	 */
	public List<Integer> getReplacingConstants();
	
}
