/**
 * Copyright 2009 Miguel Angel Veganzones, Grupo Inteligencia Computacional.
 * NPP software reimplements part of the code provided by SIMLAT5 v3.6 under Copyright 1998 J.C. Coughlan.
 * 
 * This file is part of NPP software.
 *
 * NPP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NPP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NPP. If not, see <http://www.gnu.org/licenses/>.
 *
 */
package es.ehu.www.ccwintco.npp.core.forestbgc.inputs;

/**
 * @author Miguel A. Veganzones <miguelangel.veganzones@ehu.es>
 * @author Grupo Inteligencia Computacional <http://www.ehu.es/computationalintelligence>
 * @author Universidad del País Vasco (UPV/EHU) <http://www.ehu.es>
 * Interface for managing specific-species data of the study site needed for the ForestBGC ecophysiological model.
 */
public interface SiteDataManager {

	/**
	 * Get the data for the given parameter.
	 * @param parameter the parameter to get.
	 * @return the data.
	 * @throws Exception if data cannot be obtained.
	 */
	public Double getData(int parameter) throws Exception;

	/**
	 * Set the data for the given parameter at the given 'day'.
	 * @param parameter the parameter to get.
	 * @param value the value.
	 * @throws Exception if data cannot be allocated.
	 */
	public void setData(int parameter, Double value) throws Exception;
	
	/**
	 * If true indicates that static Carbon budget data is provided, if false indicates that the provided data is for dynamic C/N budget.
	 * @return
	 */
	public boolean isStaticBudget();
		
}