% With this code we have obtained the results shown in the article
% "Learning Parsimonious Dendritic Classifiers" 
% submitted for publication in Neurocomputing.
% Example of execution on the SYNTH dataset
%
% Copyright 2011 :: Ana I. Gonzalez & Manuel Graa
%
 
clc
clear all
reset(RandStream.getDefaultStream);  % Identical repetition of runs

%% Load dataset
clave='synth_';     % name used in saved files
load synth.tr
synth	= synth(randperm(size(synth,1)),:);
X=synth(:,1:2);
t=synth(:,3);       % t in {0,1}
load synth.te
Xtest=synth(:,1:2);
ttest=synth(:,3);   % t in {0,1}

[N,d] = size(X);
t	  = logical(t);    
Nt    = size(Xtest,1);

% Normalizar
value_mean = mean(X);
value_std  = std(X);
value_std(value_std==0) = 1; % not to scale those with zero variance
X     = (X-ones(N,1)*value_mean)./(ones(N,1)*value_std);
Xtest = (Xtest-ones(Nt,1)*value_mean)./(ones(Nt,1)*value_std);


%% Initialization
% Subset of inputs of class 1
X_c1  = X(t,:);  
N_c1  = size(X_c1,1);
Nused = N_c1*d;   % Number of parameters (/2)

% Set up parameters 
pi_u_params = zeros(N_c1,d);     % in {0, inf};  
pi_l_params = zeros(N_c1,d);

eps_param = 0;   % global epsilon_param  in R+
 
pe_params = ones(N_c1,1);    % in {-1, 1};
pi_params = zeros(N_c1,1);   % in {0, -inf};  
 
% Definition of sigmoid function
sigmoid=inline('1./(1+exp(-x))');

%% Compute response of dendritics
tau=zeros(N,1);
upper_limit = X_c1 + eps_param;
lower_limit = X_c1 - eps_param;
for i=1:N
    % Calculate box-lattice based kernel function
    diff_lower = ( ones(N_c1,1)*X(i,:) - lower_limit ) + pi_l_params;
    diff_upper = ( upper_limit - ones(N_c1,1)*X(i,:) ) + pi_u_params;
    lambda     = min( min(diff_lower,diff_upper), [], 2);
    % Calculate response of SLKN
    tau(i,1) = max(lambda.*pe_params+pi_params);
end

y = sigmoid(tau);
likelihood_old	= (sum(log(y(t))) + sum(log(1-y(~t))));
       

    
%% Monte Carlo method (max)          
    
%% Initialization MC
ini_temp = 1;          % Initial temperature
fin_temp = 1e-3;       % Final temperature  (higher value, slower annealing) 

maxsimu = Nused*200;   % iterations based on number of parameters

energy_sequence    = [];  % to plot the evolution of energy
energy_sequence(1) = likelihood_old; 
 

%% Generate Markov Chain (sample)
for ksimu = 2:maxsimu

    new_pi_l_params  = pi_l_params;    
    new_pi_u_params  = pi_u_params;    
    new_eps_param = eps_param;  

    %% Generate candidate configuration 
    accepted = 0;
    switch floor(rand*3+1)    
    case 1   % change pi_l_params between 0 and inf
        inewparam = floor(rand*Nused+1); 
        if new_pi_l_params(inewparam) == 0
            new_pi_l_params(inewparam) = inf;
        else 
            new_pi_l_params(inewparam) = 0;
        end

    case 2  % change pi_u_params between 0 and inf
        inewparam = floor(rand*Nused+1); 
        if new_pi_u_params(inewparam) == 0
            new_pi_u_params(inewparam) = inf;
        else 
            new_pi_u_params(inewparam) = 0;
        end
        
   case 3 % perturbate eps_param + normal(0,1)  
        new_eps_param = max( 0, new_eps_param +randn*0.01); 

   end


    %% Compute response of dendritics
    tau=zeros(N,1);
    upper_limit = X_c1 + new_eps_param;
    lower_limit = X_c1 - new_eps_param;
    for i=1:N
        % Calculate box-lattice based kernel function
        diff_lower = ( ones(N_c1,1)*X(i,:) - lower_limit )+ new_pi_l_params;
        diff_upper = ( upper_limit - ones(N_c1,1)*X(i,:) )+ new_pi_u_params;
        lambda     = min( min(diff_lower,diff_upper), [], 2);
        % Calculate response of SLKN
        tau(i,1) = max(lambda.*pe_params + pi_params);
    end
    y = sigmoid(tau);
    likelihood_new	= (sum(log(y(t))) + sum(log(1-y(~t))));


    %% Accept new configuration?
    temp = (fin_temp/ini_temp)^(ksimu/maxsimu);  
    incr_energy = likelihood_new - likelihood_old;
    if incr_energy > 0 % we accepted
        accepted = 1;
    else      % we accepted with certain probability
        probaccept = exp(incr_energy/temp);    
        if probaccept > rand
           accepted = 1;
        end
    end

    if accepted   
        pi_l_params  = new_pi_l_params;     
        pi_u_params  = new_pi_u_params;    
        eps_param = new_eps_param;  
        likelihood_old = likelihood_new;
    end

    energy_sequence(ksimu) = likelihood_old;   % to plot

end   % final of MC

%%   T e s t 

%% Compute response of dendritics
tau=zeros(N,1);
upper_limit = X_c1 + eps_param;
lower_limit = X_c1 - eps_param;
for i=1:N
    % Calculate box-lattice based kernel function
    diff_lower = ( ones(N_c1,1)*X(i,:) - lower_limit )+ pi_l_params;
    diff_upper = ( upper_limit - ones(N_c1,1)*X(i,:) )+ pi_u_params;
    lambda     = min( min(diff_lower,diff_upper), [], 2);
    % Calculate response of SLKN
    tau(i,1) = max(lambda.*pe_params+pi_params);
end
y = sigmoid(tau);
ResulClassif = round(y);     
accuracy_train = 1 - mean((ResulClassif-t).^2);

      
%% Compute response of dendritics
tau = zeros(Nt,1);
upper_limit = X_c1 + eps_param;
lower_limit = X_c1 - eps_param;
for i=1:Nt
    % Calculate box-lattice-based kernel function
    diff_lower = ( ones(N_c1,1)*Xtest(i,:) - lower_limit )+ pi_l_params;
    diff_upper = ( upper_limit - ones(N_c1,1)*Xtest(i,:) )+ pi_u_params;
    lambda     = min( min(diff_lower,diff_upper), [], 2);
    % Calculate response of SLKN
    tau(i,1) = max(lambda.*pe_params + pi_params);
end
y = sigmoid(tau);
ResulClassif = round(y);  

%% Calculate confusion matrix
TP = sum((ttest==1) & (ResulClassif==1)); % true positive
TN = sum((ttest==0) & (ResulClassif==0)); % true negative
FP = sum((ttest==0) & (ResulClassif==1)); % false positive
FN = sum((ttest==1) & (ResulClassif==0)); % false negative

precision   = TP/(TP+FP);
sensitivity = TP/(TP+FN);
specificity = TN/(TN+FP);
accuracy    = (TP+TN)/Nt;

%% Display results
disp(['accuracy train result:'])
disp(accuracy_train)
disp(['test results:'])
disp(['  precision ', 'sensitivity  ', 'specificity  ', 'accuracy'] )      
disp([precision sensitivity specificity accuracy])


%% Save results
eval (['save Resul_SLKN-G_' clave '  pi_l_params pi_u_params  eps_param '  ... 
'pe_params pi_params precision sensitivity specificity accuracy accuracy_train ' ...
'maxsimu fin_temp energy_sequence Nused ' ])




