function datosPrograma = Estrategia_3colores()
%%% Puede distinguir a los tipos que le rodean como enemigos o amigos (Vecindad Local).
%%% Si se topa con un enemigo, se separa
%%% Si se topa con un amigo, se cohesiona con l
%%% No tiene un objetivo prefijado (objetivo aleatorio, Horizonte = nulo)
%%% Puede realizar ataque

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DEL MUNDO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Limites
mundo = inicializaMundo2D(-500, 500, -500, 500);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DE LAS METAS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parametrosM = [];
%%%%%%%%%%%% Posicion y color de todas las posibles metas (1, 2, 3 y 4 metas)
parametrosM.posicionTodasLasMetas{1} = [-200 200; 0 0]';
parametrosM.posicionTodasLasMetas{2} = [-200 0 200; -200 200 -200]';
parametrosM.posicionTodasLasMetas{3} = [-200 -200 200 200; -200 200 200 -200]';
parametrosM.color = {'r', 'b', 'g', 'c', 'k'};
%%%%%%%%%%%% Numero de metas por defecto (3-coloreado)
parametrosM.nMetas = 3;
%%%%%%%%%%%% Posicion de las Metas 
parametrosM.posicion = parametrosM.posicionTodasLasMetas{2};
parametrosM.posicionAntipodas = antipodas(parametrosM.posicion);
%%%%%%%%%%%% Zona de influencia de las Metas 
%%%%%%%%%%%% (radio de influencia y peso)
parametrosM.rInfluencia = 30;
parametrosM.pInfluencia = 1.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DE LOS AGENTES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parametrosA = [];
%%%%%%%%%%% Radio de vision del vecindario de cada agente
parametrosA.radioVision = 10;
%%%%%%%%%%% Radio de zona privada que no debe sobreparse alrededor de un
%%%%%%%%%%% individuo
parametrosA.zonaPrivada = 5;
%%%%%%%%%%% Ataca (si/no, peso)
parametrosA.vAtaqueInterno = 1;
parametrosA.pAtaqueInterno = 2.0;
parametrosA.vAtaqueExterno = 1;
parametrosA.pAtaqueExterno = 2.0;

parametrosA.vCuadrilla = 0;

%%%%%%%%%%% Peso del objetivo que busca
parametrosA.pObjetivo = 1.0;
%%%%%%%%%%% Limite del nivel de desesperacion
parametrosA.limiteDesesperacion = 30;

%%%%%%%%%%% Fuerzas enemigos: alineacion, separacion y huida
%%%%%%%%%%% Para todos los casos (si/no, peso)
opcionesEnemigos = [];
opcionesEnemigos.vAlineacion = 0;
opcionesEnemigos.vSeparacion = 0;
opcionesEnemigos.vHuida = 0;

pesosEnemigos = [];
pesosEnemigos.pAlineacion = 0.0;
pesosEnemigos.pSeparacion = 0.0;
pesosEnemigos.pHuida = 0.0;

%%%%%%%%%%% Fuerzas amigos: alineacion, cohesion y busqueda
%%%%%%%%%%% Para todos los casos (si/no, peso)
opcionesAmigos = [];
opcionesAmigos.vAlineacion = 0;
opcionesAmigos.vCohesion = 0;
opcionesAmigos.vBusqueda = 0;

pesosAmigos = [];
pesosAmigos.pAlineacion = 0.0;
pesosAmigos.pCohesion = 0.0;
pesosAmigos.pBusqueda = 0.0;

datosPrograma.mundo = mundo;
datosPrograma.parametrosMetas  = parametrosM;
datosPrograma.parametrosAgentes = parametrosA;
datosPrograma.opcionesEnemigos = opcionesEnemigos;
datosPrograma.pesosEnemigos = pesosEnemigos;
datosPrograma.opcionesAmigos = opcionesAmigos;
datosPrograma.pesosAmigos = pesosAmigos;

%%%%%%%%%%% Limitacion de la velocidad (si/no, peso)
datosPrograma.maximaNorma = 12;

%%%%%%%%%%% Tiene horizontes cercano(busca metas)
datosPrograma.tipoHorizonte = 1;